/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.Datapoint;
import datastore.FaciesColumn;
import datastore.ages.AgeConverter;
import gui.ImageGenerator;
import gui.Language;
import gui.Settings;
import gui.datamining.RollApply;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import path.ResPath;
import util.NumberUtils;
import util.Util;

public class ChronColumn
extends FaciesColumn {
    private static final long serialVersionUID = 1L;
    public final String frequencyColumnName = "Number of points per window";
    public final String minColumnName = "Minimum value per window";
    public final String maxColumnName = "Maximum value per window";
    public final String averageColumnName = "Average value per window";
    public final String rateOfChangeColumnName = "Rate of change";
    public static String CHRON_NORMAL_STYLE = "stroke-width: 0; fill: black;";
    public static String CHRON_REVERSED_STYLE = "stroke-width: 0; fill: white;";
    public static String CHRON_UNKNOWN_STYLE = "stroke-width: 0; fill: url(#ChronColumn_Unknown);";
    public static String CHRON_UNKNOWN_PATTERN_LINE_STYLE = "stroke-width: 1; stroke: black; fill: none;";
    public static String CHRON_UNKNOWN_PATTERN_BACKGROUND_STYLE = "stroke-width: 0; fill: rgb(192, 192, 192);";
    public static final Color defaultBackground = new Color(192, 192, 192);
    public double[][] polarityChronFrequencyResult;
    public double windowSize = 2.0;
    public double stepSize = 1.0;

    public void readTextFieldsFromPanel() {
        PCOptionsPanel useOP;
        PCOptionsPanel op = (PCOptionsPanel)this.optionsPanel;
        PCOptionsPanel parentOP = null;
        if (this.overlayParent != null && this.overlayParent instanceof ChronColumn) {
            parentOP = (PCOptionsPanel)this.overlayParent.optionsPanel;
        }
        PCOptionsPanel pCOptionsPanel = useOP = parentOP == null ? op : parentOP;
        if (useOP == null) {
            return;
        }
        String s = useOP.bWindowSizeTextField.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        double prevWindowSize = this.windowSize;
        try {
            this.windowSize = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.windowSize = 2.0;
        }
        s = useOP.bStepSizeTextField.getText();
        if (s.contains(",")) {
            s = s.replace(",", ".");
        }
        double prevStepSize = this.stepSize;
        try {
            this.stepSize = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.stepSize = 2.0;
        }
        if (this.prevDataMiningFunction == -1 || this.windowSize != prevWindowSize || this.stepSize != prevStepSize || this.extraColumnHeaderName != null && this.extraColumnHeaderName != this.prevExtraColumnHeaderName) {
            this.drawExtraColumn = true;
            this.prevExtraColumnHeaderName = this.extraColumnHeaderName;
        }
        if (this.windowSize == 2.0) {
            System.out.println("Window Size Not Updated");
        }
        useOP.readTextFieldsFromColumn();
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new PCOptionsPanel(this);
        }
        return this.optionsPanel;
    }

    public ChronColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_point");
        this.setColor(new Coloring(Color.white));
    }

    public static double getMag(Datapoint p) {
        return (Double)p.value;
    }

    public void getPointColName() {
        this.columnName = super.getColName();
    }

    public static void setupPatterns(ImageGenerator ig) {
        ig.pushPattern("ChronColumn_Unknown", 10.0, 10.0);
        ig.drawRect(0.0, 0.0, 10.0, 10.0, CHRON_UNKNOWN_PATTERN_BACKGROUND_STYLE);
        ig.drawLine(10.0, -5.0, -5.0, 10.0, CHRON_UNKNOWN_PATTERN_LINE_STYLE);
        ig.drawLine(15.0, 0.0, 0.0, 15.0, CHRON_UNKNOWN_PATTERN_LINE_STYLE);
        ig.popPattern();
        String lgf = ig.pushGradient();
        ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(new Color(100, 100, 200)) + ";stop-opacity:1");
        ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(new Color(255, 50, 50)) + ";stop-opacity:1");
        ig.popGradient();
        String lgb = ig.pushGradient();
        ig.setStop(0.0, "stop-color:" + Coloring.getStyleRGB(new Color(100, 100, 200)) + ";stop-opacity:1");
        ig.setStop(1.0, "stop-color:" + Coloring.getStyleRGB(new Color(255, 50, 50)) + ";stop-opacity:1");
        ig.popGradient();
    }

    @Override
    public SortedSet negateAges() {
        return this.negateAgesBreakerBased();
    }

    @Override
    public void convertAges(AgeConverter translator) {
        List<AgeConverter.Gap> gaps = translator.getGaps();
        if (gaps != null) {
            Vector<Datapoint> addBreakers = new Vector<Datapoint>();
            Iterator<AgeConverter.Gap> gapIter = gaps.iterator();
            AgeConverter.Gap gap = gapIter.next();
            Datapoint lastP = null;
            Iterator iter = this.getData();
            while (iter.hasNext()) {
                Datapoint p = (Datapoint)iter.next();
                if (gap == null) {
                    p.baseAge = translator.convertAge(p.baseAge, 1);
                    continue;
                }
                if (NumberUtils.isEqual(p.baseAge, gap.gapKey)) {
                    if (!p.breaker && iter.hasNext()) {
                        Datapoint newBreaker = new Datapoint();
                        newBreaker.value = CHRON_UNKNOWN_STYLE;
                        newBreaker.baseAge = gap.gapValueBase;
                        addBreakers.add(newBreaker);
                        p.baseAge = gap.gapValueTop;
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    }
                } else if (lastP != null) {
                    if (p.baseAge < gap.gapKey) {
                        p.baseAge = translator.convertAge(p.baseAge, 1);
                    } else if (lastP.baseAge < gap.gapKey && p.baseAge > gap.gapKey) {
                        Datapoint topHalf = new Datapoint(p);
                        topHalf.value = p.value;
                        topHalf.baseAge = gap.gapValueTop;
                        addBreakers.add(topHalf);
                        Datapoint newGap = new Datapoint();
                        newGap.baseAge = gap.gapValueBase;
                        newGap.value = "Gap";
                        addBreakers.add(newGap);
                        p.baseAge = translator.convertAge(p.baseAge, -1);
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    } else {
                        p.baseAge = translator.convertAge(p.baseAge, 1);
                        gap = gapIter.hasNext() ? gapIter.next() : null;
                    }
                } else {
                    p.baseAge = translator.convertAge(p.baseAge, 1);
                }
                lastP = p;
            }
            this.data.addAll(addBreakers);
            this.updateMinMaxAges();
        } else {
            super.convertAges(translator);
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        this.readTextFieldsFromPanel();
        Iterator iter = this.getDrawingData();
        double curTop = settings.topAge;
        double curBase = settings.baseAge;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        ArrayList<Double> ta = new ArrayList<Double>();
        ArrayList<String> tav = new ArrayList<String>();
        while (iter.hasNext() && !settings.isBelow(curTop)) {
            Datapoint p = (Datapoint)iter.next();
            if (settings.isAbove(p.baseAge)) continue;
            ta.add(p.baseAge);
            tav.add((String)p.value);
            if (p.breaker) {
                curTop = p.baseAge;
                continue;
            }
            curBase = p.baseAge;
            if (settings.isBelow(curBase)) {
                curBase = settings.baseAge;
            }
            String styleToUse = CHRON_UNKNOWN_STYLE;
            if (p.value.toString().compareToIgnoreCase("R") == 0) {
                styleToUse = CHRON_REVERSED_STYLE;
            } else if (p.value.toString().compareToIgnoreCase("N") == 0) {
                styleToUse = CHRON_NORMAL_STYLE;
            }
            ig.drawRectYear(startx, curTop, width, curBase - curTop, styleToUse, starty);
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(this.getAgeLabel(p.baseAge), this.fonts.getFont(1), 1, this.fileInfo), startx + 10.0, (curBase - settings.topAge) * settings.unitsPerMY + starty - ageLabelHeight, 20.0, ageLabelHeight, 3, 0.0, 12, this.color.getColor(p.baseAge, p.baseAge));
            }
            if (p.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(p.popup, this.fileInfo);
                ig.drawRectYear(startx, curTop, width, curBase - curTop, "stroke-width: 0; opacity: 0.5; fill: red;", starty);
                ig.popGrouping();
            }
            if (this.drawExtraColumn) {
                ig.notifyExtraColumnToIG = true;
                TreeSet newData = new TreeSet();
                Vector<Double> coordY = new Vector<Double>();
                Iterator itr = this.data.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    Datapoint dp = (Datapoint)itr.next();
                    coordY.add(dp.baseAge);
                    ++i;
                }
                double[] coordY2 = Util.getDoubleArray(coordY, 1, coordY.size() - 1);
                PCOptionsPanel pc = (PCOptionsPanel)this.optionsPanel;
                double windowSize = pc.getWindowSize();
                double windowSlide = pc.getWindowSlide();
                int windows = RollApply.numWindows(coordY2, windowSlide);
                this.polarityChronFrequencyResult = RollApply.frequency(coordY2, windows, windowSize, windowSlide);
                this.dataMiningColumnDrawing = true;
                this.drawExtraColumn = false;
            }
            curTop = curBase;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public class PCOptionsPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    Cloneable {
        ChronColumn cc;
        private JButton polaritySettingsButton;
        private JPanel polarityPanel;
        private JLabel bWindowSizeLabel;
        private JTextField bWindowSizeTextField;
        private JLabel bStepSizeLabel;
        private JTextField bStepSizeTextField;
        public JCheckBox bFrequency;
        private JButton bUpdateSettings;
        public boolean frequencySelected = false;

        public double getWindowSize() {
            String windowSize = this.bWindowSizeTextField.getText().toString();
            double res = Double.parseDouble(windowSize);
            return res;
        }

        public double getWindowSlide() {
            String windowSlide = this.bStepSizeTextField.getText().toString();
            double res = Double.parseDouble(windowSlide);
            return res;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public PCOptionsPanel(ChronColumn cc) {
            this.cc = cc;
            this.initGUI();
            this.bFrequency.addItemListener(this);
            this.bWindowSizeTextField.addActionListener(this);
            this.bStepSizeTextField.addActionListener(this);
        }

        public PCOptionsPanel() {
        }

        private Component cloneSwingComponent(Component c) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(c);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return (Component)ois.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private void initGUI() {
            try {
                GridBagLayout thisLayout = new GridBagLayout();
                thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
                thisLayout.rowHeights = new int[]{4, 4, 4, 10, 10, 10, 10, 10};
                thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
                thisLayout.columnWidths = new int[]{45, 60, 30, 20, 17};
                this.setPreferredSize(new Dimension(100, 50));
                this.setLayout(thisLayout);
                this.polarityPanel = new JPanel();
                GridBagLayout polarityPanelLayout = new GridBagLayout();
                polarityPanelLayout.rowWeights = new double[]{0.1, 0.1};
                polarityPanelLayout.rowHeights = new int[]{9, 9};
                polarityPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                polarityPanelLayout.columnWidths = new int[]{7, 7, 74, 7};
                this.add((Component)this.polarityPanel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.polarityPanel.setLayout(polarityPanelLayout);
                this.bWindowSizeLabel = new JLabel();
                this.polarityPanel.add((Component)this.bWindowSizeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.bWindowSizeLabel.setText(Language.translate(" Window Size :", true));
                this.bWindowSizeLabel.setLayout(null);
                this.bWindowSizeTextField = new JTextField();
                this.polarityPanel.add((Component)this.bWindowSizeTextField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bWindowSizeTextField.setText("2");
                this.bStepSizeLabel = new JLabel();
                this.polarityPanel.add((Component)this.bStepSizeLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.bStepSizeLabel.setText(Language.translate(" Step Size:", true));
                this.bStepSizeLabel.setLayout(null);
                this.bStepSizeTextField = new JTextField();
                this.polarityPanel.add((Component)this.bStepSizeTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bStepSizeTextField.setText("1");
                this.bFrequency = new JCheckBox();
                this.polarityPanel.add((Component)this.bFrequency, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.bFrequency.setText(Language.translate("Frequency", true));
                this.bFrequency.setLayout(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void readTextFieldsFromColumn() {
            ChronColumn.this.getPointColName();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            Object source = ie.getSource();
            if (source == this.bFrequency && this.bFrequency.isSelected()) {
                this.cc.prevExtraColumnHeaderName = this.cc.extraColumnHeaderName;
                this.cc.extraColumnHeaderName = "Number of points per window";
                this.bFrequency.setSelected(true);
                System.out.println("Frequency Clicked");
                if (ChronColumn.this.prevDataMiningFunction != ChronColumn.this.dataMiningFunction) {
                    ChronColumn.this.prevDataMiningFunction = ChronColumn.this.dataMiningFunction;
                }
                ChronColumn.this.dataMiningFunction = 0;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
        }
    }
}

