/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.ages.AgeConverter;
import datastore.editor.AbstractGroupingStewardGenerator;
import datastore.editor.GroupingSteward;
import gui.ImageGenerator;
import gui.LinkProcessor;
import gui.SVGStyleParser;
import gui.Settings;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Vector;
import util.Debug;
import util.FileUtils;

public class FreehandColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public DataColumn underlay = null;
    public double xLow = 0.0;
    public double xHigh = 100.0;
    public List primitives = new Vector();

    public FreehandColumn(String colName) {
        this(colName, null);
    }

    public FreehandColumn(String colName, DataColumn underlayCol) {
        super(colName);
        this.xHigh = this.myWidth;
        this.setColor(new Coloring(Color.white));
        this.underlay = underlayCol;
    }

    @Override
    public void setWidth(double newWidth) {
        super.setWidth(newWidth);
        this.xHigh = this.myWidth;
    }

    public void addPrimitive(Primitive p) {
        this.primitives.add(p);
        if (p.baseAge > this.maxAge) {
            this.maxAge = p.baseAge;
        }
        if (p.topAge < this.minAge) {
            this.minAge = p.topAge;
        }
    }

    @Override
    public SortedSet negateAges() {
        return null;
    }

    @Override
    public void convertAges(AgeConverter translator) {
        for (Primitive prim : this.primitives) {
            prim.convertAges(translator);
        }
        this.updateMinMaxAges();
    }

    @Override
    public double getDataDensity() {
        return (double)(4 * this.primitives.size()) / (this.maxAge - this.minAge);
    }

    @Override
    public void updateMinMaxAges() {
        this.minAge = Double.POSITIVE_INFINITY;
        this.maxAge = Double.NEGATIVE_INFINITY;
        for (Primitive prim : this.primitives) {
            if (prim.topAge < this.minAge) {
                this.minAge = prim.topAge;
            }
            if (!(prim.baseAge > this.maxAge)) continue;
            this.maxAge = prim.baseAge;
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.underlay == null) {
            super.drawData(ig, startx, starty, width, height, settings);
        } else {
            ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        }
        String cp = ig.pushClipPath();
        ig.drawRect(startx, starty, width, height, null);
        ig.popClipPath();
        ig.pushGrouping();
        ig.setClipPath(cp);
        for (Primitive prim : this.primitives) {
            if (!(prim.getBase(ig, settings, starty) - 1.0E-6 > starty) || !(prim.getTop(ig, settings, starty) < starty + height + 1.0E-6)) continue;
            prim.draw(ig, startx, starty, width, height, settings);
        }
        ig.popGrouping();
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void writeOverlay(Writer w) throws IOException {
        this.write(w, "freehand-overlay");
    }

    public void writeUnderlay(Writer w) throws IOException {
        this.write(w, "freehand-underlay");
    }

    @Override
    public void write(Writer w) throws IOException {
        this.write(w, "freehand");
    }

    protected void write(Writer w, String colName) throws IOException {
        this.writeHeader(w, colName);
        for (Primitive p : this.primitives) {
            p.write(w);
        }
    }

    public class FreehandStewardGenerator
    extends AbstractGroupingStewardGenerator {
        @Override
        public GroupingSteward createGroupingSteward(String type) {
            if (type.compareToIgnoreCase("polygon") == 0) {
                return null;
            }
            if (type.compareToIgnoreCase("image") == 0) {
                return null;
            }
            return null;
        }
    }

    public class PolygonGroupingSteward
    extends GroupingSteward {
        public PolygonGroupingSteward(Collection group, String title) {
            super(FreehandColumn.this.data, group, new PolygonTableInterpreter(), title);
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Datapoint p = (Datapoint)iter.next();
                p.series = title;
            }
        }

        @Override
        public void delete() {
            FreehandColumn.this.data.removeAll(this.groupData);
            this.groupData = new Vector();
        }

        @Override
        protected void callForNewDatapoints(Datapoint p) {
            p.series = this.getTitle();
        }
    }

    public class PolygonTableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames = new String[]{"X", "Y", "Smoothed"};
        public String[] myToolTips = new String[]{"Point's x coordinate", "Point's y coordinate, as a percentage of the column width", "Whether or not this point should be smoothed. Blank uses the polygon's setting."};
        public Class[] myClasses = new Class[]{Double.class, Double.class, Boolean.class};

        public PolygonTableInterpreter() {
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return new Double(p.baseAge);
                }
                case 2: {
                    switch (p.lineType) {
                        case 2: {
                            return "dashed";
                        }
                        case 3: {
                            return "dotted";
                        }
                    }
                    return "";
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    if (p.label.compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    if (!Double.isNaN(age)) {
                        p.baseAge = age;
                        break;
                    }
                    p.baseAge = 0.0;
                    break;
                }
                case 2: {
                    String s = value.toString().trim();
                    if (s.compareToIgnoreCase("dashed") == 0) {
                        p.lineType = 2;
                        break;
                    }
                    if (s.compareToIgnoreCase("dotted") == 0) {
                        p.lineType = 3;
                        break;
                    }
                    p.lineType = 1;
                    break;
                }
                case 3: {
                    p.popup = value.toString();
                }
            }
        }
    }

    public class Image
    extends Primitive {
        public static final int FIT = 1;
        public static final int START = 2;
        public static final int CENTER = 3;
        public static final int END = 4;
        String filename;
        int ageType;
        int xType;

        public Image(String filename, int ageType, double topAge, double baseAge, int xType) throws Exception {
            this.filename = null;
            this.ageType = 3;
            this.xType = 3;
            this.filename = filename;
            this.topAge = topAge;
            this.baseAge = baseAge;
            if (FileUtils.getAbsoluteImageURL(filename, FreehandColumn.this.fileInfo) == null) {
                throw new Exception("Image not found!");
            }
        }

        public String getImageFilename() {
            return this.filename;
        }

        @Override
        public void convertAges(AgeConverter conv) {
            super.convertAges(conv);
        }

        @Override
        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            double topAgeUse = this.topAge;
            double baseAgeUse = this.baseAge;
            if (FreehandColumn.this.unit != null && FreehandColumn.this.unit.isNegated()) {
                topAgeUse = -this.baseAge;
                baseAgeUse = -this.topAge;
            }
            System.out.println("topUse: " + topAgeUse + "  baseUse: " + baseAgeUse);
            double y = ImageGenerator.getYFromYear(topAgeUse, starty, settings);
            double h = ImageGenerator.getYFromYear(baseAgeUse, starty, settings) - y;
            if (y + h < starty || y > starty + height) {
                return;
            }
            String preserveAspectRatio = "none";
            String yPart = null;
            String xPart = null;
            switch (this.ageType) {
                case 1: {
                    break;
                }
                case 2: {
                    yPart = "YMin";
                    break;
                }
                case 3: {
                    yPart = "YMid";
                    break;
                }
                case 4: {
                    yPart = "YMax";
                }
            }
            if (yPart != null) {
                switch (this.xType) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        xPart = "xMin";
                        break;
                    }
                    case 3: {
                        xPart = "xMid";
                        break;
                    }
                    case 4: {
                        xPart = "xMax";
                    }
                }
            }
            if (xPart != null && yPart != null) {
                preserveAspectRatio = xPart + yPart;
            }
            ig.drawImage(startx, y, width, h, FileUtils.getAbsoluteImageURL(this.filename, FreehandColumn.this.fileInfo), preserveAspectRatio);
        }

        @Override
        public void write(Writer w) throws IOException {
            w.write("image\t" + this.filename + "\r\n");
            w.write("\tageType\t");
            switch (this.ageType) {
                case 1: {
                    w.write("fit\t");
                    break;
                }
                case 2: {
                    w.write("start\t");
                    break;
                }
                case 3: {
                    w.write("center\t");
                    break;
                }
                case 4: {
                    w.write("end\t");
                }
            }
            w.write(Double.toString(this.topAge) + "\t" + Double.toString(this.baseAge) + "\r\n");
            w.write("\txtype\t");
            switch (this.xType) {
                case 1: {
                    w.write("fit\r\n");
                    break;
                }
                case 2: {
                    w.write("start\r\n");
                    break;
                }
                case 3: {
                    w.write("center\r\n");
                    break;
                }
                case 4: {
                    w.write("end\r\n");
                }
            }
        }
    }

    public class Polygon
    extends Primitive {
        public boolean smoothed;
        public boolean closed;
        public List points;

        public Polygon() {
            this.smoothed = true;
            this.closed = true;
            this.points = new Vector();
        }

        public void addPoint(double x, double y, boolean smooth) {
            Point p = new Point();
            p.x = x;
            p.y = y;
            p.smooth = smooth;
            this.points.add(p);
            if (y > this.baseAge) {
                this.baseAge = y;
            }
            if (y < this.topAge) {
                this.topAge = y;
            }
        }

        public int getNumPoints() {
            return this.points.size();
        }

        public void setPattern(String pat) {
            this.patternFill = pat;
        }

        @Override
        public void convertAges(AgeConverter conv) {
            super.convertAges(conv);
            for (Point p : this.points) {
                p.y = conv.convertAge(p.y, -1);
            }
        }

        @Override
        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            if (this.points.size() < 2) {
                return;
            }
            double[] x = new double[this.points.size()];
            double[] y = new double[this.points.size()];
            boolean[] sharp = new boolean[this.points.size()];
            boolean negated = false;
            if (FreehandColumn.this.unit != null && FreehandColumn.this.unit.isNegated()) {
                negated = true;
            }
            for (int i = 0; i < this.points.size(); ++i) {
                Point p = (Point)this.points.get(negated ? this.points.size() - i - 1 : i);
                x[i] = (p.x - FreehandColumn.this.xLow) * width / (FreehandColumn.this.xHigh - FreehandColumn.this.xLow) + startx;
                double useY = p.y;
                if (FreehandColumn.this.unit != null && FreehandColumn.this.unit.isNegated()) {
                    useY = -p.y;
                }
                y[i] = ImageGenerator.getYFromYear(useY, starty, settings);
                sharp[i] = !p.smooth;
            }
            ig.drawSmoothPolyline(x, y, sharp, this.getStyleString(ig), this.closed);
            if (this.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(this.popup, FreehandColumn.this.fileInfo);
                ig.drawSmoothPolyline(x, y, sharp, "stroke-width: 0; opacity: 0.5; fill: red;", true);
                ig.popGrouping();
            }
        }

        @Override
        public void write(Writer w) throws IOException {
            w.write("polygon\t");
            if (this.smoothed) {
                w.write("smoothed\t");
            } else {
                w.write(9);
            }
            if (this.patternFill != null) {
                w.write(this.patternFill);
            }
            w.write(9);
            if (this.style != null) {
                w.write(SVGStyleParser.getStyleString(this.style));
            }
            w.write(9);
            if (this.popup != null) {
                DataColumn.writeRichText(w, this.popup);
            }
            w.write("\r\n");
            for (Point p : this.points) {
                w.write("\t" + Double.toString(p.x) + "\t" + Double.toString(p.y) + "\t");
                if (p.smooth) {
                    w.write("smoothed");
                } else {
                    w.write("sharp");
                }
                w.write("\r\n");
            }
        }

        public class Point {
            public double x;
            public double y;
            boolean smooth = true;
        }
    }

    public abstract class Primitive {
        public double topAge = Double.POSITIVE_INFINITY;
        public double baseAge = Double.NEGATIVE_INFINITY;
        public double topUnitsAdd;
        public double baseUnitsAdd;
        public String popup;
        public Map style;
        public double strokeWidth = 1.0;
        public String stroke = "black";
        public String fill = "none";
        public String patternFill = null;

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            Debug.print("Parent primitive class draw");
        }

        public double getTop(ImageGenerator ig, Settings settings, double starty) {
            double topUse = this.topAge;
            if (FreehandColumn.this.unit.isNegated()) {
                topUse = -this.baseAge;
            }
            return (topUse - settings.topAge) * settings.unitsPerMY - this.topUnitsAdd + starty;
        }

        public double getBase(ImageGenerator ig, Settings settings, double starty) {
            double baseUse = this.baseAge;
            if (FreehandColumn.this.unit.isNegated()) {
                baseUse = -this.topAge;
            }
            return (baseUse - settings.topAge) * settings.unitsPerMY + this.baseUnitsAdd + starty;
        }

        public void convertAges(AgeConverter conv) {
            this.topAge = conv.convertAge(this.topAge, -1);
            this.baseAge = conv.convertAge(this.baseAge, 1);
        }

        public void setStyle(String SVGStyle) {
            this.style = SVGStyleParser.parseSVGStyle(SVGStyle);
            this.strokeWidth = SVGStyleParser.getDouble(this.style, "stroke-width", this.strokeWidth);
            this.stroke = SVGStyleParser.getString(this.style, "stroke", this.stroke);
            this.fill = SVGStyleParser.getString(this.style, "fill", this.fill);
            this.style.remove("stroke-width");
            this.style.remove("stroke");
            this.style.remove("fill");
            this.topUnitsAdd = this.baseUnitsAdd = this.strokeWidth / 2.0;
        }

        public String getStyleString(ImageGenerator ig) {
            String ret = SVGStyleParser.getStyleString(this.style);
            ret = ret + SVGStyleParser.getStyleString("stroke-width", "" + this.strokeWidth);
            ret = ret + SVGStyleParser.getStyleString("stroke", this.stroke);
            if (this.patternFill != null) {
                this.fill = ig.patMan.getPatternFill(this.patternFill);
            }
            ret = ret + SVGStyleParser.getStyleString("fill", this.fill);
            return ret;
        }

        public void write(Writer w) throws IOException {
        }
    }
}

