/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import gui.ImageGenerator;
import gui.Settings;
import gui.editor.ComboBoxRenderer;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import path.ResPath;
import util.NumberUtils;
import util.Util;

public class SequenceColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public static final double SEQ_MINOR = 0.25;
    public static final double SEQ_MEDIUM = 0.5;
    public static final double SEQ_MAJOR = 0.75;
    public static final double TR_MINOR = 0.33;
    public static final double TR_MEDIUM = 0.66;
    public static final double TR_MAJOR = 1.0;
    public static final int SEQUENCE = 1;
    public static final int TREND = 2;
    public static final String SEQUENCE_STYLE = "stroke-width: 0; fill: rgb(64, 191, 233);";
    public static final String TREND_STYLE = "stroke-width: 1; stroke: black; fill: rgb(64, 191, 233);";
    public static final String MFS_LINE_STYLE = "stroke-width: 0.5; stroke: black;stroke-dasharray:7,4;";
    public static final String MINOR_LINE_STYLE = "stroke-width: 1; stroke: black;";
    public static final String MEDIUM_LINE_STYLE = "stroke-width: 2; stroke: black;";
    public static final String MAJOR_LINE_STYLE = "stroke-width: 3; stroke: black;";
    public static final double LABEL_MARGIN_SIZE_LEFT = 5.0;
    public static final double LABEL_MARGIN_SIZE_RIGHT = 5.0;
    public static final double LABEL_MARGIN_SIZE_LEFT_WITH_AGE = 25.0;
    public double labelMarginLeft = 5.0;
    public double labelMarginRight = 5.0;
    public String graphStyle = "stroke-width: 0; fill: rgb(64, 191, 233);";
    public int type = 1;
    public boolean drawNameLabel = true;

    public static double roundMag(double mag, int colType) {
        if (colType == 1) {
            if (mag < 0.375) {
                return 0.25;
            }
            if (mag < 0.875) {
                return 0.5;
            }
            return 0.75;
        }
        if (mag < 0.495) {
            return 0.33;
        }
        if (mag < 1.1600000000000001) {
            return 0.66;
        }
        return 1.0;
    }

    public double getXFromMag(double mag, String dir, double startx, double width) {
        if (dir.compareToIgnoreCase("SB") == 0) {
            return width + startx;
        }
        return startx + width - width * mag;
    }

    public static double getMag(Datapoint p) {
        if (p.value == null) {
            p.value = new Double(0.0);
        }
        return (Double)p.value;
    }

    public double getGraphMag(double mag, String direction) {
        if (direction.compareToIgnoreCase("SB") == 0) {
            return 0.0;
        }
        return mag;
    }

    public double getIntersectionMag(Datapoint top, Datapoint base, double cutAge) {
        double magBase;
        if (top == null || base == null) {
            return -1.0;
        }
        if (base.baseAge < top.baseAge) {
            Datapoint temp = top;
            top = base;
            base = temp;
        }
        if (top.baseAge > cutAge || base.baseAge < cutAge) {
            return -1.0;
        }
        double magTop = this.getGraphMag(SequenceColumn.getMag(top), top.direction);
        if (NumberUtils.isEqual(magTop, magBase = this.getGraphMag(SequenceColumn.getMag(base), base.direction))) {
            return magTop;
        }
        double slope = (magTop - magBase) / (top.baseAge - base.baseAge);
        double ret = magBase + (cutAge - base.baseAge) * slope;
        return ret;
    }

    public SequenceColumn(String colName, int type) {
        super(colName);
        if (type == 2) {
            this.type = 2;
            this.graphStyle = TREND_STYLE;
            this.setColor(new Coloring(new Color(245, 204, 131)));
        } else {
            this.type = 1;
            this.graphStyle = SEQUENCE_STYLE;
            this.setColor(new Coloring(Color.WHITE));
        }
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final SequenceColumn thisSC = this;
            JCheckBox nameLabelCB = new JCheckBox("Show Name Labels");
            nameLabelCB.setSelected(this.drawNameLabel);
            nameLabelCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    thisSC.drawNameLabel = ((JCheckBox)ie.getItem()).isSelected();
                }
            });
            this.optionsPanel.add(nameLabelCB);
        }
        return this.optionsPanel;
    }

    @Override
    public String getIconPath() {
        this.iconPath = this.type == 1 ? ResPath.getPath("icons.col_icon_sequence") : ResPath.getPath("icons.col_icon_trend");
        return this.iconPath;
    }

    @Override
    public SortedSet negateAges() {
        return this.negateAgesBreakerBased();
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        CollisionAvoider.Node node;
        int i;
        double textToAddBase;
        double mag;
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getDrawingData();
        Datapoint p2 = null;
        Datapoint lastP = null;
        boolean setupTop = true;
        boolean drawBaseClipped = false;
        Vector<Double> x = new Vector<Double>();
        Vector<Double> y = new Vector<Double>();
        Vector<Datapoint> trendLinesToDraw = new Vector<Datapoint>();
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        CollisionAvoider text_ca = new CollisionAvoider(0.0, height, 0.0, width - this.labelMarginLeft - this.labelMarginRight, width - this.labelMarginLeft - this.labelMarginRight);
        CollisionAvoider al_ca = new CollisionAvoider(0.0, height, 0.0, 20.0, 20.0);
        double textToAddTop = settings.topAge;
        double textToAddCenter = settings.topAge;
        Datapoint textToAddPoint = null;
        if (this.drawAgeLabel) {
            this.labelMarginLeft = 25.0;
        }
        while (iter.hasNext()) {
            String s;
            p2 = (Datapoint)iter.next();
            if (settings.isAbove(p2.baseAge)) {
                lastP = p2;
                continue;
            }
            if (settings.isBelow(p2.baseAge)) {
                drawBaseClipped = true;
                break;
            }
            if (setupTop) {
                if (lastP != null) {
                    mag = this.getIntersectionMag(lastP, p2, settings.topAge);
                    if (mag < 0.0) {
                        mag = 0.0;
                    }
                    x.add(new Double(startx + width));
                    y.add(new Double(starty));
                    x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
                    y.add(new Double(starty));
                } else {
                    x.add(new Double(startx + width));
                    y.add(new Double(ImageGenerator.getYFromYear(p2.baseAge, starty, settings)));
                }
                setupTop = false;
            }
            mag = SequenceColumn.getMag(p2);
            double curX = this.getXFromMag(this.getGraphMag(mag, p2.direction), p2.direction, startx, width);
            double curY = ImageGenerator.getYFromYear(p2.baseAge, starty, settings);
            x.add(new Double(curX));
            y.add(new Double(curY));
            if (this.type == 1) {
                if (p2.direction.compareToIgnoreCase("SB") == 0) {
                    s = mag == 0.25 ? MINOR_LINE_STYLE : (mag == 0.5 ? MEDIUM_LINE_STYLE : MAJOR_LINE_STYLE);
                    ig.drawLine(startx, curY, curX, curY, s);
                } else {
                    ig.drawLine(startx, curY, curX, curY, MFS_LINE_STYLE);
                }
            } else {
                s = mag == 0.33 ? MINOR_LINE_STYLE : (mag == 0.66 ? MEDIUM_LINE_STYLE : MAJOR_LINE_STYLE);
                Datapoint tlp = new Datapoint(curY);
                tlp.label = s;
                trendLinesToDraw.add(tlp);
            }
            if (textToAddPoint != null) {
                textToAddBase = (textToAddCenter + p2.baseAge) / 2.0;
                if (this.drawNameLabel) {
                    text_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(textToAddPoint.label, this.fonts.getFont(4), 1, this.fileInfo));
                }
                if (this.drawAgeLabel) {
                    al_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(this.getAgeLabel(textToAddPoint.baseAge), this.fonts.getFont(1), 1, this.fileInfo));
                }
                textToAddTop = textToAddBase;
                textToAddPoint = null;
            }
            textToAddPoint = p2;
            textToAddCenter = p2.baseAge;
            lastP = p2;
        }
        if (p2 == null) {
            return;
        }
        if (setupTop) {
            if (lastP != null) {
                mag = this.getIntersectionMag(lastP, p2, settings.topAge);
                if (mag < 0.0) {
                    mag = 0.0;
                }
                x.add(new Double(startx + width));
                y.add(new Double(starty));
                x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
                y.add(new Double(starty));
            } else {
                x.add(new Double(startx + width));
                y.add(new Double(ImageGenerator.getYFromYear(p2.baseAge, starty, settings)));
            }
            setupTop = false;
        }
        if (drawBaseClipped) {
            mag = this.getIntersectionMag(lastP, p2, settings.baseAge);
            if (mag < 0.0) {
                mag = 0.0;
            }
            x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
            y.add(new Double(starty + height));
            x.add(new Double(startx + width));
            y.add(new Double(starty + height));
        } else {
            x.add(new Double(startx + width));
            y.add(new Double(ImageGenerator.getYFromYear(p2.baseAge, starty, settings)));
        }
        double[] coordX = Util.getDoubleArray(x);
        double[] coordY = Util.getDoubleArray(y);
        ig.drawPolygon(coordX, coordY, this.graphStyle);
        if (this.type != 1) {
            for (Datapoint p2 : trendLinesToDraw) {
                ig.drawLine(startx, p2.baseAge, startx + width, p2.baseAge, p2.label);
            }
        }
        if (textToAddPoint != null) {
            textToAddBase = settings.baseAge;
            if (this.drawNameLabel) {
                text_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(textToAddPoint.label, this.fonts.getFont(4), 1, this.fileInfo));
            }
            if (this.drawAgeLabel) {
                al_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(this.getAgeLabel(textToAddPoint.baseAge), this.fonts.getFont(1), 1, this.fileInfo));
            }
            textToAddPoint = null;
        }
        if (this.drawNameLabel) {
            text_ca.scaleToFit();
            for (i = 0; i < text_ca.getNumNodes(); ++i) {
                node = text_ca.getAt(i);
                if (node.dp == null || node.dp.breaker) continue;
                ig.drawString(node.swi, startx + this.labelMarginLeft, node.calcTop + starty, width - this.labelMarginLeft - this.labelMarginRight, node.getCalcHeight(), 4, ImageGenerator.getYFromYear(node.dp.baseAge, starty, settings), 12, this.color.getColor(node.dp.baseAge, node.dp.baseAge));
                if (node.dp.popup == null || !settings.doPopups) continue;
                ig.pushGrouping();
                ig.doPopupThings(node.dp.popup, this.fileInfo);
                ig.drawRect(startx + this.labelMarginLeft, node.calcTop + starty, width - this.labelMarginLeft - this.labelMarginRight, node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
                ig.popGrouping();
            }
        }
        if (this.drawAgeLabel) {
            al_ca.scaleToFit();
            for (i = 0; i < al_ca.getNumNodes(); ++i) {
                node = al_ca.getAt(i);
                if (node.dp == null || node.dp.breaker) continue;
                ig.drawString(node.swi, startx + 10.0, node.calcTop + starty, 20.0, node.getCalcHeight(), 4, ImageGenerator.getYFromYear(node.dp.baseAge, starty, settings), 12, this.color.getColor(node.dp.baseAge, node.dp.baseAge));
            }
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("labelMarginLeft") == 0) {
                this.labelMarginLeft = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("labelMarginRight") == 0) {
                this.labelMarginRight = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("graphStyle") == 0) {
                this.graphStyle = Settings.getNodeTextContent(setting);
            } else if (name.compareToIgnoreCase("type") == 0) {
                String t = setting.getAttribute("type");
                this.type = t.compareToIgnoreCase("sequence") == 0 ? 1 : 2;
            } else if (name.compareToIgnoreCase("drawNameLabel") == 0) {
                this.drawNameLabel = Boolean.valueOf(Settings.getNodeTextContent(setting));
            }
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        element.appendChild(Settings.createSimpleSetting(doc, "labelMarginLeft", "" + this.labelMarginLeft));
        element.appendChild(Settings.createSimpleSetting(doc, "labelMarginRight", "" + this.labelMarginRight));
        element.appendChild(Settings.createSimpleSetting(doc, "graphStyle", this.graphStyle));
        element.appendChild(Settings.createSimpleSetting(doc, "drawNameLabel", "" + this.drawNameLabel));
        Element typeE = Settings.createSimpleSetting(doc, "type", null);
        if (this.type == 1) {
            typeE.setAttribute("type", "sequence");
        } else {
            typeE.setAttribute("type", "trend");
        }
        element.appendChild(typeE);
    }

    @Override
    public void write(Writer w) throws IOException {
        this.writeHeader(w, this.type == 2 ? "trend" : "sequence");
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            Datapoint dp = (Datapoint)iter.next();
            w.write("\t");
            if (dp.label != null) {
                w.write(dp.label + "\t");
            } else {
                w.write(9);
            }
            w.write(dp.direction + "\t");
            w.write(Double.toString(dp.baseAge) + "\t");
            w.write(this.getStringMagnitude(SequenceColumn.getMag(dp)) + "\t");
            if (dp.popup != null) {
                SequenceColumn.writeRichText(w, dp.popup);
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }

    protected String getStringMagnitude(double mag) {
        if (this.type == 2) {
            if (mag < 0.495) {
                return "Minor";
            }
            if (mag < 0.8300000000000001) {
                return "Medium";
            }
            return "Major";
        }
        if (mag < 0.375) {
            return "Minor";
        }
        if (mag < 0.625) {
            return "Medium";
        }
        return "Major";
    }

    protected double getDoubleMagnitude(String strength) {
        if (strength.compareToIgnoreCase("Minor") == 0) {
            return this.type == 1 ? 0.25 : 0.33;
        }
        if (strength.compareToIgnoreCase("Medium") == 0) {
            return this.type == 1 ? 0.5 : 0.66;
        }
        if (strength.compareToIgnoreCase("Moderate") == 0) {
            return this.type == 1 ? 0.5 : 0.66;
        }
        if (strength.compareToIgnoreCase("Major") == 0) {
            return this.type == 1 ? 0.75 : 1.0;
        }
        return 0.0;
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setSingle(new DataSteward(this.data, new TableInterpreter()));
        return series;
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames = new String[]{"Label", "Direction", "Age", "Strength", "Popup"};
        public String[] myToolTips = new String[]{"Text", "SB or MFS", null, "Major, Medium or Minor", "Text of popup window"};
        public Class[] myClasses = new Class[]{String.class, DirectionType.class, Double.class, StrengthType.class, String.class};

        public TableInterpreter() {
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
            spread.setDefaultEditor(DirectionType.class, new DefaultCellEditor(new DirectionType().getComboBox()));
            spread.setDefaultEditor(StrengthType.class, new DefaultCellEditor(new StrengthType().getComboBox()));
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return p.direction;
                }
                case 2: {
                    return new Double(p.baseAge);
                }
                case 3: {
                    return SequenceColumn.this.getStringMagnitude(SequenceColumn.getMag(p));
                }
                case 4: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    if (p.label.compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    p.direction = value.toString();
                    break;
                }
                case 2: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    if (!Double.isNaN(age)) {
                        p.baseAge = age;
                        break;
                    }
                    p.baseAge = 0.0;
                    break;
                }
                case 3: {
                    if (value == null) {
                        p.value = new Double(0.0);
                        break;
                    }
                    String s = value.toString().trim();
                    p.value = new Double(SequenceColumn.this.getDoubleMagnitude(s));
                    break;
                }
                case 4: {
                    p.popup = value.toString();
                }
            }
        }

        @Override
        public Datapoint createEmptyDatapoint() {
            Datapoint p = new Datapoint();
            p.value = new Double(0.0);
            return p;
        }

        public class StrengthType
        extends ComboBoxRenderer {
            private static final long serialVersionUID = 1L;

            public StrengthType() {
                super(new String[]{"Major", "Medium", "Minor"});
            }
        }

        public class DirectionType
        extends ComboBoxRenderer {
            private static final long serialVersionUID = 1L;

            public DirectionType() {
                super(new String[]{"MFS", "SB"});
            }
        }
    }
}

