/*
 * Decompiled with CFR 0.152.
 */
package datastore.loader;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import datastore.AgeAgeColumn;
import datastore.BlockSeriesMetaColumn;
import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.FaciesColumn;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RulerColumn;
import datastore.SequenceColumn;
import datastore.TransectColumn;
import datastore.ZoneColumn;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonLoader {
    public Datastore ds;
    public DataColumn.FileInfo fileInfo;
    private InputStreamReader inReader;

    public JsonLoader(Datastore ds, InputStream in, DataColumn.FileInfo fileInfo) throws IOException {
        this.ds = ds;
        this.inReader = new InputStreamReader(in, "UTF-8");
        this.fileInfo = fileInfo;
    }

    public void loadData() throws IOException {
        JsonReader reader = new JsonReader((Reader)this.inReader);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("color-scheme")) {
                this.ds.setDefaultColorScheme(this.columnColorString(reader.nextString()));
                continue;
            }
            if (name.equals("root-columns")) {
                reader.beginArray();
                while (reader.hasNext()) {
                    this.addRootColumn(reader);
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
    }

    private void addRootColumn(JsonReader reader) throws IOException {
        reader.setLenient(true);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name") && reader.peek() != JsonToken.NULL) {
                this.ds.setCurrentChartTitle(reader.nextString());
                continue;
            }
            if (name.equals("units") && reader.peek() != JsonToken.NULL) {
                this.ds.setCurrentUnits(reader.nextString());
                continue;
            }
            if (name.equals("selected") && reader.peek() != JsonToken.NULL) {
                this.ds.currentSubRoot.selected = reader.nextBoolean();
                continue;
            }
            if (name.equals("popup") && reader.peek() != JsonToken.NULL) {
                this.ds.currentSubRoot.popup = reader.nextString();
                continue;
            }
            if (name.equals("sub-columns")) {
                reader.beginArray();
                while (reader.hasNext()) {
                    this.ds.addColumn(this.addSubColumn(reader));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    public Datapoint getData(JsonReader reader) throws IOException {
        Datapoint dp = new Datapoint();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name") && reader.peek() != JsonToken.NULL) {
                dp.label = reader.nextString();
                continue;
            }
            if (name.equals("base-age") && reader.peek() != JsonToken.NULL) {
                dp.baseAge = reader.nextDouble();
                continue;
            }
            if (name.equals("value") && reader.peek() != JsonToken.NULL) {
                dp.value = reader.nextString();
                continue;
            }
            if (name.equals("line-type") && reader.peek() != JsonToken.NULL) {
                dp.lineType = reader.nextInt();
                continue;
            }
            if (name.equals("uncertainty") && reader.peek() != JsonToken.NULL) {
                dp.uncertainty = reader.nextString();
                continue;
            }
            if (name.equals("priority") && reader.peek() != JsonToken.NULL) {
                dp.priority = reader.nextInt();
                continue;
            }
            if (name.equals("breaker") && reader.peek() != JsonToken.NULL) {
                dp.breaker = reader.nextBoolean();
                continue;
            }
            if (name.equals("popup") && reader.peek() != JsonToken.NULL) {
                dp.popup = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return dp;
    }

    public DataColumn addSubColumn(JsonReader reader) throws IOException {
        String colName = "Untitled";
        double width = 0.0;
        boolean selected = false;
        String popup = null;
        String units = "ma";
        String type = "meta";
        String bgColor = "none";
        DataColumn column = null;
        boolean blockSeriesMetaType = true;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name") && reader.peek() != JsonToken.NULL) {
                colName = reader.nextString();
                System.out.println(colName + "---------------------------");
                continue;
            }
            if (name.equals("width") && reader.peek() != JsonToken.NULL) {
                width = reader.nextDouble();
                continue;
            }
            if (name.equals("selected") && reader.peek() != JsonToken.NULL) {
                selected = reader.nextBoolean();
                continue;
            }
            if (name.equals("popup") && reader.peek() != JsonToken.NULL) {
                popup = reader.nextString();
                continue;
            }
            if (name.equals("units") && reader.peek() != JsonToken.NULL) {
                units = reader.nextString();
                continue;
            }
            if (name.equals("background-color") && reader.peek() != JsonToken.NULL) {
                bgColor = reader.nextString();
                continue;
            }
            if (name.equals("column-type") && reader.peek() != JsonToken.NULL) {
                type = reader.nextString();
                if (type.equals("meta")) {
                    column = new MetaColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("event")) {
                    column = new EventColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("zone")) {
                    column = new ZoneColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("ruler")) {
                    column = new RulerColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("range")) {
                    column = new RangeColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("chron")) {
                    column = new ChronColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("facies")) {
                    column = new FaciesColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("point")) {
                    column = new PointColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("freehand")) {
                    column = new FreehandColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (type.equals("transect")) {
                    column = new TransectColumn(colName);
                    column.selected = selected;
                    column.setDS(this.ds);
                    column.setWidth(width);
                    if (bgColor.equals("none")) continue;
                    column.setColor(this.getbgColor(bgColor));
                    continue;
                }
                if (!type.equals("age-age")) continue;
                column = new AgeAgeColumn(colName);
                column.selected = selected;
                column.setDS(this.ds);
                column.setWidth(width);
                if (bgColor.equals("none")) continue;
                column.setColor(this.getbgColor(bgColor));
                continue;
            }
            if (type.equals("sequence") && name.equals("type") && reader.peek() != JsonToken.NULL) {
                column = new SequenceColumn(colName, reader.nextInt());
                column.selected = selected;
                column.setDS(this.ds);
                column.setWidth(width);
                if (bgColor.equals("none")) continue;
                column.setColor(this.getbgColor(bgColor));
                continue;
            }
            if (type.equals("block-series-meta") && name.equals("type") && reader.peek() != JsonToken.NULL) {
                column = new BlockSeriesMetaColumn(colName, reader.nextInt());
                column.selected = selected;
                column.setDS(this.ds);
                column.setWidth(width);
                if (bgColor.equals("none")) continue;
                column.setColor(this.getbgColor(bgColor));
                continue;
            }
            if (column != null && column instanceof BlockSeriesMetaColumn && name.equals("level") && reader.peek() != JsonToken.NULL) {
                BlockSeriesMetaColumn bsmCol = (BlockSeriesMetaColumn)column;
                bsmCol.level = reader.nextInt();
                continue;
            }
            if (column != null && column instanceof MetaColumn && name.equals("sub-columns") && reader.peek() != JsonToken.NULL) {
                DataColumn mcol = column;
                reader.beginArray();
                while (reader.hasNext()) {
                    ((MetaColumn)mcol).addColumn(this.addSubColumn(reader));
                }
                reader.endArray();
                continue;
            }
            if (column != null && !(column instanceof MetaColumn) && name.equals("data") && reader.peek() != JsonToken.NULL) {
                reader.beginArray();
                while (reader.hasNext()) {
                    column.addData(this.getData(reader));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return column;
    }

    public Coloring columnColorString(String color) {
        if ((color = color.toString().trim()).compareToIgnoreCase("CHRONOSTRAT") == 0) {
            return Coloring.USGS;
        }
        if (color.compareToIgnoreCase("USGS") == 0) {
            return Coloring.USGS;
        }
        if (color.compareToIgnoreCase("USGS-NAMED") == 0) {
            return Coloring.NAMED_USGS;
        }
        if (color.compareToIgnoreCase("UNESCO") == 0) {
            return Coloring.UNESCO;
        }
        if (color.compareToIgnoreCase("UNESCO-NAMED") == 0) {
            return Coloring.NAMED_UNESCO;
        }
        if (color.compareToIgnoreCase("nocolor") == 0) {
            return null;
        }
        if (color.length() > 1) {
            Coloring c = Coloring.getColoring(color);
            if (c == null) {
                return Coloring.USGS;
            }
            return c;
        }
        return null;
    }

    public Coloring getbgColor(String bgColor) {
        if (bgColor.equalsIgnoreCase("USGS")) {
            return Coloring.USGS;
        }
        if (bgColor.equalsIgnoreCase("UNESCO")) {
            return Coloring.UNESCO;
        }
        return new Coloring(Color.decode(bgColor));
    }
}

