/*
 * Decompiled with CFR 0.152.
 */
package datastore.searchresults;

import datastore.DataColumn;
import datastore.Datapoint;
import gui.Settings;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeNode;

public class Searchpoint
implements HyperlinkListener,
ActionListener {
    public static Double lowerAgetoChart = Double.NEGATIVE_INFINITY;
    public static Double upperAgetoChart = Double.POSITIVE_INFINITY;
    private Settings settings = null;
    public String Hierarchy = null;
    public Vector<String> vectorHier = null;
    public String baseAge = null;
    public Double lboundAge = Double.NEGATIVE_INFINITY;
    public Double uboundAge = Double.POSITIVE_INFINITY;
    public String columnType = null;
    public String Qualifier = null;
    public String Comments = null;
    public JCheckBox checktoChart = null;
    public JLabel labelHier = null;
    public JToggleButton buttonInfo = null;
    public JWindow popupHier = null;
    public JFrame popupInfo = null;
    private JScrollPane commentsPane = null;

    public Searchpoint() {
    }

    public Searchpoint(Datapoint p, ArrayList<String> hierarchy) {
        Iterator<String> iter = hierarchy.iterator();
        String ancestorEvent = null;
        this.Hierarchy = "<html><B>Hierarchy-" + p.label + "</B><br> ";
        while (iter.hasNext()) {
            ancestorEvent = iter.next();
            this.Hierarchy = this.Hierarchy + "<br>  " + ancestorEvent;
        }
        this.Hierarchy = this.Hierarchy + "<br>  " + p.label + "</html>";
        this.vectorHier = new Vector();
        this.vectorHier.add(ancestorEvent);
        this.vectorHier.add(p.label);
        this.baseAge = Double.toString(p.baseAge);
        this.uboundAge = p.baseAge;
        this.lboundAge = p.baseAge;
        if (p.value != null) {
            this.Qualifier = p.value.toString();
        }
        if (p.popup != null) {
            this.Comments = "Comments: " + p.popup;
        }
        if (p.priority != 0) {
            this.Comments = this.Comments != null ? "Priority(10=Highest) = " + p.priority + "; " + this.Comments : "Priority(10=Highest) = " + p.priority + ";";
        }
        if (p.uncertainty != null) {
            this.Comments = this.Comments != null ? "Uncertainty = " + p.uncertainty + "; " + this.Comments : "Uncertainty = " + p.uncertainty + ";";
        }
        if (this.Comments != null) {
            this.Comments = "<html><p>" + this.Comments + "</html></p>";
        }
    }

    public JCheckBox getChecktoChart() {
        if (this.checktoChart == null) {
            this.checktoChart = new JCheckBox();
            this.checktoChart.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object item = e.getItem();
                    if (item == Searchpoint.this.checktoChart) {
                        boolean selected = Searchpoint.this.checktoChart.isSelected();
                        Searchpoint.this.searchCheckItem(Searchpoint.this.vectorHier.get(0), selected);
                        Searchpoint.this.pruneAgeRange(selected);
                        Searchpoint.this.checktoChart.setSelected(selected);
                    }
                }
            });
            this.checktoChart.setEnabled(true);
        }
        return this.checktoChart;
    }

    public JLabel getHierButton() {
        if (this.labelHier == null) {
            this.labelHier = new JLabel(this.vectorHier.get(0));
            this.labelHier.addMouseListener(new MouseListener(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (Searchpoint.this.popupHier == null) {
                        Searchpoint.this.popupHier = new JWindow();
                        JLabel hier = new JLabel(Searchpoint.this.Hierarchy);
                        hier.setOpaque(true);
                        hier.setBackground(Color.ORANGE);
                        Searchpoint.this.popupHier.add(hier);
                        Searchpoint.this.popupHier.pack();
                    }
                    Point p = Searchpoint.this.labelHier.getLocationOnScreen();
                    double x = Searchpoint.this.labelHier.getWidth();
                    p.x = p.x + (int)x + 2;
                    Searchpoint.this.popupHier.setLocation(p);
                    Searchpoint.this.popupHier.setVisible(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (Searchpoint.this.popupHier != null) {
                        Searchpoint.this.popupHier.setVisible(false);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        return this.labelHier;
    }

    public JToggleButton getCommentsButton() {
        if (this.buttonInfo == null) {
            this.buttonInfo = new JToggleButton("Additional Info");
            this.buttonInfo.setOpaque(true);
            this.buttonInfo.addActionListener(this);
        }
        return this.buttonInfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonInfo) {
            if (this.popupInfo == null) {
                this.popupInfo = new JFrame("Comments - " + this.vectorHier.lastElement());
                this.popupInfo.setDefaultCloseOperation(1);
                this.popupInfo.setSize(300, 150);
                JEditorPane commentsHtml = new JEditorPane();
                this.commentsPane = new JScrollPane(commentsHtml, 20, 31);
                commentsHtml.setEditable(false);
                commentsHtml.setContentType("text/html");
                commentsHtml.setText(this.Comments);
                commentsHtml.addHyperlinkListener(this);
                this.popupInfo.add(this.commentsPane);
                Settings.globalOpenCommentsPane(this.popupInfo);
            }
            this.resetScrollBar();
            if (this.popupInfo.isVisible()) {
                this.popupInfo.setVisible(false);
                return;
            }
            Point p = this.buttonInfo.getLocationOnScreen();
            double x = this.buttonInfo.getWidth();
            p.x = p.x + (int)x + 1;
            this.popupInfo.setLocation(p);
            this.popupInfo.setVisible(true);
        }
    }

    protected void resetScrollBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Searchpoint.this.commentsPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            TSCreator.launchBrowser(event.getURL().toExternalForm());
        }
    }

    public void putSettingsReference(Settings settings) {
        if (this.settings == null) {
            this.settings = settings;
        }
    }

    private void searchCheckItem(String treeNode, boolean selected) {
        Iterator<DataColumn> iter = this.settings.ds.currentSubRoot.getSubColumns();
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            if (dc.name.equalsIgnoreCase(treeNode)) {
                dc.noofTimesResultSelected = selected ? ++dc.noofTimesResultSelected : --dc.noofTimesResultSelected;
                if (dc.noofTimesResultSelected == 0) {
                    if (dc.checkboxPanel.checkbox.isSelected()) {
                        dc.checkboxPanel.checkbox.doClick();
                    }
                } else {
                    if (dc.checkboxPanel.checkbox.isSelected()) {
                        dc.checkboxPanel.checkbox.setSelected(false);
                    }
                    dc.checkboxPanel.checkbox.doClick();
                    this.settings.clickedColumnsInSearch(dc);
                }
            }
            this.searchColumn(dc, treeNode, selected);
        }
    }

    private void searchColumn(TreeNode node, String treeNode, boolean selected) {
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                DataColumn p = (DataColumn)n;
                if (p.name.equalsIgnoreCase(treeNode)) {
                    p.noofTimesResultSelected = selected ? ++p.noofTimesResultSelected : --p.noofTimesResultSelected;
                    if (p.noofTimesResultSelected == 0) {
                        if (p.checkboxPanel.checkbox.isSelected()) {
                            p.checkboxPanel.checkbox.doClick();
                        }
                    } else {
                        if (p.checkboxPanel.checkbox.isSelected()) {
                            p.checkboxPanel.checkbox.setSelected(false);
                        }
                        p.checkboxPanel.checkbox.doClick();
                        this.settings.clickedColumnsInSearch(p);
                    }
                }
                this.searchColumn(n, treeNode, selected);
            }
        }
    }

    private void pruneAgeRange(boolean selected) {
        if (lowerAgetoChart == Double.NEGATIVE_INFINITY && upperAgetoChart == Double.POSITIVE_INFINITY) {
            upperAgetoChart = this.uboundAge;
            lowerAgetoChart = this.lboundAge;
        }
        if (this.lboundAge < lowerAgetoChart) {
            lowerAgetoChart = this.lboundAge;
        }
        if (this.uboundAge > upperAgetoChart) {
            upperAgetoChart = this.uboundAge;
        }
        this.settings.updateAgeSet(selected, this.lboundAge, this.uboundAge);
        this.settings.updateAgeFromSearchResults();
    }
}

