/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.Unit;
import gui.ImageSizeDialog;
import gui.RasterSave;
import gui.settings.SelectedTimes;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.svg.SVGDocument;
import util.Util;

public class AutoGenOptions {
    public Map<String, SelectedTimes> times = new HashMap<String, SelectedTimes>();
    public boolean autoVSForAll = false;
    public int width = -1;
    public int height = -1;
    public double zoom = 100.0;
    public double dpi = -1.0;

    public RasterSave.RasterSaveOptions getRasterSaveOptions(SVGDocument doc) {
        RasterSave.RasterSaveOptions rso = new RasterSave.RasterSaveOptions();
        ImageSizeDialog.ImageInfo imageInfo = new ImageSizeDialog.ImageInfo(doc);
        if (this.width > 0) {
            rso.width = this.width;
            rso.height = (int)Math.ceil((double)this.width / imageInfo.aspect);
        } else if (this.height > 0) {
            rso.height = this.height;
            rso.width = (int)Math.ceil(imageInfo.aspect * (double)this.height);
        } else if (this.dpi > 0.0) {
            imageInfo.convertTo(2);
            rso.width = (int)Math.ceil(imageInfo.unitWidth * this.dpi);
            rso.height = (int)Math.ceil(imageInfo.unitHeight * this.dpi);
        } else {
            rso.width = (int)Math.ceil(this.zoom / 100.0 * imageInfo.svgWidth);
            rso.height = (int)Math.ceil(this.zoom / 100.0 * imageInfo.svgHeight);
        }
        return rso;
    }

    public SelectedTimes getSTForUnit(Unit u) {
        return this.times.get(u.toString());
    }

    protected SelectedTimes getSTForUnit(String u) {
        SelectedTimes st = this.times.get(u);
        if (st == null) {
            st = new SelectedTimes();
            this.times.put(u, st);
        }
        return st;
    }

    protected static UnitArg parseUnitArgument(String arg, double dflt) {
        UnitArg ret = new UnitArg();
        ret.u = "";
        ret.arg = -1.0;
        String value = arg.trim();
        int colon = arg.indexOf(":");
        if (colon > 0) {
            ret.u = arg.substring(0, colon);
            value = arg.substring(colon + 1).trim();
        }
        if (value.length() > 0) {
            ret.arg = Util.parseDouble(value, dflt);
        }
        return ret;
    }

    public boolean parseCommandLineArgument(String arg) {
        if (arg.startsWith("vs=")) {
            UnitArg ua = AutoGenOptions.parseUnitArgument(arg.substring(arg.indexOf(61) + 1), 1.0);
            SelectedTimes st = this.getSTForUnit(ua.u);
            st.vertScale = ua.arg;
            System.out.println("Using vertical scale " + st.vertScale + "for " + ua.u);
            return true;
        }
        if (arg.endsWith("autovs")) {
            if (arg.equals("autovs")) {
                this.autoVSForAll = true;
                System.out.println("Using automatic vertical scale for the entire chart. ");
            } else {
                String u = "";
                int colon = arg.indexOf(":");
                if (colon > 0) {
                    u = arg.substring(0, colon);
                }
                SelectedTimes st = this.getSTForUnit(u);
                st.vertScale = -1.0;
                System.out.println("Using automatic vertical scale for " + u);
            }
            return true;
        }
        if (arg.startsWith("top=")) {
            UnitArg ua = AutoGenOptions.parseUnitArgument(arg.substring(arg.indexOf(61) + 1), 1.0);
            SelectedTimes st = this.getSTForUnit(ua.u);
            st.topAge = ua.arg;
            System.out.println("Using top=" + st.topAge + " for " + ua.u);
            return true;
        }
        if (arg.startsWith("base=")) {
            UnitArg ua = AutoGenOptions.parseUnitArgument(arg.substring(arg.indexOf(61) + 1), 1.0);
            SelectedTimes st = this.getSTForUnit(ua.u);
            st.baseAge = ua.arg;
            System.out.println("Using base=" + st.baseAge + " for " + ua.u);
            return true;
        }
        if (arg.startsWith("width=")) {
            this.width = (int)Util.parseDouble(arg.substring(arg.indexOf(61) + 1), this.width);
            System.out.println("Using width=" + this.width);
            return true;
        }
        if (arg.startsWith("height=")) {
            this.height = (int)Util.parseDouble(arg.substring(arg.indexOf(61) + 1), this.height);
            System.out.println("Using height=" + this.height);
            return true;
        }
        if (arg.startsWith("zoom=")) {
            this.zoom = Util.parseDouble(arg.substring(arg.indexOf(61) + 1), this.zoom);
            if (this.zoom < 0.0) {
                System.out.print("Zoom just be a positive number. ");
                this.zoom = 100.0;
            }
            System.out.println("Using zoom=" + this.zoom + "%");
            return true;
        }
        if (arg.startsWith("dpi=")) {
            this.dpi = Util.parseDouble(arg.substring(arg.indexOf(61) + 1), this.dpi);
            System.out.println("Using dpi=" + this.dpi);
            return true;
        }
        return false;
    }

    public void finishUp() {
        if (this.autoVSForAll) {
            for (Map.Entry<String, SelectedTimes> entry : this.times.entrySet()) {
                entry.getValue().vertScale = -1.0;
            }
        }
    }

    public static String getSupportedCommandLineArgumentOptions() {
        String ret = "";
        ret = ret + "        vs=unit:x        - Vertical scale, units (like My) per cm on final diagram. Default 1. Same as option in Settings, controls how expanded or contracted the diagram is. A small value (<1) is useful for sparse datasets.\r\n";
        ret = ret + "        unit:autovs      - Automatically find a vertical scale based on the input data and interval. Default is off. If unit is omitted then autovs is applied to all units.\r\n";
        ret = ret + "        top=unit:xxx     - Top of interval to draw. Default for top and base is to draw everything in the datafile.\r\n";
        ret = ret + "        base=unit:xxx    - Base of interval to draw. Default for top and base is to draw everything in the datafile.\r\n";
        ret = ret + "The unit in the previous options refers to the unit of the data. For example, -oo top=Ma:3 means to set the top of the Ma chart to 3. If your unit name has spaces, remember that you can wrap the argument in quotes: -oo \"top=m Section3:50\"\r\n";
        ret = ret + "        \r\n";
        ret = ret + "        The following options control the size of generated raster (PNG or JPEG) images. Specify only one, because one option implies the others.\r\n";
        ret = ret + "        width=xxx   - Width of generated PNG or JPEG.\r\n";
        ret = ret + "        height=xxx  - Height of generated PNG or JPEG.\r\n";
        ret = ret + "        zoom=xxx    - Zoom percentage, compared to \"1:1\" button in TSC. Default is 100.\r\n";
        ret = ret + "        dpi=xxx     - Dots-per-inch resolution of the generated image.\r\n";
        return ret;
    }

    protected static class UnitArg {
        public String u;
        public double arg;

        protected UnitArg() {
        }
    }
}

