/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TSCLinkActivationListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import util.HTMLPreprocessor;
import util.ProgramInfo;

public class WebsiteInfoDialog
extends JDialog {
    private JLabel licensedTo;
    private JEditorPane website;
    private JLabel username;
    private JButton copyPassword;
    private JLabel password;
    private JLabel lPass;
    private JLabel lUser;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                WebsiteInfoDialog inst = new WebsiteInfoDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public WebsiteInfoDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setTitle("TSC Website");
            thisLayout.rowWeights = new double[]{0.1, 0.0, 0.1, 0.0, 0.1, 0.0, 0.1, 0.0, 0.1, 1.0};
            thisLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 7, 20, 20};
            thisLayout.columnWeights = new double[]{0.1, 0.0, 0.1, 1.0, 0.1};
            thisLayout.columnWidths = new int[]{7, 185, 7, 7, 7};
            this.getContentPane().setLayout(thisLayout);
            this.setDefaultCloseOperation(2);
            this.licensedTo = new JLabel();
            this.getContentPane().add((Component)this.licensedTo, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.licensedTo.setText(HTMLPreprocessor.process("Licensed to " + ProgramInfo.get("TSC_LICENSEE"), false));
            this.website = new JEditorPane();
            this.getContentPane().add((Component)this.website, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.website.setEditable(false);
            this.website.setContentType("text/html");
            this.website.setText(HTMLPreprocessor.process("<html><body>" + ProgramInfo.get("TSC_LICENSEE") + " version website: <a href=\"" + ProgramInfo.get("TSC_WEBSITE_URL") + "\">" + ProgramInfo.get("TSC_WEBSITE_URL") + "</a></body></html>", false));
            this.website.addHyperlinkListener(new TSCLinkActivationListener());
            this.website.setBackground(null);
            this.username = new JLabel();
            this.getContentPane().add((Component)this.username, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.username.setText(HTMLPreprocessor.process(ProgramInfo.get("TSC_WEBSITE_USERNAME"), false));
            this.lUser = new JLabel();
            this.getContentPane().add((Component)this.lUser, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lUser.setText(HTMLPreprocessor.process("username:", false));
            this.lPass = new JLabel();
            this.getContentPane().add((Component)this.lPass, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lPass.setText(HTMLPreprocessor.process("password:", false));
            this.password = new JLabel();
            this.getContentPane().add((Component)this.password, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.password.setText(HTMLPreprocessor.process(ProgramInfo.get("TSC_WEBSITE_PASSWORD"), false));
            this.copyPassword = new JButton();
            this.getContentPane().add((Component)this.copyPassword, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.copyPassword.setText(HTMLPreprocessor.process("Copy password to clipboard", false));
            this.copyPassword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WebsiteInfoDialog.this.copyPasswordActionPerformed(evt);
                }
            });
            this.setSize(537, 210);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyPasswordActionPerformed(ActionEvent evt) {
        String password = ProgramInfo.get("TSC_WEBSITE_PASSWORD");
        StringSelection ss = new StringSelection(password);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }
}

