/*
 * Decompiled with CFR 0.152.
 */
package gui.crossplot;

import datastore.AccumulationRateColumn;
import gui.ExtensionFileFilter;
import gui.TSCreator;
import gui.crossplot.Coordinate2D;
import gui.crossplot.Crossplot;
import gui.crossplot.CrossplotFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.CSVReader;
import util.FileUtils;

public class CrossplotConverter
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private JFileChooser srcChooser;
    private JButton convertButton;
    private JTextField destinationFile;
    public Crossplot crossplot;
    public File convFile;
    public CrossplotFrame crossplotFrame;

    public CrossplotConverter() {
        this.initGUI();
    }

    public CrossplotConverter(Crossplot crossplot) {
        this();
        this.setCrossplot(crossplot);
    }

    public void setCrossplot(Crossplot crossplot) {
        this.crossplot = crossplot;
    }

    public void setCrossplotFrame(CrossplotFrame crossplotFrame) {
        this.crossplotFrame = crossplotFrame;
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setTitle("Edit Age/Depth Points.");
            this.setResizable(false);
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JLabel label = new JLabel("Choose the datapack to attach Age-Depth converter.", 0);
            label.setFont(new Font("Arial", 1, 12));
            panel.add((Component)label, "First");
            this.srcChooser = new JFileChooser();
            this.srcChooser.setDialogType(0);
            ExtensionFileFilter txt = new ExtensionFileFilter();
            txt.setDescription("TSCreator datapacks (.txt)");
            txt.addExtension("txt", true);
            this.srcChooser.setFileFilter(txt);
            this.srcChooser.setControlButtonsAreShown(false);
            this.srcChooser.setDragEnabled(true);
            this.srcChooser.addPropertyChangeListener(this);
            panel.add((Component)this.srcChooser, "Center");
            pane.add((Component)panel, "Before");
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JLabel dest = new JLabel("Convert to :");
            panel.add((Component)dest, "First");
            this.destinationFile = new JTextField();
            panel.add((Component)this.destinationFile, "Center");
            this.convertButton = new JButton("convert");
            this.convertButton.addActionListener(this);
            panel.add((Component)this.convertButton, "After");
            pane.add((Component)panel, "Last");
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            String srcFile = FileUtils.appendExtension(this.srcChooser.getSelectedFile().getName(), "txt");
            String dstFile = this.getDstFileName(srcFile);
            this.destinationFile.setText(dstFile);
        }
    }

    private String getDstFileName(String srcFile) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String date = "_" + month + "_" + day + "_" + year + "(" + hour + ":" + min + ":" + sec + ")";
        String dstfile = srcFile.split(".txt")[0] + "_converted" + date + ".txt";
        return dstfile;
    }

    private void convertFile(String srcFile, String dstFile) throws Exception {
        String[] value;
        boolean deleteFile = false;
        this.convFile = new File(dstFile);
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dstFile), "UTF-8"));
        CSVReader reader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), "UTF-8"), '\t');
        boolean myOutcrop = false;
        AccumulationRateColumn accuRateCol = new AccumulationRateColumn();
        accuRateCol = accuRateCol.setAccuRateCol(this.crossplot);
        while ((value = reader.readNext()) != null) {
            if (value[0].equalsIgnoreCase("outcrop:") && value[1].equalsIgnoreCase("on")) {
                myOutcrop = true;
            }
            if (value[0].equalsIgnoreCase("age units:") && !value[1].equalsIgnoreCase("ma")) {
                deleteFile = false;
                fw.write(value[0] + "\tma\n");
                fw.write("\n\nAgeConverterA\tageconvert-interpolate\n");
                int size = this.crossplot.age_depth_models.size();
                double depth0 = this.crossplot.age_depth_models.get((int)0).depth;
                double depth1 = this.crossplot.age_depth_models.get((int)1).depth;
                double depth2 = this.crossplot.age_depth_models.get((int)(size - 1)).depth;
                double depth3 = this.crossplot.age_depth_models.get((int)(size - 2)).depth;
                for (int i = 0; this.crossplot.age_depth_models != null && i < this.crossplot.age_depth_models.size(); ++i) {
                    Coordinate2D currCdt = this.crossplot.age_depth_models.get(i);
                    if (depth0 == depth1) {
                        fw.write("\t0\t0\n");
                    }
                    if (myOutcrop) {
                        fw.write("\t" + -1.0 * currCdt.depth + "\t" + currCdt.age + "\t" + currCdt.comment + "\n");
                    } else {
                        fw.write("\t" + currCdt.depth + "\t" + currCdt.age + "\t" + currCdt.comment + "\n");
                    }
                    if (depth2 != depth3) continue;
                    if (myOutcrop) {
                        fw.write("\t" + -1.0 * (currCdt.depth + 0.1) + "\t" + (currCdt.age + 0.1) + "\t" + currCdt.comment + "\n");
                        continue;
                    }
                    fw.write("\t" + (currCdt.depth + 0.1) + "\t" + (currCdt.age + 0.1) + "\t" + currCdt.comment + "\n");
                }
                this.writeAccuRateCol(fw, accuRateCol);
                this.writeSmartScaleCol(fw);
                continue;
            }
            if (value[0].equalsIgnoreCase("format version:") || value[0].equalsIgnoreCase("date:") || value[0].equalsIgnoreCase("SetTop:") || value[0].equalsIgnoreCase("SetBase:") || value[0].equalsIgnoreCase("SetScale:")) continue;
            String tempLine = "";
            for (int i = 0; i < value.length; ++i) {
                tempLine = tempLine + value[i] + "\t";
            }
            if (tempLine.contains("\t:")) {
                int j = tempLine.indexOf("\t");
                tempLine = new StringBuilder(tempLine).insert(j + 3, this.crossplotFrame.smartScaleColumn.fcID + " accumulation rate\t" + this.crossplotFrame.smartScaleColumn.fcID + " original depth scale in " + this.crossplotFrame.smartScaleColumn.fcUnit + "\t").toString();
            }
            String line = tempLine;
            line = line + "\n";
            fw.write(line);
        }
        fw.close();
        if (deleteFile) {
            this.convFile.delete();
        }
    }

    private void writeSmartScaleCol(BufferedWriter fw) {
        try {
            fw.write("\n");
            fw.write(this.crossplotFrame.smartScaleColumn.fcID + " original depth scale in " + this.crossplotFrame.smartScaleColumn.fcUnit + "\tevent\t55\t220/220/220\t\ton\nLAD\n");
            for (int i = 0; i < this.crossplotFrame.smartScaleColumn.scaleArray.length; ++i) {
                fw.write("\t" + this.crossplotFrame.smartScaleColumn.scaleArray[i] + "\t" + this.crossplotFrame.smartScaleColumn.scaleArray[i] + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeAccuRateCol(BufferedWriter fw, AccumulationRateColumn accuRateCol) {
        try {
            int i;
            fw.write("\n");
            fw.write(this.crossplotFrame.smartScaleColumn.fcID + " accumulation rate\tpoint\t150\t255/245/230\t\t\tPoints for Age-Depth Models<br><br>Depth&nbsp;&nbsp;&nbsp;Age&nbsp;&nbsp;&nbsp;&nbsp;Fossil<br>");
            for (i = 0; i < this.crossplot.age_depth_models.size(); ++i) {
                Coordinate2D currCdt = this.crossplot.age_depth_models.get(i);
                double myDepth = currCdt.depth;
                double myAge = currCdt.age;
                if (Crossplot.myOCx) {
                    myAge = -myAge;
                }
                if (Crossplot.myOCy) {
                    myDepth = -myDepth;
                }
                fw.write(myDepth + " " + myAge + " " + currCdt.comment + "<br>");
            }
            fw.write("\n");
            fw.write("nopoints\t255/0/0\t\t" + accuRateCol.min + "\t" + accuRateCol.max + "\tsmoothed\n");
            for (i = 0; i < accuRateCol.accuPair.length; ++i) {
                if (Crossplot.myOCy) {
                    fw.write("\t" + -1.0 * accuRateCol.accuPair[i].depth + "\t" + accuRateCol.accuPair[i].rate + "\n");
                    continue;
                }
                fw.write("\t" + accuRateCol.accuPair[i].depth + "\t" + accuRateCol.accuPair[i].rate + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void convert() {
        try {
            this.crossplot.updateAgeDepthPoints();
            File src = this.srcChooser.getSelectedFile();
            String srcfile = FileUtils.appendExtension(src.getAbsolutePath(), "txt");
            String dstfile = FileUtils.appendExtension(src.getParent() + "/" + this.destinationFile.getText(), "txt");
            this.convertFile(srcfile, dstfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void autoConvert() throws Exception {
        this.crossplot.updateAgeDepthPoints();
        String src = TSCreator.depthFile.getAbsolutePath();
        String dst = this.getDstFileName(src);
        this.convertFile(src, dst);
    }

    public void autoConvertAndSave() throws Exception {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter txt = new ExtensionFileFilter();
        txt.setDescription("TSCreator datapacks (.txt)");
        txt.addExtension("txt", true);
        chooser.setFileFilter(txt);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            this.crossplot.updateAgeDepthPoints();
            File dstFile = chooser.getSelectedFile();
            String src = TSCreator.depthFile.getAbsolutePath();
            String dst = dstFile.getAbsolutePath() + ".txt";
            this.convertFile(src, dst);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.convertButton) {
            this.srcChooser.approveSelection();
            if (this.srcChooser.getSelectedFile() == null) {
                return;
            }
            this.convert();
        }
    }
}

