/*
 * Decompiled with CFR 0.152.
 */
package gui.crossplot;

import datastore.Coloring;
import gui.ActionDialog;
import gui.ExtensionFileFilter;
import gui.ImageGenerator;
import gui.Language;
import gui.crossplot.Crossplot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.w3c.dom.Element;
import util.FileUtils;

public class CrossplotSettings
extends JFrame
implements ActionListener,
KeyListener,
MouseListener {
    private Crossplot plot;
    private JTabbedPane tabpane;
    private JPanel markersPanel;
    private JPanel modelsPanel;
    private JSpinner numOfPoints;
    private JCheckBox selectAllMarkers;
    private JCheckBox selectAllModels;
    private JButton selectColumn;
    private JButton add;
    private JButton save;
    private JButton load;
    private JButton update;
    private JButton remove;
    private JComboBox column_color;
    private ArrayList<JCheckBox> pointsCB_markers = null;
    private ArrayList<JTextField> age_markers = null;
    private ArrayList<JTextField> depth_markers = null;
    private ArrayList<JTextField> comment_markers = null;
    private ArrayList<JComboBox> type_markers = null;
    private ArrayList<JComboBox> columnType_markers = null;
    private ArrayList<JPanel> fill_markers = null;
    private ArrayList<JCheckBox> pointsCB_models = null;
    private ArrayList<JTextField> age_models = null;
    private ArrayList<JTextField> depth_models = null;
    private ArrayList<JTextField> comment_models = null;
    private ArrayList<JComboBox> type_models = null;
    private ArrayList<JComboBox> columnType_models = null;
    private ArrayList<JPanel> fill_models = null;

    public CrossplotSettings() {
    }

    public CrossplotSettings(Crossplot plot) {
        this();
        this.plot = plot;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setTitle(Language.translate("Edit Age/Depth Points", true));
            this.setSize(new Dimension(800, 400));
            JPanel main = new JPanel();
            this.getContentPane().add((Component)main, "Center");
            main.setLayout(new BoxLayout(main, 3));
            this.tabpane = new JTabbedPane();
            main.add((Component)this.tabpane, "Center");
            JPanel tabmain = new JPanel();
            this.tabpane.addTab(Language.translate("Age/Depth Markers", true), null, tabmain, null);
            tabmain.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            tabmain.add((Component)panel, "First");
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.selectAllMarkers = new JCheckBox();
            c.weightx = 0.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            panel.add((Component)this.selectAllMarkers, c);
            this.selectAllMarkers.addActionListener(this);
            JLabel age = new JLabel(Language.translate("Age", true), 2);
            c.weightx = 0.8;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 0;
            panel.add((Component)age, c);
            JLabel depth = new JLabel(Language.translate("Depth", true), 2);
            c.weightx = 1.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 2;
            c.gridy = 0;
            panel.add((Component)depth, c);
            JLabel comment = new JLabel(Language.translate("Comment", true), 2);
            c.weightx = 2.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 3;
            c.gridy = 0;
            panel.add((Component)comment, c);
            JLabel type = new JLabel(Language.translate("Type", true), 0);
            c.weightx = 1.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 4;
            c.gridy = 0;
            panel.add((Component)type, c);
            JLabel color = new JLabel(Language.translate("Color", true), 0);
            c.weightx = 0.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 5;
            c.gridy = 0;
            panel.add((Component)color, c);
            this.markersPanel = new JPanel();
            this.markersPanel.setLayout(new GridBagLayout());
            JScrollPane pane = new JScrollPane(this.markersPanel);
            tabmain.add((Component)pane, "Center");
            tabmain = new JPanel();
            this.tabpane.addTab(Language.translate("Age/Depth Models", true), null, tabmain, null);
            tabmain.setLayout(new BorderLayout());
            panel = new JPanel();
            tabmain.add((Component)panel, "First");
            panel.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            this.selectAllModels = new JCheckBox();
            c.weightx = 0.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            panel.add((Component)this.selectAllModels, c);
            this.selectAllModels.addActionListener(this);
            age = new JLabel(Language.translate("Age", true), 2);
            c.weightx = 0.8;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 0;
            panel.add((Component)age, c);
            depth = new JLabel(Language.translate("Depth", true), 2);
            c.weightx = 1.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 2;
            c.gridy = 0;
            panel.add((Component)depth, c);
            comment = new JLabel(Language.translate("Comment", true), 2);
            c.weightx = 2.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 3;
            c.gridy = 0;
            panel.add((Component)comment, c);
            type = new JLabel(Language.translate("Type", true), 0);
            c.weightx = 1.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 4;
            c.gridy = 0;
            panel.add((Component)type, c);
            color = new JLabel(Language.translate("Color", true), 0);
            c.weightx = 0.5;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 5;
            c.gridy = 0;
            panel.add((Component)color, c);
            this.modelsPanel = new JPanel();
            this.modelsPanel.setLayout(new GridBagLayout());
            pane = new JScrollPane(this.modelsPanel);
            tabmain.add((Component)pane, "Center");
            JPanel panel2 = new JPanel();
            main.add((Component)panel2, "Center");
            this.selectColumn = new JButton(Language.translate("Select All Markers in Chosen Column", true));
            panel2.add(this.selectColumn);
            this.selectColumn.addActionListener(this);
            this.column_color = new JComboBox<Object>(Crossplot.MARKER_COLUMN_NAMES.toArray());
            panel2.add(this.column_color);
            this.add = new JButton(Language.translate("Add", true));
            panel2.add(this.add);
            this.add.addActionListener(this);
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 10, 1);
            this.numOfPoints = new JSpinner(model);
            panel2.add(this.numOfPoints);
            this.remove = new JButton(Language.translate("Remove", true));
            panel2.add(this.remove);
            this.remove.addActionListener(this);
            JPanel next_panel = new JPanel();
            main.add((Component)next_panel, "Center");
            this.update = new JButton(Language.translate("Apply", true));
            next_panel.add(this.update);
            this.update.addActionListener(this);
            this.save = new JButton(Language.translate("Save", true));
            next_panel.add(this.save);
            this.save.addActionListener(this);
            this.load = new JButton(Language.translate("Load", true));
            next_panel.add(this.load);
            this.load.addActionListener(this);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
    }

    public void updatePointsPanels() {
        this.updateMarkersListPanel();
        this.updateModelsListPanel();
        this.repaint();
    }

    public void clearAll() {
        this.markersPanel.removeAll();
        this.markersPanel.repaint();
        this.modelsPanel.removeAll();
        this.modelsPanel.repaint();
        this.repaint();
    }

    private void updateMarkersListPanel() {
        this.markersPanel.removeAll();
        this.repaint();
        this.pointsCB_markers = new ArrayList();
        this.age_markers = new ArrayList();
        this.depth_markers = new ArrayList();
        this.comment_markers = new ArrayList();
        this.fill_markers = new ArrayList();
        this.type_markers = new ArrayList();
        this.columnType_markers = new ArrayList();
        GridBagConstraints c = new GridBagConstraints();
        if (this.plot != null) {
            this.plot.updateMarkersList();
            for (int i = 0; i < this.plot.tempMarker.size(); ++i) {
                this.pointsCB_markers.add(new JCheckBox());
                c.weightx = 0.3;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 0;
                c.gridy = i;
                this.markersPanel.add((Component)this.pointsCB_markers.get(i), c);
                this.age_markers.add(new JTextField(Double.toString(this.plot.tempMarker.get((int)i).age)));
                this.age_markers.get(i).setEditable(true);
                c.weightx = 1.25;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 1;
                c.gridy = i;
                this.markersPanel.add((Component)this.age_markers.get(i), c);
                if (Crossplot.myOCy) {
                    this.depth_markers.add(new JTextField(Double.toString(-this.plot.tempMarker.get((int)i).depth)));
                } else {
                    this.depth_markers.add(new JTextField(Double.toString(this.plot.tempMarker.get((int)i).depth)));
                }
                this.depth_markers.get(i).setEditable(true);
                c.weightx = 2.1;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 2;
                c.gridy = i;
                this.markersPanel.add((Component)this.depth_markers.get(i), c);
                this.comment_markers.add(new JTextField(this.plot.tempMarker.get((int)i).comment));
                c.weightx = 4.6;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 3;
                c.gridy = i;
                this.markersPanel.add((Component)this.comment_markers.get(i), c);
                this.type_markers.add(new JComboBox<String>(Crossplot.MARKER_POINT_TYPES));
                if (this.plot.tempMarker.get((int)i).columnType == 0) {
                    if (this.plot.tempMarker.get((int)i).type == 0) {
                        this.type_markers.get(i).setSelectedIndex(0);
                    } else if (this.plot.tempMarker.get((int)i).type == 1) {
                        this.type_markers.get(i).setSelectedIndex(2);
                    } else if (this.plot.tempMarker.get((int)i).type == 2) {
                        this.type_markers.get(i).setSelectedIndex(3);
                    }
                } else if (this.plot.tempMarker.get((int)i).columnType == 1) {
                    this.type_markers.get(i).setSelectedIndex(1);
                }
                c.weightx = 0.9;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 4;
                c.gridy = i;
                this.markersPanel.add((Component)this.type_markers.get(i), c);
                this.fill_markers.add(new JPanel());
                this.fill_markers.get(i).setBackground(Color.decode(this.plot.tempMarker.get((int)i).fill));
                c.weightx = 0.8;
                c.fill = 256;
                c.gridwidth = 1;
                c.gridx = 5;
                c.gridy = i;
                this.fill_markers.get(i).addMouseListener(this);
                this.fill_markers.get(i).setBorder(BorderFactory.createEtchedBorder(0));
                this.markersPanel.add((Component)this.fill_markers.get(i), c);
            }
        }
        this.repaint();
    }

    private void addNewMarkers(int num) {
        int size;
        GridBagConstraints c = new GridBagConstraints();
        for (int i = size = this.pointsCB_markers.size(); i < size + num; ++i) {
            this.pointsCB_markers.add(new JCheckBox());
            c.weightx = 0.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = i;
            this.markersPanel.add((Component)this.pointsCB_markers.get(i), c);
            this.age_markers.add(new JTextField());
            this.age_markers.get(i).setEditable(true);
            c.weightx = 1.25;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = i;
            this.markersPanel.add((Component)this.age_markers.get(i), c);
            this.depth_markers.add(new JTextField());
            this.depth_markers.get(i).setEditable(true);
            c.weightx = 2.1;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 2;
            c.gridy = i;
            this.markersPanel.add((Component)this.depth_markers.get(i), c);
            this.comment_markers.add(new JTextField());
            c.weightx = 4.6;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 3;
            c.gridy = i;
            this.markersPanel.add((Component)this.comment_markers.get(i), c);
            this.comment_markers.get(i).addKeyListener(this);
            this.type_markers.add(new JComboBox<String>(Crossplot.MARKER_POINT_TYPES));
            c.weightx = 0.9;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 4;
            c.gridy = i;
            this.markersPanel.add((Component)this.type_markers.get(i), c);
            this.fill_markers.add(new JPanel());
            this.fill_markers.get(i).setBackground(Color.decode(ImageGenerator.marker_color));
            c.weightx = 0.8;
            c.fill = 256;
            c.gridwidth = 1;
            c.gridx = 5;
            c.gridy = i;
            this.fill_markers.get(i).addMouseListener(this);
            this.fill_markers.get(i).setBorder(BorderFactory.createEtchedBorder(0));
            this.markersPanel.add((Component)this.fill_markers.get(i), c);
        }
        this.repaint();
    }

    private void removeMarkerPoints() {
        int size = this.pointsCB_markers.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            Element curCdt;
            if (!this.pointsCB_markers.get(i).isSelected()) continue;
            if (i < this.plot.age_depth_markers.size() && (curCdt = this.plot.svgDoc.getElementById(this.plot.age_depth_markers.get((int)i).id)) != null) {
                this.plot.markerGroup.removeChild(curCdt);
                this.removeFAD(this.plot.age_depth_markers.get((int)i).x, this.plot.age_depth_markers.get((int)i).y);
                this.removeLAD(this.plot.age_depth_markers.get((int)i).x, this.plot.age_depth_markers.get((int)i).y);
            }
            this.markersPanel.remove(this.pointsCB_markers.get(i));
            this.markersPanel.remove(this.age_markers.get(i));
            this.markersPanel.remove(this.depth_markers.get(i));
            this.markersPanel.remove(this.comment_markers.get(i));
            this.markersPanel.remove(this.fill_markers.get(i));
            this.markersPanel.remove(this.type_markers.get(i));
            this.markersPanel.remove(this.columnType_markers.get(i));
            ++count;
        }
        if (count == 0) {
            JOptionPane.showMessageDialog(this, Language.translate("No coordinates are selected.", true), Language.translate("Warning...", true), 2);
        }
        this.repaint();
    }

    private void removeFAD(int x, int y) {
        String id = "fadline(" + x + ',' + y + ")";
        Element fad = this.plot.svgDoc.getElementById(id);
        if (fad != null) {
            this.plot.fadGroup.removeChild(fad);
        }
    }

    private void removeLAD(int x, int y) {
        String id = "ladline(" + x + ',' + y + ")";
        Element lad = this.plot.svgDoc.getElementById(id);
        if (lad != null) {
            this.plot.ladGroup.removeChild(lad);
        }
    }

    private void updateMarkers() {
        int size = this.plot.age_depth_markers.size();
        int totalsize = this.pointsCB_markers.size();
        for (int i = 0; i < size; ++i) {
            Element curCdt = this.plot.svgDoc.getElementById(this.plot.age_depth_markers.get((int)i).id);
            if (curCdt != null) {
                this.plot.markerGroup.removeChild(curCdt);
            }
            this.removeFAD(this.plot.age_depth_markers.get((int)i).x, this.plot.age_depth_markers.get((int)i).y);
            this.removeLAD(this.plot.age_depth_markers.get((int)i).x, this.plot.age_depth_markers.get((int)i).y);
        }
        boolean flag = false;
        for (int i = 0; i < totalsize; ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    if (!flag) {
                        if (this.age_markers.get(i).getText().isEmpty() || this.depth_markers.get(i).getText().isEmpty()) {
                            this.markersPanel.remove(this.pointsCB_markers.get(i));
                            this.markersPanel.remove(this.age_markers.get(i));
                            this.markersPanel.remove(this.depth_markers.get(i));
                            this.markersPanel.remove(this.comment_markers.get(i));
                            this.markersPanel.remove(this.fill_markers.get(i));
                            this.markersPanel.remove(this.type_markers.get(i));
                            this.markersPanel.remove(this.columnType_markers.get(i));
                            j = 2;
                            continue;
                        }
                        if (this.type_markers.get(i).getSelectedIndex() == 0) {
                            this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 0, 0);
                        } else if (this.type_markers.get(i).getSelectedIndex() == 1) {
                            this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 0, 1);
                        } else if (this.type_markers.get(i).getSelectedIndex() == 2) {
                            this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 1, 0);
                        } else if (this.type_markers.get(i).getSelectedIndex() == 3) {
                            this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 2, 0);
                        }
                        j = 2;
                        continue;
                    }
                    if (this.type_markers.get(i).getSelectedIndex() == 0) {
                        this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 0, 0);
                    } else if (this.type_markers.get(i).getSelectedIndex() == 1) {
                        this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 0, 1);
                    } else if (this.type_markers.get(i).getSelectedIndex() == 2) {
                        this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 1, 0);
                    } else if (this.type_markers.get(i).getSelectedIndex() == 3) {
                        this.plot.addMarker(Double.parseDouble(this.age_markers.get(i).getText()), Double.parseDouble(this.depth_markers.get(i).getText()), this.comment_markers.get(i).getText(), Coloring.getCSScolor(this.fill_markers.get(i).getBackground()), 2, 0);
                    }
                    j = 2;
                    continue;
                }
                catch (Exception e) {
                    if (j == 0) {
                        flag = true;
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Language.translate("Warning...", true), 2);
                }
            }
        }
        this.plot.updateMarkersList();
        this.updatePointsPanels();
        this.repaint();
    }

    private void setAllMarkerPoints(boolean set) {
        int size = this.plot.age_depth_markers.size();
        for (int i = 0; i < size; ++i) {
            this.pointsCB_markers.get(i).setSelected(set);
        }
        this.repaint();
    }

    private void updateModelsListPanel() {
        this.modelsPanel.removeAll();
        this.repaint();
        this.pointsCB_models = new ArrayList();
        this.age_models = new ArrayList();
        this.depth_models = new ArrayList();
        this.comment_models = new ArrayList();
        this.fill_models = new ArrayList();
        this.type_models = new ArrayList();
        GridBagConstraints c = new GridBagConstraints();
        if (this.plot != null) {
            this.plot.updateModelsList();
            for (int i = 0; i < this.plot.tempModel.size(); ++i) {
                this.pointsCB_models.add(new JCheckBox());
                c.weightx = 0.3;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 0;
                c.gridy = i;
                this.modelsPanel.add((Component)this.pointsCB_models.get(i), c);
                this.age_models.add(new JTextField(Double.toString(this.plot.tempModel.get((int)i).age)));
                this.age_models.get(i).setEditable(true);
                c.weightx = 1.25;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 1;
                c.gridy = i;
                this.modelsPanel.add((Component)this.age_models.get(i), c);
                if (Crossplot.myOCy) {
                    this.depth_models.add(new JTextField(Double.toString(-this.plot.tempModel.get((int)i).depth)));
                } else {
                    this.depth_models.add(new JTextField(Double.toString(this.plot.tempModel.get((int)i).depth)));
                }
                this.depth_models.get(i).setEditable(true);
                c.weightx = 2.1;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 2;
                c.gridy = i;
                this.modelsPanel.add((Component)this.depth_models.get(i), c);
                this.comment_models.add(new JTextField(this.plot.tempModel.get((int)i).comment));
                c.weightx = 4.6;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 3;
                c.gridy = i;
                this.modelsPanel.add((Component)this.comment_models.get(i), c);
                this.type_models.add(new JComboBox<String>(Crossplot.MODEL_POINT_TYPES));
                this.type_models.get(i).setSelectedIndex(this.plot.tempModel.get((int)i).type);
                c.weightx = 0.9;
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 4;
                c.gridy = i;
                this.modelsPanel.add((Component)this.type_models.get(i), c);
                this.fill_models.add(new JPanel());
                this.fill_models.get(i).setBackground(Color.decode(this.plot.tempModel.get((int)i).fill));
                c.weightx = 0.8;
                c.fill = 256;
                c.gridwidth = 1;
                c.gridx = 5;
                c.gridy = i;
                this.fill_models.get(i).addMouseListener(this);
                this.fill_models.get(i).setBorder(BorderFactory.createEtchedBorder(0));
                this.modelsPanel.add((Component)this.fill_models.get(i), c);
            }
        }
        this.repaint();
    }

    private void addNewModels(int num) {
        int size;
        GridBagConstraints c = new GridBagConstraints();
        for (int i = size = this.pointsCB_models.size(); i < size + num; ++i) {
            this.pointsCB_models.add(new JCheckBox());
            c.weightx = 0.3;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = i;
            this.modelsPanel.add((Component)this.pointsCB_models.get(i), c);
            this.age_models.add(new JTextField());
            this.age_models.get(i).setEditable(true);
            c.weightx = 1.25;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = i;
            this.modelsPanel.add((Component)this.age_models.get(i), c);
            this.depth_models.add(new JTextField());
            this.depth_models.get(i).setEditable(true);
            c.weightx = 2.1;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 2;
            c.gridy = i;
            this.modelsPanel.add((Component)this.depth_models.get(i), c);
            this.comment_models.add(new JTextField());
            c.weightx = 4.6;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 3;
            c.gridy = i;
            this.modelsPanel.add((Component)this.comment_models.get(i), c);
            this.type_models.add(new JComboBox<String>(Crossplot.MODEL_POINT_TYPES));
            c.weightx = 0.9;
            c.fill = 2;
            c.gridwidth = 1;
            c.gridx = 4;
            c.gridy = i;
            this.modelsPanel.add((Component)this.type_models.get(i), c);
            this.fill_models.add(new JPanel());
            this.fill_models.get(i).setBackground(Color.decode(ImageGenerator.model_color));
            c.weightx = 0.8;
            c.fill = 256;
            c.gridwidth = 1;
            c.gridx = 5;
            c.gridy = i;
            this.fill_models.get(i).addMouseListener(this);
            this.fill_models.get(i).setBorder(BorderFactory.createEtchedBorder(0));
            this.modelsPanel.add((Component)this.fill_models.get(i), c);
        }
        this.repaint();
    }

    private void removeModelPoints() {
        int size = this.pointsCB_models.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            Element curCdt;
            if (!this.pointsCB_models.get(i).isSelected()) continue;
            if (i < this.plot.age_depth_models.size() && (curCdt = this.plot.svgDoc.getElementById(this.plot.age_depth_models.get((int)i).id)) != null) {
                this.plot.modelGroup.removeChild(curCdt);
            }
            this.modelsPanel.remove(this.pointsCB_models.get(i));
            this.modelsPanel.remove(this.age_models.get(i));
            this.modelsPanel.remove(this.depth_models.get(i));
            this.modelsPanel.remove(this.comment_models.get(i));
            this.modelsPanel.remove(this.fill_models.get(i));
            this.modelsPanel.remove(this.type_models.get(i));
            if (this.columnType_models == null) {
                this.columnType_models = this.type_models;
            }
            this.modelsPanel.remove(this.columnType_models.get(i));
            ++count;
        }
        if (count == 0) {
            JOptionPane.showMessageDialog(this, Language.translate("No coordinates are selected.", true), Language.translate("Warning...", true), 2);
        }
        this.repaint();
    }

    private void updateModels() {
        int size = this.plot.age_depth_models.size();
        int totalsize = this.pointsCB_models.size();
        for (int i = 0; i < size; ++i) {
            Element curCdt = this.plot.svgDoc.getElementById(this.plot.age_depth_models.get((int)i).id);
            if (curCdt == null) continue;
            this.plot.modelGroup.removeChild(curCdt);
        }
        boolean flag = false;
        for (int i = 0; i < totalsize; ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    if (!flag) {
                        if (this.age_models.get(i).getText().isEmpty() || this.depth_models.get(i).getText().isEmpty()) {
                            this.modelsPanel.remove(this.pointsCB_models.get(i));
                            this.modelsPanel.remove(this.age_models.get(i));
                            this.modelsPanel.remove(this.depth_models.get(i));
                            this.modelsPanel.remove(this.comment_models.get(i));
                            this.modelsPanel.remove(this.fill_models.get(i));
                            this.modelsPanel.remove(this.type_models.get(i));
                            if (this.columnType_models == null) {
                                this.columnType_models = this.type_models;
                            }
                            this.modelsPanel.remove(this.columnType_models.get(i));
                            j = 2;
                            continue;
                        }
                        if (this.columnType_models == null) {
                            this.columnType_models = this.type_models;
                        }
                        this.plot.addModel(Double.parseDouble(this.age_models.get(i).getText()), Double.parseDouble(this.depth_models.get(i).getText()), this.comment_models.get(i).getText(), Coloring.getCSScolor(this.fill_models.get(i).getBackground()), this.type_models.get(i).getSelectedIndex(), this.columnType_models.get(i).getSelectedIndex());
                        j = 2;
                        continue;
                    }
                    this.plot.addModel(Double.parseDouble(this.age_models.get(i).getText()), Double.parseDouble(this.depth_models.get(i).getText()), this.comment_models.get(i).getText(), Coloring.getCSScolor(this.fill_models.get(i).getBackground()), this.type_models.get(i).getSelectedIndex(), 0);
                    j = 2;
                    continue;
                }
                catch (Exception e) {
                    if (j == 0) {
                        flag = true;
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Language.translate("Warning...", true), 2);
                }
            }
        }
        this.plot.updateModelsList();
        this.updatePointsPanels();
        this.repaint();
    }

    private void setAllModelPoints(boolean set) {
        int size = this.plot.age_depth_models.size();
        for (int i = 0; i < size; ++i) {
            this.pointsCB_models.get(i).setSelected(set);
        }
        this.repaint();
    }

    private void save() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("Age-Depth file (*.txt)");
        eff.addExtension("txt", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            ActionDialog ad = new ActionDialog(Language.translate("Saving Crossplot Data...", true));
            ad.setVisible(true);
            String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
            try {
                this.plot.saveToFile(absolutePath);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error...", 0);
            }
            ad.setVisible(false);
            ad.dispose();
        }
        this.repaint();
    }

    private void load() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("Age-Depth file (*.txt)");
        eff.addExtension("txt", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            ActionDialog ad = new ActionDialog(Language.translate("Loading data from Age-Depth file...", true));
            ad.setVisible(true);
            String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
            try {
                this.plot.loadFromFile(absolutePath);
                this.updatePointsPanels();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error...", 0);
                e.printStackTrace();
            }
            ad.setVisible(false);
            ad.dispose();
        }
    }

    private void selectColumn() {
        int selectIndex = 0;
        String columnName = null;
        String markerName = null;
        int arraySize = Crossplot.MARKER_NAME_LIST.size();
        int size = this.pointsCB_markers.size();
        selectIndex = this.column_color.getSelectedIndex();
        columnName = Crossplot.MARKER_COLUMN_NAMES.get(selectIndex);
        this.setAllMarkerPoints(false);
        if (selectIndex != 0) {
            for (int i = 0; i < arraySize; ++i) {
                if (!columnName.equals(Crossplot.MARKER_COLUMN_LIST.get(i))) continue;
                markerName = Crossplot.MARKER_NAME_LIST.get(i);
                for (int j = 0; j < size; ++j) {
                    if (!markerName.equals(this.comment_markers.get(j).getText())) continue;
                    this.pointsCB_markers.get(j).setSelected(true);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.add) {
            int tab = this.tabpane.getSelectedIndex();
            int num = Integer.parseInt(this.numOfPoints.getValue().toString());
            if (tab == 0) {
                this.addNewMarkers(num);
            } else if (tab == 1) {
                this.addNewModels(num);
            }
            this.markersPanel.updateUI();
            this.markersPanel.repaint();
            this.modelsPanel.updateUI();
            this.modelsPanel.repaint();
        } else if (e.getSource() == this.remove) {
            int tab = this.tabpane.getSelectedIndex();
            if (tab == 0) {
                this.removeMarkerPoints();
            } else if (tab == 1) {
                this.removeModelPoints();
            }
        } else if (e.getSource() == this.update) {
            int tab = this.tabpane.getSelectedIndex();
            if (tab == 0) {
                this.updateMarkers();
            } else if (tab == 1) {
                this.updateModels();
            }
        } else if (e.getSource() == this.selectAllMarkers) {
            this.setAllMarkerPoints(this.selectAllMarkers.isSelected());
        } else if (e.getSource() == this.selectAllModels) {
            this.setAllModelPoints(this.selectAllModels.isSelected());
        } else if (e.getSource() == this.save) {
            this.save();
        } else if (e.getSource() == this.load) {
            this.load();
        } else if (e.getSource() == this.selectColumn) {
            this.selectColumn();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int tab = this.tabpane.getSelectedIndex();
        if (tab == 0) {
            this.updateMarkers();
        } else if (tab == 1) {
            this.updateModels();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JPanel panel = (JPanel)e.getSource();
        Color pointColor = JColorChooser.showDialog(panel, "Choose marker/model color.", panel.getBackground());
        if (pointColor != null) {
            int i;
            panel.setBackground(pointColor);
            int size = this.pointsCB_markers.size();
            for (i = 0; i < size; ++i) {
                if (!this.pointsCB_markers.get(i).isSelected() || i >= this.plot.age_depth_markers.size()) continue;
                this.fill_markers.get(i).setBackground(pointColor);
            }
            size = this.pointsCB_models.size();
            for (i = 0; i < size; ++i) {
                if (!this.pointsCB_models.get(i).isSelected() || i >= this.plot.age_depth_models.size()) continue;
                this.fill_models.get(i).setBackground(pointColor);
            }
        }
    }
}

