/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import gui.ErrorHandler;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import util.FileUtils;

public class ComboBoxRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Object[] items;
    Object[] data;
    boolean editable = false;

    public ComboBoxRenderer() {
    }

    public ComboBoxRenderer(Object[] items) {
        this.items = items;
        this.data = null;
    }

    public ComboBoxRenderer(Object[] items, Object[] data) {
        this.items = items;
        this.data = data;
    }

    public void set(Object[] items, Object[] data) {
        this.items = items;
        this.data = data;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void turnItemsToImages() {
        if (this.items == null) {
            return;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            URL imgURL = FileUtils.getURL(this.items[i].toString());
            if (imgURL == null) {
                ErrorHandler.log("Got a null URL for: " + this.items[i].toString(), 3);
                continue;
            }
            this.items[i] = "<html><center><img src=\"" + imgURL.toString() + "\"></center></html>";
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null && this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (!value.equals(this.data[i])) continue;
                super.setValue(this.items[i]);
                return;
            }
        }
        super.setValue(value);
    }

    public JComboBox getComboBox() {
        CBRComboBox cb = new CBRComboBox();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.data == null) {
                cb.addItem(this.items[i]);
                continue;
            }
            cb.addItem(this.items[i], this.data[i]);
        }
        cb.setEditable(this.editable);
        return cb;
    }

    public class CBRComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public void addItem(Object item, Object data) {
            Item i = new Item();
            i.item = item;
            i.data = data;
            super.addItem(i);
        }

        @Override
        public Object getSelectedItem() {
            Object ret = super.getSelectedItem();
            if (ret instanceof Item) {
                return ((Item)ret).data;
            }
            return ret;
        }

        protected class Item {
            Object item;
            Object data;

            protected Item() {
            }

            public String toString() {
                return this.item.toString();
            }
        }
    }
}

