/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.BlockColumn;
import model.Column;
import model.Data;
import model.LineStyles;
import model.ModelIdentifier;
import model.storage.BlockDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class BlockData
extends Data {
    private ModelIdentifier identifier = null;
    private String label = "";
    private int lineStyle = 0;
    private String color = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public BlockData(BlockColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 5));
    }

    public BlockData(BlockColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setColor(result.getString("color"));
        this.setIdentifier(id);
        this.setLabel(result.getString("label"));
        this.setLineStyle(LineStyles.getLabel(result.getString("linestyle")));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            BlockDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            BlockDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getColor() {
        return this.color;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public final void setColor(String color) {
        this.color = color;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public String toString() {
        return "BLOCK_DATA [ Identifier( " + this.identifier.toString() + "),  label = " + this.label + " lineStyle = " + LineStyles.getName(this.lineStyle) + " color = " + this.color + " ]";
    }

    public static class Factory {
        public static BlockData getByIdentifier(BlockColumn c, ModelIdentifier id) {
            List<Object> blockData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            blockData = Factory.getByIdentifiers(c, ids);
            if (blockData.isEmpty()) {
                return null;
            }
            return (BlockData)blockData.get(0);
        }

        public static List<BlockData> getByIdentifiers(BlockColumn c, List<ModelIdentifier> ids) {
            ArrayList<BlockData> blockData = new ArrayList<BlockData>();
            List<SourceResult> results = BlockDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                blockData.add(new BlockData(c, ids.get(i), results.get(i)));
            }
            return blockData;
        }

        public static List<BlockData> getByAge(BlockColumn c, double top, double bottom) {
            List<SourceResult> results = BlockDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 5);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

