/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.ChronData;
import model.Column;
import model.ModelIdentifier;
import model.storage.ChronColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class ChronColumn
extends Column {
    private ModelIdentifier identifier = null;
    private double seriesWidth = 0.0;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public ChronColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 6));
    }

    public ChronColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setSeriesWidth(result.getDouble("series_width"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            ChronColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            ChronColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public final void setSeriesWidth(double seriesWidth) {
        this.seriesWidth = seriesWidth;
    }

    public List<ChronData> getDataByAge(double top, double bottom) {
        return ChronData.Factory.getByAge(this, top, bottom);
    }

    public static class Factory {
        public static List<ChronColumn> getByTitle(String title) {
            List<SourceResult> results = ChronColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 6);
            return Factory.getByIdentifiers(ids);
        }

        public static ChronColumn getByIdentifier(ModelIdentifier id) {
            List<Object> chronColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            chronColumns = Factory.getByIdentifiers(ids);
            if (chronColumns.isEmpty()) {
                return null;
            }
            return (ChronColumn)chronColumns.get(0);
        }

        public static List<ChronColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<ChronColumn> chronColumns = new ArrayList<ChronColumn>();
            List<SourceResult> results = ChronColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                chronColumns.add(new ChronColumn(ids.get(i), results.get(i)));
            }
            return chronColumns;
        }
    }
}

