/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.BlockColumn;
import model.BlockData;
import model.LineStyles;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class BlockDataStorage
extends DataStorage {
    public static void insert(BlockData data) {
        Query query = new Query("INSERT INTO #.block_data       (id, data_id, block_columns_id, label, linestyle, color,       deleted)       VALUES (NULL, :data_id, :block_column_id, :label,         :linestyle, :color, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("block_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("linestyle", LineStyles.getName(data.getLineStyle()));
        query.setString("color", data.getColor());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(BlockData data) {
        Query query = new Query("UPDATE #.block_data       SET data_id = :data_id,         block_columns_id = :block_column_id, label = :label,         linestyle = :linestyle, color = :color       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("block_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("linestyle", LineStyles.getName(data.getLineStyle()));
        query.setString("color", data.getColor());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT color, id, label, linestyle,               deleted, last_modified, creation_date       FROM #.block_data       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(BlockColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data \t\tJOIN #.block_data as blockdata ON (blockdata.data_id = data.id)       WHERE blockdata.block_columns_id = :block_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted         AND NOT blockdata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("block_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

