/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.PointColumn;
import model.storage.ColumnStorage;
import model.storage.Query;
import model.util.SourceResult;

public class PointColumnStorage
extends ColumnStorage {
    public static void insert(PointColumn col) {
        Query query = new Query("INSERT INTO #.point_columns       (id, columns_id, line, fill_color,         range_low, range_high, smoothed, deleted)       VALUES (NULL, :columnid, :line, :fill_color,        :range_low, :range_high, :smoothed, :deleted)");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.setBoolean("line", col.isLine());
        query.setString("fill_color", col.getFillColor());
        query.setDouble("range_low", col.getRangeLow());
        query.setDouble("range_high", col.getRangeHigh());
        query.setBoolean("smoothed", col.isSmoothed());
        query.setBoolean("deleted", col.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(PointColumn col) {
        Query query = new Query("UPDATE #.point_columns       SET columns_id = :columnid, line = :line,         file_color = :fill_color, range_low = :range_low,        range_high = :range_high, smoothed = :smoothed       WHERE id = :id");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("id", col.getIdentifier().getId());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.setBoolean("line", col.isLine());
        query.setString("fill_color", col.getFillColor());
        query.setDouble("range_low", col.getRangeLow());
        query.setDouble("range_high", col.getRangeHigh());
        query.setBoolean("smoothed", col.isSmoothed());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        ArrayList<ModelIdentifier> colids = new ArrayList<ModelIdentifier>();
        Query query = new Query("SELECT '#' as database, columns_id,         line, fill_color, range_low, \t       range_high, smoothed, deleted, last_modified,         creation_date       FROM #.point_columns       WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            SourceResult result = query.executeQuery().get(0);
            results.add(result);
            colids.add(ModelIdentifier.Factory.translateSourceResult(result, 1));
        }
        query.close();
        ColumnStorage.load(results, colids);
        return results;
    }

    public static List<SourceResult> findByTitle(String title) {
        Query query = new Query("SELECT '#' AS database, pointcol.id AS id       FROM #.columns AS col         JOIN #.point_columns AS pointcol ON (pointcol.columns_id = col.id)       WHERE col.title LIKE :title         AND NOT pointcol.deleted         AND NOT col.deleted         AND col.overlay_id IS NULL");
        query.setString("title", title);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

