/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.RangeColumn;
import model.storage.ColumnStorage;
import model.storage.Query;
import model.util.SourceResult;

public class RangeColumnStorage
extends ColumnStorage {
    public static void insert(RangeColumn col) {
        Query query = new Query("INSERT INTO #.range_columns       (id, columns_id, deleted)       VALUES (NULL, :columnid, :deleted)");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.setBoolean("deleted", col.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(RangeColumn col) {
        Query query = new Query("UPDATE #.range_columns       SET columns_id = :columnid       WHERE id = :id");
        query.setInt("id", col.getIdentifier().getId());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        ArrayList<ModelIdentifier> colids = new ArrayList<ModelIdentifier>();
        Query query = new Query("SELECT '#' as database, columns_id, deleted, last_modified, creation_date      FROM #.range_columns       WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            SourceResult result = query.executeQuery().get(0);
            results.add(result);
            colids.add(ModelIdentifier.Factory.translateSourceResult(result, 1));
        }
        query.close();
        ColumnStorage.load(results, colids);
        return results;
    }

    public static List<SourceResult> findByTitle(String title) {
        Query query = new Query("SELECT '#' AS database, rangecol.id AS id       FROM #.columns AS col         JOIN #.range_columns AS rangecol ON (rangecol.columns_id = col.id)       WHERE col.title LIKE :title         AND NOT rangecol.deleted         AND NOT col.deleted         AND col.overlay_id IS NULL");
        query.setString("title", title);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

