/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.SequenceColumn;
import model.storage.ColumnStorage;
import model.storage.Query;
import model.util.SourceResult;

public class SequenceColumnStorage
extends ColumnStorage {
    public static void insert(SequenceColumn col) {
        Query query = new Query("INSERT INTO #.sequence_columns             (id, columns_id, trend, deleted)             VALUES (NULL, :columnid, :trend, :deleted)");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.setBoolean("trend", col.isTrend());
        query.setBoolean("deleted", col.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(SequenceColumn col) {
        Query query = new Query("UPDATE #.sequence_columns       SET columns_id = :column_id, trend = :trend       WHERE id = :id");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("id", col.getIdentifier().getId());
        query.setInt("column_id", col.getColumnIdentifier().getId());
        query.setBoolean("trend", col.isTrend());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        ArrayList<ModelIdentifier> colids = new ArrayList<ModelIdentifier>();
        Query query = new Query("SELECT '#' as database, columns_id, trend, deleted,                      last_modified, creation_date             FROM #.sequence_columns             WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            SourceResult result = query.executeQuery().get(0);
            results.add(result);
            colids.add(ModelIdentifier.Factory.translateSourceResult(result, 1));
        }
        query.close();
        ColumnStorage.load(results, colids);
        return results;
    }

    public static List<SourceResult> findByTitle(String title) {
        Query query = new Query("SELECT '#' AS database, seqcol.id       FROM #.columns AS col         JOIN #.sequence_columns AS seqcol ON (seqcol.columns_id = col.id)       WHERE col.title LIKE :title         AND NOT seqcol.deleted         AND NOT col.deleted         AND col.overlay_id IS NULL");
        query.setString("title", title);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

