/*
 * Decompiled with CFR 0.152.
 */
package path;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import util.Debug;
import util.JavaVMOptions;
import util.ProgramInfo;

public class ResPath {
    public static final HashMap<String, String> paths = new HashMap();
    private static final String res_root = "resources/";

    public static void initializeDependentData() {
        paths.put("datapacks.builtin_data", ResPath.stripRoot(ProgramInfo.get("TSC_DEFAULT_DATAPACK")));
    }

    public static String getPath(String ident) {
        if (paths.containsKey(ident)) {
            return res_root + paths.get(ident);
        }
        return null;
    }

    public static String getRootlessPath(String ident) {
        if (paths.containsKey(ident)) {
            return paths.get(ident);
        }
        return null;
    }

    public static String getDirname(String ident) {
        if (paths.containsKey(ident)) {
            return new File(res_root + paths.get(ident)).getParent();
        }
        return null;
    }

    public static String getFilename(String ident) {
        if (paths.containsKey(ident)) {
            return new File(res_root + paths.get(ident)).getName();
        }
        return null;
    }

    public static String stripRoot(String filepath) {
        return filepath.replace(res_root, "");
    }

    public static String getJarSafeResourcePathFromRootlessPath(String path) {
        if (path.startsWith(res_root)) {
            path = path.replaceFirst(res_root, "");
        }
        try {
            if (JavaVMOptions.isJar()) {
                return "jar:file:" + JavaVMOptions.getJarfile() + "!/" + res_root + path;
            }
            return "file:resources/" + path;
        }
        catch (Exception e) {
            Debug.print("Unable to construct PATH for path " + path);
            return null;
        }
    }

    public static URL getJarSafeResourceURLFromRootlessPath(String path) {
        try {
            return new URL(ResPath.getJarSafeResourcePathFromRootlessPath(path));
        }
        catch (MalformedURLException e) {
            Debug.print("Unable to construct URL for path " + path);
            return null;
        }
    }

    public static URL getJarSafeResourceURL(String ident) {
        if (paths.containsKey(ident)) {
            try {
                return new URL(ResPath.getJarSafeResourcePathFromRootlessPath(paths.get(ident)));
            }
            catch (MalformedURLException e) {
                Debug.print("Unable to construct URL for ident " + ident);
                return null;
            }
        }
        return null;
    }

    public static String getJarSafeResourcePath(String ident) {
        if (paths.containsKey(ident)) {
            return ResPath.getJarSafeResourcePathFromRootlessPath(paths.get(ident));
        }
        return null;
    }

    static {
        paths.put("datapacks.default_data_filename", "default_data.txt");
        paths.put("datapacks.datapack_info", "datapack_info.txt");
        paths.put("gui.arrow_down", "gui/arrow-down.gif");
        paths.put("gui.arrow_up", "gui/arrow-up.gif");
        paths.put("gui.rect", "gui/rect.gif");
        paths.put("gui.round", "gui/round.gif");
        paths.put("gui.tick", "gui/tick.gif");
        paths.put("gui.UNESCO", "gui/UNESCO.gif");
        paths.put("gui.USGS", "gui/USGS.gif");
        paths.put("html.about", "html/about.html");
        paths.put("html.bigerror_cannotsave", "html/bigerror-cannotsave.html");
        paths.put("html.bigerror_cansave", "html/bigerror-cannotsave.html");
        paths.put("html.change_in_ages", "html/change_in_ages.html");
        paths.put("html.features_summary", "html/featuresSummary.html");
        paths.put("html.file_format_guide", "html/file_format_guide.html");
        paths.put("html.introscreen", "html/introscreen.html");
        paths.put("html.license", "html/license.html");
        paths.put("html.quickstart", "html/quickstart.htm");
        paths.put("html.tour", "html/tour.html");
        paths.put("html.contact", "html/contact.html");
        paths.put("icons.checkmark", "icons/checkmark.png");
        paths.put("icons.col_icon_age", "icons/col_icon_age.png");
        paths.put("icons.col_icon_blank", "icons/col_icon_blank.png");
        paths.put("icons.col_icon_block", "icons/col_icon_block.png");
        paths.put("icons.col_icon_chron", "icons/col_icon_chron.png");
        paths.put("icons.col_icon_event", "icons/col_icon_event.png");
        paths.put("icons.col_icon_group", "icons/col_icon_group.png");
        paths.put("icons.col_icon_point", "icons/col_icon_point.png");
        paths.put("icons.col_icon_range", "icons/col_icon_range.png");
        paths.put("icons.col_icon_sequence", "icons/col_icon_sequence.png");
        paths.put("icons.col_icon_trend", "icons/col_icon_trend.png");
        paths.put("icons.dashed", "icons/dashed.gif");
        paths.put("icons.dotted", "icons/dotted.gif");
        paths.put("icons.events", "icons/events.gif");
        paths.put("icons.fx", "icons/fx.png");
        paths.put("icons.ranges", "icons/ranges.gif");
        paths.put("icons.ranges", "icons/ranges.gif");
        paths.put("icons.solid", "icons/solid.gif");
        paths.put("icons.x", "icons/x.png");
        paths.put("icons.zoom100", "icons/zoom100.png");
        paths.put("icons.zoomfit", "icons/zoomfit.png");
        paths.put("icons.zoomin", "icons/zoomin.png");
        paths.put("icons.zoomout", "icons/zoomout.png");
        paths.put("icons.time_scale", "icons/time_scale.png");
        paths.put("icons.showline", "icons/showline.png");
        paths.put("icons.refresh", "icons/Refresh.png");
        paths.put("icons.closed", "icons/closedPoint.png");
        paths.put("icons.open", "icons/openPoint.png");
        paths.put("icons.fad", "icons/fadPoint.png");
        paths.put("icons.lad", "icons/ladPoint.png");
        paths.put("icons.timelines", "icons/timelines.png");
        paths.put("icons.hide", "icons/hideDots.png");
        paths.put("icons.popup", "icons/popup.png");
        paths.put("icons.limits", "icons/limitingBox.png");
        paths.put("icons.ageline", "icons/ageline_locker.png");
        paths.put("icons.depthline", "icons/depthline_locker.png");
        paths.put("icons.closedSel", "icons/closedPointSelected.png");
        paths.put("icons.openSel", "icons/openPointSelected.png");
        paths.put("icons.timelinesSel", "icons/timelinesSelected.png");
        paths.put("icons.hideSel", "icons/hideDotsSelected.png");
        paths.put("icons.popupSel", "icons/popupSelected.png");
        paths.put("icons.limitsSel", "icons/limitingBoxSel.png");
        paths.put("icons.agelineSel", "icons/ageline_locker_Sel.png");
        paths.put("icons.depthlineSel", "icons/depthline_locker_Sel.png");
        paths.put("logos.default_tscreator", "logos/TSCreator_Icon.gif");
        paths.put("svg.facies_patterns", "svg/FaciesPatterns.svg");
        paths.put("settings_xml.coloring", "settings_xml/coloring.xml");
        paths.put("settings_xml.pattern_widths", "settings_xml/patternWidths.txt");
        paths.put("settings_xml.versioninfo", "settings_xml/versioninfo.xml");
        paths.put("settings_xml.default_settings", "settings_xml/default_settings.tsc");
        paths.put("settings_xml.serverpacksInfo", "settings_xml/serverpacksInfo.xml");
        paths.put("settings_xml.language_info", "settings_xml/language_info.txt");
        paths.put("basedir.builtin_imagesets", "builtin_imagesets/");
        paths.put("basedir.resources_html", "html/");
        paths.put("basedir.file_format_images", "html/file_format_guide_images");
        paths.put("basedir.features_summary_images", "html/features_summary_images");
        paths.put("root.global", "../");
        paths.put("textures", "textures");
        paths.put("crossplot_temp", "temp/settingsTemp.txt");
        paths.put("CrossplotJS.mouseOverText", "CrossplotJS/mouseOverText.js");
        paths.put("CrossplotJS.browserfix", "CrossplotJS/browserfix.js");
        paths.put("CrossplotJS.chartTools", "CrossplotJS/chartTools.js");
        paths.put("CrossplotJS.crossplotTools", "CrossplotJS/crossplotTools.js");
        paths.put("Patterns.Banded Iron", "Patterns/Banded Iron.PNG");
        paths.put("Patterns.Basement", "Patterns/Basement.PNG");
        paths.put("Patterns.Brackish", "Patterns/Brackish.PNG");
        paths.put("Patterns.Chalk", "Patterns/Chalk.PNG");
        paths.put("Patterns.Chert", "Patterns/Chert.PNG");
        paths.put("Patterns.Clayey limestone", "Patterns/Clayey limestone.PNG");
        paths.put("Patterns.Clayey sandstone", "Patterns/Clayey sandstone.PNG");
        paths.put("Patterns.Claystone", "Patterns/Claystone.PNG");
        paths.put("Patterns.Coal", "Patterns/Coal.PNG");
        paths.put("Patterns.Coarse clastics", "Patterns/Coarse clastics.PNG");
        paths.put("Patterns.Coarse-grained sandstone", "Patterns/Coarse-grained sandstone.PNG");
        paths.put("Patterns.Conglomerate", "Patterns/Conglomerate.PNG");
        paths.put("Patterns.Continental marl", "Patterns/Continental marl.PNG");
        paths.put("Patterns.Continental to marine fine-grained clastics", "Patterns/Continental to marine fine-grained clastics.PNG");
        paths.put("Patterns.Dolomite", "Patterns/Dolomite.PNG");
        paths.put("Patterns.Dolomitic limestone", "Patterns/Dolomitic limestone.PNG");
        paths.put("Patterns.Evaporite", "Patterns/Evaporite.PNG");
        paths.put("Patterns.Fine-grained sandstone", "Patterns/Fine-grained sandstone.PNG");
        paths.put("Patterns.Gap", "Patterns/Gap.PNG");
        paths.put("Patterns.Glacial", "Patterns/Glacial.PNG");
        paths.put("Patterns.Gneiss", "Patterns/Gneiss.PNG");
        paths.put("Patterns.Grantic", "Patterns/Grantic.PNG");
        paths.put("Patterns.Gypsiferous claystone", "Patterns/Gypsiferous claystone.PNG");
        paths.put("Patterns.Gypsum-Anhydrite", "Patterns/Gypsum-Anhydrite.PNG");
        paths.put("Patterns.Halite", "Patterns/Halite.PNG");
        paths.put("Patterns.Lacustrine", "Patterns/Lacustrine.PNG");
        paths.put("Patterns.Lava", "Patterns/Lava.PNG");
        paths.put("Patterns.Limestone", "Patterns/Limestone.PNG");
        paths.put("Patterns.Metavolcanics", "Patterns/Metavolcanics.PNG");
        paths.put("Patterns.Mixed marine", "Patterns/Mixed marine.PNG");
        paths.put("Patterns.No Data", "Patterns/No Data.PNG");
        paths.put("Patterns.Oolitic limestone", "Patterns/Oolitic limestone.PNG");
        paths.put("Patterns.Pelagic biogenic", "Patterns/Pelagic biogenic.PNG");
        paths.put("Patterns.Pelagic marl", "Patterns/Pelagic marl.PNG");
        paths.put("Patterns.Reef limestone", "Patterns/Reef limestone.PNG");
        paths.put("Patterns.Saline", "Patterns/Saline.PNG");
        paths.put("Patterns.Sandstone", "Patterns/Sandstone.PNG");
        paths.put("Patterns.Sandy claystone", "Patterns/Sandy claystone.PNG");
        paths.put("Patterns.Sandy_claystone", "Patterns/Sandy_claystone.PNG");
        paths.put("Patterns.Shallow-marine carbonite", "Patterns/Shallow-marine carbonite.PNG");
        paths.put("Patterns.Shallow-marine marl", "Patterns/Shallow-marine marl.PNG");
        paths.put("Patterns.Siliceous chalk", "Patterns/Siliceous chalk.PNG");
        paths.put("Patterns.Siliceous limestone", "Patterns/Siliceous limestone.PNG");
        paths.put("Patterns.Siltstone", "Patterns/Siltstone.PNG");
        paths.put("Patterns.Soil", "Patterns/Soil.PNG");
        paths.put("Patterns.Unknown", "Patterns/Unknown.PNG");
        paths.put("Patterns.Volcanic_ash", "Patterns/Volcanic_ash.PNG");
        paths.put("Patterns.Volcanics", "Patterns/Volcanics.PNG");
        paths.put("Patterns.NZ_Chalk", "Patterns/NZ_Chalk.PNG");
        paths.put("Patterns.NZ_Chert_nodule_limestone", "Patterns/NZ_Chert_nodule_limestone.PNG");
        paths.put("Patterns.NZ_Chert", "Patterns/NZ_Chert.PNG");
        paths.put("Patterns.NZ_Clayey_limestone", "Patterns/NZ_Clayey_limestone.PNG");
        paths.put("Patterns.NZ_Clayey_marl", "Patterns/NZ_Clayey_marl.PNG");
        paths.put("Patterns.NZ_Clayey_sandstone", "Patterns/NZ_Clayey_sandstone.PNG");
        paths.put("Patterns.NZ_Claystone", "Patterns/NZ_Claystone.PNG");
        paths.put("Patterns.NZ_Coal_clayey_sandstone", "Patterns/NZ_Coal_clayey_sandstone.PNG");
        paths.put("Patterns.NZ_Coal_claystone", "Patterns/NZ_Coal_claystone.PNG");
        paths.put("Patterns.NZ_Coal_conglomerate", "Patterns/NZ_Coal_conglomerate.PNG");
        paths.put("Patterns.NZ_Coal_pebbly_sandstone", "Patterns/NZ_Coal_pebbly_sandstone.PNG");
        paths.put("Patterns.NZ_Coal_sandstone", "Patterns/NZ_Coal_sandstone.PNG");
        paths.put("Patterns.NZ_Coal_siltstone", "Patterns/NZ_Coal_siltstone.PNG");
        paths.put("Patterns.NZ_Coal_silty_claystone", "Patterns/NZ_Coal_silty_claystone.PNG");
        paths.put("Patterns.NZ_Conglomerate_flysch", "Patterns/NZ_Conglomerate_flysch.PNG");
        paths.put("Patterns.NZ_Conglomerate", "Patterns/NZ_Conglomerate.PNG");
        paths.put("Patterns.NZ_Fan_sands", "Patterns/NZ_Fan_sands.PNG");
        paths.put("Patterns.NZ_Fine-grained_sandstone", "Patterns/NZ_Fine-grained_sandstone.PNG");
        paths.put("Patterns.NZ_Flysch", "Patterns/NZ_Flysch.PNG");
        paths.put("Patterns.NZ_Limestone", "Patterns/NZ_Limestone.PNG");
        paths.put("Patterns.NZ_Marl_limestone", "Patterns/NZ_Marl_limestone.PNG");
        paths.put("Patterns.NZ_Marl", "Patterns/NZ_Marl.PNG");
        paths.put("Patterns.NZ_Mid_bathyal_carbonate", "Patterns/NZ_Mid_bathyal_carbonate.PNG");
        paths.put("Patterns.NZ_Mid_bathyal_clastic_marl", "Patterns/NZ_Mid_bathyal_clastic_marl.PNG");
        paths.put("Patterns.NZ_Mid_bathyal_marl", "Patterns/NZ_Mid_bathyal_marl.PNG");
        paths.put("Patterns.NZ_Mid_bathyal_mud", "Patterns/NZ_Mid_bathyal_mud.PNG");
        paths.put("Patterns.NZ_Muddy_sandstone", "Patterns/NZ_Muddy_sandstone.PNG");
        paths.put("Patterns.NZ_Pebbly_sandstone", "Patterns/NZ_Pebbly_sandstone.PNG");
        paths.put("Patterns.NZ_Sandstone", "Patterns/NZ_Sandstone.PNG");
        paths.put("Patterns.NZ_Sandy_claystone", "Patterns/NZ_Sandy_claystone.PNG");
        paths.put("Patterns.NZ_Sandy_limestone", "Patterns/NZ_Sandy_limestone.PNG");
        paths.put("Patterns.NZ_Sandy_mudstone", "Patterns/NZ_Sandy_mudstone.PNG");
        paths.put("Patterns.NZ_Sandy_siltstone", "Patterns/NZ_Sandy_siltstone.PNG");
        paths.put("Patterns.NZ_Shelf_mud", "Patterns/NZ_Shelf_mud.PNG");
        paths.put("Patterns.NZ_Shelf_sand_mud", "Patterns/NZ_Shelf_sand_mud.PNG");
        paths.put("Patterns.NZ_Shelf_silt", "Patterns/NZ_Shelf_silt.PNG");
        paths.put("Patterns.NZ_Shoreface_gravel", "Patterns/NZ_Shoreface_gravel.PNG");
        paths.put("Patterns.NZ_Shoreface_sand_mud", "Patterns/NZ_Shoreface_sand_mud.PNG");
        paths.put("Patterns.NZ_Shoreface_sand", "Patterns/NZ_Shoreface_sand.PNG");
        paths.put("Patterns.NZ_Siliceous_chalk", "Patterns/NZ_Siliceous_chalk.PNG");
        paths.put("Patterns.NZ_Siliceous_limestone", "Patterns/NZ_Siliceous_limestone.PNG");
        paths.put("Patterns.NZ_Siltstone", "Patterns/NZ_Siltstone.PNG");
        paths.put("Patterns.NZ_Silty_claystone", "Patterns/NZ_Silty_claystone.PNG");
        paths.put("Patterns.NZ_Silty_marl", "Patterns/NZ_Silty_marl.PNG");
        paths.put("Patterns.NZ_Terrestrial_coal", "Patterns/NZ_Terrestrial_coal.PNG");
        paths.put("Patterns.NZ_Tuff", "Patterns/NZ_Tuff.PNG");
        paths.put("Patterns.NZ_Tuffaceous_claystone", "Patterns/NZ_Tuffaceous_claystone.PNG");
        paths.put("Patterns.NZ_Tuffaceous_conglomerate", "Patterns/NZ_Tuffaceous_conglomerate.PNG");
        paths.put("Patterns.NZ_Tuffaceous_sandstone", "Patterns/NZ_Tuffaceous_sandstone.PNG");
        paths.put("Patterns.NZ_Tuffaceous_siltstone", "Patterns/NZ_Tuffaceous_siltstone.PNG");
        paths.put("Patterns.NZ_Upper_bathyal_clastic_marl", "Patterns/NZ_Upper_bathyal_clastic_marl.PNG");
        paths.put("Patterns.NZ_Upper_bathyal_marl", "Patterns/NZ_Upper_bathyal_marl.PNG");
        paths.put("Patterns.NZ_Upper_bathyal_mud", "Patterns/NZ_Upper_bathyal_mud.PNG");
        paths.put("Patterns.NZ_Volcanics", "Patterns/NZ_Upper_Volcanics.PNG");
    }
}

