/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.FaciesColumn;
import datastore.MetaColumn;
import datastore.Unit;
import datastore.ZoneColumn;
import datastore.editor.AbstractGroupingStewardGenerator;
import datastore.editor.DataSeries;
import datastore.editor.GroupingSteward;
import datastore.loader.ParseException;
import gui.ImageGenerator;
import gui.Settings;
import gui.editor.ComboBoxRenderer;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import path.ResPath;

public class BlockSeriesMetaColumn
extends MetaColumn {
    private static final long serialVersionUID = 1L;
    public String PATTERN_TITLE = "Chron";
    public String MEMBER_TITLE = "Member Label";
    public String LABEL_TITLE = "Chron Label";
    public String SERIES_TITLE = "Series Label";
    public static final int CHRON_TYPE = 1;
    public static final int FACIES_TYPE = 2;
    String curSeries = "";
    BlockSeriesMetaColumn curSection = null;
    public int type;
    public int level = 1;
    public static double myColWidth = 0.0;
    public static String CurrentPop = null;
    public static boolean outcropStatus = false;

    public BlockSeriesMetaColumn(String colName, int type) {
        this(colName, type, 1);
    }

    public BlockSeriesMetaColumn(String colName, int type, int level) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_chron");
        switch (type) {
            case 1: {
                this.PATTERN_TITLE = "Chron";
                this.LABEL_TITLE = "Chron Label";
                this.SERIES_TITLE = "Series Label";
                this.type = 1;
                break;
            }
            default: {
                this.LABEL_TITLE = "Facies Label";
                this.PATTERN_TITLE = "Facies";
                this.SERIES_TITLE = "Series Label";
                this.MEMBER_TITLE = "Members";
                this.type = 2;
            }
        }
        if (level != 1 && level != 2) {
            level = 2;
        }
        this.level = level;
    }

    public void setCurrent(String section, String series, String sWidth, int showColumn, String popup) {
        if (series == null && this.curSeries == null) {
            series = "";
        }
        if (series.equals("BASE")) {
            series = "";
        }
        double width = 0.0;
        try {
            width = Double.parseDouble(sWidth);
        }
        catch (Exception e) {
            width = 0.0;
        }
        this.setCurrentSection(section, showColumn, popup);
        if (width > 0.0) {
            this.stretchSection(width);
        }
        this.curSeries = series;
    }

    protected void setCurrentSection(String section, int showColumn, String popup) {
        if (section == null || section.length() == 0) {
            if (this.curSection == null) {
                section = "Default";
            } else {
                return;
            }
        }
        if (this.level == 2) {
            return;
        }
        if (this.curSection != null && this.curSection.name.compareToIgnoreCase(section) == 0) {
            return;
        }
        BlockSeriesMetaColumn findSec2 = null;
        for (BlockSeriesMetaColumn findSec2 : this.subColumns) {
            if (findSec2.name.compareToIgnoreCase(section) == 0) break;
            findSec2 = null;
        }
        if (findSec2 != null) {
            this.curSection = findSec2;
            this.curSection.popup = this.curSection.popup != null && popup != null ? this.curSection.popup + "\n" + popup : popup;
        } else {
            this.curSection = new BlockSeriesMetaColumn(section, this.type, 2);
            this.curSection.unit = this.unit;
            if (showColumn != 3) {
                this.curSection.setSelected(showColumn == 1);
            }
            this.curSection.popup = popup;
            this.addColumn(this.curSection, true);
            this.curSection.createChronAndZoneColumns();
        }
    }

    @Override
    public void setUnit(Unit u) {
        this.setUnitRecurse(u);
    }

    public void createChronAndZoneColumns() {
        FaciesColumn patternCol = this.type == 1 ? new ChronColumn(this.PATTERN_TITLE) : new FaciesColumn(this.PATTERN_TITLE);
        ZoneColumn memberCol = new ZoneColumn(this.MEMBER_TITLE);
        ZoneColumn labelCol = new ZoneColumn(this.LABEL_TITLE);
        ZoneColumn seriesCol = new ZoneColumn(this.SERIES_TITLE);
        memberCol.isOutcrop = outcropStatus;
        labelCol.isOutcrop = outcropStatus;
        seriesCol.isOutcrop = outcropStatus;
        patternCol.drawTitle = false;
        memberCol.drawTitle = false;
        labelCol.drawTitle = false;
        seriesCol.drawTitle = false;
        patternCol.unit = this.unit;
        memberCol.unit = this.unit;
        labelCol.unit = this.unit;
        seriesCol.unit = this.unit;
        patternCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        if (this.type != 1 && this.type == 2) {
            memberCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        }
        labelCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        seriesCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        seriesCol.setOrientation(4);
        if (this.type == 2) {
            if (myColWidth > 0.0) {
                patternCol.setWidth(myColWidth * 0.4);
            } else {
                patternCol.setWidth(150.0);
            }
        }
        labelCol.color = new Coloring(Color.white);
        memberCol.color = new Coloring(Color.white);
        seriesCol.color = new Coloring(Color.white);
        if (this.type == 1) {
            labelCol.setWidth(40.0);
        } else if (myColWidth > 0.0) {
            labelCol.setWidth(myColWidth * 0.4);
        } else {
            labelCol.setWidth(90.0);
        }
        if (myColWidth > 0.0) {
            seriesCol.setWidth(myColWidth * 0.2);
        } else {
            seriesCol.setWidth(40.0);
        }
        this.addColumn(patternCol);
        if (this.type == 2) {
            memberCol.setSelected(false);
            this.addColumn(memberCol);
        }
        this.addColumn(labelCol);
        this.addColumn(seriesCol);
        myColWidth = 0.0;
    }

    protected void stretchSection(double newWidth) {
        if (this.curSection == null) {
            return;
        }
        DataColumn seriesCol = this.curSection.getColumnByName(this.SERIES_TITLE);
        if (seriesCol == null) {
            return;
        }
        if (seriesCol.myWidth < newWidth) {
            seriesCol.setWidth(newWidth);
        }
    }

    @Override
    public void addData(Datapoint dp) {
        if (this.level == 2) {
            super.addData(dp);
            return;
        }
        if (this.curSection == null) {
            this.setCurrentSection(null, 3, null);
        }
        dp.series = this.curSeries;
        dp.section = this.curSection.name;
        dp.SeriesPopup = CurrentPop;
        this.curSection.addData(dp);
    }

    public DataColumn finalizeBSLoading() throws ParseException {
        BlockSeriesMetaColumn sec2 = null;
        DataColumn chronCol = null;
        DataColumn memberCol = null;
        DataColumn labelCol = null;
        DataColumn seriesCol = null;
        for (BlockSeriesMetaColumn sec2 : this.subColumns) {
            chronCol = sec2.getColumnByName(this.PATTERN_TITLE);
            if (memberCol != null) {
                memberCol = sec2.getColumnByName(this.MEMBER_TITLE);
            }
            labelCol = sec2.getColumnByName(this.LABEL_TITLE);
            seriesCol = sec2.getColumnByName(this.SERIES_TITLE);
            if (sec2.reloadDataColumns()) continue;
            throw new ParseException("Internal Error: BlockSeriesMetaColumn reload failed!");
        }
        if (this.subColumns.size() == 1) {
            this.removeColumn(sec2);
            Iterator<DataColumn> secCols = sec2.getSubColumns();
            while (secCols.hasNext()) {
                this.addColumn(secCols.next());
            }
            this.data.addAll(sec2.data);
            this.level = 2;
            chronCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
            if (memberCol != null) {
                memberCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
            }
            labelCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
            seriesCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        }
        if (this.subColumns.size() == 0) {
            this.createChronAndZoneColumns();
        }
        return chronCol;
    }

    public boolean reloadDataColumns() {
        int lastPattern = 1;
        DataColumn chronCol = this.getColumnByName(this.PATTERN_TITLE);
        DataColumn memberCol = this.getColumnByName(this.MEMBER_TITLE);
        DataColumn labelCol = this.getColumnByName(this.LABEL_TITLE);
        DataColumn seriesCol = this.getColumnByName(this.SERIES_TITLE);
        chronCol.data.clear();
        if (memberCol != null) {
            memberCol.data.clear();
        }
        labelCol.data.clear();
        seriesCol.data.clear();
        chronCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        if (memberCol != null) {
            memberCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        }
        labelCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        seriesCol.setNoEdit("Select '" + this.getName() + "' to edit data for this column.");
        if (chronCol == null || labelCol == null || seriesCol == null) {
            return false;
        }
        Iterator pIter = this.getData();
        String lastSeries = null;
        String lastLabel = null;
        String lastSeriesLabel = null;
        String lastFaciesPopup = null;
        double lastBase = Double.NEGATIVE_INFINITY;
        double lastSeriesBase = Double.NEGATIVE_INFINITY;
        boolean newSeries = false;
        while (pIter.hasNext()) {
            Datapoint tempP;
            Datapoint p = (Datapoint)pIter.next();
            if (memberCol != null) {
                tempP = new Datapoint(p);
                tempP.label = p.member;
                tempP.lineType = p.lineType;
                memberCol.addData(tempP);
            }
            newSeries = false;
            if (lastSeries == null) {
                tempP = new Datapoint(p);
                tempP.popup = p.SeriesPopup;
                tempP.label = "";
                tempP.baseAge = p.baseAge;
                tempP.breaker = true;
                seriesCol.addData(tempP);
                lastSeries = p.series;
                lastSeriesBase = p.baseAge;
                lastSeriesLabel = p.SeriesPopup;
            } else if (lastSeries != null && p.series.compareToIgnoreCase(lastSeries) != 0) {
                tempP = new Datapoint(p);
                tempP.popup = lastSeriesLabel;
                tempP.label = lastSeries;
                tempP.baseAge = lastSeriesBase;
                tempP.breaker = false;
                tempP.lineType = lastPattern;
                seriesCol.addData(tempP);
                lastSeries = null;
                lastSeriesBase = p.baseAge;
                lastSeriesLabel = p.SeriesPopup;
                newSeries = true;
                if (p.breaker) {
                    tempP = new Datapoint(p);
                    tempP.popup = lastSeriesLabel;
                    tempP.label = "";
                    tempP.baseAge = p.baseAge;
                    tempP.breaker = true;
                    seriesCol.addData(tempP);
                    lastSeries = p.series;
                    lastSeriesBase = p.baseAge;
                    lastSeriesLabel = p.SeriesPopup;
                }
            }
            if (!pIter.hasNext()) {
                tempP = new Datapoint(p);
                tempP.popup = lastSeriesLabel;
                tempP.label = p.series;
                tempP.baseAge = p.baseAge;
                tempP.breaker = false;
                seriesCol.addData(tempP);
                lastSeries = null;
                lastSeriesBase = p.baseAge;
                lastSeriesLabel = p.SeriesPopup;
            }
            if (lastLabel != null && p.label.compareToIgnoreCase(lastLabel) != 0 && !p.breaker || newSeries) {
                tempP = new Datapoint(p);
                tempP.label = lastLabel;
                tempP.baseAge = lastBase;
                tempP.breaker = false;
                tempP.lineType = lastPattern;
                tempP.popup = lastFaciesPopup;
                labelCol.addData(tempP);
                lastLabel = null;
                lastBase = p.baseAge;
                lastFaciesPopup = p.popup;
            }
            if (p.breaker) {
                if (lastLabel != null) {
                    tempP = new Datapoint(p);
                    tempP.popup = null;
                    tempP.label = lastLabel;
                    tempP.baseAge = lastBase;
                    tempP.breaker = false;
                    tempP.lineType = lastPattern;
                    labelCol.addData(tempP);
                    lastLabel = null;
                    lastBase = p.baseAge;
                    lastFaciesPopup = p.popup;
                }
                tempP = new Datapoint(p);
                tempP.label = "";
                tempP.baseAge = p.baseAge;
                tempP.breaker = true;
                tempP.popup = lastFaciesPopup;
                labelCol.addData(tempP);
                lastLabel = null;
                lastBase = p.baseAge;
                lastFaciesPopup = p.popup;
            }
            if (!pIter.hasNext()) {
                tempP = new Datapoint(p);
                tempP.label = p.label;
                tempP.baseAge = p.baseAge;
                tempP.breaker = false;
                tempP.popup = p.popup;
                labelCol.addData(tempP);
                tempP.popup = null;
                lastLabel = null;
                lastBase = p.baseAge;
                lastFaciesPopup = p.popup;
            }
            if (!p.breaker) {
                lastLabel = p.label;
            }
            lastBase = p.baseAge;
            lastSeriesBase = p.baseAge;
            lastSeries = p.series;
            lastPattern = p.lineType;
            lastFaciesPopup = p.popup;
            chronCol.addData(p);
        }
        chronCol.updateMinMaxAges();
        if (memberCol != null) {
            memberCol.updateMinMaxAges();
        }
        labelCol.updateMinMaxAges();
        seriesCol.updateMinMaxAges();
        return true;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
    }

    @Override
    public void write(Writer w) throws IOException {
        if (this.treatAsRegularMetaColumn()) {
            super.write(w);
            return;
        }
        if (this.type == 1) {
            this.writeHeader(w, "chron");
        } else {
            this.writeHeader(w, "facies");
        }
        DataColumn chronCol = null;
        chronCol = this.getColumnByName(this.PATTERN_TITLE);
        String curSeries = "";
        Iterator chronIter = chronCol.getData();
        while (chronIter.hasNext()) {
            Datapoint p = (Datapoint)chronIter.next();
            String pSeries = p.series;
            if (pSeries == null) {
                pSeries = "";
            }
            if (curSeries.compareToIgnoreCase(pSeries) != 0) {
                curSeries = pSeries;
                if (pSeries.length() == 0) {
                    pSeries = "BASE";
                }
                w.write(pSeries + "\t" + p.section + "\r\n");
            }
            w.write("\t" + p.value.toString() + "\t");
            if (p.label != null) {
                w.write(p.label);
            }
            w.write("\t" + Double.toString(p.baseAge));
            if (p.popup != null) {
                w.write("\t");
                BlockSeriesMetaColumn.writeRichText(w, p.popup);
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }

    public boolean treatAsRegularMetaColumn() {
        return this.level != 2;
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setGroupingGenerator(new BlockSeriesGroupingStewardGenerator());
        BlockSeriesGroupingSteward g = null;
        SortedSet<Datapoint> groupData = Collections.synchronizedSortedSet(new TreeSet<Datapoint>(new Datapoint.Comparator()));
        String curSeries = null;
        Iterator chronIter = this.getData();
        while (chronIter.hasNext()) {
            Datapoint p = (Datapoint)chronIter.next();
            String pSeries = p.series;
            if (pSeries == null) {
                pSeries = "";
            }
            if (curSeries == null) {
                curSeries = pSeries;
            }
            if (curSeries.compareToIgnoreCase(pSeries) != 0) {
                if (groupData.size() > 0) {
                    g = new BlockSeriesGroupingSteward(groupData, curSeries);
                    series.addGrouping(g);
                    groupData = Collections.synchronizedSortedSet(new TreeSet<Datapoint>(new Datapoint.Comparator()));
                }
                curSeries = pSeries;
            }
            groupData.add(p);
        }
        if (groupData != null && groupData.size() > 0 || series.getNumGroupings() == 0) {
            g = new BlockSeriesGroupingSteward(groupData, curSeries);
            series.addGrouping(g);
        }
        return series;
    }

    public class BlockSeriesGroupingStewardGenerator
    extends AbstractGroupingStewardGenerator {
        @Override
        public GroupingSteward createGroupingSteward(String type) {
            return new BlockSeriesGroupingSteward(Collections.synchronizedSortedSet(new TreeSet<Datapoint>(new Datapoint.Comparator())), "title");
        }
    }

    public class BlockSeriesGroupingSteward
    extends GroupingSteward {
        public BlockSeriesGroupingSteward(Collection group, String title) {
            super(BlockSeriesMetaColumn.this.data, group, new TableInterpreter(), title);
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Datapoint p = (Datapoint)iter.next();
                p.series = title;
            }
        }

        @Override
        public void delete() {
            BlockSeriesMetaColumn.this.data.removeAll(this.groupData);
            this.groupData = new Vector();
        }

        @Override
        protected void callForNewDatapoints(Datapoint p) {
            p.series = this.getTitle();
        }
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames;
        public String[] myToolTips;
        public Class[] myClasses;

        public TableInterpreter() {
            super(BlockSeriesMetaColumn.this);
            this.myNames = new String[]{"Polarity", "Label", "Age", "Popup"};
            this.myToolTips = new String[]{"Appears in \"chron\" column, or TOP to specify top of data", "Appears in \"chron label\" column", "base age", null};
            this.myClasses = new Class[]{PatternType.class, String.class, Double.class, String.class};
            this.myNames[0] = BlockSeriesMetaColumn.this.type == 1 ? "Polarity" : "Pattern";
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
            spread.setDefaultEditor(PatternType.class, new DefaultCellEditor(new PatternType().getComboBox()));
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.value;
                }
                case 1: {
                    return p.label;
                }
                case 2: {
                    return new Double(p.baseAge);
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    if (value.toString().length() == 0) {
                        value = "No Data";
                    }
                    p.value = value;
                    if (p.value.toString().compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    p.label = value.toString();
                    break;
                }
                case 2: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    if (!Double.isNaN(age)) {
                        p.baseAge = age;
                        break;
                    }
                    p.baseAge = 0.0;
                    break;
                }
                case 3: {
                    p.popup = value.toString();
                }
            }
        }

        @Override
        public Datapoint createEmptyDatapoint() {
            Datapoint p = new Datapoint();
            p.value = "No Data";
            p.series = "";
            return p;
        }

        public class PatternType
        extends ComboBoxRenderer {
            private static final long serialVersionUID = 1L;

            public PatternType() {
                Object[] patterns = new String[]{"N", "R", "U", "No Data"};
                if (BlockSeriesMetaColumn.this.type == 2) {
                    patterns = BlockSeriesMetaColumn.this.ds.patMan.getPatternNames();
                }
                this.set(patterns, null);
                this.setEditable(true);
            }
        }
    }
}

