/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumnChangeEvent;
import datastore.DataColumnChangeListener;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.Unit;
import datastore.ages.AgeConverter;
import datastore.editor.AbstractDatapointTableInterpreter;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import datastore.loader.ParseException;
import gui.FontManager;
import gui.FontOptions;
import gui.ImageGenerator;
import gui.LinkProcessor;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.TSCreator;
import gui.editor.ComboBoxRenderer;
import gui.tree.DataColumnTreePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import path.ResPath;
import util.NumberUtils;

public class DataColumn
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    public static boolean setColBG = false;
    public static boolean isIntervalCol = false;
    public SortedSet<Datapoint> data;
    public double minAge = Double.POSITIVE_INFINITY;
    public double maxAge = Double.NEGATIVE_INFINITY;
    protected Datastore ds = null;
    public String id;
    public String name;
    public Coloring color;
    public int myNum;
    public Coloring defaultColor = null;
    public Coloring guiColor = new Coloring(Color.white);
    public int maxChronostratLevel = 100;
    public boolean useNamedColor = false;
    public boolean placeHolder;
    public boolean isLoaded = false;
    public boolean drawTitle = true;
    public boolean drawAgeLabel = false;
    public boolean drawUncertaintyLabel = false;
    public boolean selected = true;
    public boolean myFlip = false;
    public boolean myScale = false;
    public boolean NoDataInDataColumn = false;
    public boolean grayedOutAlreadyComputed = false;
    public boolean drawExtraColumn = false;
    public boolean dataMiningColumnDrawing = false;
    public String extraColumnHeaderName = null;
    public String prevExtraColumnHeaderName = null;
    public int dataMiningFunction = -1;
    public int prevDataMiningFunction = -2;
    public boolean priorityEnable = false;
    public int priorityVal = 10;
    public String popup = null;
    protected FontManager fonts;
    public Unit unit;
    public DataColumn overlayParent = null;
    public List underlays = null;
    public List overlays = null;
    public String noEditMessage = null;
    protected String iconPath = ResPath.getPath("icons.col_icon_blank");
    public static final int SHOW_COL = 1;
    public static final int HIDE_COL = 2;
    public static final int DEFAULT_SHOW_COL = 3;
    public DataColumnTreePanel panel;
    protected double myWidth = 100.0;
    protected double RangeColumnWidthPadding = 0.2;
    protected double RangeColumnRangeAgeLabelPadding = 2.0;
    protected double BranchSpacing = 0.0;
    protected double myHeaderHeight = -1.0;
    protected double myOwnHeaderHeight = -1.0;
    protected StringWrappingInfo nameWrap;
    public boolean grayedOut = false;
    public int noofTimesResultSelected = 0;
    public int order = 100000;
    public int myFlag = 0;
    public boolean isStdChron = false;
    public String columnName;
    public boolean isOutcrop = false;
    public FileInfo fileInfo = null;
    public static final double MIN_COL_WIDTH = 20.0;
    public static final double COL_HEADER_BOTTOM_MARGIN = 2.0;
    public static final double AGE_LABEL_WIDTH = 20.0;
    public static final double AGE_LABEL_MARGIN = 10.0;
    public static final double LABEL_GAP = 5.0;
    public JPanel optionsPanel = null;
    public DataColumnTreePanel checkboxPanel;
    protected Vector<DataColumnChangeListener> changeListeners = new Vector();

    public void setLoaded(boolean l) {
        this.isLoaded = l;
    }

    public void setDS(Datastore ds) {
        this.ds = ds;
    }

    public void addChangeListener(DataColumnChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(DataColumnChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void fireChange(int type) {
        DataColumnChangeEvent evt = new DataColumnChangeEvent(this, type);
        this.fireChange(evt);
    }

    protected void fireChange(DataColumnChangeEvent evt) {
        for (DataColumnChangeListener l : this.changeListeners) {
            l.DataColumnChanged(evt);
        }
    }

    public void readSettings(Element element, Settings settings) {
        this.fonts.resetFonts();
        this.optionsPanel = null;
        NodeList nl = element.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nl.getLength(); ++nodeIndex) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().compareToIgnoreCase("fonts") == 0) {
                this.fonts.readSettings((Element)node);
            }
            if (node.getNodeName().compareToIgnoreCase("setting") != 0) continue;
            Element setting = (Element)node;
            try {
                this.readOneSetting(setting, settings);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.isLoaded = true;
    }

    public void readOneSetting(Element setting, Settings settings) {
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("title") == 0) {
                this.setName(Settings.getNodeTextContent(setting).replaceAll("\n", "").replaceAll(" +", " ").trim());
            } else if (name.compareToIgnoreCase("backgroundColor") == 0) {
                this.color = Coloring.readSettings(setting, settings);
            } else if (name.compareToIgnoreCase("customColor") == 0) {
                this.guiColor = Coloring.readSettings(setting, settings);
            } else if (name.compareToIgnoreCase("useNamedColor") == 0) {
                this.useNamedColor = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("placeHolder") == 0) {
                this.placeHolder = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawTitle") == 0) {
                this.drawTitle = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawAgeLabel") == 0) {
                this.drawAgeLabel = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawUncertaintyLabel") == 0) {
                this.drawUncertaintyLabel = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("isSelected") == 0) {
                this.setSelected(Boolean.valueOf(Settings.getNodeTextContent(setting)));
            } else if (name.compareToIgnoreCase("width") == 0) {
                this.myWidth = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("pad") == 0) {
                this.RangeColumnWidthPadding = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("age pad") == 0) {
                this.RangeColumnRangeAgeLabelPadding = Double.parseDouble(Settings.getNodeTextContent(setting));
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        element.setAttribute("id", this.id);
        element.appendChild(Settings.createSimpleSetting(doc, "title", this.getName()));
        element.appendChild(Settings.createSimpleSetting(doc, "useNamedColor", "" + this.useNamedColor));
        element.appendChild(Settings.createSimpleSetting(doc, "placeHolder", "" + this.placeHolder));
        element.appendChild(Settings.createSimpleSetting(doc, "drawTitle", "" + this.drawTitle));
        element.appendChild(Settings.createSimpleSetting(doc, "drawAgeLabel", "" + this.drawAgeLabel));
        element.appendChild(Settings.createSimpleSetting(doc, "drawUncertaintyLabel", "" + this.drawUncertaintyLabel));
        element.appendChild(Settings.createSimpleSetting(doc, "isSelected", "" + this.isSelected()));
        element.appendChild(Settings.createSimpleSetting(doc, "width", "" + this.myWidth));
        element.appendChild(Settings.createSimpleSetting(doc, "pad", "" + this.RangeColumnWidthPadding));
        element.appendChild(Settings.createSimpleSetting(doc, "age pad", "" + this.RangeColumnRangeAgeLabelPadding));
        Element colorE = Settings.createSimpleSetting(doc, "backgroundColor", null);
        if (this.color != null) {
            this.color.writeSettings(colorE, doc);
        }
        element.appendChild(colorE);
        colorE = Settings.createSimpleSetting(doc, "customColor", null);
        if (this.guiColor != null) {
            this.guiColor.writeSettings(colorE, doc);
        }
        element.appendChild(colorE);
        Element fontsE = doc.createElement("fonts");
        this.fonts.writeSettings(fontsE, doc);
        element.appendChild(fontsE);
    }

    public DataColumn(String colName, boolean ph) {
        this.id = this.getClass().toString() + ":" + colName;
        this.createDataSet(new Datapoint.Comparator());
        this.name = colName;
        this.placeHolder = ph;
        this.myNum = TSCreator.myOrder;
        this.panel = new DataColumnTreePanel();
        this.panel.setToColumn(this);
        this.fonts = new FontManager();
        super.setAllowsChildren(false);
    }

    protected void createDataSet(Comparator comp) {
        this.data = Collections.synchronizedSortedSet(new TreeSet(comp));
    }

    public void addCheckBoxPanel(DataColumnTreePanel p) {
        this.checkboxPanel = p;
    }

    public void checkboxClick() {
        this.checkboxPanel.checkboxClick();
    }

    public DataColumn(String colName) {
        this(colName, false);
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void setColor(Coloring colColor) {
        if (this.defaultColor == null) {
            this.defaultColor = colColor;
        }
        this.color = colColor;
        if (this.color != null && this.color.oneColor != null) {
            this.guiColor = this.color;
        }
        this.useNamedColor = this.color == Coloring.NAMED_USGS || this.color == Coloring.NAMED_UNESCO;
    }

    public void addData(Datapoint dp) {
        if (dp.label != null) {
            dp.label = dp.label.trim();
        }
        this.data.add(dp);
        if (dp.baseAge > this.maxAge) {
            this.maxAge = dp.baseAge;
        }
        if (dp.baseAge < this.minAge) {
            this.minAge = dp.baseAge;
        }
    }

    public void updateMinMaxAges() {
        this.minAge = Double.POSITIVE_INFINITY;
        this.maxAge = Double.NEGATIVE_INFINITY;
        for (Datapoint dp : this.data) {
            if (dp.baseAge > this.maxAge) {
                this.maxAge = dp.baseAge;
            }
            if (!(dp.baseAge < this.minAge)) continue;
            this.minAge = dp.baseAge;
        }
    }

    public double getDataDensity() {
        return (double)this.data.size() / (this.maxAge - this.minAge);
    }

    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        if (this.getClass() == DataColumn.class) {
            this.grayedOut = false;
            return this.grayedOut;
        }
        if (Double.isNaN(topAge) || Double.isNaN(baseAge)) {
            this.grayedOut = false;
            return this.grayedOut;
        }
        boolean lastGO = this.grayedOut;
        this.grayedOut = en && this.unit != null ? !NumberUtils.doRangesOverlapErrNo(this.minAge, this.maxAge, topAge, baseAge, this.unit.isNegated()) : false;
        if (lastGO != this.grayedOut) {
            this.setName(this.name);
        }
        return this.grayedOut;
    }

    public SortedSet getData(double start, double end) {
        return this.data.subSet(new Datapoint(start), new Datapoint(end));
    }

    public SortedSet getData(double start) {
        return this.data.tailSet(new Datapoint(start));
    }

    public Iterator getData() {
        return this.data.iterator();
    }

    public SortedSet getDrawingDataSet() {
        if (this.unit != null && this.unit.isNegated()) {
            return this.negateAges();
        }
        return this.data;
    }

    public Iterator getDrawingData() {
        return this.getDrawingDataSet().iterator();
    }

    public int getNumSeries() {
        return 1;
    }

    public boolean canAlterSeries() {
        return false;
    }

    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setSingle(new DataSteward(this.data, new TableInterpreter()));
        return series;
    }

    public String getSeriesName(int which) {
        if (which != 0) {
            return null;
        }
        return this.getName();
    }

    public boolean isEditable() {
        return this.noEditMessage == null;
    }

    public String getNoEditMessage() {
        return this.noEditMessage;
    }

    public void setNoEdit(String message) {
        if (message == null) {
            message = "";
        }
        this.noEditMessage = message;
    }

    public void setUnit(Unit u) {
        this.unit = u;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getToolTipText() {
        return "<html>" + this.name + "<br>data range: " + this.minAge + " - " + this.maxAge + " " + this.unit.getName() + "</html>";
    }

    public String getAgeLabel(double age) {
        return Double.toString(new BigDecimal(age).setScale(2, 4).doubleValue());
    }

    public String getAgeLabel(double age, boolean isInteger) {
        if (!this.isStdChron) {
            if (this.unit != null && this.unit.isNegated()) {
                age = -age;
            }
            return Double.toString(new BigDecimal(age).setScale(2, 4).doubleValue());
        }
        return Double.toString(new BigDecimal(age).setScale(2, 4).doubleValue());
    }

    public String getUncertaintyLabel(CollisionAvoider.Node node) {
        return node.dp.uncertainty != null ? "(" + node.dp.uncertainty + ")" : "";
    }

    public void setSelected(boolean newCheck) {
        this.selected = newCheck;
        this.fireChange(3);
        this.panel.setChecked(this.selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean shouldDraw() {
        if (this.selected) {
            if (!this.grayedOut) {
                return true;
            }
            if (this.name.equals("Eon") || this.name.equals("Era") || this.name.equals("Sub-Era") || this.name.equals("Period") || this.name.equals("Sub-Period") || this.name.equals("Epoch") || this.name.equals("Sub-Epoch") || this.name.equals("Age/Stage") || this.name.equals("Substage") || this.name.equals("Alternate Precambrian Chronostratigraphy") || this.name.equals("GSSPs")) {
                return true;
            }
        }
        return false;
    }

    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    public FontOptions getFontOptionsPanel() {
        FontOptions fo = new FontOptions(this.fonts);
        JPanel p = fo.getAddPanel();
        p.setBorder(BorderFactory.createTitledBorder("Font Options for \"" + this.getName() + "\""));
        fo.addOptions(FontManager.getRelevantFonts(this.getClass()), true, true);
        return fo;
    }

    public int[] getRelevantFonts() {
        return FontManager.getRelevantFonts(this.getClass());
    }

    public MetaColumn getColParent() {
        return (MetaColumn)this.getParent();
    }

    public double getWidth(Settings s, ImageGenerator ig, double dataHeight) {
        return this.myWidth;
    }

    public double getMyWidth() {
        return this.myWidth;
    }

    public void setWidth(double newWidth) {
        if (newWidth < 20.0) {
            newWidth = 20.0;
        }
        this.myWidth = newWidth;
    }

    public void setRangeColumnWidthPadding(double newRangeColumnWidthPadding) {
        this.RangeColumnWidthPadding = newRangeColumnWidthPadding;
    }

    public double getRangeColumnWidthPadding() {
        return this.RangeColumnWidthPadding;
    }

    public void setAgeLabelPadding(double newAgeLabelPadding) {
        this.RangeColumnRangeAgeLabelPadding = newAgeLabelPadding;
    }

    public double getAgeLabelPadding() {
        return this.RangeColumnRangeAgeLabelPadding;
    }

    public void setBranchSpacing(double newBranchSpacing) {
        this.BranchSpacing = newBranchSpacing;
    }

    public double getBranchSpacing() {
        return this.BranchSpacing;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nt) {
        this.name = nt;
        this.fireChange(3);
    }

    public void setParentFontManager(FontManager parentFM) {
        this.fonts.setParent(parentFM);
    }

    public void setVariableColoring(Settings s) {
        if (this.color == null) {
            return;
        }
        if (this.color == Coloring.NAMED_USGS || this.color == Coloring.NAMED_UNESCO || this.color.setFrom == Coloring.NAMED_USGS || this.color.setFrom == Coloring.NAMED_UNESCO) {
            this.color = s.variableNamedColoring;
        }
        if (this.color == Coloring.USGS || this.color == Coloring.UNESCO || this.color.setFrom == Coloring.USGS || this.color.setFrom == Coloring.UNESCO) {
            this.color = s.variableColoring;
        }
    }

    public void finalizeLoading() throws ParseException {
    }

    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        this.nameWrap = ig.wrapString(this.name, this.myWidth, this.fonts.getFont(0), this.fileInfo);
        this.myOwnHeaderHeight = this.name.length() != 0 && this.drawTitle ? this.nameWrap.getHeight() + 2.0 : 0.0;
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    public SortedSet negateAges() {
        return this.negateAgesSimple();
    }

    protected SortedSet negateAgesSimple() {
        Iterator iter = this.getData();
        SortedSet<Datapoint> ret = Collections.synchronizedSortedSet(new TreeSet<Datapoint>(this.data.comparator()));
        while (iter.hasNext()) {
            Datapoint p = (Datapoint)iter.next();
            Datapoint negged = p.copy();
            negged.baseAge = -p.baseAge;
            ret.add(negged);
        }
        return ret;
    }

    protected SortedSet negateAgesBreakerBased() {
        return this.negateAgesSimple();
    }

    public void convertAges(AgeConverter translator) {
        Datapoint lastP = null;
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            int direction;
            Datapoint p = (Datapoint)iter.next();
            int n = direction = p.breaker ? 1 : -1;
            if (lastP != null && NumberUtils.isEqual(lastP.baseAge, p.baseAge)) {
                direction = 1;
            }
            p.baseAge = translator.convertAge(p.baseAge, direction);
            lastP = p;
        }
        this.updateMinMaxAges();
    }

    public void setHeaderHeight(double newHeaderHeight) {
        this.myHeaderHeight = newHeaderHeight;
    }

    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        if (this.name.length() > 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double eggy = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double eggy2 = eggy;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (eggy > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(eggy);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)eggy);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    eggy -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty, width, height - 2.0, 3);
            eggy = eggy2;
            myWrapHolder.setSize(eggy);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        if (this.overlayParent == null) {
            if (this.color != null) {
                this.color.drawColoring(ig, startx, starty, width, height, settings, this.maxChronostratLevel);
            } else {
                Coloring.drawDefaultColoring(ig, startx, starty, width, height, settings);
            }
        }
        this.drawUnderlays(ig, startx, starty, width, height, settings);
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
    }

    public void addOverlay(DataColumn overlay) {
        if (this.overlays == null) {
            this.overlays = new LinkedList();
        }
        this.overlays.add(overlay);
        overlay.setParentFontManager(this.fonts);
        if (overlay.minAge < this.minAge) {
            this.minAge = overlay.minAge;
        }
        if (overlay.maxAge > this.maxAge) {
            this.maxAge = overlay.maxAge;
        }
        overlay.overlayParent = this;
        overlay.unit = this.unit;
    }

    public void addUnderlay(DataColumn underlay) {
        if (this.underlays == null) {
            this.underlays = new LinkedList();
        }
        this.underlays.add(underlay);
        underlay.setParentFontManager(this.fonts);
        if (underlay.minAge < this.minAge) {
            this.minAge = underlay.minAge;
        }
        if (underlay.maxAge > this.maxAge) {
            this.maxAge = underlay.maxAge;
        }
        underlay.overlayParent = this;
        underlay.unit = this.unit;
    }

    public void drawOverlays(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.overlays == null) {
            return;
        }
        for (DataColumn col : this.overlays) {
            col.drawData(ig, startx, starty, width, height, settings);
        }
    }

    public void drawUnderlays(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.underlays == null) {
            return;
        }
        for (DataColumn col : this.underlays) {
            col.drawData(ig, startx, starty, width, height, settings);
        }
    }

    public void writeHeader(Writer w, String colType) throws IOException {
        w.write(this.getName() + "\t" + colType + "\t" + Double.toString(this.getMyWidth()) + "\t");
        if (this.color != null) {
            w.write(this.color.toString() + "\t");
        } else {
            w.write("nocolor\t");
        }
        if (this.drawTitle) {
            w.write(9);
        } else {
            w.write("notitle\t");
        }
        if (this.isSelected()) {
            w.write("on\t");
        } else {
            w.write("off\t");
        }
        if (this.popup != null) {
            DataColumn.writeRichText(w, this.popup);
        }
        w.write("\r\n");
    }

    public void write(Writer w) throws IOException {
    }

    public static void writeRichText(Writer w, String text) throws IOException {
        String s = text.replaceAll("\r\n", "<br>");
        s = s.replaceAll("\n", "<br>");
        s = s.replaceAll("\r", "<br>");
        w.write(s);
    }

    public void writeOverlaysAndUnderlays(Writer w) throws IOException {
        DataColumn col;
        Iterator iter;
        if (this.overlays != null) {
            iter = this.overlays.iterator();
            while (iter.hasNext()) {
                w.write("\r\n\r\n");
                col = (DataColumn)iter.next();
                if (col instanceof FreehandColumn) {
                    ((FreehandColumn)col).writeOverlay(w);
                    continue;
                }
                col.write(w);
            }
        }
        if (this.underlays != null) {
            iter = this.underlays.iterator();
            while (iter.hasNext()) {
                w.write("\r\n\r\n");
                col = (DataColumn)iter.next();
                if (col instanceof FreehandColumn) {
                    ((FreehandColumn)col).writeUnderlay(w);
                    continue;
                }
                col.write(w);
            }
        }
    }

    public void passName(String name) {
        this.columnName = name;
    }

    public String getColName() {
        return this.columnName;
    }

    public class TableInterpreter
    extends AbstractDatapointTableInterpreter {
        public String[] names = new String[]{"Label", "Age"};
        public String[] toolTips = new String[]{null, null};
        public Class[] classes = new Class[]{String.class, Double.class};

        @Override
        public Class getColumnClass(int col) {
            return this.classes[col];
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.names[col];
        }

        @Override
        public String getColumnToolTip(int col) {
            return this.toolTips[col];
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return new Double(p.baseAge);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(Datapoint p, int col) {
            return this.isCellEditable(col);
        }

        @Override
        public boolean isCellEditable(int col) {
            return col < this.getColumnCount();
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    break;
                }
                case 1: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    p.baseAge = !Double.isNaN(age) ? age : 0.0;
                    DataColumn.this.updateMinMaxAges();
                }
            }
        }

        @Override
        public Datapoint createEmptyDatapoint() {
            return new Datapoint();
        }

        public class LineType
        extends ComboBoxRenderer {
            private static final long serialVersionUID = 1L;

            public LineType() {
                super(new String[]{ResPath.getPath("icons.solid"), ResPath.getPath("icons.dashed"), ResPath.getPath("icons.dotted")}, new String[]{"solid", "dashed", "dotted"});
                this.turnItemsToImages();
            }
        }
    }

    public static class FileInfo {
        public String loadPath;
        public String workingDir = null;
        public URL baseURL = null;
        public boolean encrypted = false;
        public boolean resource = false;

        public void ensureTrailingSlashes() {
            String slash = System.getProperty("file.separator");
            if (this.workingDir != null && !this.workingDir.endsWith(slash)) {
                this.workingDir = this.workingDir + slash;
            }
            if (this.baseURL != null) {
                String urlS = this.baseURL.toString();
                if (!urlS.endsWith(slash)) {
                    urlS = urlS + slash;
                }
                try {
                    this.baseURL = new URL(urlS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

