/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datastore;
import datastore.Unit;
import gui.ImageGenerator;
import gui.Language;
import gui.Settings;
import gui.StringWrappingInfo;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.NumberUtils;

public class RulerColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public double minorInterval;
    public double majorInterval;
    public double labelInterval;
    public static double UNITS_PER_TICK = 6.0;
    public static double[] SUBDIVISIONS = new double[]{2.0, 5.0, 10.0};
    public static double[] SUBDIVISION_FACTOR = new double[]{0.5, 0.4, 0.5};
    public boolean mirrored = false;
    public boolean transposed = false;
    public static double MINOR_TICK_LENGTH = 5.0;
    public static String MINOR_TICK_STYLE = "stroke-width: 1; stroke: black;";
    public static double INTERM_TICK_LENGTH = 8.0;
    public static String INTERM_TICK_STYLE = "stroke-width: 2; stroke: black;";
    public static double MAJOR_TICK_LENGTH = 14.0;
    public static String MAJOR_TICK_STYLE = "stroke-width: 3; stroke: black;";
    public static double LABEL_LEFT_SPACE = 2.0;
    public static double LABEL_RIGHT_SPACE = 2.0;
    public static double LABEL_TOP_SPACE = 2.0;
    public static double LABEL_BOTTOM_SPACE = 2.0;
    double maxLabelWidth;

    public RulerColumn(String colName) {
        super(colName);
        this.color = new Coloring(Color.white);
    }

    public RulerColumn(String colName, boolean mirrored) {
        this(colName);
        this.mirrored = mirrored;
    }

    public RulerColumn(Unit units, boolean mirrored) {
        this("", mirrored);
        this.unit = units;
        String unitName = units.getName().toLowerCase();
        String ageTitle = units.getFirstWord();
        if (unitName.compareToIgnoreCase("ma") == 0) {
            ageTitle = "Age";
        } else if (unitName.startsWith("m ") || unitName.equals("m") || unitName.startsWith("ft ") || unitName.equals("ft")) {
            ageTitle = "Depth";
        }
        this.setName(ageTitle);
    }

    @Override
    public void setDS(Datastore ds) {
        super.setDS(ds);
    }

    @Override
    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        this.grayedOut = false;
        return this.grayedOut;
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final RulerColumn thisRC = this;
            JRadioButton leftR = new JRadioButton(Language.translate("Left Justified", true));
            JRadioButton rightR = new JRadioButton(Language.translate("Right Justified", true));
            ButtonGroup group = new ButtonGroup();
            group.add(leftR);
            group.add(rightR);
            if (thisRC.mirrored) {
                leftR.setSelected(true);
            } else {
                rightR.setSelected(true);
            }
            leftR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.mirrored = true;
                    }
                }
            });
            rightR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.mirrored = false;
                    }
                }
            });
            this.optionsPanel.add(leftR);
            this.optionsPanel.add(rightR);
        }
        return this.optionsPanel;
    }

    @Override
    public double getWidth(Settings settings, ImageGenerator ig, double dataHeight) {
        int numChars;
        double biggestNum = Math.max(Math.abs(settings.baseAge) * 10.0, Math.abs(settings.topAge) * 10.0);
        double scaleStep = this.minorInterval < 0.0 ? this.majorInterval : this.minorInterval;
        double temptickMY = 0.0;
        int count = 0;
        int minorStep = 0;
        for (temptickMY = 0.0 > settings.topAge ? 0.0 - Math.floor((0.0 - settings.topAge) / scaleStep) * scaleStep : 0.0 + Math.ceil((settings.topAge - 0.0) / scaleStep) * scaleStep; temptickMY < settings.baseAge && count < 2; temptickMY += scaleStep) {
            if (NumberUtils.isMultiple(temptickMY, this.majorInterval)) {
                ++count;
                continue;
            }
            ++minorStep;
        }
        int numFractions = (int)Math.ceil(Math.log(minorStep) / Math.log(10.0));
        if (numFractions <= 0) {
            numFractions = 1;
        }
        if ((numChars = (int)Math.ceil(Math.log(biggestNum) / Math.log(10.0))) <= 0) {
            numChars = 1;
        }
        numChars += numFractions;
        String testLabel = "";
        for (int i = 0; i < numChars; ++i) {
            testLabel = testLabel + "0";
        }
        StringWrappingInfo testLabelSWI = ig.getSWIOneLine(testLabel, this.fonts.getFont(7), 1, this.fileInfo);
        this.maxLabelWidth = testLabelSWI.getWidth();
        this.myWidth = LABEL_LEFT_SPACE + this.maxLabelWidth + LABEL_RIGHT_SPACE + Math.max(MINOR_TICK_LENGTH, MAJOR_TICK_LENGTH);
        if (this.drawTitle) {
            testLabelSWI = ig.getSWIOneLine(this.name + " ", this.fonts.getFont(0), 1, this.fileInfo);
            this.myWidth = Math.max(testLabelSWI.getWidth(), this.myWidth);
        }
        return this.myWidth;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        int mulIndex;
        super.drawData(ig, startx, starty, width, height, settings);
        this.minorInterval = 0.2;
        this.majorInterval = 1.0;
        this.labelInterval = 10.0;
        if (this.transposed) {
            double temp = startx;
            startx = starty;
            starty = temp;
            temp = width;
            width = height;
            height = temp;
        }
        double MYperTick = UNITS_PER_TICK / settings.unitsPerMY;
        System.out.println("********************************************************* " + MYperTick);
        if (MYperTick < 0.4) {
            this.minorInterval = 1.0;
            mulIndex = 0;
            while (this.minorInterval > MYperTick && !(this.minorInterval * SUBDIVISION_FACTOR[mulIndex] < MYperTick)) {
                this.minorInterval *= SUBDIVISION_FACTOR[mulIndex];
                mulIndex = (mulIndex + 1) % SUBDIVISION_FACTOR.length;
            }
            if (this.minorInterval == 1.0) {
                this.minorInterval = -1.0;
            }
            this.labelInterval = this.majorInterval * 5.0;
        } else {
            this.minorInterval = -1.0;
            mulIndex = 0;
            while (this.majorInterval < MYperTick) {
                this.majorInterval /= SUBDIVISION_FACTOR[mulIndex];
                mulIndex = (mulIndex + 1) % SUBDIVISION_FACTOR.length;
            }
            this.minorInterval = this.majorInterval;
            this.majorInterval *= 5.0;
            this.labelInterval = this.majorInterval;
        }
        if ((settings.baseAge - settings.topAge) / this.labelInterval <= 2.0 || this.majorInterval / this.minorInterval >= 10.0) {
            this.labelInterval = this.majorInterval;
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(0);
        double lastLabelBottom = starty;
        double majorTickX = this.mirrored ? startx + MAJOR_TICK_LENGTH : startx + width - MAJOR_TICK_LENGTH;
        double minorTickX = this.mirrored ? startx + MINOR_TICK_LENGTH : startx + width - MINOR_TICK_LENGTH;
        double intermTickX = this.mirrored ? startx + INTERM_TICK_LENGTH : startx + width - INTERM_TICK_LENGTH;
        double sideX = this.mirrored ? startx : startx + width;
        double scaleStart = 0.0;
        double scaleStep = this.minorInterval < 0.0 ? this.majorInterval : this.minorInterval;
        double tickMY = 0.0;
        tickMY = scaleStart > settings.topAge ? scaleStart - Math.floor((scaleStart - settings.topAge) / scaleStep) * scaleStep : scaleStart + Math.ceil((settings.topAge - scaleStart) / scaleStep) * scaleStep;
        int count = 0;
        long temptickMY = Math.round(tickMY);
        double minorStep = 0.0;
        while ((double)temptickMY < settings.baseAge && count < 2) {
            if (NumberUtils.isMultiple(temptickMY, this.majorInterval)) {
                ++count;
            } else {
                minorStep += 1.0;
            }
            temptickMY = (long)((double)temptickMY + scaleStep);
        }
        double epsilon = 1.0E-7;
        int intermCount = 0;
        for (double intermTopAge = Math.floor(tickMY); intermTopAge < settings.topAge && !(Math.abs(settings.topAge - intermTopAge) < epsilon); intermTopAge += scaleStep) {
            if (intermCount % 5 == 0) {
                ++intermCount;
                continue;
            }
            if (!(this.minorInterval > 0.0)) continue;
            ++intermCount;
        }
        while (tickMY < settings.baseAge) {
            double tickY;
            double tickX;
            boolean noDrawing = false;
            if (tickMY == settings.topAge || tickMY + scaleStep >= settings.baseAge) {
                noDrawing = true;
            }
            if (NumberUtils.isMultiple(tickMY, this.majorInterval)) {
                intermCount = 1;
                tickX = majorTickX;
                tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                double roundedNumberLeftshift = 5.0;
                lastLabelBottom = tickY;
                if (!this.transposed) {
                    if (!noDrawing) {
                        ig.drawLineYear(sideX, tickMY, majorTickX, tickMY, MAJOR_TICK_STYLE, starty);
                    }
                } else if (!noDrawing) {
                    ig.drawLine(tickY, sideX, tickY, majorTickX, MAJOR_TICK_STYLE);
                }
                if (!noDrawing) {
                    this.drawTickLabel(ig, startx, starty, width, height, settings, tickMY, nf, tickX - roundedNumberLeftshift, tickY, lastLabelBottom, true);
                }
            } else if (intermCount % 10 == 0) {
                ++intermCount;
                tickX = majorTickX;
                tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                if (!this.transposed) {
                    if (!noDrawing) {
                        ig.drawLineYear(sideX, tickMY, intermTickX, tickMY, INTERM_TICK_STYLE, starty);
                    }
                } else if (!noDrawing) {
                    ig.drawLine(tickY, sideX, tickY, intermTickX, INTERM_TICK_STYLE);
                }
                if (!noDrawing) {
                    this.drawTickLabel(ig, startx, starty, width, height, settings, tickMY, nf, tickX, tickY, lastLabelBottom, true);
                }
                lastLabelBottom = tickY;
            } else if (intermCount % 5 == 0) {
                ++intermCount;
                if (!this.transposed) {
                    if ((minorStep + 1.0) % 20.0 != 0.0 || ((minorStep + 1.0) / 100.0 - 1.0) % 2.0 == 0.0) {
                        if (!noDrawing) {
                            ig.drawLineYear(sideX, tickMY, intermTickX, tickMY, INTERM_TICK_STYLE, starty);
                        }
                    } else if (!noDrawing) {
                        ig.drawLineYear(sideX, tickMY, intermTickX, tickMY, INTERM_TICK_STYLE, starty);
                    }
                } else {
                    tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                    if ((minorStep + 1.0) % 20.0 != 0.0 || ((minorStep + 1.0) / 100.0 - 1.0) % 2.0 == 0.0) {
                        if (!noDrawing) {
                            ig.drawLine(tickY, sideX, tickY, intermTickX, INTERM_TICK_STYLE);
                        }
                    } else if (!noDrawing) {
                        ig.drawLine(tickY, sideX, tickY, intermTickX, INTERM_TICK_STYLE);
                    }
                }
                tickX = majorTickX;
                if ((minorStep + 1.0) % 20.0 != 0.0 || ((minorStep + 1.0) / 100.0 - 1.0) % 2.0 == 0.0) {
                    tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                    if (!this.transposed) {
                        if (!noDrawing) {
                            ig.drawLineYear(sideX, tickMY, intermTickX, tickMY, INTERM_TICK_STYLE, starty);
                        }
                    } else if (!noDrawing) {
                        ig.drawLine(tickY, sideX, tickY, intermTickX, INTERM_TICK_STYLE);
                    }
                    lastLabelBottom = tickY;
                }
            } else if (intermCount % 2 == 0 && (minorStep + 1.0) % 20.0 == 0.0 && ((minorStep + 1.0) / 100.0 - 1.0) % 2.0 != 0.0) {
                ++intermCount;
                if (!this.transposed) {
                    if (!noDrawing) {
                        ig.drawLineYear(sideX, tickMY, intermTickX, tickMY, INTERM_TICK_STYLE, starty);
                    }
                } else {
                    tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                    if (!noDrawing) {
                        ig.drawLine(tickY, sideX, tickY, intermTickX, INTERM_TICK_STYLE);
                    }
                }
                tickX = majorTickX;
            } else if (this.minorInterval > 0.0) {
                ++intermCount;
                if (!this.transposed) {
                    if (!noDrawing) {
                        ig.drawLineYear(sideX, tickMY, minorTickX, tickMY, MINOR_TICK_STYLE, starty);
                    }
                } else {
                    tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                    if (!noDrawing) {
                        ig.drawLine(tickY, sideX, tickY, minorTickX, MINOR_TICK_STYLE);
                    }
                }
                double d = minorTickX;
            }
            tickMY += scaleStep;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void drawTickLabel(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, double tickMY, NumberFormat nf, double tickX, double tickY, double lastTickY, boolean majorLabelType) {
        StringWrappingInfo labelSWI = null;
        String label = this.unit != null && !this.unit.isNegated() ? (this.ds != null && this.ds.isInverted && !this.unit.name.equalsIgnoreCase("Ma") ? nf.format(-tickMY) : nf.format(tickMY)) : (this.ds != null && this.ds.isInverted ? nf.format(tickMY) : nf.format(-tickMY));
        labelSWI = majorLabelType && tickY - lastTickY > this.fonts.getFont(7).getSize() && starty + height - tickY > this.fonts.getFont(7).getSize() ? ig.getSWIOneLine(label, this.fonts.getFont(7), 1, this.fileInfo) : (tickMY != 2.0 && tickY - lastTickY > this.fonts.getFont(10).getSize() && starty + height - tickY > this.fonts.getFont(10).getSize() ? ig.getSWIOneLine(label, this.fonts.getFont(10), 1, this.fileInfo) : ig.getSWIOneLine(label, this.fonts.getFont(7), 1, this.fileInfo));
        if (labelSWI != null) {
            double labelLeft;
            double labelAgeSideSize = labelSWI.getHeight() + LABEL_BOTTOM_SPACE + LABEL_TOP_SPACE;
            double labelPerpSize = labelSWI.getWidth();
            if (this.transposed) {
                labelAgeSideSize = labelSWI.getWidth() + LABEL_BOTTOM_SPACE + LABEL_TOP_SPACE;
                labelPerpSize = labelSWI.getHeight();
            }
            double labelTop = tickY - labelAgeSideSize / 2.0;
            double d = labelLeft = this.mirrored ? tickX + 3.0 * LABEL_LEFT_SPACE : tickX - LABEL_RIGHT_SPACE - labelPerpSize;
            if (!this.transposed) {
                ig.drawString(labelSWI, labelLeft, labelTop, labelPerpSize, labelAgeSideSize, 2);
            } else {
                ig.drawString(labelSWI, labelTop, labelLeft, labelAgeSideSize, labelPerpSize, 2);
            }
        }
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null && name.compareToIgnoreCase("justification") == 0) {
            String t = setting.getAttribute("justification");
            this.mirrored = t.compareToIgnoreCase("left") == 0;
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Element typeE = Settings.createSimpleSetting(doc, "justification", null);
        if (this.mirrored) {
            typeE.setAttribute("justification", "left");
        } else {
            typeE.setAttribute("justification", "right");
        }
        element.appendChild(typeE);
    }

    @Override
    public void write(Writer w) throws IOException {
    }
}

