/*
 * Decompiled with CFR 0.152.
 */
package datastore;

public class Unit {
    protected String name;
    protected boolean neg = false;
    protected String intervalColName = "Age/Stage\tStage";

    public Unit(String u) {
        this.name = u.trim();
        if (this.name.length() > 0 && this.name.charAt(0) == '-') {
            this.name = this.name.substring(1);
            this.neg = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFirstWord() {
        int space = this.name.indexOf(32);
        if (space < 0) {
            return this.name;
        }
        return this.name.substring(0, space);
    }

    public boolean isNegated() {
        return this.neg;
    }

    public String[] getIntervalColNames() {
        if (this.intervalColName == null) {
            return null;
        }
        return this.intervalColName.split("\t");
    }

    public void setIntervalColName(String s) {
        this.intervalColName = s;
    }

    public boolean equals(Unit other) {
        return this.name.compareToIgnoreCase(other.name) == 0 && this.neg == other.neg;
    }

    public boolean equals(String u) {
        Unit temp = new Unit(u);
        return this.equals(temp);
    }

    public String toString() {
        if (this.neg) {
            return "-" + this.name;
        }
        return this.name;
    }
}

