/*
 * Decompiled with CFR 0.152.
 */
package datastore.rasc;

import datastore.rasc.SecData;
import gui.editor.SpreadSheetTableModel;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DatData
extends SpreadSheetTableModel {
    public static FromAboveTableCellRenderer fromAboveRend = new FromAboveTableCellRenderer();
    public AbundanceTableCellRenderer abundanceRend = new AbundanceTableCellRenderer();
    public SecData.SectionRow secData;
    public boolean noEmptyRows = false;
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;

    public DatData(SecData.SectionRow sd) {
        this.columnNames.add("Fossil #");
        this.columnNames.add("Depth");
        this.columnNames.add("Abundance");
        this.columnNames.add("Type");
        this.secData = sd;
    }

    public void fireAbundanceTypeChanged() {
        this.fireTableDataChanged();
    }

    public int getAbundanceType() {
        if (this.secData != null) {
            return this.secData.getATint();
        }
        return 1;
    }

    @Override
    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Float.class;
            }
            case 2: {
                return Abundance.class;
            }
            case 3: {
                return Type.class;
            }
        }
        return Object.class;
    }

    public void addWellData(boolean buddy, int id, float depth) {
        DataRow row = new DataRow();
        row.setID(id);
        if (buddy) {
            row.setBuddy();
        } else {
            row.forceDepth(depth);
        }
        this.data.add(row);
        this.fireTableRowsInserted(this.data.size() - 2, this.data.size() - 1);
    }

    public void addRow(DataRow row) {
        this.data.add(row);
    }

    public void multiplyDepths(float factor) {
        for (int i = 0; i < this.data.size(); ++i) {
            DataRow row = (DataRow)this.data.get(i);
            if (row.getBuddy()) continue;
            row.setDepth(row.getDepth() * factor);
        }
        this.fireTableDataChanged();
    }

    public void modifyWellData(int which, float depth, boolean noZeros) {
        DataRow row;
        int i;
        boolean failed = true;
        int sampleCount = -1;
        for (i = 0; sampleCount < which && i < this.data.size(); ++i) {
            row = (DataRow)this.data.get(i);
            if (row.isIncomplete() || row.getBuddy() || ++sampleCount != which) continue;
            failed = false;
            break;
        }
        if (failed) {
            if (!noZeros || depth != 0.0f) {
                row = new DataRow();
                row.setID(0);
                row.setDepth(depth);
                this.data.insertElementAt(row, i);
                this.fireTableRowsInserted(i, i + 1);
            }
        } else {
            row = (DataRow)this.data.get(i);
            row.setDepth(depth);
        }
    }

    @Override
    public void addRows(int numRows) {
        int start = this.data.size();
        if (start < 0) {
            start = 0;
        }
        this.addRows(numRows, start);
    }

    @Override
    public String addRows(int numRows, int startRow) {
        for (int i = 0; i < numRows; ++i) {
            this.data.insertElementAt(new DataRow(), startRow);
        }
        this.fireTableRowsInserted(startRow, startRow + numRows);
        return null;
    }

    @Override
    public String removeRows(int[] rows) {
        super.removeRows(rows);
        this.makeEmptyRows();
        return null;
    }

    @Override
    public TableCellRenderer getTableCellRenderer(int row, int column) {
        DataRow r = (DataRow)this.getRow(row);
        if (column == 1 && r.getBuddy()) {
            return fromAboveRend;
        }
        if (column == 2 && this.getAbundanceType() == 2) {
            return super.getTableCellRenderer(row, column);
        }
        return super.getTableCellRenderer(row, column);
    }

    public void makeEmptyRows() {
    }

    public void sortDepths(int dir) {
        float lastDepth = 0.0f;
        for (int i = 0; i < this.data.size(); ++i) {
            DataRow row = (DataRow)this.getRow(i);
            if (!row.getBuddy()) {
                lastDepth = row.getDepth();
            }
            row.tempDepth = lastDepth;
        }
        Collections.sort(this.data, new DepthComparator(dir == 1 ? 1 : -1));
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1 && value != null) {
            try {
                float d = Float.parseFloat(value.toString());
                if (d == 0.0f) {
                    value = null;
                }
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (col == 2 && value instanceof String) {
            value = Abundance.fromString(value.toString());
        }
        super.setValueAt(value, row, col);
        this.makeEmptyRows();
    }

    public static class DepthComparator
    implements Comparator {
        int mul = 1;

        public DepthComparator(int mul) {
            this.mul = mul;
        }

        public int compare(Object arg0, Object arg1) {
            DataRow left = (DataRow)arg0;
            DataRow right = (DataRow)arg1;
            if (left.isIncomplete() && right.isIncomplete()) {
                return 0;
            }
            if (left.isIncomplete()) {
                return 1;
            }
            if (right.isIncomplete()) {
                return -1;
            }
            float ret = (left.tempDepth - right.tempDepth) * (float)this.mul;
            if (ret > 0.0f) {
                return 1;
            }
            if (ret < 0.0f) {
                return -1;
            }
            return 0;
        }
    }

    public static class AbundanceTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public int type = 1;

        public void setType(int t) {
            this.type = t;
        }

        @Override
        public void setValue(Object value) {
            Abundance ab = (Abundance)value;
            if (ab == null || ab.getAbundance() == 0.0f) {
                this.setText("");
            } else if (this.type == 1) {
                this.setText(ab.toString());
            } else {
                this.setText("" + ab.getAbundance());
            }
        }
    }

    public static class FromAboveTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public FromAboveTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object value) {
            this.setText("\u2191\u2191\u2191");
        }
    }

    public static class Type {
        public static String getShort(String l) {
            if (l == null || l.length() == 0) {
                return "";
            }
            int i = l.indexOf(32);
            if (i < 0) {
                return l;
            }
            return l.substring(0, i);
        }

        public static JComboBox getComboBox() {
            JComboBox<String> cb = new JComboBox<String>();
            cb.addItem("");
            cb.addItem("CTS cutting's sample");
            cb.addItem("SWC site wall core");
            cb.addItem("C core");
            cb.addItem("O other");
            return cb;
        }
    }

    public static class DataRow
    extends SpreadSheetTableModel.Row {
        public float tempDepth;

        public DataRow() {
            this.cells.setSize(4);
            this.cells.set(0, null);
        }

        public void setID(int id) {
            if (id == -1) {
                this.cells.set(0, null);
            } else {
                this.cells.set(0, new Integer(id));
            }
        }

        public void setBuddy() {
            this.cells.set(1, null);
        }

        public void setDepth(float depth) {
            if (depth == 0.0f) {
                this.cells.set(1, null);
            } else {
                this.cells.set(1, new Float(depth));
            }
        }

        public void forceDepth(float depth) {
            this.cells.set(1, new Float(depth));
        }

        public float getDepth() {
            Object o = this.getCol(1);
            if (o == null) {
                return 0.0f;
            }
            return ((Float)o).floatValue();
        }

        public boolean isIncomplete() {
            return this.getID() < 0;
        }

        public int getID() {
            Object o = this.getCol(0);
            if (o == null) {
                return -1;
            }
            return (Integer)o;
        }

        public boolean getBuddy() {
            Object o = this.getCol(1);
            return o == null || o.toString().trim().length() == 0;
        }

        public void setAbundanceFloat(float f) {
            if (f == 0.0f) {
                this.cells.set(2, null);
            } else {
                this.cells.set(2, new Abundance(f));
            }
        }

        public float getAbundanceFloat() {
            Abundance a = (Abundance)this.getCol(2);
            if (a == null) {
                return 0.0f;
            }
            return a.abund;
        }

        public String getType() {
            Object o = this.cells.get(3);
            if (o == null) {
                return null;
            }
            return o.toString();
        }

        public void setType(String s) {
            this.cells.set(3, s);
        }
    }

    public static class Abundance {
        float abund;
        public static final float NONE = 0.0f;
        public static final float RARE = 5.0f;
        public static final float COMMON = 20.0f;
        public static final float FREQUENT = 50.0f;
        public static final float ABUNDANT = 100.0f;
        public static final float FLOOD = 101.0f;

        public Abundance(float a) {
            this.setAbundance(a);
        }

        public void setAbundance(float a) {
            this.abund = a;
        }

        public float getAbundance() {
            return this.abund;
        }

        public String toString() {
            if (this.abund == 0.0f) {
                return "";
            }
            if (this.abund <= 5.0f) {
                return "rare";
            }
            if (this.abund <= 20.0f) {
                return "common";
            }
            if (this.abund <= 50.0f) {
                return "frequent";
            }
            if (this.abund <= 100.0f) {
                return "abundant";
            }
            if (this.abund > 100.0f) {
                return "flood";
            }
            return "";
        }

        public static Abundance fromString(String s) {
            try {
                float f = Float.parseFloat(s);
                if (f == 0.0f) {
                    return null;
                }
                return new Abundance(f);
            }
            catch (NumberFormatException numberFormatException) {
                if (s.length() == 0) {
                    return new Abundance(0.0f);
                }
                if (s.compareToIgnoreCase("rare") == 0) {
                    return new Abundance(5.0f);
                }
                if (s.compareToIgnoreCase("common") == 0) {
                    return new Abundance(20.0f);
                }
                if (s.compareToIgnoreCase("frequent") == 0) {
                    return new Abundance(50.0f);
                }
                if (s.compareToIgnoreCase("abundant") == 0) {
                    return new Abundance(100.0f);
                }
                if (s.compareToIgnoreCase("flood") == 0) {
                    return new Abundance(101.0f);
                }
                return new Abundance(0.0f);
            }
        }

        public static JComboBox getCombo() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("");
            comboBox.addItem("rare");
            comboBox.addItem("common");
            comboBox.addItem("frequent");
            comboBox.addItem("abundant");
            comboBox.addItem("flood");
            return comboBox;
        }
    }
}

