/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TSCreator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Random;

public class ActivationCheckThread
extends Thread {
    public static final int WAITING = 0;
    public static final int SUCCESS = 1;
    public static final int FAILED = 2;
    public static final int EXPIRED = 3;
    final Object monitor = new Object();
    protected int state = 0;
    protected String error = "";
    public static final String checkURL = "http://www.tscreator.com/activatecheck.php";
    public static final int length = 10;
    String version;

    public ActivationCheckThread(String version) {
        try {
            this.version = URLEncoder.encode(TSCreator.activationVersionString, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCheckState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckState(int state) {
        Object object = this.monitor;
        synchronized (object) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getError() {
        Object object = this.monitor;
        synchronized (object) {
            return this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(String error) {
        Object object = this.monitor;
        synchronized (object) {
            this.error = error;
        }
    }

    @Override
    public void run() {
        char[] ret = new char[10];
        char[] orig = this.getRandom();
        this.setError("");
        try {
            URL u = new URL("http://www.tscreator.com/activatecheck.php?v=" + this.version + "&r=" + new String(orig));
            InputStream in = u.openStream();
            InputStreamReader reader = new InputStreamReader(in);
            reader.read(ret);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.out);
            this.setCheckState(2);
            return;
        }
        catch (UnknownHostException e) {
            this.setCheckState(2);
            this.setError("Unknown host");
            return;
        }
        catch (SocketException e) {
            this.setCheckState(2);
            this.setError("Network error");
            return;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            this.setCheckState(2);
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.setCheckState(2);
            return;
        }
        if (this.verifyRandom(orig, ret)) {
            this.setCheckState(1);
        } else if (this.isExpired(ret)) {
            this.setCheckState(3);
        } else {
            this.setCheckState(2);
        }
    }

    public char[] getRandom() {
        Random r = new Random();
        char[] orig = new char[10];
        for (int i = 0; i < 10; ++i) {
            orig[i] = r.nextBoolean() ? 97 : 98;
        }
        return orig;
    }

    public boolean verifyRandom(char[] orig, char[] ret) {
        if (orig.length != 10 || ret.length != 10) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            char oc = orig[i];
            char rc = ret[(i + 5) % 10];
            if (oc == 'a' && rc == 'b' || oc == 'b' && rc == 'a') continue;
            return false;
        }
        return true;
    }

    public boolean isExpired(char[] ret) {
        if (ret.length == 0) {
            return false;
        }
        return ret[0] == 'x';
    }
}

