/*
 * Decompiled with CFR 0.152.
 */
package map;

import gui.ErrorHandler;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import map.MapCoordinates;

public class MapPolarCoordinates
extends MapCoordinates {
    public static final int RADIUS = 6371;
    public Point2D.Double center;
    public double height;
    public double scale;

    public void handleLocalException(String exceptionMessage, String exceptionMessageTitle) {
        Object[] options = new Object[]{"OK"};
        JFrame frame = new JFrame();
        int n = JOptionPane.showOptionDialog(frame, exceptionMessage, exceptionMessageTitle, -1, 3, null, options, options[0]);
    }

    @Override
    public void parseCoordinates(HashMap<String, Integer> header, String[] values) {
        try {
            double lon = 0.0;
            lon = header.get("CENTER LONG") != null ? Math.toRadians(Double.parseDouble(values[header.get("CENTER LONG")])) : Math.toRadians(Double.parseDouble(values[header.get("CENTER LON")]));
            double lat = Math.toRadians(Double.parseDouble(values[header.get("CENTER LAT")]));
            this.center = new Point2D.Double(lon, lat);
            this.height = Double.parseDouble(values[header.get("HEIGHT")]);
            this.scale = Double.parseDouble(values[header.get("SCALE")]);
        }
        catch (NullPointerException e) {
            String exceptionMessage = "Invalid Header in MapPack File\n Expected \"CENTER LON\", \"CENTER LAT\", \"HEIGHT\" OR \"SCALE\"";
            String exceptionMessageTitle = "Invalid Header Error Detected";
            ErrorHandler.showError(e, exceptionMessage, exceptionMessageTitle, 3);
        }
    }

    @Override
    public void parseCoordinates(HashMap<String, Integer> header, String[] values, int lineNumber, String fileName) {
        try {
            double lon = 0.0;
            lon = header.get("CENTER LONG") != null ? Math.toRadians(Double.parseDouble(values[header.get("CENTER LONG")])) : Math.toRadians(Double.parseDouble(values[header.get("CENTER LON")]));
            double lat = Math.toRadians(Double.parseDouble(values[header.get("CENTER LAT")]));
            this.center = new Point2D.Double(lon, lat);
            this.height = Double.parseDouble(values[header.get("HEIGHT")]);
            this.scale = Double.parseDouble(values[header.get("SCALE")]);
        }
        catch (NullPointerException e) {
            String exceptionMessage = "Expected \"CENTER LON\", \"CENTER LAT\", \"HEIGHT\" OR \"SCALE\" on line " + String.valueOf(lineNumber) + "In file: " + fileName;
            String exceptionMessageTitle = "Invalid Header Error Detected";
            this.handleLocalException(exceptionMessage, exceptionMessageTitle);
            System.err.println(e.getLocalizedMessage());
        }
    }

    @Override
    public Point convertCoordinates(Object[] params) {
        double latPoint = 0.0;
        double lonPoint = 0.0;
        int frameWidth = 0;
        int frameHeight = 0;
        int newLat = 0;
        int newLon = 0;
        lonPoint = Math.toRadians((Double)params[0]);
        latPoint = Math.toRadians((Double)params[1]);
        frameWidth = (Integer)params[2];
        frameHeight = (Integer)params[3];
        double lonCenter = this.center.x;
        double latCenter = this.center.y;
        double noOfKmPerPix = this.scale / (0.4 * (double)frameWidth);
        double noOfPixPerKm = 0.4 * (double)frameWidth / this.scale;
        double lonOffset = lonPoint - lonCenter;
        double P = this.height / 6371.0 + 1.0;
        double cosC = Math.cos(Math.sin(latCenter) * Math.sin(latPoint) + Math.sin(latCenter) * Math.cos(latPoint) * Math.cos(lonOffset));
        double K = P != cosC ? (P - 1.0) / (P - cosC) : 1.0;
        double X = K * (Math.cos(latPoint) * Math.sin(lonOffset)) * 6371.0;
        double Y = K * (Math.cos(latCenter) * Math.sin(latPoint) - Math.sin(latCenter) * Math.cos(latPoint) * Math.cos(lonOffset)) * 6371.0;
        newLon = (int)((double)(frameWidth / 2) + (X *= noOfPixPerKm));
        newLat = (int)((double)(frameHeight / 2) - (Y *= noOfPixPerKm));
        return new Point(newLon, newLat);
    }

    public static String getMapByName() {
        return "VERTICAL PERSPECTIVE";
    }
}

