/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.awt.Point;
import java.awt.Polygon;
import map.MapLocation;

public class MapTransect
extends MapLocation {
    MapLocation startLocation;
    MapLocation endLocation;
    Polygon transect;

    public MapTransect(MapLocation l1, MapLocation l2, String name, String note) {
        super(0.0, 0.0, name);
        this.startLocation = l1;
        this.endLocation = l2;
    }

    public MapTransect(MapLocation l1, MapLocation l2, String name) {
        this(l1, l2, name, "");
    }

    public Polygon getTransect() {
        return this.transect;
    }

    @Override
    public void setCenter(Point p) {
        super.setCenter(p);
        this.transect = this.createPolygon(this.startLocation.getCenter(), this.endLocation.getCenter());
    }

    public void scaleTransect(Point center, int width, int height) {
        Point tmp1 = new Point();
        Point tmp2 = new Point();
        tmp1.x = this.startLocation.getCenter().x;
        tmp1.y = this.startLocation.getCenter().y;
        tmp2.x = this.endLocation.getCenter().x;
        tmp2.y = this.endLocation.getCenter().y;
        tmp1.x -= center.x - width / 2;
        tmp1.y -= center.y - height / 2;
        tmp2.x -= center.x - width / 2;
        tmp2.y -= center.y - height / 2;
        this.transect = this.createPolygon(tmp1, tmp2);
    }

    public MapLocation getEndLocation() {
        return this.endLocation;
    }

    public MapLocation getStartLocation() {
        return this.startLocation;
    }

    private Polygon createPolygon(Point start, Point end) {
        return this.createPolygon(start.x, start.y, end.x, end.y);
    }

    private Polygon createPolygon(int x_start, int y_start, int x_finish, int y_finish) {
        Polygon result = new Polygon();
        double radians = MapTransect.getRadians(new Point(x_start, y_start), new Point(x_finish, y_finish));
        int x_shift = MapTransect.getXshift(radians);
        int y_shift = this.getYshift(radians);
        if (x_shift == -1 && y_shift == 1) {
            x_shift *= -1;
            y_shift *= 1;
        } else if (x_shift == -1 && y_shift == -1) {
            x_shift *= -1;
            y_shift *= 1;
        } else if (x_shift == 1 && y_shift == -1) {
            x_shift *= -1;
            y_shift *= 1;
        } else if (x_shift == 1 && y_shift == 1) {
            x_shift *= 1;
            y_shift *= -1;
        }
        result.addPoint(x_start, y_start);
        result.addPoint(x_start - (x_shift *= 2), y_start - (y_shift *= 2));
        result.addPoint(x_finish - x_shift, y_finish - y_shift);
        result.addPoint(x_finish, y_finish);
        result.addPoint(x_finish + x_shift, y_finish + y_shift);
        result.addPoint(x_start + x_shift, y_start + y_shift);
        result.addPoint(x_start, y_start);
        return result;
    }

    private static double getRadians(Point a, Point b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        double radians = 0.0;
        radians = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return radians;
    }

    private static int getXshift(double radians) {
        double x_shift_d = Math.sin(radians);
        int x_shift = (int)x_shift_d;
        x_shift = x_shift_d < 0.0 ? (int)Math.floor(x_shift_d) : (int)Math.ceil(x_shift_d);
        return x_shift;
    }

    private int getYshift(double radians) {
        double y_shift_d = Math.cos(radians);
        int y_shift = (int)y_shift_d;
        y_shift = y_shift_d < 0.0 ? (int)Math.floor(y_shift_d) : (int)Math.ceil(y_shift_d);
        return y_shift;
    }
}

