/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.SequenceColumn;
import model.storage.SequenceDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class SequenceData
extends Data {
    private ModelIdentifier identifier = null;
    private String label = "";
    private boolean sequenceBoundry = false;
    private String severity = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public SequenceData(SequenceColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 21));
    }

    public SequenceData(SequenceColumn col, ModelIdentifier id, SourceResult result) {
        super((Column)col, result);
        this.setIdentifier(id);
        this.setLabel(result.getString("label"));
        this.setSequenceBoundry(result.getBool("sequence_boundry"));
        this.setSeverity(result.getString("severity"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            SequenceDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            SequenceDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public boolean isSequenceBoundry() {
        return this.sequenceBoundry;
    }

    public final void setSequenceBoundry(boolean sequenceBoundry) {
        this.sequenceBoundry = sequenceBoundry;
    }

    public String getSeverity() {
        return this.severity;
    }

    public final void setSeverity(String severity) {
        this.severity = severity;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public String toString() {
        return "SEQUENCE_DATA: [ Identifier( " + this.identifier.toString() + ") label = " + this.getLabel() + " sequenceBoundry = " + this.isSequenceBoundry() + " severity = " + this.getSeverity() + " deleted = " + this.isDeleted() + " creationDate = " + this.getCreationDate() + " lastModified = " + this.getLastModified() + "]";
    }

    public static class Factory {
        public static SequenceData getByIdentifier(SequenceColumn c, ModelIdentifier id) {
            List<Object> sequenceData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            sequenceData = Factory.getByIdentifiers(c, ids);
            if (sequenceData.isEmpty()) {
                return null;
            }
            return (SequenceData)sequenceData.get(0);
        }

        public static List<SequenceData> getByIdentifiers(SequenceColumn c, List<ModelIdentifier> ids) {
            ArrayList<SequenceData> sequenceData = new ArrayList<SequenceData>();
            List<SourceResult> results = SequenceDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                sequenceData.add(new SequenceData(c, ids.get(i), results.get(i)));
            }
            return sequenceData;
        }

        public static List<SequenceData> getByAge(SequenceColumn c, double top, double bottom) {
            List<SourceResult> results = SequenceDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 21);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

