/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ChronColumn;
import model.ChronData;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class ChronDataStorage
extends DataStorage {
    public static void insert(ChronData data) {
        Query query = new Query("INSERT INTO #.chron_data       (id, data_id, chron_columns_id, label, polarity, deleted)       VALUES (NULL, :data_id, :chron_columns_id, :label,         :polarity, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("chron_columns_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("polarity", data.getPolarity());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(ChronData data) {
        Query query = new Query("UPDATE #.chron_data       SET data_id = :data_id,         chron_columns_id = :chron_column_id, label = :label,         polarity = :polarity       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("chron_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("polarity", data.getPolarity());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT id, label, polarity,                deleted, last_modified, creation_date       FROM #.chron_data       WHERE id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(ChronColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, chrondata.id             FROM #.data as data              JOIN #.chron_data as chrondata ON (data.id = chrondata.data_id)             WHERE chrondata.chron_columns_id = :chron_column_id               AND data.begin_age >= :begin_age               AND data.end_age <= :end_age               AND NOT data.deleted              AND NOT chrondata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("chron_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        return query.executeQuery();
    }
}

