/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.EventColumn;
import model.EventData;
import model.LineStyles;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class EventDataStorage {
    public static void insert(EventData data) {
        Query query = new Query("INSERT INTO #.event_data(id, data_id, event_columns_id, label, linestyle, type, deleted)VALUES (NULL, :data_id, :event_column_id, :label, :linestyle, :type, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("event_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("linestyle", LineStyles.getName(data.getLineStyle()));
        query.setString("type", data.getType());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(EventData data) {
        Query query = new Query("UPDATE #.event_data       SET event_columns_id = :event_column_id, label = :label,         linestyle = :linestyle, type = :type       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("event_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("linestyle", LineStyles.getName(data.getLineStyle()));
        query.setString("type", data.getType());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT id, label, linestyle, type,               deleted, last_modified, creation_date       FROM #.event_data       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(EventColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.event_data as eventdata ON ( data.id = eventdata.data_id )       WHERE eventdata.event_columns_id = :event_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted        AND NOT eventdata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("event_column_id", col.getColumnIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        return query.executeQuery();
    }
}

