/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Point;

public class Vector2D {
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D s) {
        this.x = s.x;
        this.y = s.y;
    }

    public Vector2D(Vector2D a, Vector2D b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public void setLength(double l) {
        double cl = this.length();
        double mul = l / cl;
        this.x *= mul;
        this.y *= mul;
    }

    public Vector2D setLengthR(double l) {
        Vector2D ret = new Vector2D(this);
        ret.setLength(l);
        return ret;
    }

    public void mul(double factor) {
        this.x *= factor;
        this.y *= factor;
    }

    public Vector2D mulR(double factor) {
        return new Vector2D(this.x * factor, this.y * factor);
    }

    public Vector2D addR(Vector2D o) {
        return new Vector2D(this.x + o.x, this.y + o.y);
    }

    public Vector2D subR(Vector2D o) {
        return new Vector2D(this.x - o.x, this.y - o.y);
    }

    public void add(double xa, double ya) {
        this.x += xa;
        this.y += ya;
    }

    public void add(Vector2D o) {
        this.x += o.x;
        this.y += o.y;
    }

    public double dotProduct(Vector2D o) {
        return this.x * o.x + this.y * o.y;
    }

    public void perpSlope() {
        double temp = this.x;
        this.x = this.y;
        this.y = temp;
        this.x *= 1.0;
        this.y *= -1.0;
    }

    public Vector2D perpSlopeR() {
        Vector2D ret = new Vector2D(this);
        ret.perpSlope();
        return ret;
    }

    public double compThisInA(Vector2D a) {
        return a.dotProduct(this) / a.length();
    }

    public Vector2D projThisOntoA(Vector2D a) {
        Vector2D ret = new Vector2D(a);
        ret.setLength(this.compThisInA(a));
        return ret;
    }

    public boolean equals(Vector2D other) {
        double norm = (other.x - this.x) * (other.x - this.x) + (other.y - this.y) * (other.y - this.y);
        return norm < 1.0E-6;
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y;
    }

    public Vector2D perpVectorFromLineToPoint(Point starting_point_for_vector, Point external_point) {
        double slope = this.y / this.x;
        double yint = starting_point_for_vector.y - slope * starting_point_for_vector.x;
        double A = -slope;
        double B = 1.0;
        double C = -yint;
        double distance = (A * external_point.x + B * external_point.y + C) / Math.sqrt(A * A + B * B);
        Vector2D ret = this.perpSlopeR();
        ret.setLength(distance);
        return ret;
    }
}

