/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import com.google.gson.stream.JsonWriter;
import datastore.AgeAgeColumn;
import datastore.BlockSeriesMetaColumn;
import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.EvTree;
import datastore.EventColumn;
import datastore.FaciesColumn;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PatternManager;
import datastore.PatternWidthManager;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RootColumn;
import datastore.RulerColumn;
import datastore.SequenceColumn;
import datastore.TransectColumn;
import datastore.Unit;
import datastore.ZoneColumn;
import datastore.loader.JsonLoader;
import datastore.loader.Loader1;
import datastore.loader.ParseException;
import datastore.rasc.DatData;
import datastore.rasc.DictionaryData;
import datastore.rasc.Document;
import datastore.rasc.LoaderRASC;
import datastore.rasc.SecData;
import gui.AutoGenOptions;
import gui.Settings;
import gui.TSCreator;
import gui.UnicodeInputStream;
import gui.settings.SelectedTimes;
import gui.tree.DataColumnTreeNode;
import gui.tree.NodeChangeEvent;
import gui.tree.TreeNodeChangeEventListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import map.MapInformation;
import util.FileUtils;

public class Datastore
implements TreeNodeChangeEventListener {
    public Date oldestDataDate;
    public String errors;
    public RootColumn rootColumn;
    public RootColumn currentSubRoot;
    protected DefaultTreeModel viewTreeModel;
    protected DefaultTreeModel editorTreeModel;
    protected DefaultTreeModel crossplotTreeModel;
    protected DefaultTreeModel autoplotTreeModel;
    public PatternManager patMan;
    public PatternWidthManager patWidthMan;
    public Unit displayUnit = null;
    public Coloring defaultColorScheme = Coloring.USGS;
    private HashMap<String, MapInformation> maps = null;
    public ArrayList errorList = new ArrayList();
    public boolean isInverted = false;
    public boolean setTopToUnitAge = false;
    public boolean setBaseToUnitAge = false;

    public Datastore() {
        this.maps = new HashMap();
        this.rootColumn = new RootColumn("Chart Root", null);
        this.rootColumn.drawTitle = false;
        this.rootColumn.setDS(this);
        DataColumnTreeNode node = new DataColumnTreeNode(this.rootColumn);
        DataColumnTreeNode nodeCP = new DataColumnTreeNode(this.rootColumn);
        DataColumnTreeNode nodeAPCP = new DataColumnTreeNode(this.rootColumn);
        DataColumnTreeNode nodeEd = new DataColumnTreeNode(this.rootColumn);
        node.createChildNodes();
        node.addChangeListener(this);
        nodeCP.createChildNodes();
        nodeCP.addChangeListener(this);
        nodeAPCP.createChildNodes();
        nodeAPCP.addChangeListener(this);
        nodeEd.createChildNodes();
        nodeEd.addChangeListener(this);
        this.editorTreeModel = new DefaultTreeModel(nodeEd);
        this.crossplotTreeModel = new DefaultTreeModel(nodeCP);
        this.autoplotTreeModel = new DefaultTreeModel(nodeAPCP);
        this.viewTreeModel = new DefaultTreeModel(node);
        this.patMan = new PatternManager();
        this.patMan.loadDefaultPatterns();
        this.patWidthMan = new PatternWidthManager();
        DataColumn.FileInfo patternWidthFI = new DataColumn.FileInfo();
        patternWidthFI.loadPath = PatternWidthManager.PATTERN_WIDTH_FILE;
        patternWidthFI.resource = true;
        try {
            this.load(patternWidthFI);
            while (this.rootColumn.getSubColumnCount() > 0) {
                this.rootColumn.removeColumn(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMap(String mapName, MapInformation map) {
        if (this.maps.containsKey(mapName)) {
            String message = "Map \"" + mapName + "\" already exists in Datastore.  Ignored the second time";
            TSCreator.logAndShow(message, 4);
        } else {
            this.maps.put(mapName, map);
        }
    }

    public MapInformation getMap(String mapName) {
        return this.maps.get(mapName);
    }

    public Iterator getMapIterator() {
        return this.maps.values().iterator();
    }

    public DefaultTreeModel getViewTreeModel() {
        return this.viewTreeModel;
    }

    public DefaultTreeModel getEditorTreeModel() {
        return this.editorTreeModel;
    }

    public DefaultTreeModel getCrossplotTreeModel() {
        return this.crossplotTreeModel;
    }

    public DefaultTreeModel getAutoPlotTreeModel() {
        return this.autoplotTreeModel;
    }

    public int addMetaDecl(String metaName, String newColName) {
        return this.currentSubRoot.associate(metaName, newColName, true);
    }

    public void addColumn(DataColumn col) {
        col.setUnit(this.currentSubRoot.unit);
        System.out.println("----Adding column " + col.getName() + " to unit " + this.currentSubRoot.unit);
        this.currentSubRoot.addColumn(col, true);
    }

    public DataColumn getColumnByName(Unit u, String name) {
        if (u == null || name == null) {
            return null;
        }
        RootColumn rc = this.rootColumn.getChildRoot(u);
        if (rc == null) {
            return null;
        }
        return rc.getColumnByName(name);
    }

    public DataColumn getColumnByName(String name) {
        return this.currentSubRoot.getColumnByName(name);
    }

    public void setDate(Date d) {
        this.oldestDataDate = d;
    }

    public void clear() {
        this.rootColumn = new RootColumn("Chart Root", null);
        this.rootColumn.drawTitle = false;
        this.rootColumn.setDS(this);
        DataColumnTreeNode node = new DataColumnTreeNode(this.rootColumn);
        node.createChildNodes();
        node.addChangeListener(this);
        this.viewTreeModel.setRoot(node);
        this.addBasicColumns();
        this.oldestDataDate = null;
        this.clearErrors();
    }

    public void addBasicColumns() {
    }

    public void clearErrors() {
        this.errors = null;
    }

    public void error(String err) {
        this.errors = this.errors == null ? err : this.errors + "\n" + err;
    }

    public Unit getUnitFromString(String u) {
        Unit units = new Unit(u);
        RootColumn rc = this.rootColumn.getChildRoot(units);
        if (rc != null) {
            return rc.unit;
        }
        return units;
    }

    public Unit getExistingUnitFromString(String u) {
        Unit units = new Unit(u);
        RootColumn rc = this.rootColumn.getChildRoot(units);
        if (rc != null) {
            return rc.unit;
        }
        return null;
    }

    public RootColumn setCurrentUnits(String u) {
        Unit units = new Unit(u);
        return this.setCurrentUnits(units);
    }

    public RootColumn setCurrentUnits(Unit units) {
        RootColumn rc = this.rootColumn.getChildRoot(units);
        if (rc == null) {
            String unitName = units.getName().toLowerCase();
            String colTitle = units.getName();
            String ageTitle = units.getFirstWord();
            if (unitName.compareToIgnoreCase("ma") == 0) {
                colTitle = "Chart Title";
            }
            rc = new RootColumn(colTitle, units);
            rc.isOutcrop = false;
            this.rootColumn.addColumn(rc);
            RulerColumn age = new RulerColumn(ageTitle);
            rc.addColumn(age);
        }
        this.currentSubRoot = rc;
        this.displayUnit = this.currentSubRoot.unit;
        return rc;
    }

    public RootColumn setCurrentUnits(String u, boolean meOut) {
        Unit units = new Unit(u);
        return this.setCurrentUnits(units, meOut);
    }

    public RootColumn setCurrentUnits(Unit units, boolean meOut) {
        System.out.println("Setting units to " + units);
        RootColumn rc = this.rootColumn.getChildRoot(units);
        if (rc == null) {
            System.out.println("EMPTY");
            String unitName = units.getName().toLowerCase();
            String colTitle = units.getName();
            String ageTitle = units.getFirstWord();
            if (unitName.compareToIgnoreCase("ma") == 0) {
                colTitle = "Chart Title";
            }
            rc = new RootColumn(colTitle, units);
            rc.isOutcrop = meOut;
            this.rootColumn.addColumn(rc);
            RulerColumn age = new RulerColumn(ageTitle);
            rc.addColumn(age);
        }
        this.currentSubRoot = rc;
        this.displayUnit = this.currentSubRoot.unit;
        return rc;
    }

    public Unit getCurrentUnits() {
        return this.displayUnit;
    }

    public void setCurrentChartTitle(String title) {
        if (this.currentSubRoot == null) {
            return;
        }
        this.currentSubRoot.setName(title);
    }

    public Unit getSettingsDisplayUnits() {
        return this.displayUnit;
    }

    public void setAutomaticGenSettings(Settings s, AutoGenOptions ago) {
        Iterator<DataColumn> iter = this.rootColumn.getSubColumns();
        while (iter.hasNext()) {
            SelectedTimes st;
            DataColumn dc = iter.next();
            if (!(dc instanceof RootColumn)) {
                System.err.println("A root, " + dc.getName() + ", column that's not a RootColumn!");
            }
            if ((st = ago.getSTForUnit(dc.unit)) == null) {
                st = s.getSelectedTimes(dc.unit);
            }
            this.setAutomaticGenSettings((RootColumn)dc, s, st);
        }
    }

    public void setAutomaticGenSettings(RootColumn root, Settings s, SelectedTimes st) {
        root.updateMinMaxAgesMetaOnly();
        if (st == null) {
            return;
        }
        if (Double.isNaN(st.topAge)) {
            st.topAge = !root.unit.isNegated() ? root.minAge : root.maxAge;
        }
        if (Double.isNaN(st.baseAge)) {
            st.baseAge = !root.unit.isNegated() ? root.maxAge : root.minAge;
        }
        if (st.vertScale < 0.0) {
            double density = root.getDataDensity();
            System.out.println("maximum density of '" + root.unit.toString() + "' is " + density + " datapoints/" + root.unit.getFirstWord());
            density = Math.max(density, 0.01);
            st.vertScale = density / 2.0;
            s.unitsPerMY = st.vertScale * 30.0;
            System.out.println("setting vertical scale to " + st.vertScale + " cm/" + root.unit.getFirstWord());
        } else {
            s.unitsPerMY = st.vertScale * 30.0;
        }
    }

    public void setDefaultColorScheme(Coloring scheme) {
        if (scheme == Coloring.USGS || scheme == Coloring.NAMED_USGS || scheme == Coloring.UNESCO || scheme == Coloring.NAMED_UNESCO) {
            this.defaultColorScheme = scheme;
        }
    }

    @Override
    public void TreeNodeChanged(NodeChangeEvent evt) {
        TreeNode source = evt.getSource();
        switch (evt.getType()) {
            case 1: {
                this.viewTreeModel.nodeChanged(source);
                this.editorTreeModel.nodeChanged(source);
                this.crossplotTreeModel.nodeChanged(source);
                this.autoplotTreeModel.nodeChanged(source);
                break;
            }
            case 2: 
            case 4: {
                this.viewTreeModel.nodeStructureChanged(source);
                this.editorTreeModel.nodeStructureChanged(source);
                this.crossplotTreeModel.nodeStructureChanged(source);
                this.autoplotTreeModel.nodeStructureChanged(source);
                break;
            }
            case 3: {
                this.viewTreeModel.nodesWereInserted(source, new int[]{evt.getWhichNode()});
                this.editorTreeModel.nodesWereInserted(source, new int[]{evt.getWhichNode()});
                this.crossplotTreeModel.nodesWereInserted(source, new int[]{evt.getWhichNode()});
                this.autoplotTreeModel.nodesWereInserted(source, new int[]{evt.getWhichNode()});
            }
        }
    }

    public void loadRASC(DataColumn.FileInfo fileInfo) throws Exception, ParseException {
        Document rascDoc = new Document();
        LoaderRASC.load(rascDoc, fileInfo.loadPath);
        for (int secI = 0; secI < rascDoc.sec.getRowCount(); ++secI) {
            SecData.SectionRow sec = (SecData.SectionRow)rascDoc.sec.getRow(secI);
            Unit unit = new Unit(sec.getUnit() + " " + sec.getName());
            this.setCurrentUnits(unit);
            this.currentSubRoot.setSelected(false);
            EventColumn event = new EventColumn("Fossils - " + sec.getName());
            event.setSelected(true);
            double lastDepth = 0.0;
            for (int datI = 0; datI < sec.datData.getRowCount(); ++datI) {
                double depth;
                DatData.DataRow datRow = (DatData.DataRow)sec.datData.getRow(datI);
                if (datRow.isIncomplete()) continue;
                int id = datRow.getID();
                DictionaryData.DicRow dicRow = rascDoc.dic.getRowByID(id);
                String name = dicRow.getName();
                if (datRow.getBuddy()) {
                    depth = lastDepth;
                } else {
                    lastDepth = depth = (double)datRow.getDepth();
                }
                Datapoint dp = new Datapoint();
                dp.label = name;
                dp.baseAge = depth;
                dp.value = "EVENT";
                event.addData(dp);
            }
            this.addColumn(event);
        }
    }

    public void loadJSON(DataColumn.FileInfo fileInfo) throws Exception {
        InputStream in = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        try {
            new JsonLoader(this, in, fileInfo).loadData();
        }
        catch (IOException e) {
            in.close();
            throw e;
        }
        if (in != null) {
            in.close();
        }
    }

    public final void load(DataColumn.FileInfo fileInfo) throws Exception, ParseException {
        InputStream in = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        try {
            this.load(in, fileInfo);
        }
        catch (ParseException e) {
            in.close();
            throw e;
        }
        if (in != null) {
            in.close();
        }
    }

    public final void loadNexusOrNewick(DataColumn.FileInfo fileInfo, String tsc) {
        ByteArrayInputStream newInStream = new ByteArrayInputStream(tsc.getBytes());
        try {
            this.load(newInStream, fileInfo);
        }
        catch (ParseException e) {
            try {
                ((InputStream)newInStream).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public final void loadNexus(DataColumn.FileInfo fileInfo) throws Exception, ParseException {
        String str;
        InputStream inputStream = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        EvTree T = new EvTree();
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str + "\n");
        }
        inputStream.close();
        String nex = sb.toString();
        String nwkS = T.convertNexusToNewickFormat(nex);
        T.print(nwkS);
        String tsc = T.convertNewickToTSC(nwkS);
        this.loadNexusOrNewick(fileInfo, tsc);
    }

    public final void loadNewick(DataColumn.FileInfo fileInfo) throws Exception, ParseException {
        String str;
        InputStream inputStream = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        EvTree T = new EvTree();
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str + "\n");
        }
        inputStream.close();
        String nwkS = sb.toString();
        if (nwkS.startsWith("#NEXUS")) {
            this.loadNexus(fileInfo);
            return;
        }
        String tsc = T.convertNewickToTSC(nwkS);
        this.loadNexusOrNewick(fileInfo, tsc);
    }

    public void load(InputStream input, DataColumn.FileInfo fileInfo) throws ParseException {
        String enc = null;
        UnicodeInputStream uin = new UnicodeInputStream(input, enc);
        if ((enc = uin.getEncoding()) == null) {
            enc = System.getProperty("os.name").contains("Mac OS X") ? "macroman" : "windows-1252";
        }
        new Loader1(uin, enc).loadData(this, fileInfo);
        this.currentSubRoot.goThroughStuff();
        this.currentSubRoot.clearPlaceholders();
    }

    public void writeHeader(Writer w) throws IOException {
        w.write("format version:\t1.2\r\n");
        Calendar cal = Calendar.getInstance();
        w.write("date:\t" + cal.get(5) + "/" + (cal.get(2) + 1) + "/" + cal.get(1) + "\r\n");
        DataColumn writeCol = this.rootColumn.getFirstChildCol();
        if (writeCol.unit != null) {
            w.write("age units:\t" + writeCol.unit.toString());
        }
        w.write("\r\n\r\n");
    }

    public void write(Writer w) throws IOException {
        this.writeHeader(w);
        DataColumn writeCol = this.rootColumn.getFirstChildCol();
        writeCol.write(w);
    }

    public void writeToJsonData(DataColumn col, JsonWriter writer) throws IOException {
        writer.name("data");
        writer.beginArray();
        Iterator iter = col.getData();
        while (iter.hasNext()) {
            writer.beginObject();
            Datapoint dp = (Datapoint)iter.next();
            writer.name("name").value(dp.label);
            writer.name("base-age").value(dp.baseAge);
            if (dp.value instanceof String) {
                writer.name("value").value((String)dp.value);
            } else {
                writer.name("value").value((Number)((Double)dp.value));
            }
            writer.name("line-type").value((long)dp.lineType);
            writer.name("priority").value((long)dp.priority);
            writer.name("uncertainty").value(dp.uncertainty);
            writer.name("breaker").value(dp.breaker);
            writer.name("popup").value(dp.popup);
            writer.name("member").value(dp.member);
            writer.endObject();
        }
        writer.endArray();
    }

    private void visitAllColumns(TreeNode node, JsonWriter writer) throws IOException {
        writer.beginObject();
        DataColumn dcol = (DataColumn)node;
        writer.name("name").value(dcol.name);
        writer.name("width").value(dcol.myWidth);
        writer.name("popup").value(dcol.popup);
        writer.name("selected").value(dcol.selected);
        if (dcol instanceof RootColumn) {
            writer.name("units").value(dcol.unit.name);
        } else {
            writer.name("units").value("inherited");
        }
        if (dcol.color != null && dcol.color.oneColor != null) {
            writer.name("background-color").value(Coloring.getCSScolor(dcol.color.oneColor));
        } else if (dcol.color == Coloring.NAMED_USGS || dcol.color == Coloring.NAMED_UNESCO) {
            writer.name("background-color").value(dcol.color.toString());
        } else {
            writer.name("background-color").value("none");
        }
        if (dcol instanceof EventColumn) {
            writer.name("column-type").value("event");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof ZoneColumn) {
            writer.name("column-type").value("zone");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof RangeColumn) {
            writer.name("column-type").value("range");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof SequenceColumn) {
            SequenceColumn scol = (SequenceColumn)dcol;
            writer.name("column-type").value("sequence");
            writer.name("type").value((long)scol.type);
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof ChronColumn) {
            writer.name("column-type").value("chron");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof FaciesColumn) {
            writer.name("column-type").value("facies");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof PointColumn) {
            writer.name("column-type").value("point");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof FreehandColumn) {
            writer.name("column-type").value("freehand");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof RulerColumn) {
            writer.name("column-type").value("ruler");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof TransectColumn) {
            writer.name("column-type").value("transect");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof AgeAgeColumn) {
            writer.name("column-type").value("age-age");
            this.writeToJsonData(dcol, writer);
        } else if (dcol instanceof MetaColumn) {
            if (dcol instanceof RootColumn) {
                writer.name("column-type").value("root");
            } else if (dcol instanceof BlockSeriesMetaColumn) {
                BlockSeriesMetaColumn bsmCol = (BlockSeriesMetaColumn)dcol;
                writer.name("column-type").value("block-series-meta");
                writer.name("type").value((long)bsmCol.type);
                writer.name("level").value((long)bsmCol.level);
            } else {
                writer.name("column-type").value("meta");
            }
            writer.name("sub-columns");
            writer.beginArray();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    this.visitAllColumns(n, writer);
                }
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public void writeToJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("version").value("1.3");
        writer.name("color-scheme").value(this.defaultColorScheme.toString());
        writer.name("root-columns");
        writer.beginArray();
        Iterator<DataColumn> rootIter = this.rootColumn.getSubColumns();
        while (rootIter.hasNext()) {
            RootColumn currSubRoot = (RootColumn)rootIter.next();
            this.visitAllColumns(currSubRoot, writer);
        }
        writer.endArray();
        writer.endObject();
    }
}

