/*
 * Decompiled with CFR 0.152.
 */
package datastore.loader;

import datastore.AgeAgeColumn;
import datastore.BlockSeriesMetaColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.SequenceColumn;
import datastore.TransectColumn;
import datastore.ZoneColumn;
import datastore.ages.AgeConverter;
import datastore.ages.InterpolateAgeConverter;
import datastore.loader.Loader1Constants;
import datastore.loader.Loader1TokenManager;
import datastore.loader.ParseException;
import datastore.loader.SimpleCharStream;
import datastore.loader.Token;
import gui.Language;
import gui.RichText;
import gui.SearchDataPack;
import gui.TSCFont;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import util.Point;
import util.Util;

public class Loader1
implements Loader1Constants {
    Datastore ds;
    String outcrop = "off";
    AgeConverter ageConverter = null;
    Map namedAgeConverters = new HashMap();
    String current_units = "Ma";
    boolean synonymDataPackLoading = false;
    public Loader1TokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[229];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[21];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void error(String e) {
        this.ds.error(e);
    }

    public final void loadData(Datastore ds, DataColumn.FileInfo fileInfo) throws ParseException {
        String version = "1.3";
        String date = "";
        String units_token = "";
        String title = null;
        String intervalcol = null;
        String settop = null;
        String setbase = null;
        String setscale = null;
        Coloring chronostrat = null;
        DataColumn prevCol = null;
        String value = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                this.jj_consume_token(8);
                version = this.stringNoQuotes();
                this.newline();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                this.jj_consume_token(8);
                date = this.stringNoQuotes();
                this.newline();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                this.jj_consume_token(8);
                this.outcrop = this.stringNoQuotes();
                this.newline();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block23;
                }
            }
            if (!TSCreator.containsOptionalFlags) break;
            String key = this.stringNoQuotes();
            this.jj_consume_token(8);
            value = this.stringNoQuotes();
            this.newline();
            if (key.compareToIgnoreCase("format version:") == 0) {
                version = value;
                continue;
            }
            if (key.compareToIgnoreCase("date:") == 0) {
                date = value;
                continue;
            }
            if (key.compareToIgnoreCase("age units:") == 0) {
                units_token = value;
                continue;
            }
            if (key.compareToIgnoreCase("default chronostrat:") == 0) {
                chronostrat = this.columnColorString(value);
                continue;
            }
            if (key.compareToIgnoreCase("chart title:") == 0) {
                title = value;
                continue;
            }
            if (key.compareToIgnoreCase("interval column:") == 0) {
                intervalcol = value;
                continue;
            }
            if (key.compareToIgnoreCase("SetTop:") == 0) {
                settop = value;
                continue;
            }
            if (key.compareToIgnoreCase("SetBase:") == 0) {
                setbase = value;
                continue;
            }
            if (key.compareToIgnoreCase("SetScale:") != 0) continue;
            setscale = value;
        }
        if (ds == null) {
            return;
        }
        this.ds = ds;
        if (this.outcrop.equalsIgnoreCase("on")) {
            ds.isInverted = true;
            BlockSeriesMetaColumn.outcropStatus = true;
        } else {
            ds.isInverted = false;
            BlockSeriesMetaColumn.outcropStatus = false;
        }
        if (settop != null || setbase != null || setscale != null) {
            System.out.println("Do you want to use the default Age Settings? Y/N");
            String message = "Use the Data-Pack's suggested age span?";
            String messageTitle = "Suggested Age-Span Flags detected";
            int messageResponse = JOptionPane.showConfirmDialog(null, message, messageTitle, 0);
            if (messageResponse == 0) {
                if (settop != null) {
                    TSCreator.settings.changedDefaultTopAge = true;
                    TSCreator.settings.topAge = Double.parseDouble(settop);
                    ds.setTopToUnitAge = true;
                } else {
                    TSCreator.settings.changedDefaultTopAge = false;
                    TSCreator.topFlag = false;
                }
                if (setbase != null) {
                    TSCreator.settings.changedDefaultBaseAge = true;
                    TSCreator.settings.baseAge = Double.parseDouble(setbase);
                    ds.setBaseToUnitAge = true;
                } else {
                    TSCreator.settings.changedDefaultBaseAge = false;
                    TSCreator.baseFlag = false;
                }
                if (setscale != null) {
                    TSCreator.settings.changedDefaultScale = true;
                    TSCreator.settings.scale = Double.parseDouble(setscale);
                } else {
                    TSCreator.vertFlag = false;
                }
            } else {
                TSCreator.topFlag = false;
                TSCreator.baseFlag = false;
                TSCreator.vertFlag = false;
            }
        } else {
            TSCreator.topFlag = false;
            TSCreator.baseFlag = false;
            TSCreator.vertFlag = false;
        }
        double v = Double.parseDouble(version);
        if (v > 1.5) {
            ds.errorList.add(Language.translate("Format too new (", true) + v + Language.translate("). Only file format versions up to 1.5 are supported with this version of TSCreator. Please use the latest TSCreator to open this file.", true));
        }
        SimpleDateFormat df = new SimpleDateFormat();
        try {
            ds.setDate(df.parse(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (units_token != null && units_token.length() > 0) {
            this.current_units = units_token;
        }
        ds.setCurrentUnits(this.current_units, ds.isInverted);
        if (intervalcol != null) {
            ds.getCurrentUnits().setIntervalColName(intervalcol);
        }
        if (chronostrat != null) {
            ds.setDefaultColorScheme(chronostrat);
        }
        if (title != null) {
            ds.setCurrentChartTitle(title);
        }
        if (TSCreator.containsOptionalFlags) {
            this.newlineNoEOF();
        } else {
            TSCreator.containsOptionalFlags = true;
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block24;
                }
            }
            this.newlineNoEOF();
        }
        block25: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block25;
                }
            }
            if (this.jj_2_1(3)) {
                prevCol = this.metaColumnDecl(ds, prevCol, fileInfo);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        prevCol = this.columnDecl(ds, prevCol, fileInfo);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (prevCol == null && this.synonymDataPackLoading) {
                System.out.println("May be some speacial datapack like synonym datapack has been loaded.");
                this.synonymDataPackLoading = true;
                return;
            }
            while (true) {
                if (!this.jj_2_2(Integer.MAX_VALUE)) continue block25;
                this.newlineNoEOF();
            }
            break;
        }
        this.newline();
        if (ds.errorList.size() > 0) {
            Iterator iter = ds.errorList.iterator();
            String errorMsgList = "";
            while (iter.hasNext()) {
                errorMsgList = errorMsgList + "\n" + (String)iter.next();
            }
            errorMsgList = errorMsgList + "\n";
            JScrollPane scrollPane = new JScrollPane(new JLabel("Parsing Errors"));
            scrollPane.setPreferredSize(new Dimension(500, 300));
            JTextArea textArea = new JTextArea(errorMsgList);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setMargin(new Insets(2, 2, 2, 2));
            scrollPane.getViewport().setView(textArea);
            JScrollPane message = scrollPane;
            JOptionPane.showMessageDialog(null, message, "Error loading data file!", 0);
        }
    }

    public final DataColumn metaColumnDecl(Datastore ds, DataColumn prevCol, DataColumn.FileInfo fileInfo) throws ParseException {
        DataColumn dc;
        String metaName = this.stringNoQuotes();
        this.jj_consume_token(8);
        this.jj_consume_token(6);
        do {
            this.jj_consume_token(8);
            String subName = this.stringNoQuotes();
            if (subName.compareToIgnoreCase("_METACOLUMN_OFF") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.setSelected(false);
                dc.isOutcrop = ds.isInverted;
                continue;
            }
            if (subName.compareToIgnoreCase("_METACOLUMN_ON") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.setSelected(true);
                dc.isOutcrop = ds.isInverted;
                continue;
            }
            if (subName.compareToIgnoreCase("_TITLE_OFF") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.drawTitle = false;
                dc.isOutcrop = ds.isInverted;
                continue;
            }
            if (subName.compareToIgnoreCase("_TITLE_ON") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.drawTitle = true;
                dc.isOutcrop = ds.isInverted;
                continue;
            }
            ds.addMetaDecl(metaName, subName);
            MetaColumn.flamer = ++TSCreator.myOrder;
        } while (this.jj_2_3(2));
        if (this.jj_2_4(3)) {
            this.jj_consume_token(8);
            this.jj_consume_token(8);
            String popup = this.stringNoQuotes();
            dc = ds.getColumnByName(metaName);
            if (dc != null) {
                dc.popup = popup;
            }
        }
        this.newline();
        dc = ds.getColumnByName(metaName);
        if (dc != null) {
            dc.isOutcrop = ds.isInverted;
            dc.setFileInfo(fileInfo);
        }
        return null;
    }

    public final DataColumn columnDecl(Datastore ds, DataColumn prevCol, DataColumn.FileInfo fileInfo) throws ParseException {
        String name = "";
        String type = null;
        String width = null;
        Coloring color = null;
        String showTitle = "";
        boolean bShowTitle = true;
        String showColumn = "";
        int iShowColumn = 3;
        String popup = null;
        String priority = null;
        DataColumn col = null;
        boolean applyConverterNow = true;
        Token lineNumber = null;
        name = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        type = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                width = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        color = this.columnColor();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[9] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                showTitle = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[10] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        showColumn = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[11] = this.jj_gen;
                                                    }
                                                }
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                popup = this.stringNoQuotes();
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[12] = this.jj_gen;
                                                            }
                                                        }
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 8: {
                                                                this.jj_consume_token(8);
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 7: {
                                                                        priority = this.stringNoQuotes();
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        this.jj_la1[13] = this.jj_gen;
                                                                    }
                                                                }
                                                                while (true) {
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 8: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            this.jj_la1[14] = this.jj_gen;
                                                                            break block0;
                                                                        }
                                                                    }
                                                                    this.jj_consume_token(8);
                                                                }
                                                            }
                                                        }
                                                        this.jj_la1[15] = this.jj_gen;
                                                        break block0;
                                                    }
                                                }
                                                this.jj_la1[16] = this.jj_gen;
                                                break block0;
                                            }
                                        }
                                        this.jj_la1[17] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[18] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[19] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (showTitle.compareToIgnoreCase("no") == 0 || showTitle.compareToIgnoreCase("notitle") == 0) {
            bShowTitle = false;
        }
        if (showColumn.compareToIgnoreCase("off") == 0) {
            iShowColumn = 2;
        }
        if (showColumn.compareToIgnoreCase("on") == 0) {
            iShowColumn = 1;
        }
        boolean addtods = true;
        boolean underlay = false;
        if (type == null) {
            throw new ParseException("Line :: " + lineNumber.beginLine + " | Missing Field :: TYPE | Column Name :: " + name);
        }
        if (type.endsWith("-underlay")) {
            underlay = true;
            addtods = false;
            type = type.substring(0, type.lastIndexOf("-underlay"));
        }
        boolean overlay = false;
        if (type.endsWith("-overlay")) {
            overlay = true;
            addtods = false;
            type = type.substring(0, type.lastIndexOf("-overlay"));
        }
        if (type.toString().compareToIgnoreCase("chron") == 0) {
            col = this.columnDataChron(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 1, false);
            addtods = false;
            applyConverterNow = false;
        } else if (type.toString().compareToIgnoreCase("chron-only") == 0) {
            col = this.columnDataChron(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 1, true);
            addtods = false;
            applyConverterNow = false;
        } else if (type.toString().compareToIgnoreCase("facies") == 0) {
            col = this.columnDataChron(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 2, false);
            addtods = false;
            applyConverterNow = false;
        } else if (type.toString().compareToIgnoreCase("facies-only") == 0) {
            col = this.columnDataChron(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 2, true);
            addtods = false;
            applyConverterNow = false;
        } else if (type.toString().compareToIgnoreCase("blank") == 0) {
            col = this.columnBlank(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("block") == 0) {
            col = this.columnDataBlock(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("event") == 0) {
            col = this.columnDataEvent(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("range") == 0) {
            col = this.columnDataRange(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, priority);
        } else if (type.toString().compareToIgnoreCase("point") == 0) {
            col = this.columnDataPoint(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("sequence") == 0) {
            col = this.columnDataSequence(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 1);
        } else if (type.toString().compareToIgnoreCase("trend") == 0) {
            col = this.columnDataSequence(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, 2);
        } else if (type.toString().compareToIgnoreCase("ageage") == 0) {
            col = this.columnDataAgeAge(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("transect") == 0) {
            col = this.columnDataTransect(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("freehand") == 0) {
            col = this.columnDataFreehand(ds, fileInfo, name.toString(), width, color, bShowTitle, iShowColumn, popup, null, true);
        } else if (type.toString().compareToIgnoreCase("patternwidths") == 0) {
            this.patternWidth(ds);
        } else if (type.toString().compareToIgnoreCase("ageconvert-none") == 0) {
            ds.setCurrentUnits(this.current_units);
            this.ageConverter = null;
        } else if (type.toString().compareToIgnoreCase("ageconvert-interpolate") == 0) {
            this.ageConvertInterpolate(name.toString());
        } else if (type.toString().compareToIgnoreCase("ageconvert-named") == 0) {
            this.ageConvertNamed(name.toString());
        } else if (name.toString().compareToIgnoreCase("age units:") == 0) {
            this.current_units = type.toString();
            ds.setCurrentUnits(this.current_units);
        } else if (name.toString().compareToIgnoreCase("interval column:") == 0) {
            ds.getCurrentUnits().setIntervalColName(type.toString());
        } else if (name.toString().compareToIgnoreCase("chart title:") == 0) {
            ds.setCurrentChartTitle(type.toString());
        } else {
            if (type.toString().compareToIgnoreCase("synonym") == 0) {
                this.synonymDataPackLoading = true;
                SearchDataPack.file_location = fileInfo.loadPath;
                return null;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (applyConverterNow && col != null && this.ageConverter != null) {
            col.convertAges(this.ageConverter);
        }
        if (addtods && col != null) {
            ds.addColumn(col);
        }
        if (underlay) {
            if (prevCol == null) {
                throw new ParseException("Underlay without a host column");
            }
            prevCol.addUnderlay(col);
        } else if (overlay) {
            if (prevCol == null) {
                throw new ParseException("Overlay without a host column");
            }
            prevCol.addOverlay(col);
        } else if (col != null) {
            prevCol = col;
        }
        if (col != null) {
            col.finalizeLoading();
        }
        TSCreator.logAndShow("column " + name.toString() + " (type: " + type.toString() + ") done!", 1);
        return prevCol;
    }

    public final Coloring columnColor() throws ParseException {
        String color = this.stringNoQuotes();
        return this.columnColorString(color);
    }

    public final Coloring columnColorString(String color) throws ParseException {
        if ((color = color.toString().trim()).compareToIgnoreCase("CHRONOSTRAT") == 0) {
            return Coloring.USGS;
        }
        if (color.compareToIgnoreCase("USGS") == 0) {
            return Coloring.USGS;
        }
        if (color.compareToIgnoreCase("USGS-NAMED") == 0) {
            return Coloring.NAMED_USGS;
        }
        if (color.compareToIgnoreCase("UNESCO") == 0) {
            return Coloring.UNESCO;
        }
        if (color.compareToIgnoreCase("UNESCO-NAMED") == 0) {
            return Coloring.NAMED_UNESCO;
        }
        if (color.compareToIgnoreCase("nocolor") == 0) {
            return null;
        }
        if (color.length() > 1) {
            Coloring c = Coloring.getColoring(color);
            if (c == null) {
                this.ds.errorList.add(Language.translate("Error parsing color:", true) + color + " .\n" + Language.translate("Must be in the format 'r/g/b' where r, g, and b are between 0 and 255.", true));
                return Coloring.USGS;
            }
            return c;
        }
        return null;
    }

    public final DataColumn columnBlank(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        DataColumn col = new DataColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        col.setColor(color);
        this.newline();
        return col;
    }

    public final DataColumn columnDataChron(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, int type, boolean onlyMe) throws ParseException {
        BlockSeriesMetaColumn bsmccol;
        block14: {
            bsmccol = new BlockSeriesMetaColumn(name, type);
            bsmccol.setFileInfo(fileInfo);
            bsmccol.drawTitle = showTitle;
            if (showColumn != 3) {
                bsmccol.setSelected(showColumn == 1);
            }
            if (width != null) {
                bsmccol.setWidth(Double.parseDouble(width));
                BlockSeriesMetaColumn.myColWidth = Double.parseDouble(width);
            }
            bsmccol.popup = popup;
            bsmccol.setColor(color);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block14;
                    }
                }
                if (this.jj_2_5(2)) {
                    this.chronSeriesLabel(bsmccol);
                    continue;
                }
                if (!this.jj_2_6(2)) break;
                this.columnDataChronTab(bsmccol);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.justNewlineEOF();
        bsmccol.isOutcrop = ds.isInverted;
        if (!onlyMe) {
            ds.addColumn(bsmccol);
            DataColumn col = bsmccol.finalizeBSLoading();
            if (col != null) {
                col.setName(name);
                col.setFileInfo(fileInfo);
                col.isOutcrop = bsmccol.isOutcrop;
            }
            if (this.ageConverter != null) {
                bsmccol.convertAges(this.ageConverter);
            }
            return col;
        }
        DataColumn col = bsmccol.finalizeBSLoading();
        if (col != null) {
            col.setName(name);
            col.setFileInfo(fileInfo);
            col.drawTitle = showTitle;
            if (showColumn != 3) {
                col.setSelected(showColumn == 1);
            }
            if (width != null) {
                col.setWidth(Double.parseDouble(width));
            }
            col.popup = popup;
            col.setColor(color);
            col.isOutcrop = bsmccol.isOutcrop;
            if (this.ageConverter != null) {
                col.convertAges(this.ageConverter);
            }
            ds.addColumn(col);
        }
        return col;
    }

    public final void columnDataChronTab(BlockSeriesMetaColumn col) throws ParseException {
        this.jj_consume_token(8);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.chronSeriesData(col);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(8);
                }
            }
        }
    }

    public final void chronSeriesLabel(BlockSeriesMetaColumn col) throws ParseException {
        String series = "";
        String section = null;
        String width = null;
        String showColumn = "";
        String popup = null;
        int iShowColumn = 3;
        Token lineNumber = null;
        Token sectionToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                series = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        lineNumber = this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                sectionToken = this.jj_consume_token(4);
                break;
            }
            case 5: {
                sectionToken = this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        width = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                showColumn = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[28] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        popup = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[29] = this.jj_gen;
                                    }
                                }
                                while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 8: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[30] = this.jj_gen;
                                            break block7;
                                        }
                                    }
                                    this.jj_consume_token(8);
                                }
                            }
                        }
                        this.jj_la1[31] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        section = sectionToken.toString();
        if (showColumn != null) {
            if (showColumn.compareToIgnoreCase("off") == 0) {
                iShowColumn = 2;
            }
            if (showColumn.compareToIgnoreCase("on") == 0) {
                iShowColumn = 1;
            }
        }
        BlockSeriesMetaColumn.CurrentPop = popup;
        col.isOutcrop = this.ds.isInverted;
        col.setCurrent(section, series, width, iShowColumn, popup);
    }

    public final void chronSeriesData(BlockSeriesMetaColumn col) throws ParseException {
        String label = "";
        String age = null;
        String popup = null;
        String member = null;
        String line = null;
        Datapoint dp = new Datapoint();
        Token lineNumber = null;
        boolean hasException = false;
        String polarity = this.stringNoQuotes();
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        label = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                age = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[35] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        popup = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[36] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                member = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[37] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        line = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[38] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 8: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[39] = this.jj_gen;
                                                            break block1;
                                                        }
                                                    }
                                                    this.jj_consume_token(8);
                                                }
                                            }
                                        }
                                        this.jj_la1[40] = this.jj_gen;
                                        break block1;
                                    }
                                }
                                this.jj_la1[41] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_la1[42] = this.jj_gen;
                        break block1;
                    }
                }
                this.jj_la1[43] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.value = polarity;
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: ChronSeries", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.popup = popup;
        if (member != null) {
            dp.member = member;
        }
        if (line != null) {
            dp.lineType = this.getLineType(line);
        }
        if (polarity.compareToIgnoreCase("top") == 0) {
            dp.breaker = true;
        }
        if (!hasException) {
            col.addData(dp);
            col.isOutcrop = this.ds.isInverted;
        }
    }

    public final DataColumn columnDataBlock(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        ZoneColumn col = new ZoneColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        col.setColor(color);
        col.isOutcrop = ds.isInverted;
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(8);
            this.blockData(col);
        }
        this.newline();
        return col;
    }

    public final void blockData(ZoneColumn col) throws ParseException {
        String label = "";
        String age = null;
        String line = null;
        String popup = null;
        String color = null;
        String priority = null;
        String uncertainty = null;
        ZoneColumn.ZCDatapoint dp = new ZoneColumn.ZCDatapoint();
        Token lineNumber = null;
        boolean hasException = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        age = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                line = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[47] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        popup = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[48] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                color = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[49] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        priority = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[50] = this.jj_gen;
                                                    }
                                                }
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                uncertainty = this.stringNoQuotes();
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[51] = this.jj_gen;
                                                            }
                                                        }
                                                        while (true) {
                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                case 8: {
                                                                    break;
                                                                }
                                                                default: {
                                                                    this.jj_la1[52] = this.jj_gen;
                                                                    break block5;
                                                                }
                                                            }
                                                            this.jj_consume_token(8);
                                                        }
                                                    }
                                                }
                                                this.jj_la1[53] = this.jj_gen;
                                                break block5;
                                            }
                                        }
                                        this.jj_la1[54] = this.jj_gen;
                                        break block5;
                                    }
                                }
                                this.jj_la1[55] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_la1[56] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_la1[57] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
            try {
                Integer.valueOf(age);
                dp.isAgeInteger = true;
            }
            catch (NumberFormatException e) {
                dp.isAgeInteger = false;
            }
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Block", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.lineType = this.getLineType(line);
        dp.popup = popup;
        if (label.compareToIgnoreCase("top") == 0) {
            dp.breaker = true;
        }
        if (color != null) {
            dp.color = Coloring.parseColor(color);
        }
        dp.priority = priority == null ? 0 : Integer.parseInt(priority);
        dp.uncertainty = uncertainty == null ? null : uncertainty;
        if (!hasException) {
            col.addData(dp);
            col.isOutcrop = this.ds.isInverted;
        }
    }

    public final int getLineType(String s) throws ParseException {
        int i;
        block8: {
            if (s == null || s.length() == 0) {
                return 1;
            }
            i = 1;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                if (s.compareToIgnoreCase("solid") == 0) {
                    return 1;
                }
                if (s.compareToIgnoreCase("dashed") == 0) {
                    return 2;
                }
                if (s.compareToIgnoreCase("dotted") == 0) {
                    return 3;
                }
                if (s.compareToIgnoreCase("wavy") == 0) {
                    return 4;
                }
                if (s.compareToIgnoreCase("gap") != 0) break block8;
                return 5;
            }
        }
        if (i == 1 || i == 2 || i == 3 || i == 4 || i == 5) {
            return i;
        }
        return 1;
    }

    public final DataColumn columnDataEvent(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        EventColumn col;
        block11: {
            col = new EventColumn(name);
            col.setFileInfo(fileInfo);
            col.drawTitle = showTitle;
            col.isOutcrop = ds.isInverted;
            if (showColumn != 3) {
                col.setSelected(showColumn == 1);
            }
            if (width != null) {
                col.setWidth(Double.parseDouble(width));
            }
            col.popup = popup;
            if (color != null) {
                col.setColor(color);
            }
            String header = this.eventHeader();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        header = this.eventHeader();
                        continue block7;
                    }
                    case 8: {
                        this.columnDataEventTab(col, header);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[60] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.justNewlineEOF();
        return col;
    }

    public final void columnDataEventTab(EventColumn col, String header) throws ParseException {
        this.jj_consume_token(8);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.eventData(col, header);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(8);
                }
            }
        }
    }

    public final String eventHeader() throws ParseException {
        String header = this.stringNoQuotes();
        this.newline();
        return header;
    }

    public final void eventData(EventColumn col, String header) throws ParseException {
        String age = null;
        String line = null;
        String color = null;
        String popup = null;
        String priority = null;
        String uncertainty = null;
        String synonyms = null;
        Datapoint dp = new Datapoint();
        Token lineNumber = null;
        boolean hasException = false;
        String label = this.stringNoQuotes();
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        age = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                line = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[64] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        popup = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[65] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                color = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[66] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        priority = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[67] = this.jj_gen;
                                                    }
                                                }
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                uncertainty = this.stringNoQuotes();
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[68] = this.jj_gen;
                                                            }
                                                        }
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 8: {
                                                                this.jj_consume_token(8);
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 7: {
                                                                        synonyms = this.stringNoQuotes();
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        this.jj_la1[69] = this.jj_gen;
                                                                    }
                                                                }
                                                                while (true) {
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 8: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            this.jj_la1[70] = this.jj_gen;
                                                                            break block1;
                                                                        }
                                                                    }
                                                                    this.jj_consume_token(8);
                                                                }
                                                            }
                                                        }
                                                        this.jj_la1[71] = this.jj_gen;
                                                        break block1;
                                                    }
                                                }
                                                this.jj_la1[72] = this.jj_gen;
                                                break block1;
                                            }
                                        }
                                        this.jj_la1[73] = this.jj_gen;
                                        break block1;
                                    }
                                }
                                this.jj_la1[74] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_la1[75] = this.jj_gen;
                        break block1;
                    }
                }
                this.jj_la1[76] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.value = header;
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Event", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.lineType = this.getLineType(line);
        dp.popup = popup;
        dp.color = color == null ? Color.BLACK : Coloring.parseColor(color);
        dp.priority = priority == null ? 10 : Integer.parseInt(priority);
        dp.uncertainty = uncertainty == null ? null : uncertainty;
        if (synonyms != "" && synonyms != null) {
            dp.synonyms = new ArrayList<String>(Arrays.asList(synonyms.split(", ")));
        }
        if (!hasException) {
            col.isOutcrop = this.ds.isInverted;
            col.addData(dp);
        }
    }

    public final DataColumn columnDataRange(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, String priority) throws ParseException {
        int priorityVal;
        RangeColumn col = new RangeColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (priority != null && priority.startsWith("priority") && (priorityVal = Integer.parseInt(priority.substring(8))) <= 10 && priorityVal >= 0) {
            col.priorityEnable = true;
            col.priorityVal = priorityVal;
        }
        col.setColor(color);
        while (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(8);
            this.rangeData(col);
        }
        this.newline();
        return col;
    }

    public final void rangeData(RangeColumn col) throws ParseException {
        String label = "";
        String age = null;
        String type = null;
        String popup = null;
        String speciesOrPhenon = null;
        String speciesWithFinalTopOfPhenon = null;
        boolean branch = false;
        String branch_to = null;
        String branch_label = null;
        String branch_priority = null;
        String branch_color = null;
        String default_on = null;
        String title = null;
        RangeColumn.RCDatapoint dp = new RangeColumn.RCDatapoint();
        Token lineNumber = null;
        boolean hasException = false;
        label = this.stringNoQuotes();
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        age = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                type = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                            }
                        }
                        if (type != null && type.toLowerCase().startsWith("branch")) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    this.jj_consume_token(8);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 7: {
                                            branch_to = this.stringNoQuotes();
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[80] = this.jj_gen;
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 8: {
                                            this.jj_consume_token(8);
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 7: {
                                                    default_on = this.stringNoQuotes();
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[81] = this.jj_gen;
                                                }
                                            }
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 8: {
                                                    this.jj_consume_token(8);
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 7: {
                                                            title = this.stringNoQuotes();
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[82] = this.jj_gen;
                                                        }
                                                    }
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 8: {
                                                            this.jj_consume_token(8);
                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                case 7: {
                                                                    branch_label = this.stringNoQuotes();
                                                                    break;
                                                                }
                                                                default: {
                                                                    this.jj_la1[83] = this.jj_gen;
                                                                }
                                                            }
                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                case 8: {
                                                                    this.jj_consume_token(8);
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 7: {
                                                                            popup = this.stringNoQuotes();
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            this.jj_la1[84] = this.jj_gen;
                                                                        }
                                                                    }
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 8: {
                                                                            this.jj_consume_token(8);
                                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                case 7: {
                                                                                    branch_color = this.stringNoQuotes();
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    this.jj_la1[85] = this.jj_gen;
                                                                                }
                                                                            }
                                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                case 8: {
                                                                                    this.jj_consume_token(8);
                                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                        case 7: {
                                                                                            branch_priority = this.stringNoQuotes();
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            this.jj_la1[86] = this.jj_gen;
                                                                                        }
                                                                                    }
                                                                                    while (true) {
                                                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                            case 8: {
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                this.jj_la1[87] = this.jj_gen;
                                                                                                break block1;
                                                                                            }
                                                                                        }
                                                                                        this.jj_consume_token(8);
                                                                                    }
                                                                                }
                                                                            }
                                                                            this.jj_la1[88] = this.jj_gen;
                                                                            break block1;
                                                                        }
                                                                    }
                                                                    this.jj_la1[89] = this.jj_gen;
                                                                    break block1;
                                                                }
                                                            }
                                                            this.jj_la1[90] = this.jj_gen;
                                                            break block1;
                                                        }
                                                    }
                                                    this.jj_la1[91] = this.jj_gen;
                                                    break block1;
                                                }
                                            }
                                            this.jj_la1[92] = this.jj_gen;
                                            break block1;
                                        }
                                    }
                                    this.jj_la1[93] = this.jj_gen;
                                    break block1;
                                }
                            }
                            this.jj_la1[94] = this.jj_gen;
                            break block1;
                        }
                        if (type != null && type.toLowerCase().startsWith("top")) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    this.jj_consume_token(8);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 7: {
                                            popup = this.stringNoQuotes();
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[95] = this.jj_gen;
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 8: {
                                            this.jj_consume_token(8);
                                            this.jj_consume_token(8);
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 7: {
                                                    speciesWithFinalTopOfPhenon = this.stringNoQuotes();
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[96] = this.jj_gen;
                                                }
                                            }
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 8: {
                                                    this.jj_consume_token(8);
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 7: {
                                                            speciesOrPhenon = this.stringNoQuotes();
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[97] = this.jj_gen;
                                                        }
                                                    }
                                                    while (true) {
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 8: {
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[98] = this.jj_gen;
                                                                break block1;
                                                            }
                                                        }
                                                        this.jj_consume_token(8);
                                                    }
                                                }
                                            }
                                            this.jj_la1[99] = this.jj_gen;
                                            break block1;
                                        }
                                    }
                                    this.jj_la1[100] = this.jj_gen;
                                    break block1;
                                }
                            }
                            this.jj_la1[101] = this.jj_gen;
                            break block1;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        popup = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[102] = this.jj_gen;
                                    }
                                }
                                while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 8: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[103] = this.jj_gen;
                                            break block1;
                                        }
                                    }
                                    this.jj_consume_token(8);
                                }
                            }
                        }
                        this.jj_la1[104] = this.jj_gen;
                        break block1;
                    }
                }
                this.jj_la1[105] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Range", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.setType(type);
        dp.popup = popup;
        if (speciesWithFinalTopOfPhenon != null && speciesOrPhenon != null) {
            col.speciesPhenonTreeDrawing = true;
            dp.speciesOrPhenon = speciesOrPhenon;
            dp.speciesWithFinalTopOfPhenon = speciesWithFinalTopOfPhenon;
        }
        if (branch_to != null) {
            dp.branch = true;
            dp.branchTo = branch_to;
            dp.branchLabel = branch_label;
            if (default_on != null && default_on.equalsIgnoreCase("off")) {
                dp.notInclude = true;
            }
            if (title != null) {
                dp.subLabel = title;
            }
            if (branch_color != null) {
                dp.branchColor = Coloring.parseColor(branch_color);
            }
            if (branch_priority != null) {
                dp.branchPrio = Integer.parseInt(branch_priority);
            }
        }
        if (!hasException) {
            col.addData(dp);
        }
    }

    public final DataColumn columnDataTransect(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        TransectColumn col = new TransectColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        col.setColor(color);
        this.transectData(col);
        return col;
    }

    public final void transectData(TransectColumn col) throws ParseException {
        Vector<Vector> grid = new Vector<Vector>();
        Vector polyV = new Vector();
        int numtabs = 0;
        int xlineLineNumber = -1;
        Token lineNumberToken = null;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block6;
                }
            }
            numtabs = 0;
            do {
                lineNumberToken = this.jj_consume_token(8);
                ++numtabs;
                if (xlineLineNumber != -1) continue;
                xlineLineNumber = lineNumberToken.beginLine;
            } while (this.jj_2_9(Integer.MAX_VALUE));
            if (!this.jj_2_10(Integer.MAX_VALUE)) continue;
            Vector line = this.transectLine(numtabs);
            this.justNewlineEOF();
            grid.add(line);
        }
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                    break block8;
                }
            }
            String s = this.stringNoQuotes();
            if (s.compareToIgnoreCase("POLYGON") == 0) {
                this.transectPolygon(col, polyV);
                continue;
            }
            if (s.compareToIgnoreCase("TEXT") != 0) continue;
            this.transectText(col);
        }
        this.justNewlineEOF();
        col.setParsedGrid(grid, polyV, xlineLineNumber);
        col.getDataDensity();
    }

    public final Vector transectLine(int numTabsBefore) throws ParseException {
        String s;
        Vector<String> line;
        block9: {
            line = new Vector<String>();
            line.setSize(numTabsBefore);
            s = this.stringNoQuotes();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        line.add(s);
                        s = null;
                        continue block7;
                    }
                    case 7: {
                        s = this.stringNoQuotes();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[110] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (s != null) {
            line.add(s);
        }
        return line;
    }

    public final void transectPolygon(TransectColumn col, Vector polyV) throws ParseException {
        String style = null;
        String popup = null;
        String lastId = null;
        String firstId = null;
        boolean readId = true;
        TransectColumn.GridPolygon.GPLine line = null;
        TransectColumn.GridPolygon.GPLine firstLastLine = null;
        TransectColumn.GridPolygon poly = new TransectColumn.GridPolygon();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        style = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                popup = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[112] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[113] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(8);
                        }
                    }
                }
                this.jj_la1[114] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        poly.style = style;
        if (popup != null) {
            poly.popup = popup;
        }
        while (this.jj_2_11(3)) {
            readId = true;
            this.jj_consume_token(8);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    readId = false;
                    break;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                }
            }
            String s = this.stringNoQuotes();
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[117] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(8);
            }
            this.justNewlineEOF();
            if (readId) {
                if (s.indexOf(46) > 0) {
                    s = s.substring(0, s.indexOf(46));
                }
                if (line != null) {
                    line.id2 = s;
                    if (line.id1 == null) {
                        System.out.println("Trying to add line with id1=null. id2=" + line.id2);
                    }
                    poly.lines.add(line);
                    line = null;
                } else if (firstLastLine != null) {
                    firstLastLine.id2 = s;
                } else if (firstId != null) {
                    if (lastId == null) {
                        System.out.println("Trying to add straight line with lastId=null. read: " + s);
                    }
                    line = new TransectColumn.GridPolygon.GPLine();
                    line.id1 = lastId;
                    line.id2 = s;
                    line.style = null;
                    poly.lines.add(line);
                    line = null;
                }
                lastId = s;
                if (firstId != null) continue;
                firstId = s;
                continue;
            }
            if (lastId == null) {
                firstLastLine = new TransectColumn.GridPolygon.GPLine();
                firstLastLine.style = s;
                continue;
            }
            line = new TransectColumn.GridPolygon.GPLine();
            line.id1 = lastId;
            line.style = s;
        }
        if (firstLastLine != null) {
            if (lastId != null) {
                firstLastLine.id1 = lastId;
                poly.lines.add(firstLastLine);
            } else {
                System.out.println("extrenous line \"" + firstLastLine.style + "\" in transect, probably because there are no endpoints.");
            }
        } else if (line != null) {
            line.id2 = firstId;
            poly.lines.add(line);
            line = null;
        } else {
            line = new TransectColumn.GridPolygon.GPLine();
            line.id1 = lastId;
            line.id2 = firstId;
            line.style = null;
            poly.lines.add(line);
            line = null;
        }
        polyV.add(poly);
    }

    public final void transectText(TransectColumn col) throws ParseException {
        String ageS = null;
        String xS = null;
        String textS = null;
        String fontS = null;
        String ageSpreadS = null;
        String xRangeS = null;
        TransectColumn.TextLabel text = new TransectColumn.TextLabel(col);
        Token lineNumber = null;
        double x = 0.0;
        double age = 0.0;
        boolean hasException = false;
        lineNumber = this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                ageS = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        xS = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[119] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                textS = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[120] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        fontS = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[121] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                ageSpreadS = this.stringNoQuotes();
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                xRangeS = this.stringNoQuotes();
                                                                while (true) {
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 8: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            this.jj_la1[122] = this.jj_gen;
                                                                            break block7;
                                                                        }
                                                                    }
                                                                    this.jj_consume_token(8);
                                                                }
                                                            }
                                                        }
                                                        this.jj_la1[123] = this.jj_gen;
                                                        break block7;
                                                    }
                                                }
                                                this.jj_la1[124] = this.jj_gen;
                                                break block7;
                                            }
                                        }
                                        this.jj_la1[125] = this.jj_gen;
                                        break block7;
                                    }
                                }
                                this.jj_la1[126] = this.jj_gen;
                                break block7;
                            }
                        }
                        this.jj_la1[127] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_la1[128] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        try {
            age = Double.parseDouble(ageS);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Column type :: Transect", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            x = Double.parseDouble(xS);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: X", true) + " | " + Language.translate("Column type :: Transect", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            text.text = new RichText(textS, col.fileInfo);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: TEXT", true) + " | " + Language.translate("Column type :: Transect", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            text.font = new TSCFont(fontS);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: FONT", true) + " | " + Language.translate("Column type :: Transect", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        if (ageSpreadS != null) {
            text.ageSpread = Double.parseDouble(ageSpreadS);
        }
        if (xRangeS != null) {
            text.widthFrac = Double.parseDouble(xRangeS) / 100.0;
        }
        if (!hasException) {
            text.point = new Point(x, age);
            col.textLabels.add(text);
        }
    }

    public final DataColumn columnDataPoint(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        PointColumn col = new PointColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        col.isOutcrop = ds.isInverted;
        if (color != null) {
            col.setColor(color);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.pointOptions(col);
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
            }
        }
        while (this.jj_2_12(Integer.MAX_VALUE)) {
            this.pointData(col);
        }
        this.newline();
        return col;
    }

    public final void pointOptions(PointColumn col) throws ParseException {
        Color c;
        Coloring coloring;
        String pointType = null;
        String line = null;
        String fill = null;
        String rangeLow = null;
        String rangeHigh = null;
        String smooth = null;
        String side = null;
        String gradBgStart = null;
        String gradBgEnd = null;
        String gradCvStart = null;
        String gradCvEnd = null;
        Token lineNumber = null;
        boolean hasException = false;
        pointType = this.stringNoQuotes();
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                lineNumber = this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        line = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[131] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                fill = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[132] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        rangeLow = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[133] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                rangeHigh = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[134] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        smooth = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[135] = this.jj_gen;
                                                    }
                                                }
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                side = this.stringNoQuotes();
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[136] = this.jj_gen;
                                                            }
                                                        }
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 8: {
                                                                this.jj_consume_token(8);
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 7: {
                                                                        gradBgStart = this.stringNoQuotes();
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        this.jj_la1[137] = this.jj_gen;
                                                                    }
                                                                }
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 8: {
                                                                        this.jj_consume_token(8);
                                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                            case 7: {
                                                                                gradBgEnd = this.stringNoQuotes();
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                this.jj_la1[138] = this.jj_gen;
                                                                            }
                                                                        }
                                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                            case 8: {
                                                                                this.jj_consume_token(8);
                                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                    case 7: {
                                                                                        gradCvStart = this.stringNoQuotes();
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        this.jj_la1[139] = this.jj_gen;
                                                                                    }
                                                                                }
                                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                    case 8: {
                                                                                        this.jj_consume_token(8);
                                                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                            case 7: {
                                                                                                gradCvEnd = this.stringNoQuotes();
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                this.jj_la1[140] = this.jj_gen;
                                                                                            }
                                                                                        }
                                                                                        while (true) {
                                                                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                                                case 8: {
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    this.jj_la1[141] = this.jj_gen;
                                                                                                    break block2;
                                                                                                }
                                                                                            }
                                                                                            this.jj_consume_token(8);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                this.jj_la1[142] = this.jj_gen;
                                                                                break block2;
                                                                            }
                                                                        }
                                                                        this.jj_la1[143] = this.jj_gen;
                                                                        break block2;
                                                                    }
                                                                }
                                                                this.jj_la1[144] = this.jj_gen;
                                                                break block2;
                                                            }
                                                        }
                                                        this.jj_la1[145] = this.jj_gen;
                                                        break block2;
                                                    }
                                                }
                                                this.jj_la1[146] = this.jj_gen;
                                                break block2;
                                            }
                                        }
                                        this.jj_la1[147] = this.jj_gen;
                                        break block2;
                                    }
                                }
                                this.jj_la1[148] = this.jj_gen;
                                break block2;
                            }
                        }
                        this.jj_la1[149] = this.jj_gen;
                        break block2;
                    }
                }
                this.jj_la1[150] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (pointType != null) {
            if (pointType.compareToIgnoreCase("nopoints") == 0) {
                col.drawPoints = false;
            } else if (pointType.compareToIgnoreCase("rect") == 0) {
                col.drawPoints = true;
                col.pointType = 1;
            } else if (pointType.compareToIgnoreCase("circle") == 0) {
                col.drawPoints = true;
                col.pointType = 2;
            } else if (pointType.compareToIgnoreCase("cross") == 0) {
                col.drawPoints = true;
                col.pointType = 3;
            }
        }
        if (line != null) {
            if (line.compareToIgnoreCase("noline") == 0) {
                col.drawLine = false;
            } else if (line.compareToIgnoreCase("line") == 0) {
                col.drawLine = true;
            } else {
                coloring = Coloring.getColoring(line);
                if (coloring == null) {
                    this.ds.errorList.add(Language.translate("Error parsing color:", true) + line + " .\n" + Language.translate("Must be in the format 'r/g/b' where r, g, and b are between 0 and 255.", true));
                } else {
                    c = coloring.oneColor;
                    col.drawLine = true;
                    col.lineColor = c;
                }
            }
        }
        if (fill != null) {
            if (fill.compareToIgnoreCase("nofill") == 0) {
                col.drawFill = false;
            } else if (fill.compareToIgnoreCase("gradient") == 0) {
                Coloring coloring1 = Coloring.getColoring(gradBgStart);
                Coloring coloring2 = Coloring.getColoring(gradBgEnd);
                Coloring coloring3 = Coloring.getColoring(gradCvStart);
                Coloring coloring4 = Coloring.getColoring(gradCvEnd);
                col.backGradStart = coloring1 == null ? new Color(255, 255, 255) : coloring1.oneColor;
                col.backGradEnd = coloring2 == null ? new Color(255, 255, 255) : coloring2.oneColor;
                if (coloring3 == null && coloring4 == null) {
                    col.curveGradStart = new Color(0, 0, 255);
                    col.curveGradEnd = new Color(255, 0, 0);
                } else if (coloring3 == null) {
                    col.curveGradStart = new Color(255, 255, 255);
                    col.curveGradEnd = coloring4.oneColor;
                } else if (coloring4 == null) {
                    col.curveGradStart = coloring3.oneColor;
                    col.curveGradEnd = new Color(255, 255, 255);
                } else {
                    col.curveGradStart = coloring3.oneColor;
                    col.curveGradEnd = coloring4.oneColor;
                }
                col.drawBgrndGradient = true;
                col.drawCurveGradient = true;
            } else {
                coloring = Coloring.getColoring(fill);
                if (coloring == null) {
                    this.ds.errorList.add(Language.translate("Error parsing color:", true) + fill + " .\n" + Language.translate("Must be in the format 'r/g/b' where r, g, and b are between 0 and 255.", true));
                } else {
                    c = coloring.oneColor;
                    col.drawFill = true;
                    col.fillColor = c;
                }
            }
        }
        if (rangeLow != null) {
            col.doNotSetWindowAuto = true;
            try {
                col.minWindow = Double.parseDouble(rangeLow);
                col.autoScale();
            }
            catch (Exception e) {
                this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: RANGE LOW", true) + " | " + Language.translate("Column type :: Point", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            }
        }
        if (rangeHigh != null) {
            col.doNotSetWindowAuto = true;
            try {
                col.maxWindow = Double.parseDouble(rangeHigh);
                col.autoScale();
            }
            catch (Exception e) {
                this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: RANGE HIGH", true) + " | " + Language.translate("Column type :: Point", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            }
        }
        if (smooth != null) {
            if (smooth.compareToIgnoreCase("smoothed") == 0) {
                col.drawSmooth = true;
            } else if (smooth.compareToIgnoreCase("notsmoothed") == 0) {
                col.drawSmooth = false;
            }
        }
        if (side != null) {
            if (side.compareToIgnoreCase("left") == 0) {
                col.side = 1;
            } else if (side.compareToIgnoreCase("right") == 0) {
                col.side = 2;
            }
        }
    }

    public final void pointData(PointColumn col) throws ParseException {
        String age = null;
        String point = null;
        String line = null;
        String label = null;
        String color = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        Token lineNumber = null;
        boolean hasException = false;
        lineNumber = this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                age = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
            }
        }
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        point = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[153] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                line = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[154] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        label = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[155] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                popup = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[156] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        color = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[157] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 8: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[158] = this.jj_gen;
                                                            break block5;
                                                        }
                                                    }
                                                    this.jj_consume_token(8);
                                                }
                                            }
                                        }
                                        this.jj_la1[159] = this.jj_gen;
                                        break block5;
                                    }
                                }
                                this.jj_la1[160] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_la1[161] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_la1[162] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        try {
            dp.value = Double.valueOf(point);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: VALUE", true) + " | " + Language.translate("Column type :: Point", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Column type :: Point", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        if (line != null) {
            dp.lineType = this.getLineType(line.toLowerCase());
        }
        if (color != null) {
            dp.color = Coloring.parseColor(color);
        }
        dp.popup = popup;
        if (!hasException) {
            col.isOutcrop = this.ds.isInverted;
            col.addData(dp);
        }
    }

    public final DataColumn columnDataSequence(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, int type) throws ParseException {
        SequenceColumn col = new SequenceColumn(name, type);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        while (this.jj_2_13(Integer.MAX_VALUE)) {
            this.sequenceData(col);
        }
        this.newline();
        return col;
    }

    public final void sequenceData(SequenceColumn col) throws ParseException {
        String direction = null;
        String label = null;
        String age = null;
        String strength = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        Token lineNumber = null;
        boolean hasException = false;
        lineNumber = this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
            }
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        direction = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[165] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                age = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[166] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        strength = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[167] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                popup = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[168] = this.jj_gen;
                                            }
                                        }
                                        while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 8: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[169] = this.jj_gen;
                                                    break block4;
                                                }
                                            }
                                            this.jj_consume_token(8);
                                        }
                                    }
                                }
                                this.jj_la1[170] = this.jj_gen;
                                break block4;
                            }
                        }
                        this.jj_la1[171] = this.jj_gen;
                        break block4;
                    }
                }
                this.jj_la1[172] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        if (direction == null) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: DIRECTION", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Sequence", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        } else {
            dp.direction = direction;
        }
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Sequence", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        double mag = 0.0;
        if (strength == null) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: STRENGTH", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Sequence", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        } else {
            if (strength.compareToIgnoreCase("Minor") == 0) {
                mag = col.type == 1 ? 0.25 : 0.33;
            } else if (strength.compareToIgnoreCase("Medium") == 0) {
                mag = col.type == 1 ? 0.5 : 0.66;
            } else if (strength.compareToIgnoreCase("Moderate") == 0) {
                mag = col.type == 1 ? 0.5 : 0.66;
            } else if (strength.compareToIgnoreCase("Major") == 0) {
                mag = col.type == 1 ? 0.75 : 1.0;
            } else {
                this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: STRENGTH", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: Sequence", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
                hasException = true;
            }
            dp.value = new Double(mag);
        }
        dp.popup = popup;
        if (!hasException) {
            col.addData(dp);
        }
    }

    public final DataColumn columnDataAgeAge(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        AgeAgeColumn col = new AgeAgeColumn(name);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        while (this.jj_2_14(Integer.MAX_VALUE)) {
            this.ageAgeData(col);
        }
        this.newline();
        return col;
    }

    public final void ageAgeData(AgeAgeColumn col) throws ParseException {
        String label = null;
        String chronAge = null;
        String age = null;
        String yErrorUp = null;
        String yErrorDown = null;
        String xErrorRight = null;
        String xErrorLeft = null;
        String type = null;
        String popup = null;
        AgeAgeColumn.AgeAgeDatapoint dp = new AgeAgeColumn.AgeAgeDatapoint();
        Token lineNumber = null;
        boolean hasException = false;
        lineNumber = this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                chronAge = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[175] = this.jj_gen;
            }
        }
        block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        age = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[176] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                yErrorUp = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[177] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        yErrorDown = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[178] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                xErrorRight = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[179] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        xErrorLeft = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[180] = this.jj_gen;
                                                    }
                                                }
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 8: {
                                                        this.jj_consume_token(8);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 7: {
                                                                type = this.stringNoQuotes();
                                                                break;
                                                            }
                                                            default: {
                                                                this.jj_la1[181] = this.jj_gen;
                                                            }
                                                        }
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 8: {
                                                                this.jj_consume_token(8);
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 7: {
                                                                        popup = this.stringNoQuotes();
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        this.jj_la1[182] = this.jj_gen;
                                                                    }
                                                                }
                                                                while (true) {
                                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                        case 8: {
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            this.jj_la1[183] = this.jj_gen;
                                                                            break block11;
                                                                        }
                                                                    }
                                                                    this.jj_consume_token(8);
                                                                }
                                                            }
                                                        }
                                                        this.jj_la1[184] = this.jj_gen;
                                                        break block11;
                                                    }
                                                }
                                                this.jj_la1[185] = this.jj_gen;
                                                break block11;
                                            }
                                        }
                                        this.jj_la1[186] = this.jj_gen;
                                        break block11;
                                    }
                                }
                                this.jj_la1[187] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_la1[188] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_la1[189] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[190] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        try {
            dp.baseAge = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Double.valueOf(age).doubleValue() : Double.valueOf(age);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: AGE", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: AgeAge", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            if (xErrorRight.charAt(xErrorRight.length() - 1) == '?') {
                dp.xErrorRightQ = true;
                xErrorRight = xErrorRight.substring(0, xErrorRight.length() - 1);
            }
            dp.xErrorRight = Double.valueOf(xErrorRight);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: X ERROR RIGHT", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: AgeAge", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            if (xErrorLeft.charAt(xErrorLeft.length() - 1) == '?') {
                dp.xErrorLeftQ = true;
                xErrorLeft = xErrorLeft.substring(0, xErrorLeft.length() - 1);
            }
            dp.xErrorLeft = Double.valueOf(xErrorLeft);
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: X ERROR LEFT", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: AgeAge", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            if (yErrorUp.charAt(yErrorUp.length() - 1) == '?') {
                dp.yErrorUpQ = true;
                yErrorUp = yErrorUp.substring(0, yErrorUp.length() - 1);
            }
            dp.yErrorUp = Math.abs(Double.valueOf(yErrorUp));
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: Y ERROR UP", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: AgeAge", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        try {
            if (yErrorDown.charAt(yErrorDown.length() - 1) == '?') {
                dp.yErrorDownQ = true;
                yErrorDown = yErrorDown.substring(0, yErrorDown.length() - 1);
            }
            dp.yErrorDown = Math.abs(Double.valueOf(yErrorDown));
        }
        catch (Exception e) {
            this.ds.errorList.add(Language.translate("Line :: ", true) + lineNumber.beginLine + " | " + Language.translate("Missing Field :: Y ERROR DOWN", true) + " | " + Language.translate("Datapoint :: ", true) + label + " | " + Language.translate("Column type :: AgeAge", true) + " | " + Language.translate("Column Name :: ", true) + col.getName());
            hasException = true;
        }
        dp.baseAge = chronAge == null ? ("on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? (dp.chronAge = -(dp.yErrorUp + dp.yErrorDown) / 2.0) : (dp.chronAge = (dp.yErrorUp + dp.yErrorDown) / 2.0)) : ("on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? (dp.chronAge = -Double.valueOf(chronAge).doubleValue()) : (dp.chronAge = Double.valueOf(chronAge).doubleValue()));
        if (type == null) {
            dp.pointType = 0;
        } else if (type.compareToIgnoreCase("A") == 0) {
            dp.pointType = 1;
        } else if (type.compareToIgnoreCase("U") == 0) {
            dp.pointType = 2;
        } else if (type.compareToIgnoreCase("O") == 0) {
            dp.pointType = 3;
        }
        dp.popup = popup;
        if (!hasException) {
            col.addData(dp);
        }
    }

    public final DataColumn columnDataFreehand(Datastore ds, DataColumn.FileInfo fileInfo, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, DataColumn underlay, boolean addToDS) throws ParseException {
        FreehandColumn col = new FreehandColumn(name, underlay);
        col.setFileInfo(fileInfo);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        while (this.jj_2_15(Integer.MAX_VALUE)) {
            this.freehandHeader(col);
        }
        this.newline();
        return col;
    }

    public final void freehandHeader(FreehandColumn col) throws ParseException {
        String header = this.stringNoQuotes();
        if (header.compareToIgnoreCase("polygon") == 0) {
            this.freehandPolygon(col);
        }
        if (header.compareToIgnoreCase("image") == 0) {
            this.freehandImage(col);
        }
    }

    public final void freehandImage(FreehandColumn col) throws ParseException {
        String filename = null;
        String sLineType = "";
        String one = null;
        String two = null;
        int ageType = 3;
        int xType = 3;
        double top = 0.0;
        double base = 0.0;
        Token lineToken = null;
        boolean hasException = false;
        lineToken = this.jj_consume_token(8);
        filename = this.stringNoQuotes();
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        one = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[191] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                two = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[192] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[193] = this.jj_gen;
                                    break block5;
                                }
                            }
                            this.jj_consume_token(8);
                        }
                    }
                }
                this.jj_la1[194] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[195] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (one != null) {
            if (two == null) {
                this.ds.errorList.add(Language.translate("Image on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("has a top age but no bottom.", true));
                hasException = true;
            }
            try {
                top = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Util.parseDouble(one, Double.NaN) : Util.parseDouble(one, Double.NaN);
            }
            catch (Exception e) {
                this.ds.errorList.add(Language.translate("Image Top age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + one);
                hasException = true;
            }
            if (Double.isNaN(top)) {
                this.ds.errorList.add(Language.translate("Image Top age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + one);
                hasException = true;
            }
            try {
                base = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Util.parseDouble(two, Double.NaN) : Util.parseDouble(two, Double.NaN);
            }
            catch (Exception e) {
                this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + two);
                hasException = true;
            }
            if (Double.isNaN(base)) {
                this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + two);
                hasException = true;
            }
            ageType = 3;
            xType = 3;
        }
        while (this.jj_2_16(Integer.MAX_VALUE)) {
            lineToken = this.jj_consume_token(8);
            sLineType = this.stringNoQuotes();
            one = "";
            two = "";
            String three = "";
            block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            one = this.stringNoQuotes();
                            break;
                        }
                        default: {
                            this.jj_la1[196] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            this.jj_consume_token(8);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    two = this.stringNoQuotes();
                                    break;
                                }
                                default: {
                                    this.jj_la1[197] = this.jj_gen;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    this.jj_consume_token(8);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 7: {
                                            three = this.stringNoQuotes();
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[198] = this.jj_gen;
                                        }
                                    }
                                    while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[199] = this.jj_gen;
                                                break block20;
                                            }
                                        }
                                        this.jj_consume_token(8);
                                    }
                                }
                            }
                            this.jj_la1[200] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_la1[201] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[202] = this.jj_gen;
                }
            }
            this.justNewlineEOF();
            if (sLineType.compareToIgnoreCase("ageType") == 0) {
                if (one.compareToIgnoreCase("fit") == 0) {
                    ageType = 1;
                } else if (one.compareToIgnoreCase("start") == 0) {
                    ageType = 2;
                } else if (one.compareToIgnoreCase("center") == 0) {
                    ageType = 3;
                } else if (one.compareToIgnoreCase("end") == 0) {
                    ageType = 4;
                }
                try {
                    top = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Util.parseDouble(two, Double.NaN) : Util.parseDouble(two, Double.NaN);
                }
                catch (Exception e) {
                    this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + two);
                    hasException = true;
                }
                if (Double.isNaN(top)) {
                    this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + two);
                    hasException = true;
                }
                try {
                    base = "on".equals(this.outcrop) || "ON".equals(this.outcrop) || "On".equals(this.outcrop) || "oN".equals(this.outcrop) ? -Util.parseDouble(three, Double.NaN) : Util.parseDouble(three, Double.NaN);
                }
                catch (Exception e) {
                    this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + three);
                    hasException = true;
                }
                if (!Double.isNaN(base)) continue;
                this.ds.errorList.add(Language.translate("Image Base age specified on line", true) + " \"" + lineToken.beginLine + "\" " + Language.translate("is not a number:", true) + three);
                hasException = true;
                continue;
            }
            if (sLineType.compareToIgnoreCase("xType") != 0) continue;
            if (one.compareToIgnoreCase("fit") == 0) {
                xType = 1;
                continue;
            }
            if (one.compareToIgnoreCase("start") == 0) {
                xType = 2;
                continue;
            }
            if (one.compareToIgnoreCase("center") == 0) {
                xType = 3;
                continue;
            }
            if (one.compareToIgnoreCase("end") != 0) continue;
            xType = 4;
        }
        if (!hasException) {
            try {
                FreehandColumn freehandColumn = col;
                Objects.requireNonNull(freehandColumn);
                FreehandColumn.Image img = freehandColumn.new FreehandColumn.Image(filename, ageType, top, base, xType);
                col.addPrimitive(img);
            }
            catch (Exception e) {
                this.ds.errorList.add(Language.translate(filename + " :: Image not found :: line ", true) + lineToken.beginLine);
                hasException = true;
            }
        }
    }

    public final void freehandPolygon(FreehandColumn col) throws ParseException {
        String closed = null;
        String smoothed = null;
        String pattern = null;
        String style = null;
        String popup = null;
        String sx = null;
        String sy = null;
        String smoothedPoint = null;
        FreehandColumn.Polygon poly = col.new FreehandColumn.Polygon();
        boolean hasException = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        closed = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[203] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                smoothed = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[204] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        pattern = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[205] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 8: {
                                        this.jj_consume_token(8);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                style = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[206] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 8: {
                                                this.jj_consume_token(8);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 7: {
                                                        popup = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[207] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 8: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[208] = this.jj_gen;
                                                            break block0;
                                                        }
                                                    }
                                                    this.jj_consume_token(8);
                                                }
                                            }
                                        }
                                        this.jj_la1[209] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[210] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[211] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[212] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[213] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (closed == null || closed.compareToIgnoreCase("closed") == 0) {
            poly.closed = true;
        } else if (closed.compareToIgnoreCase("open") == 0) {
            poly.closed = false;
        } else {
            this.ds.errorList.add(Language.translate("Should the polygon be 'open' or 'closed'? '", true) + closed + Language.translate("' is invalid.", true));
            hasException = true;
        }
        poly.smoothed = smoothed != null && (smoothed.compareToIgnoreCase("smoothed") == 0 || smoothed.compareToIgnoreCase("smooth") == 0);
        poly.setPattern(pattern);
        poly.setStyle(style);
        if (popup != null) {
            poly.popup = popup;
        }
        while (this.jj_2_17(2)) {
            this.jj_consume_token(8);
            sx = this.stringNoQuotes();
            this.jj_consume_token(8);
            sy = this.stringNoQuotes();
            block33 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            smoothedPoint = this.stringNoQuotes();
                            break;
                        }
                        default: {
                            this.jj_la1[214] = this.jj_gen;
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                break;
                            }
                            default: {
                                this.jj_la1[215] = this.jj_gen;
                                break block33;
                            }
                        }
                        this.jj_consume_token(8);
                    }
                }
                default: {
                    this.jj_la1[216] = this.jj_gen;
                }
            }
            this.justNewlineEOF();
            double x = Double.parseDouble(sx);
            double y = Double.parseDouble(sy);
            boolean s = poly.smoothed;
            if (smoothedPoint != null) {
                if (smoothedPoint.compareToIgnoreCase("smooth") == 0 || smoothedPoint.compareToIgnoreCase("smoothed") == 0) {
                    s = true;
                } else if (smoothedPoint.compareToIgnoreCase("sharp") == 0) {
                    s = false;
                }
                smoothedPoint = null;
            }
            poly.addPoint(x, y, s);
        }
        if (!hasException) {
            col.addPrimitive(poly);
        }
    }

    public final void patternWidth(Datastore ds) throws ParseException {
        String name = null;
        String width = null;
        while (this.jj_2_18(2)) {
            this.jj_consume_token(8);
            name = this.stringNoQuotes();
            this.jj_consume_token(8);
            width = this.stringNoQuotes();
            block4: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                        break block4;
                    }
                }
                this.jj_consume_token(8);
            }
            this.justNewlineEOF();
            ds.patWidthMan.setWidth(name, Util.parseDouble(width, ds.patWidthMan.getDefaultWidth()));
        }
    }

    public final void ageConvertInterpolate(String name) throws ParseException {
        String errorString;
        String inAgeS = null;
        String outAgeS = null;
        String fromUnitS = null;
        String toUnitS = null;
        String comment = null;
        InterpolateAgeConverter conv = new InterpolateAgeConverter();
        boolean hasException = false;
        if (this.jj_2_20(Integer.MAX_VALUE)) {
            fromUnitS = this.stringNoQuotes();
            if (this.jj_2_19(Integer.MAX_VALUE)) {
                this.jj_consume_token(8);
                block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        toUnitS = this.stringNoQuotes();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[218] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(8);
                        }
                    }
                    default: {
                        this.jj_la1[219] = this.jj_gen;
                    }
                }
            }
            this.justNewlineEOF();
        }
        while (this.jj_2_21(2)) {
            this.jj_consume_token(8);
            inAgeS = this.stringNoQuotes();
            this.jj_consume_token(8);
            outAgeS = this.stringNoQuotes();
            block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            comment = this.stringNoQuotes();
                            break block6;
                        }
                    }
                    this.jj_la1[220] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[221] = this.jj_gen;
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[222] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(8);
            }
            this.justNewlineEOF();
            if (this.ds.isInverted) {
                conv.addWayPoint(-Double.parseDouble(inAgeS), Double.parseDouble(outAgeS));
                continue;
            }
            conv.addWayPoint(Double.parseDouble(inAgeS), Double.parseDouble(outAgeS));
        }
        if (fromUnitS != null && toUnitS == null) {
            this.ds.errorList.add(Language.translate("Error parsing interpolate age converter '", true) + name + Language.translate("': specified a FROM unit (", true) + fromUnitS + Language.translate(") but not a TO unit. You must specify both or neither.", true));
            hasException = true;
        }
        if (toUnitS != null) {
            this.ds.setCurrentUnits(toUnitS);
            conv.setUnits(this.ds.getUnitFromString(fromUnitS), this.ds.getUnitFromString(toUnitS));
        }
        if ((errorString = conv.checkForErrors()) != null) {
            this.ds.errorList.add(Language.translate("Error parsing interpolate age converter '", true) + name + "':" + errorString);
            hasException = true;
        }
        this.ageConverter = conv;
        if (!hasException) {
            this.namedAgeConverters.put(name, conv);
        }
    }

    public final void ageConvertNamed(String name) throws ParseException {
        AgeConverter conv;
        Object o = this.namedAgeConverters.get(name);
        if (o == null) {
            this.ds.errorList.add(Language.translate("There is no age converter named '", true) + name + "'");
        }
        this.ageConverter = conv = (AgeConverter)o;
    }

    public final void justNewline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[223] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String stringNoQuotes() throws ParseException {
        int i = 1;
        Token t = this.jj_consume_token(7);
        String s = t.toString();
        while (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        s = s.replaceAll("\"\"", "\"").trim();
        char[] charArray = s.toCharArray();
        while (i < s.length()) {
            if (charArray[i] == ',' && Character.isDigit(charArray[i - 1])) {
                charArray[i] = 46;
            }
            ++i;
        }
        s = new String(charArray);
        return s;
    }

    public final void justNewlineEOF() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[224] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void newline() throws ParseException {
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[225] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(8);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void newlineNoEOF() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[227] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(8);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_58()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_3R_53();
    }

    private boolean jj_3_14() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_59() {
        return this.jj_3R_51();
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_51()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_3R_55();
    }

    private boolean jj_3_15() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_12() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3_8() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_19() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3_20() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_1() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_58() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_50() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3R_49() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3_7() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3R_56() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_54() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(8)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(0)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(5)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3_2() {
        return this.jj_3R_50();
    }

    private boolean jj_3_5() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_57() {
        return this.jj_3R_59();
    }

    private boolean jj_3_13() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2, 4, 8, 128, 3840, 128, 128, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 256, 384, 256, 128, 128, 48, 128, 128, 128, 256, 256, 256, 256, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 384, 384, 256, 128, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 256, 128, 128, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 256, 128, 128, 128, 256, 256, 256, 256, 128, 256, 256, 256, 256, 256, 128, 384, 384, 128, 128, 256, 256, 256, 256, 256, 128, 128, 128, 128, 256, 128, 256, 128, 256, 256, 256, 256, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 128, 128, 128, 128, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 256, 256, 128, 128, 256, 256, 256, 128, 128, 128, 256, 256, 256, 256, 128, 128, 128, 128, 128, 256, 256, 256, 256, 256, 256, 128, 256, 256, 256, 256, 128, 128, 256, 256, 3584, 3841, 256, 3585, 256, 3584};
    }

    public Loader1(InputStream stream) {
        this(stream, null);
    }

    public Loader1(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new Loader1TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Loader1(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new Loader1TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Loader1(Loader1TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Loader1TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 229; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[13];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 229; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 13; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 21; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Loader1.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

