/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.ChronColumn;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.FaciesColumn;
import datastore.RangeColumn;
import datastore.RootColumn;
import datastore.SequenceColumn;
import datastore.ZoneColumn;
import datastore.searchresults.BlockResults;
import datastore.searchresults.ChronResults;
import datastore.searchresults.ColumnResults;
import datastore.searchresults.EventResults;
import datastore.searchresults.FacieResults;
import datastore.searchresults.RangeResults;
import datastore.searchresults.Searchpoint;
import datastore.searchresults.SeqResults;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;

public class SearchDataPack {
    public static boolean FOUND = false;
    public ArrayList<EventResults> eventResults = null;
    public ArrayList<BlockResults> blockResults = null;
    public ArrayList<RangeResults> rangeResults = null;
    public ArrayList<SeqResults> seqResults = null;
    public ArrayList<ChronResults> chronResults = null;
    public ArrayList<FacieResults> facieResults = null;
    public ArrayList<ColumnResults> columnResults = null;
    private String searchString;
    private ArrayList<String> hierarchy = null;
    private boolean regex = false;
    private static boolean searchComments = false;
    private Pattern pat;
    private Pattern patternComments;
    private Matcher mat;
    public static String file_location = null;

    public static String SynMapConstruct(String userInput) {
        try {
            ArrayList<String> fileContent = new ArrayList<String>();
            ArrayList synonymContent = new ArrayList();
            if (file_location == null) {
                return null;
            }
            FileReader fr = new FileReader(file_location);
            BufferedReader br = new BufferedReader(fr);
            String strFile = null;
            while ((strFile = br.readLine()) != null) {
                fileContent.add(strFile);
            }
            br.close();
            HashMap<String, String> synMap = new HashMap<String, String>();
            String key = null;
            for (int i = 0; i < fileContent.size(); ++i) {
                String[] line;
                if (((String)fileContent.get(i)).isEmpty() || ((String)fileContent.get(i)).split("\\t").length <= 1 || !((String)fileContent.get(i)).split("\\t")[1].equalsIgnoreCase("Synonym")) continue;
                while (!((String)fileContent.get(i)).isEmpty() && (line = ((String)fileContent.get(i)).split("\\t")).length != 0) {
                    key = line[1].toLowerCase();
                    String value = line[2].toLowerCase();
                    synMap.put(value, key);
                    synMap.put(key, key);
                    ++i;
                    System.out.println("key: " + key + " value:" + value);
                }
            }
            String result = (String)synMap.get(userInput.toLowerCase());
            System.out.println("the Key = " + result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean search(Datastore ds, String searchString, boolean searchComments) {
        this.clearPreviousResults();
        this.searchString = searchString.toLowerCase();
        System.out.println(searchString);
        SearchDataPack.searchComments = searchComments;
        this.regex = searchString.contains("*");
        if (this.regex) {
            this.searchString = this.searchString.replace(".", "\\.");
            this.searchString = this.searchString.replace("*", ".*");
            this.pat = Pattern.compile(this.searchString);
        }
        this.patternComments = Pattern.compile(".*" + this.searchString + ".*");
        this.hierarchy = new ArrayList();
        Iterator<DataColumn> rootIter = ds.rootColumn.getSubColumns();
        while (rootIter.hasNext()) {
            RootColumn currSubRoot = (RootColumn)rootIter.next();
            Iterator<DataColumn> iter = currSubRoot.getSubColumns();
            while (iter.hasNext()) {
                DataColumn dc = iter.next();
                dc.noofTimesResultSelected = 0;
                this.hierarchy.add(dc.name);
                this.searchSubColumns(dc);
                this.searchColumn(dc);
                this.hierarchy.remove(dc.name);
            }
            currSubRoot.noofTimesResultSelected = 0;
            this.hierarchy.add(currSubRoot.name);
            this.searchSubColumns(currSubRoot);
            this.searchColumn(currSubRoot);
            this.hierarchy.remove(currSubRoot.name);
        }
        this.hierarchy = null;
        return FOUND;
    }

    private void searchColumn(TreeNode node) {
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                DataColumn p = (DataColumn)n;
                p.noofTimesResultSelected = 0;
                try {
                    this.hierarchy.add(p.name);
                }
                catch (NoSuchElementException E) {
                    System.out.println("No Element exception\n");
                }
                if (n instanceof EventColumn) {
                    this.searchEvents((EventColumn)n);
                } else if (n instanceof ZoneColumn) {
                    this.searchBlocks((ZoneColumn)n);
                } else if (n instanceof RangeColumn) {
                    this.searchRanges((RangeColumn)n);
                } else if (n instanceof SequenceColumn) {
                    this.searchSequences((SequenceColumn)n);
                } else if (n instanceof ChronColumn) {
                    this.searchChrons((ChronColumn)n);
                } else if (n instanceof FaciesColumn) {
                    this.searchFacies((FaciesColumn)n);
                }
                this.searchSubColumns(p);
                this.searchColumn(n);
                this.hierarchy.remove(p.name);
            }
        }
    }

    private void searchEvents(EventColumn event) {
        Iterator iter = event.getData();
        while (iter.hasNext()) {
            Searchpoint s;
            Datapoint p = (Datapoint)iter.next();
            String presEvent = p.label.toLowerCase();
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            ArrayList<String> matchedSynonyms = null;
            if (p.synonyms != null) {
                matchedSynonyms = this.searchSynonyms(p.synonyms);
            }
            if (this.regex) {
                this.searchSubWords(p.label.toLowerCase());
                if (!this.mat.matches() && !foundInComments && matchedSynonyms == null) continue;
                if (this.eventResults == null) {
                    this.eventResults = new ArrayList();
                }
                s = new Searchpoint(p, this.hierarchy);
                this.appendEvent(p.label, s, matchedSynonyms);
                FOUND = true;
                continue;
            }
            if (!presEvent.equalsIgnoreCase(this.searchString) && !presEvent.contains(" " + this.searchString + " ") && !presEvent.contains(" " + this.searchString + ",") && !presEvent.startsWith(this.searchString + " ") && !presEvent.startsWith(this.searchString + ",") && !presEvent.endsWith(" " + this.searchString) && !foundInComments && matchedSynonyms == null) continue;
            if (this.eventResults == null) {
                this.eventResults = new ArrayList();
            }
            s = new Searchpoint(p, this.hierarchy);
            this.appendEvent(p.label, s, matchedSynonyms);
            FOUND = true;
        }
    }

    private void searchBlocks(ZoneColumn block) {
        String previousBlock = null;
        Double previousAge = 0.0;
        Iterator iter = block.getData();
        while (iter.hasNext()) {
            ZoneColumn.ZCDatapoint p = (ZoneColumn.ZCDatapoint)iter.next();
            String presBlock = null;
            try {
                presBlock = p.label.toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            if (p.label != null) {
                Searchpoint s;
                if (this.regex) {
                    this.searchSubWords(p.label.toLowerCase());
                    if (this.mat.matches() || foundInComments) {
                        if (this.blockResults == null) {
                            this.blockResults = new ArrayList();
                        }
                        s = BlockResults.getBlockpoint(p, this.hierarchy, previousAge, previousBlock);
                        this.appendBlock(p.label, s);
                        FOUND = true;
                    }
                } else if (presBlock.equalsIgnoreCase(this.searchString) || presBlock.contains(" " + this.searchString + " ") || presBlock.contains(" " + this.searchString + ",") || presBlock.startsWith(this.searchString + " ") || presBlock.startsWith(this.searchString + ",") || presBlock.endsWith(" " + this.searchString) || foundInComments) {
                    if (this.blockResults == null) {
                        this.blockResults = new ArrayList();
                    }
                    s = BlockResults.getBlockpoint(p, this.hierarchy, previousAge, previousBlock);
                    this.appendBlock(p.label, s);
                    FOUND = true;
                }
            }
            previousBlock = "[Next Higher Unit = " + p.label + " at " + p.baseAge + " ] ";
            previousAge = p.baseAge;
        }
    }

    private void searchRanges(RangeColumn range) {
        Iterator iter = range.getData();
        while (iter.hasNext()) {
            Searchpoint s;
            RangeColumn.RCDatapoint p = (RangeColumn.RCDatapoint)iter.next();
            String presRange = p.label.toLowerCase();
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            if (this.regex) {
                this.searchSubWords(p.label.toLowerCase());
                if (!this.mat.matches() && !foundInComments) continue;
                if (this.rangeResults == null) {
                    this.rangeResults = new ArrayList();
                }
                s = new Searchpoint(p, this.hierarchy);
                s.Qualifier = p.type != null ? p.type : "TOP";
                this.appendRange(p.label, s);
                FOUND = true;
                continue;
            }
            if (!presRange.equalsIgnoreCase(this.searchString) && !presRange.contains(" " + this.searchString + " ") && !presRange.contains(" " + this.searchString + ",") && !presRange.startsWith(this.searchString + " ") && !presRange.startsWith(this.searchString + ",") && !presRange.endsWith(" " + this.searchString) && !foundInComments) continue;
            if (this.rangeResults == null) {
                this.rangeResults = new ArrayList();
            }
            s = new Searchpoint(p, this.hierarchy);
            s.Qualifier = p.type != null ? p.type : "TOP";
            this.appendRange(p.label, s);
            FOUND = true;
        }
    }

    private void searchSequences(SequenceColumn sequence) {
        String previousSeq = "[Next Higher Sequence = TOP at 0.00] ";
        Double previousAge = 0.0;
        Iterator iter = sequence.getData();
        while (iter.hasNext()) {
            Searchpoint sNext;
            String Seq;
            Searchpoint s;
            Datapoint p = (Datapoint)iter.next();
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            if (p.label == null) continue;
            String presSeq = p.label.toLowerCase();
            if (this.regex) {
                this.searchSubWords(p.label.toLowerCase());
                if (this.mat.matches() || foundInComments) {
                    if (this.seqResults == null) {
                        this.seqResults = new ArrayList();
                    }
                    s = SeqResults.getSeqpoint(p, this.hierarchy, previousAge, previousSeq);
                    Seq = p.label;
                    sNext = null;
                    if (iter.hasNext()) {
                        p = (Datapoint)iter.next();
                        p.label = Seq;
                        sNext = SeqResults.getSeqpoint(p, this.hierarchy, previousAge, previousSeq);
                        p.label = null;
                    }
                    this.appendSequencenNext(Seq, s, sNext);
                    FOUND = true;
                }
            } else if (presSeq.equalsIgnoreCase(this.searchString) || presSeq.contains(" " + this.searchString + " ") || presSeq.contains(" " + this.searchString + ",") || presSeq.startsWith(this.searchString + " ") || presSeq.startsWith(this.searchString + ",") || presSeq.endsWith(" " + this.searchString) || foundInComments) {
                if (this.seqResults == null) {
                    this.seqResults = new ArrayList();
                }
                s = SeqResults.getSeqpoint(p, this.hierarchy, previousAge, previousSeq);
                Seq = p.label;
                sNext = null;
                if (iter.hasNext()) {
                    p = (Datapoint)iter.next();
                    p.label = Seq;
                    sNext = SeqResults.getSeqpoint(p, this.hierarchy, previousAge, previousSeq);
                    p.label = null;
                }
                this.appendSequencenNext(Seq, s, sNext);
                FOUND = true;
            }
            previousSeq = "[Next Higher Sequence = " + p.label + " at " + p.baseAge + " ] ";
            previousAge = p.baseAge;
        }
    }

    private void searchChrons(ChronColumn chron) {
        String previousChron = "[Next Higher Chron = TOP at 0.00] ";
        Double previousAge = 0.0;
        Iterator iter = chron.getData();
        while (iter.hasNext()) {
            Searchpoint s;
            Datapoint p = (Datapoint)iter.next();
            String presChron = p.label.toLowerCase();
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            if (this.regex) {
                this.searchSubWords(p.label.toLowerCase());
                if (this.mat.matches() || foundInComments) {
                    if (this.chronResults == null) {
                        this.chronResults = new ArrayList();
                    }
                    s = ChronResults.getChronpoint(p, this.hierarchy, previousAge, previousChron);
                    this.appendChron(p.label, s);
                    FOUND = true;
                }
            } else if (presChron.equalsIgnoreCase(this.searchString) || presChron.contains(" " + this.searchString + " ") || presChron.contains(" " + this.searchString + ",") || presChron.startsWith(this.searchString + " ") || presChron.startsWith(this.searchString + ",") || presChron.endsWith(" " + this.searchString) || foundInComments) {
                if (this.chronResults == null) {
                    this.chronResults = new ArrayList();
                }
                s = ChronResults.getChronpoint(p, this.hierarchy, previousAge, previousChron);
                this.appendChron(p.label, s);
                FOUND = true;
            }
            if (p.label == null) continue;
            previousChron = "[Next Higher Unit = " + p.label + " at " + p.baseAge + " ] ";
            previousAge = p.baseAge;
        }
    }

    private void searchFacies(FaciesColumn facie) {
        String previousFacie = "[Next Higher Facie = TOP at 0.00] ";
        Double previousAge = 0.0;
        Iterator iter = facie.getData();
        while (iter.hasNext()) {
            Searchpoint s;
            Datapoint p = (Datapoint)iter.next();
            String presFacie = p.label.toLowerCase();
            boolean foundInComments = false;
            if (searchComments) {
                foundInComments = this.searchCommentsMethod(p.popup);
            }
            if (this.regex) {
                this.searchSubWords(p.label.toLowerCase());
                if (this.mat.matches() || foundInComments) {
                    if (this.facieResults == null) {
                        this.facieResults = new ArrayList();
                    }
                    s = FacieResults.getFaciepoint(p, this.hierarchy, previousAge, previousFacie);
                    this.appendFacie(p.label, s);
                    FOUND = true;
                }
            } else if (presFacie.equalsIgnoreCase(this.searchString) || presFacie.contains(" " + this.searchString + " ") || presFacie.contains(" " + this.searchString + ",") || presFacie.startsWith(this.searchString + " ") || presFacie.startsWith(this.searchString + ",") || presFacie.endsWith(" " + this.searchString) || foundInComments) {
                if (this.facieResults == null) {
                    this.facieResults = new ArrayList();
                }
                s = FacieResults.getFaciepoint(p, this.hierarchy, previousAge, previousFacie);
                this.appendFacie(p.label, s);
                FOUND = true;
            }
            if (p.label == null) continue;
            previousFacie = "[Next Higher Unit = " + p.label + " at " + p.baseAge + " ] ";
            previousAge = p.baseAge;
        }
    }

    private void searchSubColumns(DataColumn dc) {
        Searchpoint s = this.findColumn(dc);
        if (s != null) {
            this.appendColumn(dc.name, s);
        }
    }

    private void searchSubWords(String wholeString) {
        String[] subwords = wholeString.split(" ");
        int lenofArray = subwords.length;
        for (int i = 0; i < lenofArray; ++i) {
            this.mat = this.pat.matcher(subwords[i]);
            if (!this.mat.matches()) continue;
            return;
        }
    }

    private ArrayList<String> searchSynonyms(ArrayList<String> synonyms) {
        Iterator<String> iter = synonyms.iterator();
        int i = 0;
        ArrayList<String> matchedSynonyms = null;
        block0: while (iter.hasNext()) {
            String synonym = iter.next();
            if (this.regex) {
                String[] subwords = synonym.toLowerCase().split(" ");
                int lenofArray = subwords.length;
                for (i = 0; i < lenofArray; ++i) {
                    if (!this.pat.matcher(subwords[i]).matches()) continue;
                    if (matchedSynonyms == null) {
                        matchedSynonyms = new ArrayList();
                    }
                    matchedSynonyms.add(synonym);
                    continue block0;
                }
                continue;
            }
            String synonymLowercase = synonym.toLowerCase();
            if (!synonymLowercase.equals(this.searchString) && !synonymLowercase.contains(this.searchString + " ") && !synonymLowercase.contains(" " + this.searchString + " ") && !synonymLowercase.contains(" " + this.searchString)) continue;
            if (matchedSynonyms == null) {
                matchedSynonyms = new ArrayList<String>();
            }
            matchedSynonyms.add(synonym);
        }
        return matchedSynonyms;
    }

    private Searchpoint findColumn(DataColumn dc) {
        Searchpoint s = null;
        String presColumn = dc.name.toLowerCase();
        boolean foundInComments = false;
        if (searchComments) {
            foundInComments = this.searchCommentsMethod(dc.popup);
        }
        if (this.regex) {
            this.searchSubWords(dc.name.toLowerCase());
            if (this.mat.matches() || foundInComments) {
                if (this.columnResults == null) {
                    this.columnResults = new ArrayList();
                }
                s = new Searchpoint();
                s.vectorHier = new Vector();
                s.vectorHier.add(dc.name);
                Iterator<String> iter = this.hierarchy.iterator();
                s.Hierarchy = "<html><B>Hierarchy-" + dc.name + "</B><br> ";
                while (iter.hasNext()) {
                    s.Hierarchy = s.Hierarchy + "<br>  " + iter.next();
                }
                s.Hierarchy = s.Hierarchy + "</html>";
                FOUND = true;
            }
        } else if (presColumn.equalsIgnoreCase(this.searchString) || presColumn.contains(" " + this.searchString + " ") || presColumn.contains(" " + this.searchString + ",") || presColumn.startsWith(this.searchString + " ") || presColumn.startsWith(this.searchString + ",") || presColumn.endsWith(" " + this.searchString) || foundInComments) {
            if (this.columnResults == null) {
                this.columnResults = new ArrayList();
            }
            s = new Searchpoint();
            s.vectorHier = new Vector();
            s.vectorHier.add(dc.name);
            Iterator<String> iter = this.hierarchy.iterator();
            s.Hierarchy = "<html><B>Hierarchy-" + dc.name + "</B><br> ";
            while (iter.hasNext()) {
                s.Hierarchy = s.Hierarchy + "<br>  " + iter.next();
            }
            s.Hierarchy = s.Hierarchy + "</html>";
            FOUND = true;
        }
        return s;
    }

    private boolean searchCommentsMethod(String comments) {
        boolean foundInComments = false;
        if (comments != null) {
            comments = comments.toLowerCase();
            if (this.regex) {
                this.mat = this.patternComments.matcher(comments);
                if (this.mat.matches()) {
                    foundInComments = true;
                }
            } else if (comments.contains(this.searchString)) {
                foundInComments = true;
            }
        }
        return foundInComments;
    }

    private void appendEvent(String s, Searchpoint sp, ArrayList<String> synonyms) {
        EventResults e2;
        System.out.println("String=" + s);
        System.out.println("SP" + sp);
        if (synonyms != null) {
            System.out.println("Synonyms" + synonyms);
        }
        sp.columnType = "EVENT";
        for (EventResults e2 : this.eventResults) {
            if (!e2.foundString.equalsIgnoreCase(s)) continue;
            e2.event.add(sp);
            return;
        }
        e2 = new EventResults(s);
        e2.event.add(sp);
        e2.Synonyms = synonyms;
        this.eventResults.add(e2);
    }

    private void appendBlock(String s, Searchpoint bsp) {
        BlockResults b2;
        bsp.columnType = "BLOCK";
        for (BlockResults b2 : this.blockResults) {
            if (!b2.foundString.equalsIgnoreCase(s)) continue;
            b2.block.add(bsp);
            return;
        }
        b2 = new BlockResults(s);
        b2.block.add(bsp);
        this.blockResults.add(b2);
    }

    private void appendRange(String s, Searchpoint sp) {
        RangeResults e2;
        sp.columnType = "RANGE";
        for (RangeResults e2 : this.rangeResults) {
            if (!e2.foundString.equalsIgnoreCase(s)) continue;
            e2.range.add(sp);
            return;
        }
        e2 = new RangeResults(s);
        e2.range.add(sp);
        this.rangeResults.add(e2);
    }

    private void appendSequencenNext(String s, Searchpoint sp, Searchpoint spNext) {
        SeqResults b2;
        sp.columnType = "SEQUENCE";
        if (spNext != null) {
            spNext.columnType = "SEQUENCE";
        }
        for (SeqResults b2 : this.seqResults) {
            try {
                if (!b2.foundString.equalsIgnoreCase(s)) continue;
                b2.sequence.add(sp);
                if (spNext != null) {
                    b2.sequence.add(spNext);
                }
                return;
            }
            catch (Exception e) {
                System.out.println("Bug while appending the sequence result");
            }
        }
        b2 = new SeqResults(s);
        b2.sequence.add(sp);
        if (spNext != null) {
            b2.sequence.add(spNext);
        }
        this.seqResults.add(b2);
    }

    private void appendChron(String s, Searchpoint sp) {
        ChronResults e2;
        sp.columnType = "CHRON";
        for (ChronResults e2 : this.chronResults) {
            if (!e2.foundString.equalsIgnoreCase(s)) continue;
            e2.chron.get((int)0).Qualifier = "Contains Multiple Chrons";
            return;
        }
        e2 = new ChronResults(s);
        e2.chron.add(sp);
        this.chronResults.add(e2);
    }

    private void appendFacie(String s, Searchpoint sp) {
        FacieResults e2;
        sp.columnType = "FACIE";
        for (FacieResults e2 : this.facieResults) {
            if (!e2.foundString.equalsIgnoreCase(s)) continue;
            e2.facie.add(sp);
            return;
        }
        e2 = new FacieResults(s);
        e2.facie.add(sp);
        this.facieResults.add(e2);
    }

    private void appendColumn(String s, Searchpoint sp) {
        ColumnResults e2;
        sp.columnType = "SUBCOLUMN";
        for (ColumnResults e2 : this.columnResults) {
            if (!e2.foundString.equalsIgnoreCase(s)) continue;
            e2.column.add(sp);
            return;
        }
        e2 = new ColumnResults(s);
        e2.column.add(sp);
        this.columnResults.add(e2);
    }

    private void clearPreviousResults() {
        if (this.eventResults != null) {
            this.eventResults.clear();
        }
        if (this.blockResults != null) {
            this.blockResults.clear();
        }
        if (this.rangeResults != null) {
            this.rangeResults.clear();
        }
        if (this.seqResults != null) {
            this.seqResults.clear();
        }
        if (this.chronResults != null) {
            this.chronResults.clear();
        }
        if (this.facieResults != null) {
            this.facieResults.clear();
        }
        if (this.columnResults != null) {
            this.columnResults.clear();
        }
        if (this.hierarchy != null) {
            this.hierarchy.clear();
        }
        FOUND = false;
        Searchpoint.lowerAgetoChart = Double.NEGATIVE_INFINITY;
        Searchpoint.upperAgetoChart = Double.POSITIVE_INFINITY;
    }
}

