/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ErrorHandler;
import gui.TSCPopup;
import gui.TSCSVGCanvas;
import gui.TSCreator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class TSCSVGUserAgent
implements SVGUserAgent {
    protected TSCSVGCanvas canvas;
    Vector popups = new Vector();

    public void setCanvas(TSCSVGCanvas myCanvas) {
        this.canvas = myCanvas;
    }

    public void killpopups() {
        Iterator iter = this.popups.iterator();
        while (iter.hasNext()) {
            TSCPopup popup = (TSCPopup)iter.next();
            if (!popup.killme()) continue;
            iter.remove();
        }
    }

    @Override
    public void displayError(String message) {
        ErrorHandler.log(message, 3);
    }

    @Override
    public void displayError(Exception ex) {
        ErrorHandler.printException(ex);
    }

    @Override
    public void displayMessage(String message) {
        ErrorHandler.log("msg: " + message);
    }

    @Override
    public void showAlert(String message) {
        this.killpopups();
        String popupID = message;
        SVGDocument doc = this.canvas.getSVGDocument();
        Element popupE = doc.getElementById(popupID);
        String text = null;
        String docbase = null;
        if (popupE != null) {
            text = popupE.getAttribute("popuptext");
            docbase = popupE.getAttribute("docbase");
        }
        TSCPopup popup = new TSCPopup(TSCreator.tscFrame, text, docbase);
        this.popups.add(popup);
        if (this.canvas != null) {
            popup.setLocation(this.canvas.mouseX, this.canvas.mouseY);
        }
        popup.setVisible(true);
    }

    @Override
    public String showPrompt(String message) {
        ErrorHandler.log("prompt: " + message);
        return "";
    }

    @Override
    public String showPrompt(String message, String defaultValue) {
        ErrorHandler.log("prompt: " + message);
        return defaultValue;
    }

    @Override
    public boolean showConfirm(String message) {
        System.out.println("confirm: " + message);
        return true;
    }

    @Override
    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    @Override
    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    @Override
    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    @Override
    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    @Override
    public float getLighterFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 100.0f;
            }
            case 200: {
                return 100.0f;
            }
            case 300: {
                return 200.0f;
            }
            case 400: {
                return 300.0f;
            }
            case 500: {
                return 400.0f;
            }
            case 600: {
                return 400.0f;
            }
            case 700: {
                return 400.0f;
            }
            case 800: {
                return 400.0f;
            }
            case 900: {
                return 400.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    @Override
    public float getBolderFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 600.0f;
            }
            case 200: {
                return 600.0f;
            }
            case 300: {
                return 600.0f;
            }
            case 400: {
                return 600.0f;
            }
            case 500: {
                return 600.0f;
            }
            case 600: {
                return 700.0f;
            }
            case 700: {
                return 800.0f;
            }
            case 800: {
                return 900.0f;
            }
            case 900: {
                return 900.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    @Override
    public String getLanguages() {
        return "en";
    }

    @Override
    public String getUserStyleSheetURI() {
        return null;
    }

    @Override
    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    @Override
    public boolean isXMLParserValidating() {
        return false;
    }

    @Override
    public String getMedia() {
        return "screen";
    }

    @Override
    public String getAlternateStyleSheet() {
        return null;
    }

    @Override
    public void openLink(String uri, boolean newc) {
    }

    @Override
    public boolean supportExtension(String s) {
        return false;
    }

    @Override
    public void handleElement(Element elt, Object data) {
    }

    @Override
    public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
        return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
    }

    @Override
    public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
        ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
        if (s != null) {
            s.checkLoadScript();
        }
    }

    @Override
    public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
        return new RelaxedExternalResourceSecurity(resourceURL, docURL);
    }

    @Override
    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
        if (s != null) {
            s.checkLoadExternalResource();
        }
    }
}

