/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import datastore.Datapoint;
import datastore.Unit;
import gui.TSCreator;
import gui.settings.TimesPanel;
import util.NumberUtils;
import util.Util;

public class SelectedTimes {
    public double topAge = 0.0;
    public double baseAge = 0.0;
    public double vertScale = 1.0;
    public boolean skipEmptyColumns = true;
    public boolean isValid = false;
    public String error = "";

    public static double getVertScale(TimesPanel tp) {
        String s = tp.unitsPerMaTF.getText();
        String vertScale = s.contains(",") ? s.replace(",", ".") : s;
        return Util.parseDouble(vertScale, 1.0);
    }

    public SelectedTimes() {
        this.topAge = Double.NaN;
        this.baseAge = Double.NaN;
    }

    public SelectedTimes(TimesPanel tp, boolean updateTexts) {
        this.setToTP(tp, updateTexts);
    }

    public final void setToTP(TimesPanel tp, boolean updateTexts) {
        String s;
        Datapoint p;
        this.isValid = true;
        if (TSCreator.autoGenOptions == null) {
            if (tp.topStageRadio.isSelected()) {
                p = (Datapoint)tp.topStage.getSelectedItem();
                if (p == null) {
                    this.isValid = false;
                    this.error = "Unable to get top age from combo box.";
                } else {
                    this.topAge = p.baseAge;
                }
            } else if (tp.topMYRadio.isSelected()) {
                s = tp.topMY.getText();
                String newTop = s.contains(",") ? s.replace(",", ".") : s;
                try {
                    this.topAge = Double.parseDouble(newTop);
                }
                catch (NumberFormatException e) {
                    this.isValid = false;
                    this.error = newTop.length() == 0 ? "Top age not specified." : "Top age is invalid.";
                }
                if (!tp.topMY.hasFocus()) {
                    if (s.contains(",")) {
                        tp.topMY.setText(s);
                    } else {
                        tp.topMY.setText(new Double(this.topAge).toString());
                    }
                }
            } else if (TSCreator.autoSaveFile == null) {
                this.isValid = false;
                this.error = "Top age not specified.";
            }
        }
        if (TSCreator.autoGenOptions == null) {
            if (tp.baseStageRadio.isSelected()) {
                p = (Datapoint)tp.baseStage.getSelectedItem();
                if (p == null) {
                    this.isValid = false;
                    this.error = "Unable to get base age from combo box.";
                } else {
                    this.baseAge = p.baseAge;
                }
            } else if (tp.baseMYRadio.isSelected()) {
                s = tp.baseMY.getText();
                String newBase = s.contains(",") ? s.replace(",", ".") : s;
                try {
                    this.baseAge = Double.parseDouble(newBase);
                }
                catch (NumberFormatException e) {
                    this.isValid = false;
                    this.error = newBase.length() == 0 ? "Base age not specified." : "Base age is invalid.";
                }
                if (!tp.baseMY.hasFocus()) {
                    if (s.contains(",")) {
                        tp.baseMY.setText(s);
                    } else {
                        tp.baseMY.setText(new Double(this.baseAge).toString());
                    }
                }
            } else if (TSCreator.autoSaveFile == null) {
                this.isValid = false;
                this.error = "Base age not specified.";
            }
        }
        if (!tp.unit.isNegated() && this.topAge > this.baseAge || tp.unit.isNegated() && this.topAge < this.baseAge) {
            this.isValid = false;
            this.error = "Base age must be older than top age!";
        }
        this.skipEmptyColumns = tp.skipEmptyColumnsCheck.isSelected();
        s = tp.unitsPerMaTF.getText();
        String newvertScale = s.contains(",") ? s.replace(",", ".") : s;
        this.vertScale = Util.parseDouble(newvertScale, this.vertScale);
        if (this.vertScale < 0.001) {
            this.isValid = false;
            this.error = "vertical scale must be equal to or larger than 0.001!";
            this.vertScale = 0.001;
        }
        if (!tp.unitsPerMaTF.hasFocus()) {
            if (s.contains(",")) {
                tp.unitsPerMaTF.setText(s);
            } else {
                tp.unitsPerMaTF.setText(NumberUtils.formatDouble(this.vertScale));
            }
        }
    }

    public boolean checkIsValid(Unit u) {
        this.isValid = true;
        if (!u.isNegated() && (this.topAge > this.baseAge || this.topAge < this.baseAge) || u.isNegated() && this.topAge < this.baseAge) {
            this.isValid = false;
            this.error = "Base age must be older than top age!";
        }
        if (this.vertScale <= 0.0) {
            this.isValid = false;
            this.error = "vertical scale must be a positive number!";
        }
        return this.isValid;
    }
}

