/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.FaciesColumn;
import model.ModelIdentifier;
import model.storage.FaciesDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FaciesData
extends Data {
    private ModelIdentifier identifier = null;
    private String label = "";
    private String pattern = "";
    private String seriesLabel = "";
    private String members = "";
    private int linetype;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FaciesData(FaciesColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 11));
    }

    public FaciesData(FaciesColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setIdentifier(id);
        this.setLabel(result.getString("label"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            FaciesDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FaciesDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getSeriesLabel() {
        return this.seriesLabel;
    }

    public void setSeriesLabel(String seriesLabel) {
        this.seriesLabel = seriesLabel;
    }

    public String getMembers() {
        return this.members;
    }

    public void setMembers(String members) {
        this.members = members;
    }

    public int getLineType() {
        return this.linetype;
    }

    public void setLineType(int linetype) {
        this.linetype = linetype;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static FaciesData getByIdentifier(FaciesColumn c, ModelIdentifier id) {
            List<Object> faciesData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            faciesData = Factory.getByIdentifiers(c, ids);
            if (faciesData.isEmpty()) {
                return null;
            }
            return (FaciesData)faciesData.get(0);
        }

        public static List<FaciesData> getByIdentifiers(FaciesColumn c, List<ModelIdentifier> ids) {
            ArrayList<FaciesData> faciesData = new ArrayList<FaciesData>();
            List<SourceResult> results = FaciesDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                faciesData.add(new FaciesData(c, ids.get(i), results.get(i)));
            }
            return faciesData;
        }

        public static List<FaciesData> getByAge(FaciesColumn c, double top, double bottom) {
            List<SourceResult> results = FaciesDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 11);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

