/*
 * Decompiled with CFR 0.152.
 */
package util;

import datastore.DataColumn;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import path.ResPath;
import util.Dater;
import util.Debug;
import util.FileUtils;
import util.JavaVMOptions;
import util.ProgramInfo;

public class HTMLPreprocessor {
    private static Vector<ReplaceRule> replace_rules = new Vector();

    public static String process(String html_filename) {
        return HTMLPreprocessor.process(html_filename, true);
    }

    public static String process(String html_source_or_filename, boolean isFile) {
        String html_source = html_source_or_filename;
        if (isFile) {
            if (!FileUtils.doesFileExist(html_source_or_filename)) {
                Debug.critical("Unable to open HTML file " + html_source_or_filename + "!");
                return "";
            }
            InputStream is = FileUtils.getInputStream(html_source_or_filename);
            if (is == null) {
                Debug.critical("Unable to open html file " + html_source_or_filename);
                return "";
            }
            html_source = FileUtils.readWholeTextFile(is);
        }
        Iterator<ReplaceRule> i = replace_rules.iterator();
        while (i.hasNext()) {
            html_source = i.next().performReplace(html_source);
        }
        return html_source;
    }

    public static URL getGlobalBaseDirectory() {
        try {
            if (JavaVMOptions.isJar()) {
                return new URL("jar:file:" + JavaVMOptions.getJarfile() + "!/" + ResPath.getPath("root.global"));
            }
            return new URL("file:" + ResPath.getPath("root.global"));
        }
        catch (Exception e) {
            Debug.critical("Unable to get URL for global base directory for HTML resources! Exception was: " + e.toString());
            System.exit(1);
            return null;
        }
    }

    public static URL getResourceDirectory() {
        try {
            return new URL(HTMLPreprocessor.getGlobalBaseDirectory().toString() + "resources/");
        }
        catch (Exception e) {
            Debug.critical("Unable to get URL for global base directory for HTML resources! Exception was: " + e.toString());
            System.exit(1);
            return null;
        }
    }

    public static String findAndFixDatapackLinks(String html_source, DataColumn.FileInfo fileInfo) {
        String base_directory = fileInfo.workingDir;
        if (!base_directory.endsWith(File.separator)) {
            base_directory = base_directory + File.separator;
        }
        String[] parts = html_source.split("=");
        for (int i = 1; i < parts.length; ++i) {
            URL url;
            String[] quote_parts;
            if (!parts[i - 1].endsWith("href") && !parts[i - 1].endsWith("src") || (quote_parts = parts[i].split("\"")).length < 3 || FileUtils.isURL(quote_parts[1])) continue;
            String filename = quote_parts[1];
            String new_part = "";
            if (parts[i - 1].endsWith("href")) {
                quote_parts[1] = base_directory + filename;
            } else if (parts[i - 1].endsWith("src") && (url = FileUtils.getAbsoluteImageURL(filename, fileInfo)) != null) {
                quote_parts[1] = url.toString();
            }
            for (int j = 0; j < quote_parts.length; ++j) {
                new_part = new_part + quote_parts[j];
                if (j >= quote_parts.length - 1) continue;
                new_part = new_part + "\"";
            }
            parts[i] = new_part;
        }
        String ret = "";
        for (int i = 0; i < parts.length; ++i) {
            ret = ret + parts[i];
            if (i >= parts.length - 1) continue;
            ret = ret + "=";
        }
        return ret;
    }

    private HTMLPreprocessor() {
    }

    static {
        replace_rules.add(new ReplaceRule("$TSC_VERSION", ProgramInfo.get("TSC_VERSION")));
        if (!ProgramInfo.isPublic()) {
            replace_rules.add(new ReplaceRule("$TSC_LICENSEE_INFO", "Licensed to " + ProgramInfo.get("TSC_LICENSEE") + "<br>website: <a href=\"" + ProgramInfo.get("TSC_WEBSITE_URL") + "\"></a><br>username and password can be found in Help-&gt;Website."));
            replace_rules.add(new ReplaceRule("$TSC_PROGNAME", "TSCreator Pro"));
            replace_rules.add(new ReplaceRule("$TSC_LICENSE_FINE_PRINT", "Under this license agreement TSCreator Pro can be licensed for commercial use at a fee.<br><br>You may not give copies of the Software to others. You must not charge any money for the Software itself or the act of copying the Software. You may not distribute the Software, single or as part of a larger package."));
        } else {
            replace_rules.add(new ReplaceRule("$TSC_LICENSEE_INFO", ""));
            replace_rules.add(new ReplaceRule("$TSC_PROGNAME", "TSCreator"));
            replace_rules.add(new ReplaceRule("$TSC_LICENSE_FINE_PRINT", "Under this license agreement, TSCreator can be used by private persons for purposes that do not generate any income and by registered not-for-profit organizations which are not primarily funded with proceeds from any kind of taxes imposed by a government on its people.<br><br>You may give copies of the Software to others. You must not charge any money for the Software itself or the act of copying the Software."));
        }
        replace_rules.add(new ReplaceRule("$TSC_LOGO", ResPath.getPath("logos.default_tscreator")));
        if (ProgramInfo.get("TSC_ICON_FILENAME").length() == 0) {
            replace_rules.add(new ReplaceRule("$TSC_ICON_IMG_TAG", ""));
        } else {
            replace_rules.add(new ReplaceRule("$TSC_ICON_IMG_TAG", "<img src=\"" + ProgramInfo.get("TSC_ICON_FILENAME") + "\">"));
        }
        if (Dater.doesExpire()) {
            Calendar date = Dater.getExpireDate();
            replace_rules.add(new ReplaceRule("$TSC_EXPIRATION_INFO", "<strong><font color=\"red\">Trial expires " + date.get(1) + "-" + date.get(2) + "-" + date.get(5) + "</font></strong> "));
        } else {
            replace_rules.add(new ReplaceRule("$TSC_EXPIRATION_INFO", ""));
        }
        replace_rules.add(new ReplaceRule("$TSC_NOTICE_TEXT", ProgramInfo.get("TSC_NOTICE_TEXT")));
        replace_rules.add(new ReplaceRule("$CUR_YEAR", new SimpleDateFormat("yyyy").format(new Date())));
        replace_rules.add(new ReplaceRule("$RESOURCES_HTML_BASEDIR", ResPath.getPath("basedir.resources_html")));
        replace_rules.add(new ReplaceRule("$FEATURES_SUMMARY_IMAGES_BASEDIR", ResPath.getPath("basedir.features_summary_images")));
        replace_rules.add(new ReplaceRule("$FILE_FORMAT_GUIDE_IMAGES_BASEDIR", ResPath.getPath("basedir.file_format_images")));
    }

    private static class ReplaceRule {
        private String pattern = "";
        private String replace_with = "";

        public ReplaceRule(String pattern_param, String replace_with_param) {
            this.pattern = pattern_param;
            this.replace_with = replace_with_param;
        }

        public String performReplace(String input) {
            return input.replace(this.pattern, this.replace_with);
        }
    }
}

