var lMouseDragging = true;
var hideTimeLine = false;
var X1 = 0;
var Y1 = 0;
var X2 = 0;
var Y2 = 0;

var SVGDoc = null;
var SVGRoot = null;
var SVGViewBox = null;

function Init(evt) {
    SVGDoc = evt.target.ownerDocument;
    SVGRoot = SVGDoc.documentElement;

    SVGRoot.addEventListener('click', mouseClicked, false);
    SVGRoot.addEventListener('mousemove', mouseMove, false);
    SVGRoot.addEventListener('keypress', keyPressed, false);
    if(typeof(top) !== "undefined")
        browserFix();
}

function keyPressed(evt) {
    var chCode = evt.charCode? evt.charCode : evt.keyCode;
    if (chCode == 72 || chCode == 104) {
        hideTimeLine = !hideTimeLine;
        hideLine();
    }
}

function mouseClicked(evt) {
    lMouseDragging = !lMouseDragging;
}

function mouseMove(evt) { 
    var p = document.documentElement.createSVGPoint();
    evt = evt || window.event;
    p.x = evt.clientX;
    p.y = evt.clientY;
    try {
        if (evt.pageX || evt.pageY) {
            p.x = evt.pageX;
            p.y = evt.pageY;
        }
        else{
            p.x = evt.clientX + (document.documentElement.scrollLeft + document.body.scrollLeft);
            p.y = e.clientY + (document.documentElement.scrollTop + document.body.scrollTop);
        }
    }
    catch (e){}
 
    var timeLine = document.getElementById("timeline");
    var timeLineUp = document.getElementById("timeline_up");
    var timeLineDown = document.getElementById("timeline_down");
    var timeLabel = document.getElementById("TimeLineLabel");

    if (timeLine && timeLabel) {
        var m = timeLine.getScreenCTM();
        var scale = parseFloat(timeLine.getAttribute("vertScale"));
        p = p.matrixTransform(m.inverse());
        var indicatorLineWidth = 10;
        if (lMouseDragging){
            if (timeLine){
                var minY = Number(timeLine.getAttribute("minY"));
                var maxY = Number(timeLine.getAttribute("maxY"));
                if (p.y > minY) {
                    minY = p.y;
                }
                if (minY > maxY) {
                    minY = maxY
                }
                
                timeLine.setAttribute("y1", minY);
                timeLine.setAttribute("y2", minY);
                
                // This sets the attributes for the indicators for one unit up and down
                // p.x and minY are where the mouse currently is
                // This is when timeline is floating
                
                timeLineUp.setAttribute("y1", minY - scale);
                timeLineUp.setAttribute("y2", minY - scale);
                timeLineUp.setAttribute("x1", p.x - indicatorLineWidth / 2);
                timeLineUp.setAttribute("x2", p.x + indicatorLineWidth / 2);
                
                timeLineDown.setAttribute("y1", minY + scale);
                timeLineDown.setAttribute("y2", minY + scale);
                timeLineDown.setAttribute("x1", p.x - indicatorLineWidth / 2);
                timeLineDown.setAttribute("x2", p.x + indicatorLineWidth / 2);
            }
        }
        else {
        	if (timeLine){
            	var minY = Number(timeLine.getAttribute("minY"));
            	var maxY = Number(timeLine.getAttribute("maxY"));
            	if (p.y > minY) {
                	minY = p.y;
            	}
            	if (minY > maxY) {
                	minY = maxY
            	}
                            
            	// This sets the attributes for the indicators for one unit up and down
            	// p.x and minY are where the mouse currently is
            	// This is for when timeline is locked

            	timeLineUp.setAttribute("x1", p.x - indicatorLineWidth / 2);
            	timeLineUp.setAttribute("x2", p.x + indicatorLineWidth / 2);
                
            	timeLineDown.setAttribute("x1", p.x - indicatorLineWidth / 2);
            	timeLineDown.setAttribute("x2", p.x + indicatorLineWidth / 2);
        	}
        }
    }
    
    if (timeLabel) {
        var y = parseInt(timeLine.getAttribute("y1"));
        showCurrAge(p.x,y,evt);
    }
}

function showCurrAge(x,y,evt) {
    var timeLine = document.getElementById("timeline");
    var timeLabel = document.getElementById("TimeLineLabel");
    var timeLabelUp = document.getElementById("TimeLineLabelUp");
    var timeLabelDown = document.getElementById("TimeLineLabelDown");
    
    if(timeLabel && timeLine) {
        var minY = parseFloat(timeLine.getAttribute("minY"));
        var scale = parseFloat(timeLine.getAttribute("vertScale"));
        var topAge = parseFloat(timeLine.getAttribute("topAge"));
        var currY = minY;
        if (y > minY){
            currY = y;
        }
        var currAge = topAge + ((currY - minY)/scale);
        
        timeLabel.setAttribute("x", x + 12);
        timeLabel.setAttribute("y", currY - 5);
        timeLabel.firstChild.nodeValue = Math.round(currAge*1000)/1000;
        
        timeLabelUp.setAttribute("x", x - 25);
        timeLabelUp.setAttribute("y", currY - scale + 4.5);
        timeLabelUp.firstChild.nodeValue = -1;
        
        timeLabelDown.setAttribute("x", x - 21);
        timeLabelDown.setAttribute("y", currY + scale + 4.5);
        timeLabelDown.firstChild.nodeValue = +1;
    }
}

function hideLine() {
    var timeLine = document.getElementById("timeline");
	var timeLineUp = document.getElementById("timeline_up");
	var timeLineDown = document.getElementById("timeline_down");
	
    var timeLabel = document.getElementById("TimeLineLabel");
    var timeLabelUp = document.getElementById("TimeLineLabelUp");
    var timeLabelDown = document.getElementById("TimeLineLabelDown");
    
    timeLabel.setAttributeNS(null, "visibility", "visible");
    timeLabelUp.setAttributeNS(null, "visibility", "visible");
    timeLabelDown.setAttributeNS(null, "visibility", "visible");
    
    if (timeLine && timeLabel) {
        timeLine.setAttribute("style", hideTimeLine ? "stroke-opacity: 0;" : "stroke: red; stroke-opacity: 0.5;");
        timeLineUp.setAttribute("style", hideTimeLine ? "stroke-opacity: 0;" : "stroke: red; stroke-opacity: 0.5;");
        timeLineDown.setAttribute("style", hideTimeLine ? "stroke-opacity: 0;" : "stroke: red; stroke-opacity: 0.5;");
        timeLabel.setAttribute("style", hideTimeLine ? "fill-opacity: 0;" : "font-size: 10; fill: red; fill-opacity: 0.7;");
        timeLabelUp.setAttribute("style", hideTimeLine ? "fill-opacity: 0;" : "font-size: 10; fill: red; fill-opacity: 0.7;");
        timeLabelDown.setAttribute("style", hideTimeLine ? "fill-opacity: 0;" : "font-size: 10; fill: red; fill-opacity: 0.7;");
    }
}