/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.DataColumn;
import datastore.Datapoint;
import datastore.RulerColumn;
import gui.ImageGenerator;
import gui.Language;
import gui.LinkProcessor;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AgeAgeColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public static final String CERTAIN_STROKE = "stroke-width: 1; stroke: black;";
    public static final String UNCERTAIN_STROKE = "stroke-width: 1; stroke: black; stroke-dasharray:3,3;";
    public static final int NONE = 0;
    public static final int ARAR = 1;
    public static final String ARAR_STYLE = "stroke-width: 0.5; stroke: blue; ";
    public static final int UPB = 2;
    public static final String UPB_STYLE = "stroke-width: 0; fill: red; ";
    public static final int OTHER = 3;
    public static final String OTHER_STYLE = "stroke-width: 0; fill: black; ";
    public static final double CENTER_RADIUS = 2.5;
    public boolean drawAxis = true;
    public RulerColumn axisCol = null;
    public double axisHeight = 0.0;

    public AgeAgeColumn(String colName) {
        super(colName);
        this.setWidth(60.0);
        this.axisCol = new RulerColumn("");
        this.axisCol.drawTitle = false;
        this.axisCol.transposed = true;
        this.axisCol.fonts.setParent(this.fonts);
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            JCheckBox showAxisCB = new JCheckBox(Language.translate("Show Age scale on top", true));
            showAxisCB.setSelected(this.drawAxis);
            this.optionsPanel.add(showAxisCB);
            showAxisCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    AgeAgeColumn.this.drawAxis = ((JCheckBox)ie.getItem()).isSelected();
                }
            });
            this.optionsPanel.add(new JLabel("<html>" + Language.translate("Note: Column width will be the same as diagram height.", true) + "</html>"));
        }
        return this.optionsPanel;
    }

    @Override
    public double getMyWidth() {
        return 100.0;
    }

    @Override
    public double getWidth(Settings settings, ImageGenerator ig, double dataHeight) {
        this.myWidth = (settings.baseAge - settings.topAge) * settings.unitsPerMY;
        if (this.myWidth < 20.0) {
            this.myWidth = 20.0;
        }
        return this.myWidth;
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        if (this.drawAxis) {
            this.axisHeight = this.axisCol.getWidth(settings, ig, 0.0);
            this.myOwnHeaderHeight += this.axisHeight;
        } else {
            this.axisHeight = 0.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        if (this.name.length() > 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double wrapSize = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double wrapSize2 = wrapSize;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (wrapSize > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(wrapSize);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)wrapSize);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    wrapSize -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty, width, height - this.axisHeight, 3);
            wrapSize = wrapSize2;
            myWrapHolder.setSize(wrapSize);
        }
        if (this.drawAxis) {
            this.axisCol.drawData(ig, startx, starty + height - this.axisHeight, width, this.axisHeight, settings);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    @Override
    public SortedSet negateAges() {
        return this.data;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            AgeAgeDatapoint p = (AgeAgeDatapoint)iter.next();
            if (settings.isAbove(p.baseAge)) continue;
            if (settings.isBelow(p.baseAge)) break;
            this.drawItem(ig, startx, starty, width, height, settings, p);
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    protected void drawItem(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, AgeAgeDatapoint item) {
        double ageX = (item.age - settings.topAge) * settings.unitsPerMY;
        double ageY = (item.chronAge - settings.topAge) * settings.unitsPerMY;
        double left = startx + ageX - item.xErrorLeft * settings.unitsPerMY;
        double right = startx + ageX + item.xErrorRight * settings.unitsPerMY;
        double top = starty + (item.yErrorUp - settings.topAge) * settings.unitsPerMY;
        double bottom = starty + (item.yErrorDown - settings.topAge) * settings.unitsPerMY;
        boolean showLeft = true;
        boolean showRight = true;
        boolean showTop = true;
        boolean showBottom = true;
        ageX += startx;
        ageY += starty;
        if (left < startx) {
            showLeft = false;
            left = startx;
        }
        if (right > width + startx) {
            showRight = false;
            right = width + startx;
        }
        if (top < starty) {
            showTop = false;
            top = starty;
        }
        if (bottom > height + starty) {
            showBottom = false;
            bottom = height + starty;
        }
        if (ageX - 2.5 > startx && ageX + 2.5 < width + startx && ageY - 2.5 > starty && ageY + 2.5 < height + starty) {
            switch (item.pointType) {
                case 1: {
                    ig.drawLine(ageX - 2.5, ageY - 2.5, ageX + 2.5, ageY + 2.5, ARAR_STYLE);
                    ig.drawLine(ageX - 2.5, ageY + 2.5, ageX + 2.5, ageY - 2.5, ARAR_STYLE);
                    break;
                }
                case 2: {
                    ig.drawCircle(ageX, ageY, 2.5, UPB_STYLE);
                    break;
                }
                case 3: {
                    double[] x = new double[3];
                    double[] y = new double[3];
                    x[0] = ageX;
                    x[1] = ageX + 2.165;
                    x[2] = ageX + -2.165;
                    y[0] = ageY - 2.5;
                    y[1] = y[2] = ageY + 1.25;
                    ig.drawPolygon(x, y, OTHER_STYLE);
                }
            }
        }
        if (showLeft) {
            ig.drawLine(left, top, left, bottom, item.xErrorLeftQ ? UNCERTAIN_STROKE : CERTAIN_STROKE);
        }
        if (showRight) {
            ig.drawLine(right, top, right, bottom, item.xErrorRightQ ? UNCERTAIN_STROKE : CERTAIN_STROKE);
        }
        if (showTop) {
            ig.drawLine(left, top, right, top, item.yErrorUpQ ? UNCERTAIN_STROKE : CERTAIN_STROKE);
        }
        if (showBottom) {
            ig.drawLine(left, bottom, right, bottom, item.yErrorDownQ ? UNCERTAIN_STROKE : CERTAIN_STROKE);
        }
        if (item.label != null) {
            // empty if block
        }
        if (item.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(item.popup, this.fileInfo);
            ig.drawRect(left, top, right - left, bottom - top, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String nameAttr = setting.getAttribute("name");
        if (nameAttr != null && nameAttr.compareToIgnoreCase("drawWidthAgeAxisLabels") == 0) {
            this.drawAxis = Boolean.valueOf(Settings.getNodeTextContent(setting));
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        element.appendChild(Settings.createSimpleSetting(doc, "drawWidthAgeAxisLabels", "" + this.drawAxis));
    }

    public static class AgeAgeDatapoint
    extends Datapoint {
        public double chronAge;
        public double age;
        public double xErrorLeft;
        public boolean xErrorLeftQ = false;
        public double xErrorRight;
        public boolean xErrorRightQ = false;
        public double yErrorUp;
        public boolean yErrorUpQ = false;
        public double yErrorDown;
        public boolean yErrorDownQ = false;
        public int pointType;
    }
}

