/*
 * Decompiled with CFR 0.152.
 */
package datastore.rasc;

import datastore.loader.DatLoader;
import datastore.loader.DepLoader;
import datastore.loader.ParseException;
import datastore.rasc.DatData;
import datastore.rasc.DictionaryData;
import datastore.rasc.Document;
import gui.ErrorHandler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class LoaderRASC {
    public static int TITLE_LINE = 0;
    public static int FINISHED_LINE = -99999;

    public static void load(Document doc, String filename) {
        FileInputStream fis;
        Exception e = null;
        try {
            fis = new FileInputStream(LoaderRASC.changeExtension(filename, "DIC"));
            LoaderRASC.loadDIC(doc.dic, new LineNumberReader(new InputStreamReader(fis)));
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            ErrorHandler.showError(e, "NOTE THAT ALL THE FILES MUST HAVE THE SAME NAME AS THE .DAT FILE AND ONLY DIFFER BY THE 3 LETTER EXTENSION.", "There was an error loading the DIC file", 3);
        }
        e = null;
        try {
            fis = new FileInputStream(LoaderRASC.changeExtension(filename, "INP"));
            LoaderRASC.loadINP(doc, new LineNumberReader(new InputStreamReader(fis)));
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            ErrorHandler.showError(e, "NOTE THAT ALL THE FILES MUST HAVE THE SAME NAME AS THE .DAT FILE AND ONLY DIFFER BY THE 3 LETTER EXTENSION.", "There was an error loading the INP file", 3);
        }
        e = null;
        try {
            fis = new FileInputStream(LoaderRASC.changeExtension(filename, "DAT"));
            new DatLoader(fis).parseDat(doc.sec);
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (ParseException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            ErrorHandler.showError(e, null, "There was an error loading the INP file", 3);
        }
        e = null;
        try {
            fis = new FileInputStream(LoaderRASC.changeExtension(filename, "DEP"));
            new DepLoader(fis).parseDep(doc.sec);
        }
        catch (FileNotFoundException ex) {
            e = ex;
        }
        catch (ParseException ex) {
            e = ex;
        }
        catch (Exception ex) {
            e = ex;
        }
        if (e != null) {
            ErrorHandler.showError(e, "NOTE THAT ALL THE FILES MUST HAVE THE SAME NAME AS THE .DAT FILE AND ONLY DIFFER BY THE 3 LETTER EXTENSION.", "There was an error loading the DEP file", 3);
        }
    }

    public static String changeExtension(String filename, String ext) {
        return filename.substring(0, filename.length() - 3) + ext;
    }

    public static void loadDIC(DictionaryData data, LineNumberReader r) {
        int lineNum = 0;
        try {
            String line = r.readLine();
            while (line != null && (line = line.trim()).compareToIgnoreCase("LAST") != 0) {
                int id = -1;
                int cutPoint = line.lastIndexOf(32);
                if (cutPoint > 0) {
                    String sid = line.substring(cutPoint + 1);
                    try {
                        id = Integer.parseInt(sid);
                    }
                    catch (NumberFormatException e) {
                        id = -1;
                        cutPoint = line.length();
                    }
                } else {
                    cutPoint = line.length();
                }
                if (id == -1) {
                    id = lineNum + 1;
                }
                String name = line.substring(0, cutPoint).trim();
                data.set(lineNum++, name, id);
                line = r.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadINP(Document doc, LineNumberReader r) {
        String sub;
        String header = "";
        String ue = "";
        String mh = "";
        try {
            header = r.readLine();
            try {
                ue = r.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                mh = r.readLine();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            return;
        }
        if (header.length() < 12) {
            return;
        }
        try {
            doc.wellCutoff = Integer.parseInt(header.substring(2, 4).trim());
        }
        catch (NumberFormatException e) {
            doc.wellCutoff = 6;
        }
        try {
            doc.indicator1 = Integer.parseInt(header.substring(4, 6).trim());
        }
        catch (NumberFormatException e) {
            doc.indicator1 = 1;
        }
        try {
            doc.indicator2 = Integer.parseInt(header.substring(6, 8).trim());
        }
        catch (NumberFormatException e) {
            doc.indicator2 = 1;
        }
        try {
            doc.indicator3 = Integer.parseInt(header.substring(8, 10).trim());
        }
        catch (NumberFormatException e) {
            doc.indicator3 = 1;
        }
        try {
            doc.pairCutoff = Integer.parseInt(header.substring(10, 12).trim());
        }
        catch (NumberFormatException e) {
            doc.pairCutoff = 3;
        }
        int i = 0;
        while (ue.length() >= i * 4 + 4) {
            sub = ue.substring(i * 4, i * 4 + 4);
            try {
                doc.dic.setUE(Integer.parseInt(sub.trim()), true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (mh.length() >= i * 4 + 4) {
            sub = mh.substring(i * 4, i * 4 + 4);
            try {
                doc.dic.setMH(Integer.parseInt(sub.trim()), true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static int parseDepLine(String line, boolean decimalFile, int index, DatData data) {
        int charsPerNum = decimalFile ? 7 : 6;
        int i = 0;
        i = 0;
        while (i < line.length()) {
            float num;
            String numS = i + charsPerNum > line.length() ? line.substring(i) : line.substring(i, i + charsPerNum);
            try {
                num = Float.parseFloat(numS);
            }
            catch (NumberFormatException e) {
                if (i == 0) {
                    return TITLE_LINE;
                }
                return FINISHED_LINE;
            }
            data.modifyWellData(index++, num, !decimalFile);
            if (!decimalFile || (i += charsPerNum) >= line.length() || line.charAt(i) != ',') continue;
            ++i;
        }
        if (decimalFile && line.length() < 71) {
            return FINISHED_LINE;
        }
        if (!decimalFile && line.length() < 78) {
            return FINISHED_LINE;
        }
        return index;
    }
}

