/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ActivationCheckThread;
import gui.ErrorHandler;
import gui.TSCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ActivationChecker
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel msg = null;
    private JPanel buttonPanel = null;
    private JButton tryAgain = null;
    private JButton close = null;
    ActivationCheckThread thread;
    Timer timer;

    public ActivationChecker(Frame owner, String versionString) {
        super(owner, true);
        this.initialize();
        this.thread = new ActivationCheckThread(versionString);
        this.startCheck();
    }

    protected final void startCheck() {
        this.msg.setText("Checking with tscreator.com...");
        this.thread.run();
        this.timer = new Timer(100, this);
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        switch (this.thread.getCheckState()) {
            case 0: {
                break;
            }
            case 1: {
                ErrorHandler.log("Trial version check succeeded");
                this.dispose();
                this.timer.stop();
                TSCreator.activationSucceeded();
                break;
            }
            case 2: {
                ErrorHandler.log("Trial version check failed");
                this.timer.stop();
                String s = "Failed check with tscreator.com";
                if (this.thread.getError().length() > 0) {
                    s = s + ": " + this.thread.getError();
                }
                this.msg.setText(s);
                this.tryAgain.setEnabled(true);
                break;
            }
            case 3: {
                ErrorHandler.log("Trial version expired.");
                this.timer.stop();
                this.msg.setText("Trial Expired.");
            }
        }
    }

    private void initialize() {
        this.setSize(246, 131);
        this.setTitle("TSCreator PRO trial");
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.msg = new JLabel("Checking with tscreator.com...");
            Dimension d = this.msg.getPreferredSize();
            d.width = 300;
            this.msg.setPreferredSize(d);
            this.msg.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jContentPane.add((Component)this.msg, "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridy = 0;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getTryAgain(), gridBagConstraints1);
            this.buttonPanel.add((Component)this.getClose(), gridBagConstraints);
        }
        return this.buttonPanel;
    }

    private JButton getTryAgain() {
        if (this.tryAgain == null) {
            this.tryAgain = new JButton();
            this.tryAgain.setText("Try Again");
            this.tryAgain.setEnabled(false);
            this.tryAgain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivationChecker.this.startCheck();
                    ActivationChecker.this.tryAgain.setEnabled(false);
                }
            });
        }
        return this.tryAgain;
    }

    private JButton getClose() {
        if (this.close == null) {
            this.close = new JButton();
            this.close.setText("Close");
            this.close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ActivationChecker.this.timer != null) {
                        ActivationChecker.this.timer.stop();
                    }
                    ActivationChecker.this.dispose();
                }
            });
        }
        return this.close;
    }
}

