/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.AgeAgeColumn;
import datastore.BlockSeriesMetaColumn;
import datastore.ChronColumn;
import datastore.EventColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RootColumn;
import datastore.RulerColumn;
import datastore.SequenceColumn;
import datastore.ZoneColumn;
import gui.Settings;
import gui.TSCFont;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FontManager {
    public static final TSCFont[] defaultFonts = new TSCFont[]{new TSCFont("Arial", 0, 14.0, Color.BLACK), new TSCFont("Arial", 0, 6.0, Color.BLACK), new TSCFont("Arial", 2, 5.0, Color.BLACK), new TSCFont("Arial", 0, 12.0, Color.BLACK), new TSCFont("Arial", 0, 12.0, Color.BLACK), new TSCFont("Arial", 2, 7.0, Color.BLACK), new TSCFont("Arial", 0, 12.0, Color.BLACK), new TSCFont("Arial", 0, 12.0, Color.BLACK), new TSCFont("Arial", 0, 6.0, Color.BLACK), new TSCFont("Arial", 2, 12.0, Color.BLACK), new TSCFont("Arial", 0, 7.0, Color.BLACK), new TSCFont("Verdana", 1, 14.0, Color.BLACK), new TSCFont("Verdana", 1, 12.0, Color.BLACK), new TSCFont("Verdana", 2, 12.0, Color.BLACK), new TSCFont("Arial", 2, 12.0, Color.BLACK)};
    public static final String[] fontFunctions = new String[]{"Column Header", "Age Label", "Uncertainty Label", "Zone Column Label", "Sequence Column Label", "Event Column Label", "Popup Body", "Ruler Label", "Point Column Scale Label", "Range Label", "Ruler Tick Mark Label", "Legend Title", "Legend Column Name", "Legend Column Source", "Range Box Label"};
    public static final int COLUMN_HEADER_FONT = 0;
    public static final int AGE_LABEL_FONT = 1;
    public static final int UNCERTAINTY_LABEL_FONT = 2;
    public static final int ZONE_COL_LABEL_FONT = 3;
    public static final int SEQUENCE_COL_LABEL_FONT = 4;
    public static final int EVENT_COL_LABEL_FONT = 5;
    public static final int POPUP_FONT = 6;
    public static final int RULER_LABEL_FONT = 7;
    public static final int POINT_COL_SCALE_LABEL_FONT = 8;
    public static final int RANGE_LABEL_FONT = 9;
    public static final int RANGE_BOX_LABEL_FONT = 14;
    public static final int RULER_INTERM_LABEL_FONT = 10;
    public static final int LEGEND_TITLE_FONT = 11;
    public static final int LEGEND_COL_NAME_FONT = 12;
    public static final int LEGEND_COL_INFO_FONT = 13;
    public TSCFont[] chosenFonts = new TSCFont[defaultFonts.length];
    public boolean[] inheritable;
    public FontManager parent = null;

    public static int[] getRelevantFonts(Class column) {
        if (column == ChronColumn.class) {
            return new int[]{0, 1};
        }
        if (column == PointColumn.class) {
            return new int[]{0, 8};
        }
        if (column == EventColumn.class) {
            return new int[]{0, 1, 2, 5, 9};
        }
        if (column == SequenceColumn.class) {
            return new int[]{0, 1, 4};
        }
        if (column == ZoneColumn.class) {
            return new int[]{0, 1, 3};
        }
        if (column == RulerColumn.class) {
            return new int[]{0, 7};
        }
        if (column == AgeAgeColumn.class) {
            return new int[]{0, 7};
        }
        if (column == MetaColumn.class || column == RootColumn.class || column == BlockSeriesMetaColumn.class) {
            return new int[]{0};
        }
        if (column == RangeColumn.class) {
            return new int[]{0, 1, 2, 7, 3, 4, 5, 9, 14, 6, 8, 10, 11, 12, 13};
        }
        return new int[]{0, 1, 2, 7, 3, 4, 5, 9, 6, 8, 10, 11, 12, 13};
    }

    public static int[] uniqueArrayUnion(int[] a, int[] b) {
        int i;
        int length = a.length;
        boolean[] bAdditions = new boolean[b.length];
        for (int i2 = 0; i2 < b.length; ++i2) {
            int j;
            for (j = 0; j < a.length && a[j] != b[i2]; ++j) {
            }
            if (j == a.length) {
                ++length;
                bAdditions[i2] = true;
                continue;
            }
            bAdditions[i2] = false;
        }
        int[] ret = new int[length];
        for (i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        for (int j = 0; j < bAdditions.length; ++j) {
            if (!bAdditions[j]) continue;
            ret[i] = b[j];
            ++i;
        }
        return ret;
    }

    public static int[] uniqueArraySubtract(int[] a, int[] b) {
        int length = 0;
        boolean[] aKeep = new boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            int j;
            for (j = 0; j < b.length && a[i] != b[j]; ++j) {
            }
            if (j == b.length) {
                aKeep[i] = true;
                ++length;
                continue;
            }
            aKeep[i] = false;
        }
        int[] ret = new int[length];
        int retIndex = 0;
        for (int i = 0; i < aKeep.length; ++i) {
            if (!aKeep[i]) continue;
            ret[retIndex] = a[i];
            ++retIndex;
        }
        return ret;
    }

    public FontManager() {
        this.inheritable = new boolean[defaultFonts.length];
        for (int i = 0; i < this.inheritable.length; ++i) {
            this.inheritable[i] = false;
        }
    }

    public FontManager(FontManager parent) {
        this.parent = parent;
    }

    public void setParent(FontManager parent) {
        this.parent = parent;
    }

    public FontManager getParent() {
        return this.parent;
    }

    public void setFont(int which, TSCFont newFont) {
        this.chosenFonts[which] = newFont;
    }

    public void resetFont(int which) {
        this.chosenFonts[which] = this.parent == null ? defaultFonts[which] : null;
    }

    public void resetFonts() {
        if (this.parent == null) {
            System.arraycopy(defaultFonts, 0, this.chosenFonts, 0, this.chosenFonts.length);
        } else {
            for (int i = 0; i < this.chosenFonts.length; ++i) {
                this.chosenFonts[i] = null;
            }
        }
    }

    public TSCFont getFont(int which) {
        if (this.chosenFonts[which] != null) {
            return this.chosenFonts[which];
        }
        if (this.parent != null) {
            return this.parent.getFontInheriting(which);
        }
        return defaultFonts[which];
    }

    protected TSCFont getFontInheriting(int which) {
        if (this.chosenFonts[which] != null && this.inheritable[which]) {
            return this.chosenFonts[which];
        }
        if (this.parent != null) {
            return this.parent.getFontInheriting(which);
        }
        return defaultFonts[which];
    }

    public String getFontSVGStyle(int which) {
        return this.getFont(which).getSVGStyle();
    }

    public static int getIndexByFunction(String func) {
        for (int i = 0; i < fontFunctions.length; ++i) {
            if (fontFunctions[i].compareToIgnoreCase(func) != 0) continue;
            return i;
        }
        return -1;
    }

    public void readSettings(Element element) {
        this.resetFonts();
        NodeList nl = element.getElementsByTagName("font");
        for (int elementIndex = 0; elementIndex < nl.getLength(); ++elementIndex) {
            int fontIndex;
            Element font = (Element)nl.item(elementIndex);
            String function = font.getAttribute("function");
            if (function == null || (fontIndex = FontManager.getIndexByFunction(function)) < 0) continue;
            String sInheritable = font.getAttribute("inheritable");
            boolean fontInheritable = sInheritable == null ? true : sInheritable.trim().compareToIgnoreCase("true") == 0;
            String fontSVGStyle = Settings.getNodeTextContent(font).trim();
            if (fontSVGStyle == null || fontSVGStyle.length() == 0) {
                this.setFont(fontIndex, null);
            } else {
                this.setFont(fontIndex, new TSCFont(fontSVGStyle));
            }
            this.inheritable[fontIndex] = fontInheritable;
        }
    }

    public void writeSettings(Element element, Document doc) {
        for (int i = 0; i < this.chosenFonts.length; ++i) {
            Element cf = doc.createElement("font");
            cf.setAttribute("function", fontFunctions[i]);
            cf.setAttribute("inheritable", Boolean.toString(this.inheritable[i]));
            if (this.chosenFonts[i] != null) {
                Settings.setNodeTextContent(cf, this.chosenFonts[i].getSVGStyle(), doc);
            }
            element.appendChild(cf);
        }
    }
}

