/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ModifyTextField;
import gui.PriorityFonts;
import gui.SpringUtilities;
import gui.TSCFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;

public class PriorityOptions
extends JPanel {
    protected PriorityFonts pFonts;
    protected JPanel addPanel = this;

    public PriorityOptions(PriorityFonts pFonts) {
        this.pFonts = pFonts;
        this.setLayout(new BoxLayout(this, 1));
    }

    public JPanel getAddPanel() {
        return this.addPanel;
    }

    public JPanel addNestedAddPanel() {
        JPanel oldAddPanel = this.addPanel;
        this.addPanel = new JPanel();
        oldAddPanel.add(this.addPanel);
        return this.addPanel;
    }

    public void addOptions(boolean bindToBottom) {
        JPanel p = new JPanel(new SpringLayout());
        p.add(new JLabel("Change Font"));
        p.add(new JLabel("Font Face"));
        p.add(new JLabel("Size"));
        JLabel bLabel = new JLabel("Bold");
        bLabel.setFont(new Font("Times", 1, 12));
        p.add(bLabel);
        JLabel iLabel = new JLabel("Italic");
        iLabel.setFont(new Font("Times", 2, 12));
        p.add(iLabel);
        p.add(new JLabel("Color"));
        p.add(new JLabel("Preview"));
        for (int i = 0; i < this.pFonts.priorityLabels.length; ++i) {
            new SinglePriorityOptions(this.pFonts, i, p);
        }
        SpringUtilities.makeCompactGrid(p, this.pFonts.priorityLabels.length + 1, 7, 5, 5, 5, 5, bindToBottom);
        this.addPanel.add(p);
    }

    public class SinglePriorityOptions
    implements ActionListener,
    MouseListener {
        PriorityFonts pFonts;
        TSCFont chosenPriority;
        int priority;
        JLabel priorityType;
        JComboBox priorityFontName;
        ModifyTextField priorityFontSize;
        JRadioButton bold;
        JRadioButton italics;
        JPanel priorityTextColor;
        JLabel previewText;

        public SinglePriorityOptions(PriorityFonts pFonts, int priority, JComponent comp) {
            this.pFonts = pFonts;
            this.chosenPriority = pFonts.getFont(priority);
            this.priority = priority;
            JPanel labelPanel = new JPanel(new SpringLayout());
            this.priorityType = new JLabel(pFonts.getLabelbyPriority(priority));
            this.priorityType.setFont(new Font("Times", 1, 12));
            Dimension d = labelPanel.getPreferredSize();
            d.width = 200;
            labelPanel.setPreferredSize(d);
            labelPanel.setMaximumSize(d);
            labelPanel.add(this.priorityType);
            String[] priorityFontFamilies = new String[]{"Arial", "Courier", "Verdana"};
            this.priorityFontName = new JComboBox<String>(priorityFontFamilies);
            d = this.priorityFontName.getPreferredSize();
            d.width = 100;
            this.priorityFontName.setMaximumSize(d);
            int sel = 0;
            for (int i = 0; i < priorityFontFamilies.length; ++i) {
                if (!priorityFontFamilies[i].equals(this.chosenPriority.getFamily())) continue;
                sel = i;
                break;
            }
            this.priorityFontName.setSelectedIndex(sel);
            this.priorityFontName.addActionListener(this);
            this.priorityFontSize = new ModifyTextField(true, true);
            d = this.priorityFontSize.getPreferredSize();
            d.width = 40;
            this.priorityFontSize.setPreferredSize(d);
            this.priorityFontSize.setMaximumSize(d);
            this.priorityFontSize.setText("" + pFonts.getFont(priority).getSizeInt());
            this.priorityFontSize.addActionListener(this);
            this.bold = new JRadioButton();
            this.bold.setSelected(pFonts.getFont(priority).isBold());
            this.bold.addActionListener(this);
            this.bold.setSelected(this.chosenPriority.isBold());
            this.italics = new JRadioButton();
            this.italics.setSelected(pFonts.getFont(priority).isItalic());
            this.italics.addActionListener(this);
            this.italics.setSelected(this.chosenPriority.isItalic());
            this.priorityTextColor = new JPanel();
            d = this.priorityTextColor.getPreferredSize();
            d.width = 20;
            this.priorityTextColor.setPreferredSize(d);
            this.priorityTextColor.setMaximumSize(d);
            this.priorityTextColor.setBackground(this.chosenPriority.getColor());
            this.priorityTextColor.addMouseListener(this);
            JPanel panel = new JPanel(new SpringLayout());
            this.previewText = new JLabel("Sample Text");
            d = this.priorityFontSize.getPreferredSize();
            d.width = 100;
            panel.setPreferredSize(d);
            this.previewText.setFont(this.chosenPriority.getFont());
            panel.add(this.previewText);
            comp.add(labelPanel);
            comp.add(this.priorityFontName);
            comp.add(this.priorityFontSize);
            comp.add(this.bold);
            comp.add(this.italics);
            comp.add(this.priorityTextColor);
            comp.add(panel);
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            Object source = a.getSource();
            if (source == this.priorityFontName) {
                this.chosenPriority.family = (String)this.priorityFontName.getSelectedItem();
                this.pFonts.setFont(this.priority, this.chosenPriority);
                this.previewText.setFont(this.chosenPriority.getFont());
            } else if (source == this.priorityFontSize) {
                try {
                    this.chosenPriority.size = Double.parseDouble(this.priorityFontSize.getText());
                }
                catch (Exception e) {
                    this.chosenPriority.size = 1.0;
                }
                this.pFonts.setFont(this.priority, this.chosenPriority);
                this.previewText.setFont(this.chosenPriority.getFont());
            } else if (source == this.bold) {
                int type = this.chosenPriority.getStyle();
                type = this.bold.isSelected() ? (type |= 1) : (type &= 0xFFFFFFFE);
                this.chosenPriority.setStyle(type);
                this.pFonts.setFont(this.priority, this.chosenPriority);
                this.previewText.setFont(this.chosenPriority.getFont());
            } else if (source == this.italics) {
                int type = this.chosenPriority.getStyle();
                type = this.italics.isSelected() ? (type |= 2) : (type &= 0xFFFFFFFD);
                this.chosenPriority.setStyle(type);
                this.pFonts.setFont(this.priority, this.chosenPriority);
                this.previewText.setFont(this.chosenPriority.getFont());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Color textColorChoice;
            Color initColor = Color.BLACK;
            if (this.chosenPriority.getColor() != null) {
                initColor = this.chosenPriority.getColor();
            }
            if ((textColorChoice = JColorChooser.showDialog(this.priorityTextColor, "Choose Font Color", initColor)) != null) {
                initColor = textColorChoice;
            }
            this.priorityTextColor.setBackground(initColor);
            this.chosenPriority.setColor(initColor);
            this.previewText.setForeground(initColor);
            this.pFonts.setFont(this.priority, this.chosenPriority);
        }
    }
}

