/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.AgeAgeColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datastore;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RootColumn;
import datastore.RulerColumn;
import datastore.Unit;
import datastore.searchresults.BlockResults;
import datastore.searchresults.ChronResults;
import datastore.searchresults.ColumnResults;
import datastore.searchresults.EventResults;
import datastore.searchresults.FacieResults;
import datastore.searchresults.RangeResults;
import datastore.searchresults.Searchpoint;
import datastore.searchresults.SeqResults;
import gui.AutoGenOptions;
import gui.ColumnImageGenerator;
import gui.ErrorHandler;
import gui.ExtensionFileFilter;
import gui.FontManager;
import gui.FontOptions;
import gui.ImageGenerator;
import gui.Language;
import gui.ModifyTextField;
import gui.SearchDataPack;
import gui.TSCAction;
import gui.TSCLinkActivationListener;
import gui.TSCreator;
import gui.settings.SelectedTimes;
import gui.settings.TimesPanel;
import gui.settings.TimesPanelRest;
import gui.settings.TimesSelectChangeListener;
import gui.tree.CheckboxTreeCellEditor;
import gui.tree.CheckboxTreeCellRenderer;
import gui.tree.DataColumnTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import map.MapListPanel;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import path.ResPath;
import util.FileUtils;
import util.HTMLPreprocessor;
import util.ProgramInfo;

public class Settings
extends JDialog
implements TreeSelectionListener,
ItemListener,
ActionListener,
TimesSelectChangeListener,
KeyListener {
    public TSCreator tsObj = null;
    public static final String settingsBackupFile = System.getProperty("java.io.tmpdir") + File.separator + "backupsettings.tsc";
    private static final Dimension resultsArea = new Dimension(600, 480);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    public JTabbedPane tabbedPane = null;
    private JPanel buttonPanel = null;
    private JButton loadButton = null;
    private Boolean loadSettingsButtonClick = false;
    private JButton saveButton = null;
    private JButton okButton = null;
    private JButton generateAndCloseButton = null;
    private JButton generateAndKeepOpenButton = null;
    private JButton generate3DButton;
    private JLabel errorLabel = null;
    public static TSCAction generateAction = null;
    private TSCAction generate3DAction = null;
    private JPanel timesTabPanel = null;
    private JTabbedPane timesTabbedPane = null;
    public Map<Unit, TimesPanel> timesPanels = new HashMap<Unit, TimesPanel>();
    public Map<Unit, SelectedTimes> timesSelections = new HashMap<Unit, SelectedTimes>();
    private JPanel zonesPanel = null;
    private JPanel fontTabPanel = null;
    private JPanel searchPanel = null;
    private FontOptions fontPanel = null;
    private MapListPanel mapListPanel = null;
    private JCheckBox negativeCheck = null;
    private JCheckBox popupCheck = null;
    private JCheckBox enEventBG = null;
    private JCheckBox enGlobalPriority = null;
    private JCheckBox enBlockLableHide = null;
    private JCheckBox enLegend = null;
    private JCheckBox enConsSpaceFT = null;
    private JCheckBox noIndent = null;
    private JRadioButton USGSRadio = null;
    private JRadioButton UNESCORadio = null;
    public Coloring variableColoring = new Coloring(Coloring.USGS);
    public Coloring variableNamedColoring = new Coloring(Coloring.NAMED_USGS);
    private JPanel zoneOptionsPanel = null;
    public JTree zoneTree = null;
    private JRadioButton variableColorRadio = null;
    private JButton resetColorButton = null;
    private JRadioButton customRadio = null;
    private JLabel colorLabel = null;
    private JButton customColor = null;
    private JPanel customColorBox = null;
    private JLabel widthLabel = null;
    private ModifyTextField widthTF = null;
    private JLabel paddingLabel = null;
    private ModifyTextField paddingTF = null;
    private JLabel ageLabelPaddingLabel = null;
    private ModifyTextField ageLabelPaddingTF = null;
    private JLabel titleLabel = null;
    private JCheckBox showTitleCB = null;
    private ModifyTextField titleTF = null;
    private JCheckBox showAgeLabelsCB = null;
    private JCheckBox showUncertaintyLabelsCB = null;
    private JButton fontOptionsB = null;
    private JButton dataEditB = null;
    private JPanel colPanel = null;
    private JPanel colOptionsPanel = null;
    private JPanel colInfoPanel = null;
    private JEditorPane colInfoLabel = null;
    private JLabel FTpriorityLabel = null;
    private JLabel RowShiftLabel = null;
    private JLabel BranchSpacingLabel = null;
    private ModifyTextField branchTF = null;
    private JCheckBox FTpriorityEnable = null;
    private JComboBox FTpriorityVal = null;
    private JPanel searchOptionsPanel = null;
    private JPanel searchResultsPanel = null;
    public ArrayList<String> searchedStrings = new ArrayList();
    private JScrollPane resultsPane = null;
    private BoxLayout resultsLayout = null;
    private JCheckBox commentsCheck = null;
    private JTextField searchtextField = null;
    private JButton searchButton = null;
    private JCheckBox chartCheck = null;
    private JLabel noResultsLabel = null;
    public SearchDataPack searchResults = null;
    public SearchDataPack searchResultsSyn = null;
    private static boolean searchComments = false;
    private JButton moveUp = null;
    private JButton moveDown = null;
    private JSeparator belowColorSep = null;
    private JSeparator belowFontsSep = null;
    private JSeparator belowPrioritySep = null;
    private JSeparator belowWidthSep = null;
    private JSeparator belowArrowsSep = null;
    public DataColumn curSelectDC = null;
    public static DataColumn mySelectDC = null;
    public Datastore ds = null;
    private boolean noData = true;
    public boolean isValid = false;
    public final int ERROR = 1;
    public final int WARNING = 2;
    public final int OK = 3;
    public double topAge;
    public double baseAge;
    public double scale;
    public boolean changedDefaultTopAge = false;
    public boolean changedDefaultBaseAge = false;
    public boolean changedDefaultScale = false;
    public double unitsPerMY = 30.0;
    public boolean isPopulated = false;
    public static boolean negativeChk = false;
    public boolean noIndentPattern = false;
    public boolean doPopups = false;
    public boolean enEventColBG = false;
    public boolean enChartLegend = false;
    public boolean enConsSpace = false;
    public boolean enPriority = false;
    public boolean enHideBlockLable = false;
    public boolean skipEmptyColumns = true;
    ColumnImageGenerator columnImageGenerator;
    public static double BORDER_WIDTH = 2.0;
    public static double SUB_IMAGE_SPACING = 20.0;
    public FontManager fonts = new FontManager();
    public static final String SOLID_STROKE = "";
    public static final String DASHED_STROKE = "stroke-dasharray:7,4;";
    public static final String DOTTED_STROKE = "stroke-dasharray:2,2;";
    public static final String POPUP_HIGHLIGHT_STYLE = "stroke-width: 0; opacity: 0.5; fill: red;";
    boolean ignoreGrayOut = false;
    private ArrayList<Double> ageSet = null;
    static ArrayList<JFrame> openCommentsPanes = null;
    ArrayList<DataColumn> clickedColumns = null;

    public static String getStroke(int which) {
        if (which == 2) {
            return DASHED_STROKE;
        }
        if (which == 3) {
            return DOTTED_STROKE;
        }
        return SOLID_STROKE;
    }

    public boolean isAbove(double age) {
        return age - 1.0E-6 <= this.topAge;
    }

    public boolean isBelow(double age) {
        return age + 1.0E-6 >= this.baseAge;
    }

    public boolean isInRange(double age) {
        return !this.isAbove(age) && !this.isBelow(age);
    }

    public Settings(Datastore ds) throws HeadlessException {
        if (ds != null) {
            this.initialize(ds, this.columnImageGenerator);
        }
    }

    public void addTSObj(TSCreator tsObj) {
        this.tsObj = tsObj;
    }

    protected Settings() {
    }

    public SelectedTimes getSelectedTimes(Unit u) {
        return this.timesSelections.get(u);
    }

    public Settings getReadOnlySettings(Unit u) {
        Settings ret = new Settings();
        ret.ds = this.ds;
        SelectedTimes st = this.timesSelections.get(u);
        if (st != null) {
            if (!u.isNegated()) {
                ret.topAge = st.topAge;
                ret.baseAge = st.baseAge;
            } else {
                ret.topAge = -st.topAge;
                ret.baseAge = -st.baseAge;
            }
            ret.unitsPerMY = st.vertScale * 30.0;
            ret.skipEmptyColumns = st.skipEmptyColumns;
        } else {
            ret.topAge = this.topAge;
            ret.baseAge = this.baseAge;
            ret.unitsPerMY = this.unitsPerMY;
            ret.skipEmptyColumns = this.skipEmptyColumns;
        }
        ret.variableColoring = this.variableColoring;
        ret.variableNamedColoring = this.variableNamedColoring;
        ret.fonts.chosenFonts = this.fonts.chosenFonts;
        ret.noIndentPattern = this.noIndentPattern;
        ret.doPopups = this.doPopups;
        ret.enChartLegend = this.enChartLegend;
        ret.enEventColBG = this.enEventColBG;
        ret.enPriority = this.enPriority;
        ret.enHideBlockLable = this.enHideBlockLable;
        return ret;
    }

    public static Settings getReadOnlySettings(Datastore ds, Unit u, SelectedTimes st, Settings defaults) {
        Settings ret = new Settings();
        ret.ds = ds;
        if (!u.isNegated()) {
            ret.topAge = st.topAge;
            ret.baseAge = st.baseAge;
        } else {
            ret.topAge = -st.topAge;
            ret.baseAge = -st.baseAge;
        }
        if (defaults != null) {
            ret.variableColoring = defaults.variableColoring;
            ret.variableNamedColoring = defaults.variableNamedColoring;
        }
        ret.unitsPerMY = st.vertScale * 30.0;
        if (defaults != null) {
            ret.skipEmptyColumns = defaults.skipEmptyColumns;
            ret.noIndentPattern = defaults.noIndentPattern;
            ret.doPopups = defaults.doPopups;
            ret.enChartLegend = defaults.enChartLegend;
            ret.enEventColBG = defaults.enEventColBG;
            ret.enPriority = defaults.enPriority;
            ret.enHideBlockLable = defaults.enHideBlockLable;
        }
        return ret;
    }

    public void setGenerateAction(TSCAction a) {
        generateAction = a;
        this.mapListPanel.setMapGenerateAction(a);
    }

    public void setGenerate3DAction(TSCAction a) {
        this.generate3DAction = a;
    }

    public void setTopAge(Unit unit, String s) {
        TimesPanel tp = this.timesPanels.get(unit);
        if (tp != null) {
            tp.topMY.setText(s);
            tp.topMYRadio.setSelected(true);
        }
    }

    public void setBaseAge(Unit unit, String s) {
        TimesPanel tp = this.timesPanels.get(unit);
        if (tp != null) {
            tp.baseMY.setText(s);
            tp.baseMYRadio.setSelected(true);
        }
    }

    public void setVertScale(Unit unit, String s) {
        TimesPanel tp = this.timesPanels.get(unit);
        if (tp != null) {
            tp.unitsPerMaTF.setText(s);
        }
    }

    public void setEmptyColumn(Unit unit, boolean value) {
        TimesPanel tp = this.timesPanels.get(unit);
        if (tp != null) {
            tp.skipEmptyColumnsCheck.setSelected(value);
        }
    }

    private void initialize(Datastore ds, ColumnImageGenerator columnImageGenerator) {
        this.ds = ds;
        this.setModal(false);
        this.setTitle(Language.translate("Settings", true));
        this.setContentPane(this.getJContentPane());
        this.setSize(700, 800);
        this.columnImageGenerator = columnImageGenerator;
        this.noData = true;
    }

    public void showGenerating(boolean gen) {
        if (gen) {
            this.tabbedPane.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.generateAndCloseButton.setEnabled(false);
            this.generateAndKeepOpenButton.setEnabled(false);
            this.setErrorString("<html><strong>Settings disabled while generating!</strong></html>", 1);
        } else {
            this.tabbedPane.setEnabled(true);
            this.loadButton.setEnabled(true);
            this.generateAndCloseButton.setEnabled(true);
            this.generateAndKeepOpenButton.setEnabled(true);
            this.setErrorString(SOLID_STROKE, 3);
        }
    }

    public void populate(Datastore ds) {
        this.isPopulated = true;
        this.ds = ds;
        for (Map.Entry<Unit, TimesPanel> entry : this.timesPanels.entrySet()) {
            entry.getValue().populate(ds);
        }
        for (int i = 0; i < this.zoneTree.getRowCount(); ++i) {
            if (this.zoneTree.getPathForRow(i).getPathCount() > 2) continue;
            this.zoneTree.expandRow(i);
        }
        this.zoneTree.setRootVisible(false);
        this.zoneTree.setShowsRootHandles(true);
        this.zoneTree.setRowHeight(0);
        this.isValidToGenerate();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            JScrollPane timesScrollPane = new JScrollPane(this.getTimesPanel());
            this.tabbedPane.addTab(Language.translate("Choose Time Interval", true), null, timesScrollPane, null);
            this.tabbedPane.addTab(Language.translate("Choose Columns", true), null, this.getZonesPanel(), null);
            if (TSCreator.showSearchPane) {
                this.tabbedPane.addTab(Language.translate("Search", true), null, this.getSearchPanel(), null);
            }
            this.fontTabPanel = new JPanel(new BorderLayout());
            this.fontTabPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontTabPanel.add(this.getFontPanel());
            JScrollPane fontScrollPane = new JScrollPane(this.fontTabPanel, 20, 30);
            fontScrollPane.setViewportView(this.fontTabPanel);
            this.tabbedPane.addTab(Language.translate("Font Options", true), null, fontScrollPane, null);
            this.tabbedPane.addTab(Language.translate("Map Points", true), null, this.getMapPanel(), null);
        }
        return this.tabbedPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel p = new JPanel();
            p.add(this.getLoadButton());
            p.add(this.getSaveButton());
            p.add(this.getOkButton());
            p.add(this.getGenerateAndKeepOpenButton());
            p.add(this.getGenerateAndCloseButton());
            if (TSCreator.ENABLE_3D) {
                p.add(this.getGenerate3DButton());
            }
            this.buttonPanel.add((Component)p, "East");
            this.buttonPanel.add((Component)this.getErrorLabel(), "Center");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(Language.translate("Close", true));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getGenerateAndCloseButton() {
        if (this.generateAndCloseButton == null) {
            this.generateAndCloseButton = new JButton();
            this.generateAndCloseButton.setText("<html><strong>" + Language.translate("Generate and Close", true) + "</strong></html>");
            this.generateAndCloseButton.addActionListener(this);
        }
        return this.generateAndCloseButton;
    }

    private JButton getGenerateAndKeepOpenButton() {
        if (this.generateAndKeepOpenButton == null) {
            this.generateAndKeepOpenButton = new JButton();
            this.generateAndKeepOpenButton.setText("<html>" + Language.translate("Generate", true) + "</html>");
            this.generateAndKeepOpenButton.addActionListener(this);
        }
        return this.generateAndKeepOpenButton;
    }

    private JButton getGenerate3DButton() {
        if (this.generate3DButton == null) {
            this.generate3DButton = new JButton();
            this.generate3DButton.setText("<html>" + Language.translate("Generate 3D", true) + "</html>");
            this.generate3DButton.addActionListener(this);
        }
        return this.generate3DButton;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText(Language.translate("Load...", true));
            this.loadButton.addActionListener(this);
            if (TSCreator.isApplet()) {
                this.loadButton.setVisible(false);
            }
        }
        return this.loadButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(Language.translate("Save...", true));
            this.saveButton.addActionListener(this);
            if (TSCreator.isApplet()) {
                this.saveButton.setVisible(false);
            }
        }
        return this.saveButton;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new JLabel();
        }
        return this.errorLabel;
    }

    private void addTimesTab(Unit u) {
        TimesPanel tp = new TimesPanel(this, u);
        tp.populate(this.ds);
        this.timesPanels.put(u, tp);
        this.timesTabbedPane.addTab(u.getName(), null, tp, null);
    }

    private JPanel getTimesPanel() {
        if (this.timesTabPanel == null) {
            this.timesTabPanel = new JPanel();
            this.timesTabPanel.setLayout(new BoxLayout(this.timesTabPanel, 3));
            this.timesTabbedPane = new JTabbedPane();
            this.timesTabPanel.add(this.timesTabbedPane);
            TimesPanelRest tpr = new TimesPanelRest(this);
            this.timesTabPanel.add(tpr);
            this.noIndent = tpr.noIndent;
            this.noIndent.setSelected(this.noIndentPattern);
            this.noIndent.addItemListener(this);
            this.popupCheck = tpr.popupCheck;
            this.popupCheck.setSelected(this.doPopups);
            this.popupCheck.addItemListener(this);
            this.enEventBG = tpr.enEventBG;
            this.enEventBG.setSelected(this.enEventColBG);
            this.enEventBG.addItemListener(this);
            this.enGlobalPriority = tpr.enGlobalPriority;
            this.enGlobalPriority.setSelected(this.enPriority);
            this.enGlobalPriority.addItemListener(this);
            this.enBlockLableHide = tpr.enBlockLabelPriorityHide;
            this.enBlockLableHide.setSelected(this.enHideBlockLable);
            this.enBlockLableHide.addItemListener(this);
            this.enLegend = tpr.enLegend;
            this.enLegend.setSelected(this.enChartLegend);
            this.enLegend.addItemListener(this);
            this.enConsSpaceFT = tpr.enConsSpaceFT;
            this.enConsSpaceFT.setSelected(this.enConsSpace);
            this.enConsSpaceFT.addItemListener(this);
            this.USGSRadio = tpr.USGSRadio;
            this.USGSRadio.addItemListener(this);
            this.UNESCORadio = tpr.UNESCORadio;
            this.UNESCORadio.addItemListener(this);
        }
        return this.timesTabPanel;
    }

    private JPanel getZonesPanel() {
        if (this.zonesPanel == null) {
            this.zonesPanel = new JPanel();
            this.zonesPanel.setLayout(new BorderLayout());
            this.zonesPanel.add((Component)this.getZoneOptionsPanel(), "East");
            this.zonesPanel.add((Component)new JScrollPane(this.getZoneTree()), "Center");
        }
        return this.zonesPanel;
    }

    private FontOptions getFontPanel() {
        if (this.fontPanel == null) {
            this.fontPanel = new FontOptions(this.fonts);
            JPanel p = new JPanel(new GridLayout(1, 1));
            p.add(new JLabel(Language.translate("<html>These are the default systemwide fonts.<br>Changing one here will affect the entire chart. To make a change, check the checkbox for that font. Uncheck it to go back to system defaults.<br><br><b>NOTE:</b> These settings can be overriden on a column-by-column basis by using the Font button for each column under \"Choose Zonations\".<br></html>", true)));
            this.fontPanel.add(p);
            this.fontPanel.addOptions(FontManager.getRelevantFonts(null), false, false);
        }
        return this.fontPanel;
    }

    private JScrollPane getMapPanel() {
        this.mapListPanel = new MapListPanel(this.ds, generateAction);
        return new JScrollPane(this.mapListPanel, 20, 30);
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel();
        }
        this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 1));
        this.searchPanel.add(this.getSearchOptionsPanel());
        this.resultsPane = new JScrollPane(this.getSearchResultsPanel(), 20, 31);
        this.resultsPane.setPreferredSize(resultsArea);
        this.searchPanel.add(this.resultsPane);
        return this.searchPanel;
    }

    private JPanel getSearchOptionsPanel() {
        if (this.searchOptionsPanel == null) {
            this.searchOptionsPanel = new JPanel();
            SpringLayout searchLayout = new SpringLayout();
            this.searchOptionsPanel.setLayout(searchLayout);
            this.commentsCheck = new JCheckBox(Language.translate("Turn ON Comments Search", true));
            this.commentsCheck.addItemListener(this);
            this.searchtextField = new JTextField(20);
            this.searchtextField.addKeyListener(this);
            this.searchButton = new JButton(Language.translate("Search", true));
            this.searchButton.addActionListener(this);
            this.chartCheck = new JCheckBox(Language.translate("Select 3Ma around event for chart generation", true));
            this.chartCheck.addItemListener(this);
            this.noResultsLabel = new JLabel();
            searchLayout.putConstraint("West", (Component)this.commentsCheck, 10, "West", (Component)this.searchOptionsPanel);
            searchLayout.putConstraint("North", (Component)this.commentsCheck, 10, "North", (Component)this.searchOptionsPanel);
            searchLayout.putConstraint("West", (Component)this.searchtextField, 10, "West", (Component)this.searchOptionsPanel);
            searchLayout.putConstraint("North", (Component)this.searchtextField, 10, "South", (Component)this.commentsCheck);
            searchLayout.putConstraint("West", (Component)this.searchButton, 5, "East", (Component)this.searchtextField);
            searchLayout.putConstraint("North", (Component)this.searchButton, 10, "South", (Component)this.commentsCheck);
            searchLayout.putConstraint("West", (Component)this.chartCheck, 10, "West", (Component)this.searchOptionsPanel);
            searchLayout.putConstraint("North", (Component)this.chartCheck, 10, "South", (Component)this.searchtextField);
            searchLayout.putConstraint("West", (Component)this.noResultsLabel, 10, "West", (Component)this.searchOptionsPanel);
            searchLayout.putConstraint("North", (Component)this.noResultsLabel, 5, "South", (Component)this.chartCheck);
            this.searchOptionsPanel.add(this.commentsCheck);
            this.searchOptionsPanel.add(this.searchtextField);
            this.searchOptionsPanel.add(this.searchButton);
            this.searchOptionsPanel.add(this.chartCheck);
            this.searchOptionsPanel.add(this.noResultsLabel);
            this.commentsCheck.setEnabled(true);
            this.chartCheck.setEnabled(true);
        }
        return this.searchOptionsPanel;
    }

    private JPanel getSearchResultsPanel() {
        if (this.searchResultsPanel == null) {
            this.searchResultsPanel = new JPanel();
            this.resultsLayout = new BoxLayout(this.searchResultsPanel, 1);
            this.searchResultsPanel.setLayout(this.resultsLayout);
        }
        return this.searchResultsPanel;
    }

    private JTree getZoneTree() {
        if (this.zoneTree == null) {
            this.zoneTree = new JTree(this.ds.getViewTreeModel());
            this.zoneTree.setCellRenderer(new CheckboxTreeCellRenderer());
            this.zoneTree.setCellEditor(new CheckboxTreeCellEditor(this.zoneTree));
            this.zoneTree.setEditable(true);
            this.zoneTree.getSelectionModel().setSelectionMode(1);
            this.zoneTree.addTreeSelectionListener(this);
        }
        return this.zoneTree;
    }

    private JPanel getZoneOptionsPanel() {
        if (this.zoneOptionsPanel == null) {
            this.zoneOptionsPanel = new JPanel();
            SpringLayout layout = new SpringLayout();
            this.zoneOptionsPanel.setLayout(layout);
            this.colorLabel = new JLabel();
            this.colorLabel.setText(Language.translate("Background Color:", true));
            this.customColorBox = new JPanel();
            this.zoneOptionsPanel.add((Component)this.colorLabel, null);
            this.zoneOptionsPanel.add((Component)this.getVariableColorRadio(), null);
            this.zoneOptionsPanel.add((Component)this.getCustomRadio(), null);
            this.zoneOptionsPanel.add((Component)this.getColorResetButton(), null);
            this.zoneOptionsPanel.add((Component)this.getCustomColor(), null);
            this.zoneOptionsPanel.add((Component)this.customColorBox, null);
            this.zoneOptionsPanel.add((Component)this.getFontOptionsB(), null);
            this.zoneOptionsPanel.add((Component)this.getDataEditB(), null);
            this.widthLabel = new JLabel();
            this.widthLabel.setText(Language.translate("Width:", true));
            this.paddingLabel = new JLabel();
            this.paddingLabel.setText(Language.translate("Margin:", true));
            this.ageLabelPaddingLabel = new JLabel();
            this.ageLabelPaddingLabel.setText(Language.translate("Age Pad:", true));
            this.zoneOptionsPanel.add((Component)this.widthLabel, null);
            this.zoneOptionsPanel.add((Component)this.getWidthTF(), null);
            this.widthTF.addActionListener(this);
            this.zoneOptionsPanel.add((Component)this.paddingLabel, null);
            this.zoneOptionsPanel.add((Component)this.getPaddingTF(), null);
            this.paddingTF.addActionListener(this);
            this.zoneOptionsPanel.add((Component)this.ageLabelPaddingLabel, null);
            this.zoneOptionsPanel.add((Component)this.getAgeLabelPaddingTF(), null);
            this.ageLabelPaddingTF.addActionListener(this);
            this.titleLabel = new JLabel();
            this.titleLabel.setText(Language.translate("Edit Title:", true));
            this.zoneOptionsPanel.add((Component)this.titleLabel, null);
            this.zoneOptionsPanel.add((Component)this.getTitleTF(), null);
            this.titleTF.addActionListener(this);
            this.zoneOptionsPanel.add((Component)this.getShowTitleCB(), null);
            this.zoneOptionsPanel.add((Component)this.getShowAgeLabelsCB(), null);
            this.zoneOptionsPanel.add((Component)this.getShowUncertaintyLabelsCB(), null);
            this.zoneOptionsPanel.add((Component)this.getMoveUp(), null);
            this.zoneOptionsPanel.add((Component)this.getMoveDown(), null);
            this.FTpriorityLabel = new JLabel();
            this.RowShiftLabel = new JLabel();
            this.BranchSpacingLabel = new JLabel();
            this.FTpriorityLabel.setText(Language.translate("FTree Priority Value:", true));
            this.RowShiftLabel.setText(Language.translate("Row Shift:", true));
            this.BranchSpacingLabel.setText(Language.translate("Branch Spacing:", true));
            this.zoneOptionsPanel.add((Component)this.BranchSpacingLabel, null);
            this.zoneOptionsPanel.add((Component)this.getBranchTF(), null);
            this.branchTF.addActionListener(this);
            this.zoneOptionsPanel.add((Component)this.FTpriorityLabel, null);
            this.zoneOptionsPanel.add((Component)this.RowShiftLabel, null);
            this.zoneOptionsPanel.add((Component)this.getFTpriorityEnable(), null);
            this.zoneOptionsPanel.add((Component)this.getFTpriorityVal(), null);
            this.belowColorSep = new JSeparator(0);
            this.belowFontsSep = new JSeparator(0);
            this.belowPrioritySep = new JSeparator(0);
            this.belowWidthSep = new JSeparator(0);
            this.belowArrowsSep = new JSeparator(0);
            this.zoneOptionsPanel.add((Component)this.belowColorSep, null);
            this.zoneOptionsPanel.add((Component)this.belowFontsSep, null);
            this.zoneOptionsPanel.add((Component)this.belowPrioritySep, null);
            this.zoneOptionsPanel.add((Component)this.belowWidthSep, null);
            this.zoneOptionsPanel.add((Component)this.belowArrowsSep, null);
            this.colPanel = new JPanel(new BorderLayout());
            this.colOptionsPanel = new JPanel(new BorderLayout());
            this.colPanel.add((Component)this.colOptionsPanel, "North");
            this.colInfoPanel = new JPanel(new BorderLayout());
            JPanel borderPanel = new JPanel(new BorderLayout());
            borderPanel.setBorder(BorderFactory.createTitledBorder(Language.translate("Information and References", true)));
            this.colInfoLabel = new JEditorPane();
            this.colInfoLabel.setEditable(false);
            this.colInfoLabel.setContentType("text/html");
            this.colInfoLabel.addHyperlinkListener(new TSCLinkActivationListener());
            this.colInfoLabel.setBackground(null);
            JScrollPane sp = new JScrollPane(this.colInfoLabel, 20, 31);
            sp.setBorder(null);
            borderPanel.add(sp);
            this.colInfoPanel.add((Component)borderPanel, "Center");
            this.colPanel.add((Component)this.colInfoPanel, "Center");
            this.zoneOptionsPanel.add((Component)this.colPanel, null);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getVariableColorRadio());
            group.add(this.getCustomRadio());
            layout.putConstraint("West", (Component)this.colorLabel, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.variableColorRadio, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.customRadio, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.customColor, 5, "East", (Component)this.customRadio);
            layout.putConstraint("West", (Component)this.customColorBox, 5, "East", (Component)this.customColor);
            layout.putConstraint("West", (Component)this.resetColorButton, 5, "East", (Component)this.customColorBox);
            layout.putConstraint("West", (Component)this.fontOptionsB, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("East", (Component)this.dataEditB, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.titleLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.widthLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.paddingLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.ageLabelPaddingLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.FTpriorityLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.RowShiftLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.FTpriorityEnable, 10, "East", (Component)this.FTpriorityVal);
            layout.putConstraint("West", (Component)this.FTpriorityVal, 5, "East", (Component)this.FTpriorityLabel);
            layout.putConstraint("West", (Component)this.showTitleCB, 20, "East", (Component)this.widthTF);
            layout.putConstraint("West", (Component)this.showAgeLabelsCB, 20, "East", (Component)this.widthTF);
            layout.putConstraint("West", (Component)this.showUncertaintyLabelsCB, 20, "East", (Component)this.widthTF);
            layout.putConstraint("East", (Component)this.titleTF, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.titleTF, 5, "East", (Component)this.titleLabel);
            layout.putConstraint("West", (Component)this.widthTF, 5, "East", (Component)this.widthLabel);
            layout.putConstraint("North", (Component)this.paddingLabel, 12, "South", (Component)this.widthLabel);
            layout.putConstraint("North", (Component)this.paddingTF, 0, "South", (Component)this.widthTF);
            layout.putConstraint("West", (Component)this.paddingTF, 5, "East", (Component)this.paddingLabel);
            layout.putConstraint("West", (Component)this.ageLabelPaddingTF, 5, "East", (Component)this.ageLabelPaddingLabel);
            layout.putConstraint("North", (Component)this.ageLabelPaddingLabel, 12, "South", (Component)this.paddingLabel);
            layout.putConstraint("North", (Component)this.ageLabelPaddingTF, 0, "South", (Component)this.paddingTF);
            layout.putConstraint("West", (Component)this.ageLabelPaddingTF, 5, "East", (Component)this.ageLabelPaddingLabel);
            layout.putConstraint("West", (Component)this.moveUp, 3, "East", (Component)this.RowShiftLabel);
            layout.putConstraint("West", (Component)this.moveDown, 5, "East", (Component)this.moveUp);
            layout.putConstraint("West", (Component)this.BranchSpacingLabel, 10, "East", (Component)this.moveDown);
            layout.putConstraint("East", (Component)this.colPanel, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.colPanel, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowColorSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowFontsSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowPrioritySep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowWidthSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowArrowsSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowColorSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowFontsSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowPrioritySep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowWidthSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowArrowsSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("North", (Component)this.variableColorRadio, 5, "South", (Component)this.colorLabel);
            layout.putConstraint("North", (Component)this.customRadio, 5, "South", (Component)this.variableColorRadio);
            layout.putConstraint("North", (Component)this.customColor, 0, "North", (Component)this.customRadio);
            layout.putConstraint("South", (Component)this.customColorBox, 0, "South", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.customColorBox, 0, "North", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.resetColorButton, 0, "North", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.belowColorSep, 3, "South", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.fontOptionsB, 5, "South", (Component)this.belowColorSep);
            layout.putConstraint("North", (Component)this.dataEditB, 0, "North", (Component)this.fontOptionsB);
            layout.putConstraint("North", (Component)this.belowFontsSep, 3, "South", (Component)this.fontOptionsB);
            layout.putConstraint("North", (Component)this.titleLabel, 5, "South", (Component)this.belowFontsSep);
            layout.putConstraint("North", (Component)this.titleTF, 10, "North", (Component)this.belowFontsSep);
            layout.putConstraint("North", (Component)this.widthLabel, 10, "South", (Component)this.titleLabel);
            layout.putConstraint("North", (Component)this.widthTF, 1, "South", (Component)this.titleTF);
            layout.putConstraint("North", (Component)this.showTitleCB, 0, "South", (Component)this.titleTF);
            layout.putConstraint("North", (Component)this.showAgeLabelsCB, 0, "South", (Component)this.showTitleCB);
            layout.putConstraint("North", (Component)this.showUncertaintyLabelsCB, 0, "South", (Component)this.showAgeLabelsCB);
            layout.putConstraint("North", (Component)this.belowWidthSep, 15, "South", (Component)this.showUncertaintyLabelsCB);
            layout.putConstraint("North", (Component)this.FTpriorityLabel, 5, "South", (Component)this.belowWidthSep);
            layout.putConstraint("North", (Component)this.FTpriorityVal, 3, "South", (Component)this.belowWidthSep);
            layout.putConstraint("North", (Component)this.FTpriorityEnable, 3, "South", (Component)this.belowWidthSep);
            layout.putConstraint("North", (Component)this.belowPrioritySep, 3, "South", (Component)this.FTpriorityEnable);
            layout.putConstraint("North", (Component)this.RowShiftLabel, 5, "South", (Component)this.belowPrioritySep);
            layout.putConstraint("North", (Component)this.moveUp, 0, "South", (Component)this.belowPrioritySep);
            layout.putConstraint("North", (Component)this.moveDown, 0, "North", (Component)this.moveUp);
            layout.putConstraint("North", (Component)this.BranchSpacingLabel, 0, "North", (Component)this.RowShiftLabel);
            layout.putConstraint("North", (Component)this.branchTF, 0, "North", (Component)this.moveDown);
            layout.putConstraint("West", (Component)this.branchTF, 1, "East", (Component)this.BranchSpacingLabel);
            layout.putConstraint("North", (Component)this.belowArrowsSep, 3, "South", (Component)this.moveDown);
            layout.putConstraint("South", (Component)this.colPanel, 0, "South", (Component)this.zoneOptionsPanel);
            layout.putConstraint("North", (Component)this.colPanel, 5, "South", (Component)this.belowArrowsSep);
            layout.putConstraint("West", (Component)this.zoneOptionsPanel, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("East", (Component)this.zoneOptionsPanel, 300, "West", (Component)this.zoneOptionsPanel);
            this.updateZoneSelectRadios();
        }
        return this.zoneOptionsPanel;
    }

    private JRadioButton getVariableColorRadio() {
        if (this.variableColorRadio == null) {
            this.variableColorRadio = new JRadioButton();
            this.variableColorRadio.setText(Language.translate("Set to Chronostrat", true));
            this.variableColorRadio.addItemListener(this);
        }
        return this.variableColorRadio;
    }

    private JRadioButton getCustomRadio() {
        if (this.customRadio == null) {
            this.customRadio = new JRadioButton();
            this.customRadio.setText(SOLID_STROKE);
            this.customRadio.addItemListener(this);
        }
        return this.customRadio;
    }

    private JButton getColorResetButton() {
        if (this.resetColorButton == null) {
            this.resetColorButton = new JButton();
            this.resetColorButton.setText(Language.translate("Reset", true));
            this.resetColorButton.addActionListener(this);
        }
        return this.resetColorButton;
    }

    private JButton getCustomColor() {
        if (this.customColor == null) {
            this.customColor = new JButton();
            this.customColor.setText(Language.translate("Choose", true));
            this.customColor.addActionListener(this);
        }
        return this.customColor;
    }

    private JButton getFontOptionsB() {
        if (this.fontOptionsB == null) {
            this.fontOptionsB = new JButton();
            this.fontOptionsB.setText(Language.translate("Fonts", true));
            this.fontOptionsB.addActionListener(this);
        }
        return this.fontOptionsB;
    }

    private JButton getDataEditB() {
        if (this.dataEditB == null) {
            this.dataEditB = new JButton();
            this.dataEditB.setText(Language.translate("Raw Data", true));
            this.dataEditB.addActionListener(this);
            this.dataEditB.setEnabled(false);
        }
        return this.dataEditB;
    }

    private ModifyTextField getTitleTF() {
        if (this.titleTF == null) {
            this.titleTF = new ModifyTextField(true, true);
            this.titleTF.addActionListener(this);
        }
        return this.titleTF;
    }

    private ModifyTextField getWidthTF() {
        if (this.widthTF == null) {
            this.widthTF = new ModifyTextField(true, true);
            Dimension d = this.widthTF.getPreferredSize();
            d.width = 40;
            this.widthTF.setPreferredSize(d);
            this.widthTF.addActionListener(this);
        }
        return this.widthTF;
    }

    private ModifyTextField getPaddingTF() {
        if (this.paddingTF == null) {
            this.paddingTF = new ModifyTextField(true, true);
            Dimension e = this.paddingTF.getPreferredSize();
            e.width = 40;
            this.paddingTF.setPreferredSize(e);
            this.paddingTF.addActionListener(this);
        }
        return this.paddingTF;
    }

    private ModifyTextField getBranchTF() {
        if (this.branchTF == null) {
            this.branchTF = new ModifyTextField(true, true);
            Dimension f = this.branchTF.getPreferredSize();
            f.width = 40;
            this.branchTF.setPreferredSize(f);
            this.branchTF.addActionListener(this);
        }
        return this.branchTF;
    }

    private ModifyTextField getAgeLabelPaddingTF() {
        if (this.ageLabelPaddingTF == null) {
            this.ageLabelPaddingTF = new ModifyTextField(true, true);
            Dimension e = this.paddingTF.getPreferredSize();
            e.width = 40;
            this.ageLabelPaddingTF.setPreferredSize(e);
            this.ageLabelPaddingTF.addActionListener(this);
        }
        return this.ageLabelPaddingTF;
    }

    private JCheckBox getShowTitleCB() {
        if (this.showTitleCB == null) {
            this.showTitleCB = new JCheckBox(Language.translate("Show Title", true));
            this.showTitleCB.addActionListener(this);
        }
        return this.showTitleCB;
    }

    private JCheckBox getShowAgeLabelsCB() {
        if (this.showAgeLabelsCB == null) {
            this.showAgeLabelsCB = new JCheckBox(Language.translate("Show Age Labels", true));
            this.showAgeLabelsCB.addActionListener(this);
        }
        return this.showAgeLabelsCB;
    }

    private JCheckBox getShowUncertaintyLabelsCB() {
        if (this.showUncertaintyLabelsCB == null) {
            this.showUncertaintyLabelsCB = new JCheckBox(Language.translate("Show Uncertainty Labels", true));
            this.showUncertaintyLabelsCB.addActionListener(this);
        }
        return this.showUncertaintyLabelsCB;
    }

    private JCheckBox getFTpriorityEnable() {
        if (this.FTpriorityEnable == null) {
            this.FTpriorityEnable = new JCheckBox(Language.translate("Enable", true));
            this.FTpriorityEnable.addActionListener(this);
        }
        return this.FTpriorityEnable;
    }

    private JComboBox getFTpriorityVal() {
        if (this.FTpriorityVal == null) {
            String[] prioVals = new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"};
            this.FTpriorityVal = new JComboBox<String>(prioVals);
            this.FTpriorityVal.setSelectedIndex(0);
            this.FTpriorityVal.addActionListener(this);
        }
        return this.FTpriorityVal;
    }

    private JButton getMoveUp() {
        if (this.moveUp == null) {
            this.moveUp = new JButton();
            ImageIcon icon = FileUtils.getImageIcon(ResPath.getPath("gui.arrow_up"));
            this.moveUp.setIcon(icon);
            this.moveUp.addActionListener(this);
        }
        return this.moveUp;
    }

    private JButton getMoveDown() {
        if (this.moveDown == null) {
            this.moveDown = new JButton();
            ImageIcon icon = FileUtils.getImageIcon(ResPath.getPath("gui.arrow_down"));
            this.moveDown.setIcon(icon);
            this.moveDown.addActionListener(this);
        }
        return this.moveDown;
    }

    public String getIndexTitle() {
        int p = this.timesTabbedPane.getSelectedIndex();
        String myTitle = this.timesTabbedPane.getTitleAt(p);
        return myTitle;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DataColumn col = null;
        Object o = this.zoneTree.getLastSelectedPathComponent();
        if (o instanceof DataColumn) {
            col = (DataColumn)o;
        }
        if (o instanceof DataColumnTreeNode) {
            col = ((DataColumnTreeNode)o).col;
        }
        mySelectDC = this.curSelectDC = col;
        this.updateZoneSelectRadios();
    }

    public void updateZoneSelectRadios() {
        if (this.curSelectDC == null) {
            this.colorLabel.setEnabled(false);
            this.variableColorRadio.setEnabled(false);
            this.resetColorButton.setEnabled(false);
            this.customRadio.setEnabled(false);
            this.customColor.setEnabled(false);
            this.customColorBox.setBackground(Color.WHITE);
            this.fontOptionsB.setEnabled(false);
            this.dataEditB.setEnabled(false);
            this.variableColorRadio.setSelected(false);
            this.customRadio.setSelected(true);
            this.titleLabel.setEnabled(false);
            this.titleTF.setEnabled(false);
            this.titleTF.setText(SOLID_STROKE);
            this.showTitleCB.setEnabled(false);
            this.showAgeLabelsCB.setEnabled(false);
            this.showUncertaintyLabelsCB.setEnabled(false);
            this.widthLabel.setEnabled(false);
            this.widthTF.setEnabled(false);
            this.widthTF.setText(SOLID_STROKE);
            this.paddingLabel.setVisible(false);
            this.paddingTF.setVisible(false);
            this.paddingTF.setText(SOLID_STROKE);
            this.ageLabelPaddingLabel.setVisible(false);
            this.ageLabelPaddingTF.setVisible(false);
            this.ageLabelPaddingTF.setText(SOLID_STROKE);
            this.FTpriorityLabel.setEnabled(false);
            this.FTpriorityEnable.setEnabled(false);
            this.FTpriorityVal.setEnabled(false);
            this.colOptionsPanel.removeAll();
            this.colOptionsPanel.repaint();
            this.setColInfoText(null, null);
            this.colPanel.doLayout();
            this.colPanel.revalidate();
            this.colPanel.repaint();
        } else if (this.curSelectDC instanceof MetaColumn) {
            this.colorLabel.setEnabled(true);
            this.variableColorRadio.setEnabled(false);
            this.resetColorButton.setEnabled(false);
            this.customRadio.setEnabled(false);
            this.customColor.setEnabled(false);
            this.customColorBox.setBackground(Color.WHITE);
            this.fontOptionsB.setEnabled(true);
            this.dataEditB.setEnabled(false);
            this.variableColorRadio.setSelected(false);
            this.customRadio.setSelected(true);
            this.titleLabel.setEnabled(true);
            this.titleTF.setEnabled(true);
            this.titleTF.setText(this.curSelectDC.name);
            this.showTitleCB.setEnabled(true);
            this.showTitleCB.setSelected(this.curSelectDC.drawTitle);
            this.showAgeLabelsCB.setEnabled(false);
            this.showUncertaintyLabelsCB.setEnabled(false);
            this.widthLabel.setEnabled(false);
            this.widthTF.setEnabled(false);
            this.widthTF.setText(SOLID_STROKE);
            this.paddingLabel.setVisible(false);
            this.paddingTF.setVisible(false);
            this.paddingTF.setText(SOLID_STROKE);
            this.ageLabelPaddingLabel.setVisible(false);
            this.ageLabelPaddingTF.setVisible(false);
            this.ageLabelPaddingTF.setText(SOLID_STROKE);
            if (this.curSelectDC instanceof RootColumn && ((RootColumn)this.curSelectDC).unit == null) {
                this.titleLabel.setEnabled(false);
                this.titleTF.setEnabled(false);
                this.showTitleCB.setEnabled(false);
            }
            this.FTpriorityLabel.setEnabled(false);
            this.FTpriorityEnable.setEnabled(false);
            this.FTpriorityVal.setEnabled(false);
            this.colOptionsPanel.removeAll();
            this.colOptionsPanel.add(this.curSelectDC.getOptionsPanel());
            this.colOptionsPanel.revalidate();
            this.colOptionsPanel.repaint();
            this.setColInfoText(this.curSelectDC.popup, this.curSelectDC.fileInfo != null ? this.curSelectDC.fileInfo : null);
            this.colPanel.doLayout();
            this.colPanel.revalidate();
            this.colPanel.repaint();
        } else {
            this.colorLabel.setEnabled(true);
            this.variableColorRadio.setEnabled(true);
            this.resetColorButton.setEnabled(true);
            this.customRadio.setEnabled(true);
            this.customColor.setEnabled(true);
            this.customColorBox.setBackground(this.curSelectDC.guiColor.oneColor);
            this.fontOptionsB.setEnabled(true);
            this.dataEditB.setEnabled(false);
            if (this.curSelectDC.color == Coloring.USGS || this.curSelectDC.color == Coloring.NAMED_USGS || this.curSelectDC.color == Coloring.UNESCO || this.curSelectDC.color == Coloring.NAMED_UNESCO || this.curSelectDC.color == this.variableColoring || this.curSelectDC.color == this.variableNamedColoring) {
                this.variableColorRadio.setSelected(true);
            } else if (this.curSelectDC.color == null) {
                this.variableColorRadio.setSelected(false);
                this.customRadio.setSelected(false);
            } else {
                this.customRadio.setSelected(true);
                this.curSelectDC.guiColor = this.curSelectDC.color;
                this.customColorBox.setBackground(this.curSelectDC.guiColor.oneColor);
            }
            this.titleLabel.setEnabled(true);
            this.titleTF.setEnabled(true);
            this.titleTF.setText(this.curSelectDC.name);
            this.showTitleCB.setEnabled(true);
            this.showTitleCB.setSelected(this.curSelectDC.drawTitle);
            if (this.curSelectDC instanceof RangeColumn) {
                this.FTpriorityLabel.setEnabled(true);
                this.FTpriorityEnable.setEnabled(true);
                this.FTpriorityVal.setEnabled(true);
                this.FTpriorityEnable.setSelected(this.curSelectDC.priorityEnable);
                this.FTpriorityVal.setSelectedIndex(10 - this.curSelectDC.priorityVal);
            }
            if (this.curSelectDC instanceof PointColumn || this.curSelectDC instanceof AgeAgeColumn || this.curSelectDC instanceof FreehandColumn) {
                this.showAgeLabelsCB.setEnabled(false);
                this.showUncertaintyLabelsCB.setEnabled(false);
            } else {
                this.showAgeLabelsCB.setEnabled(true);
                this.showAgeLabelsCB.setSelected(this.curSelectDC.drawAgeLabel);
                this.showUncertaintyLabelsCB.setEnabled(this.curSelectDC.drawAgeLabel);
                this.showUncertaintyLabelsCB.setSelected(this.curSelectDC.drawUncertaintyLabel);
            }
            this.widthLabel.setEnabled(true);
            this.widthTF.setEnabled(true);
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
            if (this.curSelectDC instanceof RangeColumn) {
                this.paddingLabel.setVisible(true);
                this.paddingTF.setVisible(true);
                if (RangeColumn.ConserveSpace) {
                    this.curSelectDC.setRangeColumnWidthPadding(0.0);
                } else {
                    this.curSelectDC.setRangeColumnWidthPadding(0.0);
                }
                this.paddingTF.setText(nf.format(this.curSelectDC.getRangeColumnWidthPadding()));
                this.ageLabelPaddingLabel.setVisible(true);
                this.ageLabelPaddingTF.setVisible(true);
                this.ageLabelPaddingTF.setText(nf.format(this.curSelectDC.getAgeLabelPadding()));
                this.BranchSpacingLabel.setVisible(true);
                this.branchTF.setVisible(true);
                this.branchTF.setText(nf.format(this.curSelectDC.getBranchSpacing()));
            } else {
                this.paddingLabel.setVisible(false);
                this.paddingTF.setVisible(false);
                this.paddingTF.setText(SOLID_STROKE);
                this.ageLabelPaddingLabel.setVisible(false);
                this.ageLabelPaddingTF.setVisible(false);
                this.ageLabelPaddingTF.setText(SOLID_STROKE);
                this.BranchSpacingLabel.setVisible(false);
                this.branchTF.setVisible(false);
                this.branchTF.setText(SOLID_STROKE);
            }
            if (this.curSelectDC instanceof RulerColumn || this.curSelectDC instanceof AgeAgeColumn || this.curSelectDC instanceof RangeColumn) {
                this.widthTF.setText(Language.translate("auto", true));
                this.widthTF.setEnabled(false);
            } else {
                this.widthTF.setText(nf.format(this.curSelectDC.getMyWidth()));
            }
            this.colOptionsPanel.removeAll();
            if (this.curSelectDC instanceof RangeColumn) {
                RangeColumn rc = (RangeColumn)this.curSelectDC;
                rc.settings = this;
            }
            JPanel colPane = this.curSelectDC.getOptionsPanel();
            JScrollPane colScrollPane = new JScrollPane(colPane);
            colScrollPane.setViewportView(colPane);
            if (this.curSelectDC instanceof PointColumn) {
                colScrollPane.setPreferredSize(new Dimension(100, 70));
            } else {
                colScrollPane.setPreferredSize(new Dimension(100, 150));
            }
            this.colOptionsPanel.add(colScrollPane);
            this.colOptionsPanel.revalidate();
            this.colOptionsPanel.repaint();
            if (this.curSelectDC instanceof PointColumn) {
                this.curSelectDC.passName(this.curSelectDC.getName());
            }
            this.setColInfoText(this.curSelectDC.popup, this.curSelectDC.fileInfo != null ? this.curSelectDC.fileInfo : null);
            this.colPanel.doLayout();
            this.colPanel.revalidate();
            this.colPanel.repaint();
        }
        this.zoneOptionsPanel.doLayout();
        this.zoneOptionsPanel.revalidate();
    }

    protected void setColInfoText(String t, DataColumn.FileInfo fileInfo) {
        if (t != null) {
            this.colInfoLabel.setText("<html>" + HTMLPreprocessor.findAndFixDatapackLinks(t, fileInfo) + "</html>");
        } else {
            this.colInfoLabel.setText(SOLID_STROKE);
        }
    }

    public File openSaveSettingsFileDialog() {
        FileDialog fileChooser = new FileDialog(new Frame(), "Save settings file", 1);
        fileChooser.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.endsWith(".tsc");
            }
        });
        fileChooser.setFile("settings.tsc");
        fileChooser.setVisible(true);
        File selFile = null;
        if (fileChooser.getFile() != null && !fileChooser.getFile().isEmpty()) {
            selFile = new File(fileChooser.getDirectory() + fileChooser.getFile());
        }
        return selFile;
    }

    public File openLoadSettingsFileDialog() {
        FileDialog fileChooser = new FileDialog(new Frame(), "Save settings file", 0);
        fileChooser.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.endsWith(".tsc");
            }
        });
        fileChooser.setVisible(true);
        File selFile = null;
        if (fileChooser.getFile() != null && !fileChooser.getFile().isEmpty()) {
            selFile = new File(fileChooser.getDirectory() + fileChooser.getFile());
        }
        return selFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MetaColumn p;
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setVisible(false);
        } else if (source == this.generateAndCloseButton) {
            this.setVisible(false);
            if (generateAction != null) {
                generateAction.actionPerformed(null);
            }
        } else if (source == this.generateAndKeepOpenButton) {
            if (generateAction != null) {
                generateAction.actionPerformed(null);
            }
        } else if (source == this.generate3DButton) {
            if (this.generate3DButton != null) {
                this.generate3DAction.actionPerformed(null);
            }
        } else if (source == this.saveButton) {
            try {
                File selFile = this.openSaveSettingsFileDialog();
                this.setupWrite(FileUtils.appendExtension(selFile.getAbsolutePath(), "tsc"));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.toString() + "\n" + ex.getStackTrace().toString());
            }
        } else if (source == this.loadButton) {
            try {
                this.loadSettingsButtonClick = true;
                File selFile = this.openLoadSettingsFileDialog();
                this.setupRead(FileUtils.appendExtension(selFile.getAbsolutePath(), "tsc"));
            }
            catch (Exception ex) {
                ErrorHandler.showError(ex, null, "Error", 3);
            }
        } else if (source == this.customColor) {
            Color chosenColor;
            Color initColor = Color.white;
            if (this.curSelectDC != null) {
                initColor = this.curSelectDC.guiColor.oneColor;
            }
            if ((chosenColor = JColorChooser.showDialog(this, Language.translate("Choose Column's Background Color", true), initColor)) != null) {
                this.curSelectDC.guiColor = new Coloring(chosenColor);
                this.customColorBox.setBackground(chosenColor);
                this.curSelectDC.color = this.curSelectDC.guiColor;
                this.customRadio.setSelected(true);
            }
        } else if (source == this.resetColorButton) {
            this.curSelectDC.color = this.curSelectDC.defaultColor;
            if (this.curSelectDC.color != null && this.curSelectDC.color.oneColor != null) {
                this.curSelectDC.guiColor = this.curSelectDC.color;
            }
            this.updateZoneSelectRadios();
        } else if (source == this.fontOptionsB) {
            if (this.curSelectDC.getParent() == null) {
                this.tabbedPane.setSelectedComponent(this.fontTabPanel);
            } else {
                JOptionPane.showOptionDialog(this, this.curSelectDC.getFontOptionsPanel(), Language.translate("Set Column Font", true), 0, -1, null, new String[]{"Close"}, null);
            }
        } else if (source == this.dataEditB) {
            if (this.curSelectDC != null) {
                // empty if block
            }
        } else if (source == this.titleTF) {
            if (this.titleTF.isEnabled()) {
                String nt = this.titleTF.getText();
                if (this.curSelectDC != null) {
                    this.curSelectDC.setName(nt);
                }
            }
        } else if (source == this.showTitleCB) {
            if (this.curSelectDC != null) {
                this.curSelectDC.drawTitle = this.showTitleCB.isSelected();
            }
        } else if (source == this.showAgeLabelsCB) {
            if (this.curSelectDC != null) {
                this.curSelectDC.drawAgeLabel = this.showAgeLabelsCB.isSelected();
                this.showUncertaintyLabelsCB.setEnabled(this.curSelectDC.drawAgeLabel);
                this.curSelectDC.drawUncertaintyLabel = this.curSelectDC.drawAgeLabel ? this.showUncertaintyLabelsCB.isSelected() : false;
            }
        } else if (source == this.showUncertaintyLabelsCB) {
            if (this.curSelectDC != null) {
                this.curSelectDC.drawUncertaintyLabel = this.curSelectDC.drawAgeLabel ? this.showUncertaintyLabelsCB.isSelected() : false;
            }
        } else if (source == this.widthTF) {
            if (this.widthTF.isEnabled()) {
                double dw;
                String sw = this.widthTF.getText();
                try {
                    dw = Double.parseDouble(sw);
                }
                catch (NumberFormatException nfe) {
                    dw = 0.0;
                }
                if (this.curSelectDC != null) {
                    if (dw < 20.0) {
                        dw = 20.0;
                    }
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumFractionDigits(0);
                    this.curSelectDC.setWidth(dw);
                    if (!this.widthTF.hasFocus()) {
                        sw = nf.format(dw);
                        this.widthTF.setText(sw);
                    }
                } else {
                    this.widthTF.setText(SOLID_STROKE);
                }
            }
        } else if (source == this.paddingTF) {
            if (this.paddingTF.isEnabled()) {
                double dw;
                String sw = this.paddingTF.getText();
                try {
                    dw = Double.parseDouble(sw);
                }
                catch (NumberFormatException nfe) {
                    dw = 0.0;
                }
                if (this.curSelectDC != null) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumFractionDigits(0);
                    this.curSelectDC.setRangeColumnWidthPadding(dw);
                    if (!this.paddingTF.hasFocus()) {
                        sw = nf.format(dw);
                        this.paddingTF.setText(sw);
                    }
                } else {
                    this.paddingTF.setText("0.0");
                }
            }
        } else if (source == this.ageLabelPaddingTF) {
            if (this.ageLabelPaddingTF.isEnabled()) {
                double dw;
                String sw = this.ageLabelPaddingTF.getText();
                try {
                    dw = Double.parseDouble(sw);
                }
                catch (NumberFormatException nfe) {
                    dw = 0.0;
                }
                if (this.curSelectDC != null) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumFractionDigits(0);
                    this.curSelectDC.setAgeLabelPadding(dw);
                    if (!this.ageLabelPaddingTF.hasFocus()) {
                        sw = nf.format(dw);
                        this.ageLabelPaddingTF.setText(sw);
                    }
                } else {
                    this.ageLabelPaddingTF.setText("0");
                }
            }
        } else if (source == this.branchTF) {
            if (this.branchTF.isEnabled()) {
                double dw;
                String sw = this.branchTF.getText();
                try {
                    dw = Double.parseDouble(sw);
                }
                catch (NumberFormatException nfe) {
                    dw = 0.0;
                }
                if (this.curSelectDC != null) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumFractionDigits(0);
                    this.curSelectDC.setBranchSpacing(dw);
                    if (!this.branchTF.hasFocus()) {
                        sw = nf.format(dw);
                        this.branchTF.setText(sw);
                    }
                } else {
                    this.branchTF.setText("0");
                }
            }
        } else if (source == this.FTpriorityEnable) {
            if (this.curSelectDC != null) {
                this.curSelectDC.priorityEnable = this.FTpriorityEnable.isSelected();
            }
        } else if (source == this.FTpriorityVal) {
            if (this.curSelectDC != null) {
                this.curSelectDC.priorityVal = 10 - this.FTpriorityVal.getSelectedIndex();
            }
        } else if (source == this.moveUp) {
            MetaColumn p2;
            if (this.curSelectDC != null && (p2 = this.curSelectDC.getColParent()) != null) {
                TreePath selPath = this.zoneTree.getSelectionPath();
                p2.moveColumn(this.curSelectDC, -1);
                this.zoneTree.setSelectionPath(selPath);
            }
        } else if (source == this.moveDown && this.curSelectDC != null && (p = this.curSelectDC.getColParent()) != null) {
            TreePath selPath = this.zoneTree.getSelectionPath();
            p.moveColumn(this.curSelectDC, 1);
            this.zoneTree.setSelectionPath(selPath);
        }
        if (source == this.searchButton) {
            this.startSearch(this.searchtextField.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean forceValidate = false;
        Object item = e.getItem();
        if (item == this.USGSRadio) {
            if (this.USGSRadio.isSelected()) {
                this.variableNamedColoring.set(Coloring.NAMED_USGS);
                this.variableColoring.set(Coloring.USGS);
            }
        } else if (item == this.UNESCORadio) {
            if (this.UNESCORadio.isSelected()) {
                this.variableNamedColoring.set(Coloring.NAMED_UNESCO);
                this.variableColoring.set(Coloring.UNESCO);
            }
        } else if (item == this.variableColorRadio) {
            if (this.curSelectDC == null) {
                return;
            }
            this.curSelectDC.color = this.curSelectDC.useNamedColor ? this.variableNamedColoring : this.variableColoring;
        } else if (item == this.customRadio) {
            if (this.curSelectDC == null) {
                return;
            }
            this.curSelectDC.color = this.curSelectDC.guiColor;
        } else if (item == this.negativeCheck) {
            negativeChk = this.negativeCheck.isSelected();
        } else if (item == this.popupCheck) {
            this.doPopups = this.popupCheck.isSelected();
        } else if (item == this.enEventBG) {
            this.enEventColBG = this.enEventBG.isSelected();
        } else if (item == this.enLegend) {
            this.enChartLegend = this.enLegend.isSelected();
        } else if (item == this.enConsSpaceFT) {
            RangeColumn.ConserveSpace = this.enConsSpace = this.enConsSpaceFT.isSelected();
            NumberFormat nf = NumberFormat.getNumberInstance();
            if (this.curSelectDC == null) {
                return;
            }
            if (RangeColumn.ConserveSpace) {
                this.curSelectDC.setRangeColumnWidthPadding(0.0);
            } else {
                this.curSelectDC.setRangeColumnWidthPadding(0.0);
            }
            this.paddingTF.setText(nf.format(this.curSelectDC.getRangeColumnWidthPadding()));
        } else if (item == this.enGlobalPriority) {
            this.enPriority = this.enGlobalPriority.isSelected();
        } else if (item == this.enBlockLableHide) {
            this.enHideBlockLable = this.enBlockLableHide.isSelected();
        } else if (item == this.noIndent) {
            this.noIndentPattern = this.noIndent.isSelected();
        }
        if (item == this.commentsCheck) {
            searchComments = this.commentsCheck.isSelected();
        }
        if (item == this.chartCheck) {
            this.updateAgeFromSearchResults();
        }
        if (this.errorLabel.getText().length() > 0 || forceValidate) {
            this.isValidToGenerate();
        }
    }

    @Override
    public void timesChanged(int type, Unit affectedUnit) {
        SelectedTimes st = this.timesSelections.get(affectedUnit);
        if (st != null) {
            st.setToTP(this.timesPanels.get(affectedUnit), true);
            TSCreator.setSettings(st);
        }
        switch (type) {
            case 0: {
                this.grayOutEmptyColumns();
                this.isValidToGenerate();
                break;
            }
            case 1: {
                this.grayOutEmptyColumns();
                break;
            }
        }
    }

    public void setErrorString(String e, int severity) {
        switch (severity) {
            case 3: {
                this.errorLabel.setForeground(new Color(0, 128, 0));
                break;
            }
            case 2: {
                this.errorLabel.setForeground(new Color(128, 128, 0));
                break;
            }
            default: {
                this.errorLabel.setForeground(new Color(128, 0, 0));
            }
        }
        this.errorLabel.setText(e);
    }

    public String getErrorString() {
        return this.errorLabel.getText();
    }

    public void grayOutEmptyColumns() {
        if (this.ignoreGrayOut) {
            return;
        }
        this.ignoreGrayOut = true;
        Iterator<DataColumn> unitRootIter = this.ds.rootColumn.getSubColumns();
        while (unitRootIter.hasNext()) {
            DataColumn dc = unitRootIter.next();
            SelectedTimes st = this.timesSelections.get(dc.unit);
            if (st == null) continue;
            dc.grayOutIfEmpty(st.topAge, st.baseAge, st.skipEmptyColumns);
        }
        this.ignoreGrayOut = false;
    }

    public void setFromAutoGenOptions(AutoGenOptions ago) {
        SelectedTimes st;
        if (ago.times.size() == 1 && this.ds.rootColumn.getSubColumnCount() == 1) {
            SelectedTimes st2 = ago.times.entrySet().iterator().next().getValue();
            Unit u = this.ds.rootColumn.getSubColumns().next().unit;
            this.timesSelections.clear();
            this.timesSelections.put(u, st2);
            return;
        }
        this.timesSelections.clear();
        for (String agoU : ago.times.keySet()) {
            Unit u = this.ds.getExistingUnitFromString(agoU);
            if (u == null) {
                System.out.println("Warning: '" + agoU + "' doesn't appear in the datafile. Ignoring.");
                continue;
            }
            st = ago.getSTForUnit(agoU);
            if (st == null) {
                System.out.println("Internal error with times for '" + agoU + "'");
                continue;
            }
            this.timesSelections.put(u, st);
        }
        Iterator<DataColumn> unitRootIter = this.ds.rootColumn.getSubColumns();
        while (unitRootIter.hasNext()) {
            DataColumn dc = unitRootIter.next();
            if (this.timesSelections.containsKey(dc.unit)) continue;
            st = new SelectedTimes();
            if (ago.autoVSForAll) {
                st.vertScale = -1.0;
            }
            this.timesSelections.put(dc.unit, st);
        }
    }

    public boolean isValidToGenerate() {
        this.isValid = true;
        ImageGenerator errorCheck = new ImageGenerator(this.ds.rootColumn, TSCreator.settings, this.ds.patMan);
        if (TSCreator.autoGenOptions == null) {
            for (Map.Entry<Unit, TimesPanel> entry : this.timesPanels.entrySet()) {
                Unit u = entry.getKey();
                TimesPanel tp = entry.getValue();
                RootColumn rc = errorCheck.rootCol.getChildRoot(u);
                SelectedTimes st = new SelectedTimes(tp, true);
                if (!st.isValid && !rc.isOutcrop || st.isValid && rc.isOutcrop) {
                    this.isValid = false;
                    if (st.error == SOLID_STROKE) {
                        st.error = !rc.isOutcrop ? "Base age must be older than top age!" : "Top depth must be higher than base depth!";
                    }
                    this.setErrorString(u.getName() + ": " + st.error, 1);
                    break;
                }
                this.timesSelections.put(u, st);
            }
            if (this.isValid) {
                this.setErrorString("Ready to generate!", 3);
            }
        } else {
            for (Map.Entry<Unit, SelectedTimes> entry : this.timesSelections.entrySet()) {
                Unit u = entry.getKey();
                SelectedTimes st = entry.getValue();
                if (st.checkIsValid(u)) continue;
                this.isValid = false;
                System.out.println(u.toString() + ": " + st.error);
            }
            this.grayOutEmptyColumns();
        }
        return this.isValid;
    }

    public void printTimeSelections() {
        for (Map.Entry<Unit, SelectedTimes> entry : this.timesSelections.entrySet()) {
            Unit u = entry.getKey();
            SelectedTimes st = entry.getValue();
            System.out.println(u.toString() + " interval is " + st.topAge + " to " + st.baseAge + ", vs=" + st.vertScale);
        }
    }

    protected void setupRead(String filePath) {
        DOMParser parser = new DOMParser();
        try {
            ZipFile zipSet = new ZipFile(filePath);
            ZipEntry entrySet = zipSet.entries().nextElement();
            InputSource is = new InputSource(zipSet.getInputStream(entrySet));
            parser.parse(is);
        }
        catch (SAXException se) {
            ErrorHandler.showError(se, null, "Error", 3);
        }
        catch (IOException ioe) {
            try {
                InputSource is = new InputSource(FileUtils.getInputStream(filePath));
                parser.parse(is);
            }
            catch (SAXException se) {
                ErrorHandler.showError(se, null, "Error", 3);
            }
            catch (IOException ie) {
                ErrorHandler.showError(ie, null, "Error", 3);
            }
        }
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        this.ds.rootColumn.setLoaded(false);
        NodeList nl = root.getChildNodes();
        for (int nodeIndex = 0; nodeIndex < nl.getLength(); ++nodeIndex) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if (name.compareToIgnoreCase("settings") == 0) {
                this.readSettings((Element)node);
                continue;
            }
            if (name.compareToIgnoreCase("fonts") == 0) {
                this.fonts.readSettings((Element)node);
                continue;
            }
            if (name.compareToIgnoreCase("column") != 0) continue;
            this.ds.rootColumn.readSettings((Element)node, this);
        }
        this.fontTabPanel.removeAll();
        this.fontPanel = null;
        this.fontTabPanel.add(this.getFontPanel());
        this.zoneTree.setSelectionPath(null);
        if (TSCreator.autoGenOptions != null) {
            this.updateTimesSelections();
        }
        if (this.loadSettingsButtonClick.booleanValue()) {
            Set<Unit> unitSet = this.timesPanels.keySet();
            for (Unit unit : unitSet) {
                this.timesChanged(2, unit);
            }
            this.loadSettingsButtonClick = false;
        }
        this.grayOutEmptyColumns();
    }

    public void setupWrite(String filePath) throws IOException {
        DocumentImpl docImpl = new DocumentImpl();
        DOMImplementation impl = docImpl.getImplementation();
        Document doc = impl.createDocument(SOLID_STROKE, "TSCreator", null);
        Element root = doc.getDocumentElement();
        root.setAttribute("version", ProgramInfo.get("TSC_VERSION"));
        Element settingsE = doc.createElement("settings");
        settingsE.setAttribute("version", "1.0");
        this.writeSettings(settingsE, doc);
        root.appendChild(settingsE);
        if (TSCreator.SAVE_COMPLETE_SETTINGS) {
            Element fontsE = doc.createElement("fonts");
            this.fonts.writeSettings(fontsE, doc);
            root.appendChild(fontsE);
        }
        Element rootColE = doc.createElement("column");
        this.ds.rootColumn.writeSettings(rootColE, doc);
        root.appendChild(rootColE);
        FileOutputStream out = new FileOutputStream(filePath);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        OutputFormat outFormat = new OutputFormat();
        outFormat.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(writer, outFormat);
        serializer.serialize(doc);
        out.close();
        writer.close();
    }

    public void backupSettings() {
        try {
            this.setupWrite(settingsBackupFile);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.toString() + "\n" + ex.getStackTrace().toString());
        }
    }

    public static void saveBackup(File backup) {
        int result = JOptionPane.showConfirmDialog(null, "Detected a crash. Would you like to save your backedup settings?", "Confirm Save?", 0);
        if (result != 0) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save Backup Settingsfile");
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("TSCreator settings file (*.tsc)");
        eff.addExtension("tsc", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showSaveDialog(TSCreator.curCreator);
        if (returnVal == 0) {
            try {
                backup.renameTo(new File(FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "tsc")));
            }
            catch (SecurityException ex) {
                JOptionPane.showMessageDialog(TSCreator.curCreator, ex.toString() + "\n" + ex.getStackTrace().toString());
            }
            catch (NullPointerException ex) {
                JOptionPane.showMessageDialog(TSCreator.curCreator, ex.toString() + "\n" + ex.getStackTrace().toString());
            }
        }
    }

    public void readSettings(Element element) {
        NodeList nl = element.getChildNodes();
        for (int elementIndex = 0; elementIndex < nl.getLength(); ++elementIndex) {
            Unit u;
            Element setting;
            Node node = nl.item(elementIndex);
            if (node.getNodeType() != 1 || (setting = (Element)node).getTagName().compareToIgnoreCase("setting") != 0) continue;
            String unit_string = setting.getAttribute("unit");
            TimesPanel tp = null;
            SelectedTimes st = null;
            if (unit_string == null || unit_string.length() < 1) {
                u = this.ds.getExistingUnitFromString("Ma");
                tp = this.timesPanels.get(u);
                if (tp == null && this.timesPanels.size() > 0) {
                    tp = this.timesPanels.entrySet().iterator().next().getValue();
                }
            } else {
                u = this.ds.getExistingUnitFromString(unit_string);
                tp = this.timesPanels.get(u);
                st = this.timesSelections.get(u);
            }
            try {
                int i;
                String stage;
                String subName;
                Element sub;
                Node subNode;
                int subIndex;
                NodeList subNL;
                String source;
                String name = setting.getAttribute("name");
                if (name == null) continue;
                if (name.compareToIgnoreCase("topAge") == 0 && tp != null) {
                    source = setting.getAttribute("source");
                    if ("stage".compareToIgnoreCase(source) == 0) {
                        tp.topStageRadio.setSelected(true);
                    } else {
                        tp.topMYRadio.setSelected(true);
                    }
                    subNL = setting.getChildNodes();
                    block4: for (subIndex = 0; subIndex < subNL.getLength(); ++subIndex) {
                        subNode = subNL.item(subIndex);
                        if (subNode.getNodeType() != 1 || (sub = (Element)subNode).getTagName().compareToIgnoreCase("setting") != 0) continue;
                        subName = sub.getAttribute("name");
                        if (sub.getTagName().compareToIgnoreCase("setting") != 0 || subName == null) continue;
                        if (subName.compareToIgnoreCase("stage") == 0) {
                            stage = Settings.getNodeTextContent(sub);
                            for (i = 0; i < tp.topStage.getItemCount(); ++i) {
                                if (tp.topStage.getItemAt(i).toString().compareToIgnoreCase(stage) != 0) continue;
                                tp.topStage.setSelectedIndex(i);
                                continue block4;
                            }
                            continue;
                        }
                        if (subName.compareToIgnoreCase("text") != 0) continue;
                        tp.topMY.setText(Settings.getNodeTextContent(sub));
                    }
                    continue;
                }
                if (name.compareToIgnoreCase("baseAge") == 0 && tp != null) {
                    source = setting.getAttribute("source");
                    if ("stage".compareToIgnoreCase(source) == 0) {
                        tp.baseStageRadio.setSelected(true);
                    } else {
                        tp.baseMYRadio.setSelected(true);
                    }
                    subNL = setting.getChildNodes();
                    block6: for (subIndex = 0; subIndex < subNL.getLength(); ++subIndex) {
                        subNode = subNL.item(subIndex);
                        if (subNode.getNodeType() != 1 || (sub = (Element)subNode).getTagName().compareToIgnoreCase("setting") != 0 || (subName = sub.getAttribute("name")) == null) continue;
                        if (subName.compareToIgnoreCase("stage") == 0) {
                            stage = Settings.getNodeTextContent(sub);
                            for (i = 0; i < tp.baseStage.getItemCount(); ++i) {
                                if (tp.baseStage.getItemAt(i).toString().compareToIgnoreCase(stage) != 0) continue;
                                tp.baseStage.setSelectedIndex(i);
                                continue block6;
                            }
                            continue;
                        }
                        if (subName.compareToIgnoreCase("text") != 0) continue;
                        tp.baseMY.setText(Settings.getNodeTextContent(sub));
                    }
                    continue;
                }
                if (name.compareToIgnoreCase("variableColors") == 0) {
                    if (Settings.getNodeTextContent(setting).compareToIgnoreCase("UNESCO") == 0) {
                        this.UNESCORadio.setSelected(true);
                        continue;
                    }
                    this.USGSRadio.setSelected(true);
                    continue;
                }
                if (name.compareToIgnoreCase("unitsPerMY") == 0 && (tp != null || st != null)) {
                    this.unitsPerMY = Double.parseDouble(Settings.getNodeTextContent(setting));
                    if (tp != null) {
                        tp.unitsPerMaTF.setText(SOLID_STROKE + this.unitsPerMY / 30.0);
                    }
                    if (st == null) continue;
                    st.vertScale = this.unitsPerMY / 30.0;
                    continue;
                }
                if (name.compareToIgnoreCase("negativeChk") == 0) {
                    negativeChk = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.negativeCheck.setSelected(negativeChk);
                    continue;
                }
                if (name.compareToIgnoreCase("doPopups") == 0) {
                    this.doPopups = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.popupCheck.setSelected(this.doPopups);
                    continue;
                }
                if (name.compareToIgnoreCase("enPriority") == 0) {
                    this.enPriority = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.enGlobalPriority.setSelected(this.enPriority);
                    continue;
                }
                if (name.compareToIgnoreCase("enHideBlockLable") == 0) {
                    this.enHideBlockLable = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.enBlockLableHide.setSelected(this.enHideBlockLable);
                    continue;
                }
                if (name.compareToIgnoreCase("enChartLegend") == 0) {
                    this.enChartLegend = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.enLegend.setSelected(this.enChartLegend);
                    continue;
                }
                if (name.compareToIgnoreCase("enEventColBG") == 0) {
                    this.enEventColBG = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    this.enEventBG.setSelected(this.enEventColBG);
                    continue;
                }
                if (name.compareToIgnoreCase("skipEmptyColumns") == 0 && tp != null) {
                    this.skipEmptyColumns = Boolean.valueOf(Settings.getNodeTextContent(setting));
                    tp.skipEmptyColumnsCheck.setSelected(this.skipEmptyColumns);
                    continue;
                }
                if (name.compareToIgnoreCase("noIndentPattern") != 0) continue;
                this.noIndentPattern = Boolean.valueOf(Settings.getNodeTextContent(setting));
                this.noIndent.setSelected(this.noIndentPattern);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        for (Map.Entry<Unit, TimesPanel> entry : this.timesPanels.entrySet()) {
            Element stage;
            Unit u = entry.getKey();
            TimesPanel tp = entry.getValue();
            if (tp == null) continue;
            Element setting = doc.createElement("setting");
            setting.setAttribute("unit", u.toString());
            setting.setAttribute("name", "topAge");
            if (tp.topStage.isEnabled()) {
                stage = doc.createElement("setting");
                stage.setAttribute("name", "stage");
                Settings.setNodeTextContent(stage, tp.topStage.getSelectedItem().toString(), doc);
                setting.appendChild(stage);
            }
            if (tp.topStageRadio.isSelected()) {
                setting.setAttribute("source", "stage");
            } else {
                setting.setAttribute("source", "text");
            }
            Element text = doc.createElement("setting");
            text.setAttribute("name", "text");
            Settings.setNodeTextContent(text, tp.topMY.getText(), doc);
            setting.appendChild(text);
            element.appendChild(setting);
            setting = doc.createElement("setting");
            setting.setAttribute("unit", u.toString());
            setting.setAttribute("name", "baseAge");
            if (tp.baseStage.isEnabled()) {
                stage = doc.createElement("setting");
                stage.setAttribute("name", "stage");
                Settings.setNodeTextContent(stage, tp.baseStage.getSelectedItem().toString(), doc);
                setting.appendChild(stage);
            }
            if (tp.baseStageRadio.isSelected()) {
                setting.setAttribute("source", "stage");
            } else {
                setting.setAttribute("source", "text");
            }
            text = doc.createElement("setting");
            text.setAttribute("name", "text");
            Settings.setNodeTextContent(text, tp.baseMY.getText(), doc);
            setting.appendChild(text);
            element.appendChild(setting);
            element.appendChild(Settings.createSimpleSetting(doc, u, "unitsPerMY", SOLID_STROKE + SelectedTimes.getVertScale(tp) * 30.0));
            element.appendChild(Settings.createSimpleSetting(doc, u, "skipEmptyColumns", SOLID_STROKE + tp.skipEmptyColumnsCheck.isSelected()));
        }
        String varCol = "USGS";
        if (this.UNESCORadio.isSelected()) {
            varCol = "UNESCO";
        }
        element.appendChild(Settings.createSimpleSetting(doc, "variableColors", varCol));
        element.appendChild(Settings.createSimpleSetting(doc, "noIndentPattern", SOLID_STROKE + this.noIndentPattern));
        element.appendChild(Settings.createSimpleSetting(doc, "negativeChk", SOLID_STROKE + negativeChk));
        element.appendChild(Settings.createSimpleSetting(doc, "doPopups", SOLID_STROKE + this.doPopups));
        element.appendChild(Settings.createSimpleSetting(doc, "enEventColBG", SOLID_STROKE + this.enEventColBG));
        element.appendChild(Settings.createSimpleSetting(doc, "enChartLegend", SOLID_STROKE + this.enChartLegend));
        element.appendChild(Settings.createSimpleSetting(doc, "enPriority", SOLID_STROKE + this.enPriority));
        element.appendChild(Settings.createSimpleSetting(doc, "enHideBlockLable", SOLID_STROKE + this.enHideBlockLable));
    }

    public static Element createSimpleSetting(Document doc, String name, String value) {
        Element e = doc.createElement("setting");
        e.setAttribute("name", name);
        Settings.setNodeTextContent(e, value, doc);
        return e;
    }

    public static Element createSimpleSetting(Document doc, Unit u, String name, String value) {
        Element e = doc.createElement("setting");
        e.setAttribute("name", name);
        e.setAttribute("unit", u.toString());
        Settings.setNodeTextContent(e, value, doc);
        return e;
    }

    public static void setNodeTextContent(Node n, String s, Document doc) {
        Node sub = n.getFirstChild();
        block3: while (sub != null) {
            switch (sub.getNodeType()) {
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    Node temp = sub.getNextSibling();
                    n.removeChild(sub);
                    sub = temp;
                    continue block3;
                }
            }
            sub = sub.getNextSibling();
        }
        n.appendChild(doc.createTextNode(s));
    }

    public static String getNodeTextContent(Node n) {
        String ret = SOLID_STROKE;
        switch (n.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return n.getNodeValue();
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                for (Node sub = n.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                    ret = ret + Settings.getNodeTextContent(sub);
                }
                return ret;
            }
        }
        return null;
    }

    public void mapDataAdded() {
        this.mapListPanel.updateMapData();
    }

    public void updateTimesSelections() {
        Iterator<DataColumn> unitRootIter = this.ds.rootColumn.getSubColumns();
        while (unitRootIter.hasNext()) {
            TimesPanel tp;
            DataColumn dc = unitRootIter.next();
            if (dc.unit == null || (tp = this.timesPanels.get(dc.unit)) == null) continue;
            SelectedTimes st = new SelectedTimes(tp, true);
            this.timesSelections.put(dc.unit, st);
        }
    }

    public void dataAdded() {
        if (TSCreator.autoGenOptions == null) {
            Iterator<DataColumn> unitRootIter = this.ds.rootColumn.getSubColumns();
            while (unitRootIter.hasNext()) {
                DataColumn dc = unitRootIter.next();
                if (dc.unit == null) continue;
                if (!this.timesPanels.containsKey(dc.unit)) {
                    this.addTimesTab(dc.unit);
                }
                SelectedTimes st = new SelectedTimes(this.timesPanels.get(dc.unit), true);
                this.timesSelections.put(dc.unit, st);
            }
            this.grayOutEmptyColumns();
        }
        if (this.noData) {
            if (this.ds.defaultColorScheme == Coloring.UNESCO || this.ds.defaultColorScheme == Coloring.NAMED_UNESCO) {
                this.UNESCORadio.setSelected(true);
            }
            this.noData = false;
        }
    }

    private void startSearch(String searchString) {
        if (this.searchResults == null) {
            this.searchResults = new SearchDataPack();
        }
        String[] searchStrings = searchString.split(";");
        boolean multipleWordSearch = false;
        for (int i = 0; i < searchStrings.length; ++i) {
            searchString = searchStrings[i].trim();
            this.clearAgeSet();
            Settings.closeCommentsPanes();
            boolean found = this.searchResults.search(this.ds, searchString, searchComments);
            System.out.println("found = " + found);
            System.out.println("String = " + searchString);
            if (!this.searchedStrings.contains(searchString)) {
                this.displaySearchResults(found, searchString, multipleWordSearch);
            }
            multipleWordSearch = true;
        }
        this.searchedStrings.clear();
    }

    private void displaySearchResults(boolean found, String searchString, boolean multipleWordSearch) {
        if (!multipleWordSearch) {
            this.searchResultsPanel.removeAll();
            this.noResultsLabel.setText(SOLID_STROKE);
        }
        boolean synFound = false;
        String synString = SearchDataPack.SynMapConstruct(searchString);
        if (!found) {
            this.noResultsLabel.setText("<html><b><br><p style=\"margin-left: 250px;\">No Results Found for " + searchString + "</p><br></b></html>");
        } else {
            this.resultsPane.getVerticalScrollBar().setValue(0);
            this.displayResults(searchString);
        }
        if (synString != null) {
            synFound = this.searchResults.search(this.ds, synString, searchComments);
        }
        if (synString != null && !synFound) {
            System.out.println("Nothing!!! " + synString);
            this.noResultsLabel.setText("<html><b><br><p style=\"margin-left: 20px;\">No Results Found for " + synString + "</p><br></b></html>");
        } else if (synString != null && synFound) {
            this.resultsPane.getVerticalScrollBar().setValue(0);
            if (!synString.equals(searchString)) {
                this.displayResults(synString);
            }
        }
        this.searchResultsPanel.revalidate();
        this.searchResultsPanel.repaint();
    }

    private void displayResults(String searchString) {
        JPanel panel;
        if (this.searchedStrings.contains(searchString)) {
            return;
        }
        this.searchedStrings.add(searchString);
        boolean position = true;
        this.searchResultsPanel.add(new JLabel("<html><b>Results for the word: " + searchString + "</b></html>"));
        if (this.searchResults.eventResults != null) {
            Iterator<Object> iter = this.searchResults.eventResults.iterator();
            System.out.println(searchString);
            while (iter.hasNext()) {
                EventResults eventResults = (EventResults)iter.next();
                String foundString = eventResults.foundString;
                if (eventResults.Synonyms != null) {
                    foundString = foundString + " ( ";
                    Iterator<String> iterSyn = eventResults.Synonyms.iterator();
                    while (iterSyn.hasNext()) {
                        foundString = foundString + iterSyn.next();
                    }
                    foundString = foundString + " )";
                }
                JPanel labelEvent = this.getResultSyn(foundString + " - Event");
                JPanel panel2 = this.getResultColumns(eventResults.event);
                this.searchResultsPanel.add(labelEvent);
                this.searchResultsPanel.add(panel2);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.blockResults != null) {
            for (BlockResults blockResults : this.searchResults.blockResults) {
                JPanel labelBlock = this.getResultSyn(blockResults.foundString + " - Block");
                panel = this.getResultColumns(blockResults.block);
                this.searchResultsPanel.add(labelBlock);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.rangeResults != null) {
            for (RangeResults rangeResults : this.searchResults.rangeResults) {
                JPanel labelRange = this.getResultSyn(rangeResults.foundString + " - Range");
                panel = this.getResultColumns(rangeResults.range);
                this.searchResultsPanel.add(labelRange);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.seqResults != null) {
            for (SeqResults seqResults : this.searchResults.seqResults) {
                JPanel labelSeq = this.getResultSyn(seqResults.foundString + " - Sequence");
                panel = this.getResultColumns(seqResults.sequence);
                this.searchResultsPanel.add(labelSeq);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.chronResults != null) {
            for (ChronResults chronResults : this.searchResults.chronResults) {
                JPanel labelChron = this.getResultSyn(chronResults.foundString + " - Chron");
                panel = this.getResultColumns(chronResults.chron);
                this.searchResultsPanel.add(labelChron);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.facieResults != null) {
            for (FacieResults facieResults : this.searchResults.facieResults) {
                JPanel labelFacie = this.getResultSyn(facieResults.foundString + " - Facie");
                panel = this.getResultColumns(facieResults.facie);
                this.searchResultsPanel.add(labelFacie);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
        if (this.searchResults.columnResults != null) {
            for (ColumnResults columnResults : this.searchResults.columnResults) {
                JPanel labelColumn = this.getResultSyn(columnResults.foundString + " - Column");
                panel = this.getResultColumns(columnResults.column);
                this.searchResultsPanel.add(labelColumn);
                this.searchResultsPanel.add(panel);
                this.searchResultsPanel.add(new JLabel(" "));
            }
        }
    }

    private JPanel getResultSyn(String foundString) {
        JPanel result = null;
        result = new JPanel();
        result.setBackground(Color.ORANGE);
        JLabel label = new JLabel(foundString);
        label.setFont(new Font("Sherif", 1, 14));
        result.add(label);
        result.setPreferredSize(new Dimension(600, 25));
        result.setMaximumSize(new Dimension(700, 25));
        return result;
    }

    private JPanel getResultColumns(ArrayList<Searchpoint> e) {
        JPanel panelInt = this.getHeader();
        int i = 1;
        for (Searchpoint sp : e) {
            JComponent Comments;
            sp.putSettingsReference(this);
            JCheckBox checkEvent = sp.getChecktoChart();
            if (checkEvent != null) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
            }
            panelInt.add(checkEvent);
            JLabel hierarchy = sp.getHierButton();
            hierarchy.setPreferredSize(new Dimension(40, 20));
            panelInt.add(hierarchy);
            JLabel Age = null;
            Age = sp.baseAge != null ? new JLabel(sp.baseAge, 0) : new JLabel(" - ", 0);
            panelInt.add(Age);
            JLabel Qualifier = null;
            Qualifier = sp.Qualifier != null ? new JLabel(sp.Qualifier) : new JLabel(" - ");
            panelInt.add(Qualifier);
            if (sp.Comments != null) {
                Comments = sp.getCommentsButton();
                panelInt.add(Comments);
            } else {
                Comments = new JLabel("No Additional Info.");
                panelInt.add(Comments);
            }
            ++i;
        }
        panelInt.setPreferredSize(new Dimension(600, 25 * i));
        panelInt.setMaximumSize(new Dimension(700, 25 * i));
        return panelInt;
    }

    private JPanel getHeader() {
        JPanel header = new JPanel();
        header.setLayout(new GridLayout(0, 5));
        JLabel displayCheck = new JLabel("Add To Chart");
        displayCheck.setFont(new Font("Sherif", 1, 12));
        header.add(displayCheck);
        JLabel columnLabel = new JLabel("ColumnPath");
        columnLabel.setFont(new Font("Sherif", 1, 12));
        header.add(columnLabel);
        JLabel ageLabel = new JLabel("Age", 0);
        ageLabel.setFont(new Font("Sherif", 1, 12));
        header.add(ageLabel);
        JLabel qualLabel = new JLabel("Qualifier");
        qualLabel.setFont(new Font("Sherif", 1, 12));
        header.add(qualLabel);
        JLabel infoLabel = new JLabel("More Info.");
        infoLabel.setFont(new Font("Sherif", 1, 12));
        header.add(infoLabel);
        return header;
    }

    public void updateAgeFromSearchResults() {
        if (this.chartCheck.isSelected()) {
            Set<Unit> unitSet = this.timesPanels.keySet();
            for (Unit unit : unitSet) {
                TimesPanel timespanel = this.timesPanels.get(unit);
                if (Searchpoint.lowerAgetoChart != Double.NEGATIVE_INFINITY) {
                    Double topAgeminusThree = Searchpoint.lowerAgetoChart - 3.0;
                    if (topAgeminusThree < 0.0) {
                        topAgeminusThree = new Double(0.0);
                    }
                    timespanel.topMY.setText(Double.toString(topAgeminusThree));
                    timespanel.topMYRadio.setSelected(true);
                    this.timesChanged(0, unit);
                    timespanel.unitsPerMaTF.setText("2");
                    this.timesChanged(2, unit);
                } else {
                    timespanel.topMY.setText(SOLID_STROKE);
                    timespanel.topStageRadio.setSelected(true);
                    timespanel.unitsPerMaTF.setText("1");
                    this.timesChanged(2, unit);
                }
                if (Searchpoint.upperAgetoChart != Double.POSITIVE_INFINITY) {
                    Double baseAgeplusThree = Searchpoint.upperAgetoChart + 3.0;
                    timespanel.baseMY.setText(Double.toString(baseAgeplusThree));
                    timespanel.baseMYRadio.setSelected(true);
                    this.timesChanged(0, unit);
                    continue;
                }
                timespanel.baseMY.setText(SOLID_STROKE);
                timespanel.baseStageRadio.setSelected(true);
            }
        }
    }

    public void updateAgeSet(boolean selected, Double baseSearchpoint, Double topSearchpoint) {
        if (this.ageSet == null) {
            this.ageSet = new ArrayList();
        }
        if (selected) {
            this.ageSet.add(baseSearchpoint);
            this.ageSet.add(topSearchpoint);
            return;
        }
        try {
            this.ageSet.remove(baseSearchpoint);
            this.ageSet.remove(topSearchpoint);
        }
        catch (Exception e) {
            System.out.println("Bug. Searchpoint should be in the ageSet");
        }
        Double least = Double.NEGATIVE_INFINITY;
        Double highest = Double.POSITIVE_INFINITY;
        for (Double d : this.ageSet) {
            if (d > least) {
                least = d;
            }
            if (!(d < highest)) continue;
            highest = d;
        }
        Searchpoint.lowerAgetoChart = least;
        Searchpoint.upperAgetoChart = highest;
    }

    private void clearAgeSet() {
        if (this.ageSet != null) {
            this.ageSet.clear();
        }
    }

    public static void globalOpenCommentsPane(JFrame openFrame) {
        if (openCommentsPanes == null) {
            openCommentsPanes = new ArrayList();
        }
        openCommentsPanes.add(openFrame);
    }

    private static void closeCommentsPanes() {
        if (openCommentsPanes != null) {
            for (JFrame frame : openCommentsPanes) {
                if (!frame.isVisible()) continue;
                frame.dispose();
            }
            openCommentsPanes.clear();
        }
    }

    public void clickedColumnsInSearch(DataColumn dc) {
        if (this.clickedColumns == null) {
            this.clickedColumns = new ArrayList();
        }
        if (!this.clickedColumns.contains(dc)) {
            this.clickedColumns.add(dc);
        }
    }

    private void resetTimeTreePanels() {
        Set<Unit> unitSet = this.timesPanels.keySet();
        for (Unit unit : unitSet) {
            TimesPanel timespanel = this.timesPanels.get(unit);
            timespanel.topStageRadio.setSelected(true);
            timespanel.topMY.setText(null);
            timespanel.baseStageRadio.setSelected(true);
            timespanel.baseMY.setText(null);
            timespanel.unitsPerMaTF.setText("1");
            this.timesChanged(2, unit);
        }
        if (this.clickedColumns != null) {
            for (DataColumn dc : this.clickedColumns) {
                dc.noofTimesResultSelected = 0;
                if (!dc.checkboxPanel.checkbox.isSelected()) continue;
                dc.checkboxPanel.checkbox.doClick();
            }
            this.clickedColumns.clear();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != '\n') {
            return;
        }
        this.startSearch(this.searchtextField.getText());
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

