/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.DataColumn;
import datastore.MetaColumn;
import datastore.RootColumn;
import datastore.Unit;
import gui.ErrorHandler;
import gui.ImageGenerator;
import gui.Settings;
import gui.TSCSVGUserAgent;
import gui.TSCSVGViewPanel;
import gui.TSCreator;

public class TSCColumnPreview
extends TSCSVGViewPanel {
    protected DataColumn col;
    protected RootColumn root = new RootColumn("", null);
    public Settings settings = new Settings();

    public TSCColumnPreview(DataColumn col) {
        this(col, null);
    }

    public TSCColumnPreview(DataColumn col, TSCSVGUserAgent agent) {
        super(null, agent);
        this.setColumn(col);
    }

    public final void setColumn(DataColumn col) {
        this.col = col;
        Unit unit = new Unit("Ma");
        this.root = new RootColumn("", unit);
        MetaColumn metacol = new MetaColumn("Transect Preview");
        metacol.setUnit(unit);
        metacol.addColumn(col);
        metacol.setSelected(true);
        this.root.addColumn(metacol);
    }

    public void draw() {
        if (this.col == null) {
            return;
        }
        try {
            ImageGenerator ig = new ImageGenerator(this.root, this.settings, TSCreator.db.patMan);
            this.doc = ig.drawImage();
        }
        catch (Exception e) {
            ErrorHandler.printException(e, "Internal error while generating preview! (" + e.getMessage() + ")");
            return;
        }
        catch (OutOfMemoryError oeme) {
            TSCreator.showInLabel("Out of Memory!", 3);
            return;
        }
        try {
            this.setDocument(this.doc);
        }
        catch (OutOfMemoryError oeme) {
            TSCreator.showInLabel("Out of Memory!", 3);
            this.setDocument(null);
            ErrorHandler.log("Out of Memory!\n");
        }
    }
}

