/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.Coloring;
import gui.TSCLinkActivationListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class TSCPopup
extends JDialog
implements FocusListener {
    String html = null;
    String docbase = null;
    private JTextPane textPane;
    private JScrollPane jScrollPane1;
    protected int lastDragX = -1;
    protected int lastDragY = -1;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                TSCPopup inst = new TSCPopup(frame);
                inst.setVisible(true);
            }
        });
    }

    public TSCPopup(JFrame frame) {
        this(frame, "foo! hello<br>new line<br>linky: <a href='www.tscreator.com'>linkylinky</a>", null);
    }

    public TSCPopup(JFrame frame, String text, String docbase) {
        super(frame);
        this.html = text = text + "<br>----------<br>To discuss about this datapack or report problems, please click <a href=\"https://timescalecreator.org/contactus/contactus.php\">here</a>.";
        this.docbase = docbase;
        this.initGUI();
    }

    private void initGUI() {
        try {
            Container cp = this.getContentPane();
            cp.setBackground(new Color(255, 255, 170));
            this.setDefaultCloseOperation(2);
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
            this.jScrollPane1.setPreferredSize(new Dimension(315, 133));
            this.textPane = new JTextPane();
            this.jScrollPane1.setViewportView(this.textPane);
            this.textPane.setContentType("text/html");
            this.textPane.addHyperlinkListener(new TSCLinkActivationListener());
            this.textPane.setText("<html><body bgcolor='" + Coloring.getHTMLColor(cp.getBackground()) + "'>" + this.html + "</body></html>");
            this.textPane.setEditable(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(cp.getBackground());
            this.textPane.setCaretPosition(0);
            HTMLDocument doc = (HTMLDocument)this.textPane.getDocument();
            if (this.docbase != null) {
                try {
                    doc.setBase(new URL(this.docbase));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.jScrollPane1.setBackground(cp.getBackground());
            this.addFocusListener(this);
            doc = (HTMLDocument)this.textPane.getDocument();
            HTMLDocument.Iterator iterator = doc.getIterator(HTML.Tag.IMG);
            if (iterator.isValid()) {
                AttributeSet attributes = iterator.getAttributes();
                String src = (String)attributes.getAttribute(HTML.Attribute.SRC);
                if (!src.contains("file")) {
                    this.setSize(315, 155);
                } else {
                    URL url_src = new URL(src);
                    BufferedImage image = ImageIO.read(url_src);
                    int height = 0;
                    height = image.getHeight();
                    int width = 0;
                    width = image.getWidth();
                    if (height > 200 && width > 135) {
                        this.setSize(width + 90, height + 115);
                    } else if (height > 200 && width > 0 && width < 135) {
                        this.setSize(155, height + 115);
                    } else if (height > 0 && height < 200 && width > 135) {
                        this.setSize(width + 90, 200);
                    } else {
                        this.setSize(315, 135);
                    }
                }
            } else {
                this.setSize(315, 135);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.killme();
    }

    public boolean killme() {
        boolean IBeDeadNow = true;
        this.setVisible(false);
        this.dispose();
        return IBeDeadNow;
    }
}

