/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.Datastore;
import gui.ActionDialog;
import gui.ExtensionFileFilter;
import gui.ImageGenerator;
import gui.Language;
import gui.TSCAction;
import gui.TSCSVGCanvas;
import gui.TSCSVGScrollPane;
import gui.TSCSVGUserAgent;
import gui.TSCreator;
import gui.crossplot.Crossplot;
import gui.crossplot.CrossplotAutoPlotSettings;
import gui.crossplot.CrossplotSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.w3c.dom.svg.SVGDocument;
import path.ResPath;
import util.FileUtils;

public class TSCSVGViewPanel
extends JPanel
implements ActionListener {
    public Crossplot crossplot;
    public TSCSVGCanvas displayCanvas;
    public TSCSVGScrollPane displayCanvasPane;
    protected SVGDocument doc;
    protected final Object docLock = new Object();
    protected OptionsPanel toolbar;
    protected boolean recenterOnRedraw = true;
    protected JButton zoomInAction;
    protected JButton zoomOutAction;
    protected JButton actualSizeAction;
    protected JButton fitToWindowAction;
    public boolean allowSave = false;
    public boolean isAgelock = false;
    public boolean isDepthlock = false;
    public TSCAction saveAction = new TSCAction(this, Language.translate("Save this image", true), null, Language.translate("Save this image.", true));
    protected JButton markerTB;
    protected JButton modelTB;
    protected JButton refreshTB;
    protected JToggleButton hidePoints;
    protected JToggleButton showTimeLines;
    protected JToggleButton showPopup;
    protected JToggleButton showLimitingBox;
    protected JToggleButton lockAgeline;
    protected JToggleButton lockDepthline;
    public TSCAction modelAction = new TSCAction(this, Language.translate("Show Crossplot Models", true), ResPath.getPath("icons.closed"), Language.translate("Toggles between Markers/Models.", true));
    public TSCAction markerAction = new TSCAction(this, Language.translate("Show Crossplot Markers", true), ResPath.getPath("icons.open"), Language.translate("Toggles between Markers/Models.", true));
    public TSCAction hideAction = new TSCAction(this, Language.translate("Show/Hide coordinates", true), ResPath.getPath("icons.hide"), Language.translate("Show/Hide Model Points.", true));
    public TSCAction hideLinesAction = new TSCAction(this, Language.translate("Show/Hide Time-Line", true), ResPath.getPath("icons.timelinesSel"), Language.translate("Show/Hide axes pointers.", true));
    public TSCAction popupAction = new TSCAction(this, Language.translate("Show Popups", true), ResPath.getPath("icons.popup"), Language.translate("Show Age/Depth Popups.", true));
    public TSCAction limitingAction = new TSCAction(this, Language.translate("Enable limiting box.", true), ResPath.getPath("icons.limitsSel"), Language.translate("Show or hide plot bounds", true));
    public TSCAction editAction = new TSCAction(this, Language.translate("Edit Age/Depth Points", true), null, Language.translate("Age/Depth point settings.", true));
    public TSCAction autoPlot = new TSCAction(this, Language.translate("Auto Plot Settings", true), null, Language.translate("Age/Depth point settings.", true));
    public TSCAction refreshAction = new TSCAction(this, Language.translate("Refresh", true), ResPath.getPath("icons.refresh"), Language.translate("Refresh Crossplot.", true));
    public AbstractAction agelineAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TSCSVGViewPanel.this.isAgelock) {
                TSCSVGViewPanel.this.lockAgeline.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.ageline")));
                TSCSVGViewPanel.this.isAgelock = false;
            } else {
                TSCSVGViewPanel.this.lockAgeline.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.agelineSel")));
                TSCSVGViewPanel.this.isAgelock = true;
            }
        }
    };
    public AbstractAction depthlineAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TSCSVGViewPanel.this.isDepthlock) {
                TSCSVGViewPanel.this.lockDepthline.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.depthline")));
                TSCSVGViewPanel.this.isDepthlock = false;
            } else {
                TSCSVGViewPanel.this.lockDepthline.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.depthlineSel")));
                TSCSVGViewPanel.this.isDepthlock = true;
            }
        }
    };

    public TSCSVGViewPanel() {
        this(null, null, false);
    }

    public TSCSVGViewPanel(boolean allowSave) {
        this(null, null, allowSave);
    }

    public TSCSVGViewPanel(Datastore ds, boolean allowSave) {
        this(null, null, allowSave);
    }

    public TSCSVGViewPanel(SVGDocument doc) {
        this(doc, null, false);
    }

    public TSCSVGViewPanel(SVGDocument doc, TSCSVGUserAgent agent) {
        this(doc, agent, false);
    }

    public TSCSVGViewPanel(SVGDocument doc, TSCSVGUserAgent agent, boolean allowSave) {
        this.allowSave = allowSave;
        this.toolbar = new OptionsPanel();
        this.crossplot = new Crossplot();
        try {
            this.setLayout(new BorderLayout());
            this.toolbar.setFloatable(false);
            this.add((Component)this.toolbar, "North");
            this.displayCanvas = agent == null ? new TSCSVGCanvas() : new TSCSVGCanvas(agent);
            this.displayCanvasPane = new TSCSVGScrollPane(this.displayCanvas);
            this.add((Component)this.displayCanvasPane, "Center");
            this.setDocument(doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setToolbarEnabled(boolean tf) {
        this.zoomInAction.setEnabled(tf);
        this.zoomOutAction.setEnabled(tf);
        this.actualSizeAction.setEnabled(tf);
        this.fitToWindowAction.setEnabled(tf);
        this.saveAction.setEnabled(tf);
        this.modelTB.setEnabled(tf);
        this.markerTB.setEnabled(tf);
        this.hidePoints.setEnabled(tf);
        this.showTimeLines.setEnabled(tf);
        this.lockAgeline.setEnabled(tf);
        this.lockDepthline.setEnabled(tf);
        this.showPopup.setEnabled(tf);
        this.showLimitingBox.setEnabled(tf);
        this.editAction.setEnabled(tf);
        this.autoPlot.setEnabled(tf);
        this.refreshTB.setEnabled(tf);
        this.refreshAction.setEnabled(tf);
    }

    public final void setCrossplot(Crossplot crossplot) {
        this.crossplot = crossplot;
        crossplot.crossplotGroup.setAttribute("CdtType", "1");
        this.modelTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.closedSel")));
        this.markerTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.open")));
        crossplot.popupGroup.setAttribute("showPopup", this.showPopup.isSelected() ? "true" : "false");
        this.hideAllCdts();
        this.hideAxes();
        this.hideAxes();
    }

    public final void setDocument(SVGDocument doc) {
        this.doc = doc;
        if (doc != null) {
            DrawThread drawerThread = new DrawThread(this.recenterOnRedraw);
            drawerThread.start();
        } else {
            this.displayCanvas.setDocument(doc);
        }
        this.displayCanvasPane.zoomToFit();
    }

    public TSCSVGCanvas getDisplayCanvas() {
        return this.displayCanvas;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.zoomInAction) {
            this.displayCanvasPane.zoomBy(1.25);
        } else if (source == this.zoomOutAction) {
            this.displayCanvasPane.zoomBy(0.8);
        } else if (source == this.actualSizeAction) {
            this.displayCanvasPane.resetTransform();
            this.displayCanvasPane.recenter();
        } else if (source == this.fitToWindowAction) {
            this.displayCanvasPane.zoomToFit();
        } else if (source == this.refreshTB) {
            this.displayCanvasPane.zoomToFit();
        } else if (source == this.saveAction) {
            this.save();
        } else if (source == this.hidePoints) {
            this.hideAllCdts();
            this.hidePoints.setIcon(FileUtils.getImageIcon(this.hidePoints.isSelected() ? ResPath.getPath("icons.hideSel") : ResPath.getPath("icons.hide")));
        } else if (source == this.showTimeLines) {
            this.hideAxes();
            this.showTimeLines.setIcon(FileUtils.getImageIcon(this.showTimeLines.isSelected() ? ResPath.getPath("icons.timelinesSel") : ResPath.getPath("icons.timelines")));
        } else if (source == this.modelTB) {
            this.crossplot.crossplotGroup.setAttribute("CdtType", "1");
            this.modelTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.closedSel")));
            this.markerTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.open")));
        } else if (source == this.markerTB) {
            this.crossplot.crossplotGroup.setAttribute("CdtType", "0");
            this.modelTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.closed")));
            this.markerTB.setIcon(FileUtils.getImageIcon(ResPath.getPath("icons.openSel")));
        } else if (source == this.showPopup) {
            this.crossplot.popupGroup.setAttribute("showPopup", this.showPopup.isSelected() ? "true" : "false");
            this.showPopup.setIcon(FileUtils.getImageIcon(this.showPopup.isSelected() ? ResPath.getPath("icons.popupSel") : ResPath.getPath("icons.popup")));
        } else if (source == this.showLimitingBox) {
            this.hideLimitingBox();
            this.showLimitingBox.setIcon(FileUtils.getImageIcon(this.showLimitingBox.isSelected() ? ResPath.getPath("icons.limitsSel") : ResPath.getPath("icons.limits")));
        } else if (source == this.editAction) {
            if (Crossplot.crossplotSettings != null) {
                Crossplot.crossplotSettings = null;
            }
            Crossplot.crossplotSettings = new CrossplotSettings(this.crossplot);
            this.crossplot.updateAgeDepthPoints();
            Crossplot.crossplotSettings.updatePointsPanels();
            Crossplot.crossplotSettings.setVisible(true);
        } else if (source == this.autoPlot) {
            if (Crossplot.autoPlotSettings == null) {
                Crossplot.autoPlotSettings = new CrossplotAutoPlotSettings(this.crossplot);
            }
            Crossplot.autoPlotSettings.setVisible(true);
        }
    }

    public boolean isRecenterOnRedraw() {
        return this.recenterOnRedraw;
    }

    public void setRecenterOnRedraw(boolean recenterOnRedraw) {
        this.recenterOnRedraw = recenterOnRedraw;
    }

    public void hideAllCdts() {
        this.crossplot.modelGroup.setAttribute("visibility", this.hidePoints.isSelected() ? "hidden" : "visible");
    }

    public void hideAxes() {
        this.crossplot.timelineGroup.setAttribute("visibility", this.showTimeLines.isSelected() ? "visible" : "hidden");
        this.crossplot.timelabelsGroup.setAttribute("visibility", this.showTimeLines.isSelected() ? "visible" : "hidden");
    }

    public void hideLimitingBox() {
        this.crossplot.limitingBox.setAttribute("visibility", this.showLimitingBox.isSelected() ? "visible" : "hidden");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("SVG file (*.svg)");
        eff.addExtension("svg", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            ActionDialog ad = new ActionDialog("Saving Pattern SVG...");
            ad.setVisible(true);
            String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "svg");
            try {
                OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "UTF-8");
                Object object = this.docLock;
                synchronized (object) {
                    ImageGenerator.write(this.doc, fw);
                }
                fw.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), Language.translate("Error writing pattern SVG", true), 0);
            }
            catch (OutOfMemoryError oome) {
                JOptionPane.showMessageDialog(this, Language.translate("Out of memory!", true), Language.translate("Error writing pattern SVG", true), 0);
            }
            ad.setVisible(false);
        }
    }

    protected class DrawThread
    extends Thread {
        public boolean recenter;
        AffineTransform rendTrans = null;

        public DrawThread(boolean r) {
            this.recenter = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TSCSVGViewPanel.this.docLock;
            synchronized (object) {
                AffineTransform at = TSCSVGViewPanel.this.displayCanvas.getRenderingTransform();
                TSCSVGViewPanel.this.displayCanvas.setDocument(TSCSVGViewPanel.this.doc);
                TSCSVGViewPanel.this.displayCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

                    @Override
                    public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                        TSCSVGViewPanel.this.displayCanvas.removeGVTTreeRendererListener(this);
                        if (DrawThread.this.recenter) {
                            TSCSVGViewPanel.this.displayCanvasPane.zoomToFit();
                        } else if (DrawThread.this.rendTrans != null) {
                            TSCSVGViewPanel.this.displayCanvas.setRenderingTransform(DrawThread.this.rendTrans);
                        }
                    }

                    @Override
                    public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                    }

                    @Override
                    public void gvtRenderingFailed(GVTTreeRendererEvent e) {
                    }
                });
                if (TSCSVGViewPanel.this.doc != null) {
                    TSCSVGViewPanel.this.setToolbarEnabled(true);
                    if (!this.recenter && at != null) {
                        this.rendTrans = at;
                        TSCSVGViewPanel.this.displayCanvas.setRenderingTransform(at);
                    }
                }
            }
        }
    }

    public class OptionsPanel
    extends JToolBar {
        public OptionsPanel() {
            super("SVG viewer options");
            TSCSVGViewPanel.this.zoomInAction = new JButton(FileUtils.getImageIcon(TSCreator.curCreator.zoomInAction.origIconFile));
            TSCSVGViewPanel.this.zoomInAction.setToolTipText(TSCreator.curCreator.zoomInAction.origDescription);
            TSCSVGViewPanel.this.zoomInAction.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.zoomOutAction = new JButton(FileUtils.getImageIcon(TSCreator.curCreator.zoomOutAction.origIconFile));
            TSCSVGViewPanel.this.zoomOutAction.setToolTipText(TSCreator.curCreator.zoomOutAction.origDescription);
            TSCSVGViewPanel.this.zoomOutAction.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.actualSizeAction = new JButton(FileUtils.getImageIcon(TSCreator.curCreator.actualSizeAction.origIconFile));
            TSCSVGViewPanel.this.actualSizeAction.setToolTipText(TSCreator.curCreator.actualSizeAction.origDescription);
            TSCSVGViewPanel.this.actualSizeAction.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.fitToWindowAction = new JButton(FileUtils.getImageIcon(TSCreator.curCreator.fitToWindowAction.origIconFile));
            TSCSVGViewPanel.this.fitToWindowAction.setToolTipText(TSCreator.curCreator.fitToWindowAction.origDescription);
            TSCSVGViewPanel.this.fitToWindowAction.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.refreshTB = new JButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.refreshAction.origIconFile));
            TSCSVGViewPanel.this.refreshTB.setToolTipText(TSCSVGViewPanel.this.refreshAction.origDescription);
            TSCSVGViewPanel.this.refreshTB.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.modelTB = new JButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.modelAction.origIconFile));
            TSCSVGViewPanel.this.modelTB.setToolTipText(TSCSVGViewPanel.this.modelAction.origDescription);
            TSCSVGViewPanel.this.modelTB.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.markerTB = new JButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.markerAction.origIconFile));
            TSCSVGViewPanel.this.markerTB.setToolTipText(TSCSVGViewPanel.this.markerAction.origDescription);
            TSCSVGViewPanel.this.markerTB.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.hidePoints = new JToggleButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.hideAction.origIconFile), false);
            TSCSVGViewPanel.this.hidePoints.setToolTipText(TSCSVGViewPanel.this.hideAction.origDescription);
            TSCSVGViewPanel.this.hidePoints.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.showTimeLines = new JToggleButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.hideLinesAction.origIconFile), false);
            TSCSVGViewPanel.this.showTimeLines.setToolTipText(TSCSVGViewPanel.this.hideLinesAction.origDescription);
            TSCSVGViewPanel.this.showTimeLines.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.showTimeLines.setSelected(true);
            TSCSVGViewPanel.this.lockAgeline = new JToggleButton(FileUtils.getImageIcon(ResPath.getPath("icons.ageline")), true);
            TSCSVGViewPanel.this.lockAgeline.setToolTipText("Vertical line unmoved");
            TSCSVGViewPanel.this.lockAgeline.addActionListener(TSCSVGViewPanel.this.agelineAction);
            TSCSVGViewPanel.this.lockAgeline.getInputMap(2).put(KeyStroke.getKeyStroke(88, 0), "X_pressed");
            TSCSVGViewPanel.this.lockAgeline.getActionMap().put("X_pressed", TSCSVGViewPanel.this.agelineAction);
            TSCSVGViewPanel.this.lockAgeline.setSelected(false);
            TSCSVGViewPanel.this.lockDepthline = new JToggleButton(FileUtils.getImageIcon(ResPath.getPath("icons.depthline")), false);
            TSCSVGViewPanel.this.lockDepthline.setToolTipText("Horizontal line unmoved");
            TSCSVGViewPanel.this.lockDepthline.addActionListener(TSCSVGViewPanel.this.depthlineAction);
            TSCSVGViewPanel.this.lockDepthline.getInputMap(2).put(KeyStroke.getKeyStroke(89, 0), "Y_pressed");
            TSCSVGViewPanel.this.lockDepthline.getActionMap().put("Y_pressed", TSCSVGViewPanel.this.depthlineAction);
            TSCSVGViewPanel.this.lockDepthline.setSelected(false);
            TSCSVGViewPanel.this.showPopup = new JToggleButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.popupAction.origIconFile), true);
            TSCSVGViewPanel.this.showPopup.setToolTipText(TSCSVGViewPanel.this.popupAction.origDescription);
            TSCSVGViewPanel.this.showPopup.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.showPopup.setSelected(true);
            TSCSVGViewPanel.this.showLimitingBox = new JToggleButton(FileUtils.getImageIcon(TSCSVGViewPanel.this.limitingAction.origIconFile), true);
            TSCSVGViewPanel.this.showLimitingBox.setToolTipText(TSCSVGViewPanel.this.limitingAction.origDescription);
            TSCSVGViewPanel.this.showLimitingBox.addActionListener(TSCSVGViewPanel.this);
            TSCSVGViewPanel.this.showLimitingBox.setSelected(true);
            this.addSeparator();
            this.add(TSCSVGViewPanel.this.refreshTB);
            this.addSeparator();
            this.add(TSCSVGViewPanel.this.zoomInAction);
            this.add(TSCSVGViewPanel.this.zoomOutAction);
            this.add(TSCSVGViewPanel.this.actualSizeAction);
            this.add(TSCSVGViewPanel.this.fitToWindowAction);
            if (TSCSVGViewPanel.this.allowSave) {
                this.addSeparator();
                this.add(TSCSVGViewPanel.this.saveAction);
            }
            this.addSeparator();
            this.add(TSCSVGViewPanel.this.modelTB);
            this.add(TSCSVGViewPanel.this.markerTB);
            this.add(TSCSVGViewPanel.this.showTimeLines);
            this.add(TSCSVGViewPanel.this.lockAgeline);
            this.add(TSCSVGViewPanel.this.lockDepthline);
            this.add(TSCSVGViewPanel.this.showPopup);
            this.add(TSCSVGViewPanel.this.showLimitingBox);
            this.addSeparator();
            this.add(TSCSVGViewPanel.this.editAction);
            this.addSeparator();
            TSCSVGViewPanel.this.setToolbarEnabled(false);
        }
    }
}

