/*
 * Decompiled with CFR 0.152.
 */
package gui.crossplot;

import datastore.DataColumn;
import datastore.EventColumn;
import gui.Language;
import gui.crossplot.Crossplot;
import gui.crossplot.CrossplotAutoPlotOptions;
import gui.tree.CheckboxTreeCellEditor;
import gui.tree.CheckboxTreeCellRenderer;
import gui.tree.DataColumnTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class CrossplotAutoPlotSettings
extends JFrame
implements TreeSelectionListener,
ActionListener {
    private Crossplot plot;
    private JTree autoPlotColumnTree;
    private CrossplotAutoPlotOptions autoplotOptions;
    private JTextField xSource;
    private JTextField ySource;
    private JButton addX;
    private JButton addY;
    private JButton autoPlot;
    private DataColumn ageColumn;
    private DataColumn depthColumn;

    protected CrossplotAutoPlotSettings() {
    }

    public CrossplotAutoPlotSettings(Crossplot plot) {
        this();
        this.plot = plot;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setTitle(Language.translate("Edit Age/Depth Points", true));
            this.setSize(new Dimension(500, 700));
            JPanel main = new JPanel();
            this.getContentPane().add((Component)main, "Center");
            main.setLayout(new BoxLayout(main, 2));
            JPanel panel = new JPanel();
            main.add((Component)panel, (Object)Box.createVerticalBox());
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            if (this.autoPlotColumnTree == null) {
                this.autoPlotColumnTree = new JTree(this.plot.data.getAutoPlotTreeModel());
                this.autoPlotColumnTree.setCellRenderer(new CheckboxTreeCellRenderer());
                this.autoPlotColumnTree.setCellEditor(new CheckboxTreeCellEditor(this.autoPlotColumnTree));
                this.autoPlotColumnTree.setEditable(true);
                this.autoPlotColumnTree.getSelectionModel().setSelectionMode(1);
                this.autoPlotColumnTree.addTreeSelectionListener(this);
            }
            panel.add(new JScrollPane(this.autoPlotColumnTree));
            JPanel selPanel = new JPanel();
            panel.add((Component)selPanel, "First");
            selPanel.setLayout(new BorderLayout());
            selPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.autoplotOptions = new CrossplotAutoPlotOptions(null, this);
            selPanel.add((Component)this.autoplotOptions, "First");
            JPanel innerPanel = new JPanel();
            selPanel.add((Component)innerPanel, "Center");
            GridBagLayout layout = new GridBagLayout();
            innerPanel.setLayout(layout);
            innerPanel.setBackground(Color.WHITE);
            GridBagConstraints c = new GridBagConstraints();
            int x = 0;
            int y = 0;
            x = 0;
            this.addX = new JButton("Age");
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y;
            c.weighty = 0.0;
            innerPanel.add((Component)this.addX, c);
            this.addX.addActionListener(this);
            this.addX.setEnabled(false);
            this.xSource = new JTextField("\"select an age column\"");
            this.xSource.setColumns(30);
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y++;
            c.weighty = 0.0;
            innerPanel.add((Component)this.xSource, c);
            this.xSource.setEditable(false);
            x = 0;
            this.addY = new JButton("Depth");
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y;
            c.weighty = 0.0;
            innerPanel.add((Component)this.addY, c);
            this.addY.addActionListener(this);
            this.addY.setEnabled(false);
            this.ySource = new JTextField("\"select an depth column\"");
            this.ySource.setColumns(30);
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y++;
            c.weighty = 0.0;
            innerPanel.add((Component)this.ySource, c);
            this.ySource.setEditable(false);
            x = 0;
            this.autoPlot = new JButton("Auto Plot");
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y;
            c.gridwidth = 2;
            c.weighty = 0.0;
            innerPanel.add((Component)this.autoPlot, c);
            this.autoPlot.addActionListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DataColumn col = null;
        Object o = this.autoPlotColumnTree.getLastSelectedPathComponent();
        if (o instanceof DataColumn) {
            col = (DataColumn)o;
        }
        if (o instanceof DataColumnTreeNode) {
            col = ((DataColumnTreeNode)o).col;
        }
        if (col != null && col instanceof EventColumn) {
            this.addX.setEnabled(true);
            this.addY.setEnabled(true);
        } else {
            this.addX.setEnabled(false);
            this.addY.setEnabled(false);
        }
        this.autoplotOptions.setColumn(col);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source;
        DataColumn col = null;
        Object o = this.autoPlotColumnTree.getLastSelectedPathComponent();
        if (o instanceof DataColumn) {
            col = (DataColumn)o;
        }
        if (o instanceof DataColumnTreeNode) {
            col = ((DataColumnTreeNode)o).col;
        }
        if ((source = (JButton)e.getSource()) == this.addX) {
            if (col != null) {
                this.xSource.setText(col.getName());
                this.ageColumn = col;
            }
        } else if (source == this.addY) {
            if (col != null) {
                this.ySource.setText(col.getName());
                this.depthColumn = col;
            }
        } else if (source == this.autoPlot && this.plot != null) {
            this.plot.autoPlot(this.ageColumn, this.depthColumn);
        }
    }
}

