/*
 * Decompiled with CFR 0.152.
 */
package gui.datamining;

import datastore.Datapoint;
import java.util.ArrayList;
import java.util.SortedSet;

public class RollApply {
    public static double[][] rollApply(double[] t, double[] d, double windowSize, double windowSlide, int i) {
        int windows = RollApply.numWindows(t, windowSlide);
        double[][] dataOut = new double[2][windows];
        if (i == 0) {
            dataOut = RollApply.frequency(t, windows, windowSize, windowSlide);
        } else if (i == 1) {
            dataOut = RollApply.minimum(t, d, windows, windowSize, windowSlide);
        } else if (i == 2) {
            dataOut = RollApply.maximum(t, d, windows, windowSize, windowSlide);
        } else if (i == 3) {
            dataOut = RollApply.average(t, d, windows, windowSize, windowSlide);
        } else if (i == 4) {
            dataOut = RollApply.rateOfChange(t, d, windowSize, windowSlide);
        }
        return dataOut;
    }

    public static double[][] frequency_event(double[] t, SortedSet<Datapoint> d, int i, int windows, double windowSize, double windowSlide) {
        double[][] freqResult = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = t[0] + windowSlide;
        int count = 0;
        for (int windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            while (t[k] < end) {
                if (i == 0) {
                    ++count;
                } else if (i == 5 || i == 6 || i == 7) {
                    // empty if block
                }
                ++k;
            }
            if (end == t[t.length - 1]) {
                if (i == 0) {
                    ++count;
                } else if (i == 5 || i == 6 || i == 7) {
                    // empty if block
                }
            }
            k = 0;
            freqResult[0][windowCounter] = count;
            freqResult[1][windowCounter] = (start + end) / 2.0;
            count = 0;
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        return freqResult;
    }

    public static double[][] frequency(double[] t, int windows, double windowSize, double windowSlide) {
        double[][] freqResult = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = t[0] + windowSlide;
        int count = 0;
        for (int windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            while (k < t.length && t[k] < end) {
                ++count;
                ++k;
            }
            if (end == t[t.length - 1]) {
                ++count;
            }
            k = 0;
            freqResult[0][windowCounter] = count;
            freqResult[1][windowCounter] = windowCounter == 0 ? t[0] : (start + end) / 2.0;
            count = 0;
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        return freqResult;
    }

    public static double[][] minimum(double[] t, double[] d, int windows, double windowSize, double windowSlide) {
        double[][] minResult = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = t[0] + windowSlide;
        double minimum = 0.0;
        for (int windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            minimum = d[k];
            while (k < t.length && t[k] < end) {
                if (minimum > d[k]) {
                    minimum = d[k];
                }
                if (end == t[t.length - 1] && minimum > d[d.length - 1]) {
                    minimum = d[d.length - 1];
                }
                ++k;
            }
            k = 0;
            minResult[0][windowCounter] = minimum;
            minResult[1][windowCounter] = windowCounter == 0 ? t[0] : (start + end) / 2.0;
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        return minResult;
    }

    public static double[][] maximum(double[] t, double[] d, int windows, double windowSize, double windowSlide) {
        double[][] maxResult = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = t[0] + windowSlide;
        double maximum = 0.0;
        for (int windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            maximum = d[k];
            while (k < t.length && t[k] < end) {
                if (maximum < d[k]) {
                    maximum = d[k];
                }
                if (end == t[t.length - 1] && maximum < d[d.length - 1]) {
                    maximum = d[d.length - 1];
                }
                ++k;
            }
            k = 0;
            maxResult[0][windowCounter] = maximum;
            maxResult[1][windowCounter] = windowCounter == 0 ? t[0] : (start + end) / 2.0;
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        return maxResult;
    }

    public static double[][] average(double[] t, double[] d, int windows, double windowSize, double windowSlide) {
        double[][] avgResult = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = t[0] + windowSlide;
        double sum = 0.0;
        int count = 0;
        for (int windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            while (k < t.length && t[k] < end) {
                sum += d[k];
                ++count;
                ++k;
            }
            if (end == t[t.length - 1]) {
                sum += d[d.length - 1];
                ++count;
            }
            k = 0;
            if (count != 0) {
                avgResult[0][windowCounter] = sum / (double)count;
                avgResult[1][windowCounter] = windowCounter == 0 ? t[1] : (start + end) / 2.0;
            }
            sum = 0.0;
            count = 0;
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        return avgResult;
    }

    public static double[][] RatesOfChange2(double[] time, double[] data) {
        ArrayList<Double> Rates_of_Change = new ArrayList<Double>();
        ArrayList<Double> newTime = new ArrayList<Double>();
        double res = -2.147483648E9;
        for (int i = 0; i < data.length - 1; ++i) {
            if (time[i + 1] != time[i]) {
                res = RollApply.Slope(data[i + 1], data[i], time[i + 1], time[i]);
                Rates_of_Change.add(res);
            } else {
                if (i > 0 && time[i + 1] != time[i - 1]) {
                    double r = RollApply.Slope(data[i + 1], data[i - 1], time[i + 1], time[i - 1]);
                    if (Math.abs(r) > Math.abs(res)) {
                        res = r;
                    }
                } else {
                    res = 0.0;
                }
                Rates_of_Change.add(res);
            }
            newTime.add((time[i + 1] + time[i]) / 2.0);
        }
        double[][] result = new double[2][Rates_of_Change.size() + 1];
        for (int i = 0; i < Rates_of_Change.size(); ++i) {
            result[0][i] = (Double)Rates_of_Change.get(i);
            result[1][i] = (Double)newTime.get(i);
        }
        return result;
    }

    public static double[][] RatesOfChange(double[] time, double[] data) {
        ArrayList<Double> Rates_of_Change = new ArrayList<Double>();
        ArrayList<Double> newTime = new ArrayList<Double>();
        for (int i = 0; i < data.length - 1; ++i) {
            double result = RollApply.Slope(data[i + 1], data[i], time[i + 1], time[i]);
            Rates_of_Change.add(result);
            double t = (time[i + 1] + time[i]) / 2.0;
            newTime.add(t);
        }
        double[][] result = new double[2][Rates_of_Change.size() + 1];
        for (int i = 0; i < Rates_of_Change.size(); ++i) {
            result[0][i] = (Double)Rates_of_Change.get(i);
            result[1][i] = (Double)newTime.get(i);
        }
        return result;
    }

    public static double Slope(double y2, double y1, double x2, double x1) {
        if (x2 != x1) {
            double result = (y2 - y1) / (x2 - x1);
            return result;
        }
        System.out.println("Error: Undefined");
        return 0.0;
    }

    public static double[][] rateOfChange(double[] t, double[] d, double windowSize, double windowSlide) {
        int windowCounter;
        int windows = RollApply.numWindows(t, windowSlide);
        double[][] rateOfChange = new double[2][windows];
        int k = 0;
        double start = t[0];
        double end = start + windowSlide;
        double sumT = 0.0;
        double sumD = 0.0;
        double sumTD = 0.0;
        double sumT2 = 0.0;
        int n = 0;
        double slope = 0.0;
        for (windowCounter = 0; windowCounter < windows; ++windowCounter) {
            while (t[k] < start) {
                ++k;
            }
            while (k < t.length && t[k] < end) {
                ++n;
                sumT += t[k];
                sumD += d[k];
                sumTD += t[k] * d[k];
                sumT2 += Math.pow(t[k], 2.0);
                ++k;
            }
            k = 0;
            slope = (double)n * sumTD - sumT * sumD;
            if (Double.isNaN(slope /= (double)n * sumT2 - Math.pow(sumT, 2.0))) {
                slope = 0.0;
            }
            slope = -slope;
            sumT = 0.0;
            sumD = 0.0;
            sumTD = 0.0;
            sumT2 = 0.0;
            n = 0;
            rateOfChange[0][windowCounter] = slope;
            if (windowCounter == 0) {
                rateOfChange[1][0] = t[0];
            } else {
                rateOfChange[1][windowCounter] = (start + end) / 2.0;
            }
            end = end + windowSlide < t[t.length - 1] ? (end += windowSlide) : t[t.length - 1];
            if (end - start > windowSize) {
                start = end - windowSize;
                continue;
            }
            if (end != t[t.length - 1]) continue;
            start += windowSlide;
        }
        windowCounter = 0;
        return rateOfChange;
    }

    public static double[] listConversion(ArrayList<Double> toConvert) {
        double[] result = new double[toConvert.size()];
        for (int i = 0; i < toConvert.size(); ++i) {
            result[i] = toConvert.get(i);
        }
        return result;
    }

    public static int numWindows(double[] t, double windowSlide) {
        int windowCount = 0;
        double end = t[t.length - 1];
        for (double start = t[0]; start <= end; start += windowSlide) {
            if (start + windowSlide < t[t.length - 1]) {
                ++windowCount;
                continue;
            }
            ++windowCount;
            break;
        }
        return windowCount;
    }

    public static int numWindows(Double[] t, double windowSlide) {
        int windowCount = 0;
        double end = t[t.length - 1];
        for (double start = t[0].doubleValue(); start <= end; start += windowSlide) {
            if (start + windowSlide < t[t.length - 1]) {
                ++windowCount;
                continue;
            }
            ++windowCount;
            break;
        }
        return windowCount;
    }

    public static void main(String[] args) {
        System.out.println("-- TESTING DATA --");
        double[] t = new double[]{1.21, 3.0, 5.16, 8.31, 10.21};
        double[] d = new double[]{1.69, 5.89, 4.11, 5.49, 8.65};
        double windowSize = 9.1;
        double windowSlide = 9.1;
        double[][] results = RollApply.maximum(t, d, 1, windowSize, windowSlide);
        for (int i = 0; i < results[0].length; ++i) {
            System.out.println("Window " + i + ": " + results[0][i]);
        }
    }
}

