/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.BlockData;
import model.Column;
import model.ModelIdentifier;
import model.storage.BlockColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class BlockColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public BlockColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 4));
    }

    public BlockColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            BlockColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            BlockColumnStorage.update(this);
        }
    }

    public List<BlockData> getDataByAge(double top, double bottom) {
        return BlockData.Factory.getByAge(this, top, bottom);
    }

    @Override
    public String toString() {
        return super.toString() + "BLOCK_COLUMN [ Identifier( " + this.identifier.toString() + ") ]";
    }

    public static class Factory {
        public static List<BlockColumn> getByTitle(String title) {
            List<SourceResult> results = BlockColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 4);
            return Factory.getByIdentifiers(ids);
        }

        public static BlockColumn getByIdentifier(ModelIdentifier id) {
            List<Object> blockColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            blockColumns = Factory.getByIdentifiers(ids);
            if (blockColumns.isEmpty()) {
                return null;
            }
            return (BlockColumn)blockColumns.get(0);
        }

        public static List<BlockColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<BlockColumn> blockColumns = new ArrayList<BlockColumn>();
            List<SourceResult> results = BlockColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                blockColumns.add(new BlockColumn(ids.get(i), results.get(i)));
            }
            return blockColumns;
        }
    }
}

