/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.FreehandColumn;
import model.ModelIdentifier;
import model.storage.FreehandImageDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FreehandImageData
extends Data {
    private ModelIdentifier identifier = null;
    private String image = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FreehandImageData(FreehandColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 13));
    }

    public FreehandImageData(FreehandColumn col, ModelIdentifier id, SourceResult result) {
        super((Column)col, result);
        this.setIdentifier(id);
        this.setImage(result.getString("image"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            FreehandImageDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FreehandImageDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getImage() {
        return this.image;
    }

    public final void setImage(String image) {
        this.image = image;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static FreehandImageData getByIdentifier(FreehandColumn c, ModelIdentifier id) {
            List<Object> freehandImageData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            freehandImageData = Factory.getByIdentifiers(c, ids);
            if (freehandImageData.isEmpty()) {
                return null;
            }
            return (FreehandImageData)freehandImageData.get(0);
        }

        public static List<FreehandImageData> getByIdentifiers(FreehandColumn c, List<ModelIdentifier> ids) {
            ArrayList<FreehandImageData> freehandData = new ArrayList<FreehandImageData>();
            List<SourceResult> results = FreehandImageDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                freehandData.add(new FreehandImageData(c, ids.get(i), results.get(i)));
            }
            return freehandData;
        }

        public static List<FreehandImageData> getByAge(FreehandColumn c, double top, double bottom) {
            List<SourceResult> results = FreehandImageDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 13);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

